/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.util.OrgTypeUtils;
import com.kingdee.eas.common.EASBizException;
import java.util.Set;

public class OrgCommonUtils {
    public static Set getOrgTypeCol(FullOrgUnitInfo fullOrgUnitInfo) {
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(fullOrgUnitInfo);
        return orgTypeHelper.getAllSelectOrgTypeSet();
    }

    public static boolean isOrgType(OrgUnitInfo orgUnit, OrgType orgType) {
        return OrgTypeUtils.isOrgType(orgUnit, orgType);
    }

    public static Set getAllOrgType() {
        return OrgTypeInfoMgr.getInstance().getAllOrgType();
    }

    public static boolean isCanBeDefOrg(FullOrgUnitInfo fullOrgUnitInfo) {
        block2: {
            block3: {
                OrgTypeHelper orgTypeHelper = new OrgTypeHelper(fullOrgUnitInfo);
                Set allOrgTypeSet = orgTypeHelper.getAllSelectOrgTypeSet();
                if (allOrgTypeSet == null || allOrgTypeSet.size() != 1) break block2;
                OrgType oneType = (OrgType)((Object)allOrgTypeSet.iterator().next());
                if (OrgType.Admin == oneType) break block3;
                if (OrgType.UnionDebt != oneType) break block2;
            }
            return false;
        }
        return true;
    }

    public static OrgUnitInfo getOrgUnitInfo(Context ctx, String orgId, OrgType orgType, SelectorItemCollection selector) throws BOSException, EASBizException {
        return NewOrgViewHelper.getOrgUnitInfo(ctx, orgId, orgType, selector);
    }

    public static OrgType getOrgType(String orgTypeStr) {
        return OrgType.getEnum(orgTypeStr);
    }

    public static String getOrgTreeId(OrgType orgType) {
        return OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType).getOrgTreeID();
    }

    public static FilterInfo createFilterInfo(OrgType orgType) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgTypeStr", (Object)OrgTypeHelper.createLikeStr(orgType), CompareType.LIKE));
        return filterInfo;
    }

    public static String getOrgQueryCon(OrgType orgType, String baseUnitTableAlias) {
        return baseUnitTableAlias + ".forgTypeStr like '%" + OrgTypeHelper.createLikeStr(orgType) + "%'";
    }

    public static boolean isBasicOrgType(OrgType orgType) {
        if (orgType == null) {
            return false;
        }
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfoByOrgType(orgType);
        if (orgTypeInfo == null) {
            return false;
        }
        return orgTypeInfo.isBasicOrgType();
    }

    public static OrgUnitCollection getOrgUnitCollection(Context ctx, OrgType orgType, String oql) throws BOSException, EASBizException {
        return NewOrgViewHelper.getOrgUnitCollection(ctx, orgType, oql);
    }
}

