/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos;

import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonType;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.Stateless;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.IObjectFactory;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.rpcwrapper.ServerSessionContainer;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.LRUMap;
import org.apache.log4j.Logger;

public class ORMRPCObjectFactory
implements IObjectFactory {
    private static Logger logger = Logger.getLogger(ORMRPCObjectFactory.class);
    private static final LRUMap BOSObjectCache = new LRUMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IORMModel createObject(String objectName, Class model, Class[] argTypes, Object[] initArgs) throws Exception {
        Context ctx;
        SessionInfo sessionInfo;
        ISessionManager manager;
        String sessionID;
        String className;
        BusinessObjectInfo bo = null;
        String pk = null;
        if (objectName.equals("$bosobj$" + MetaDataTypeList.LOGIN)) {
            className = "com.kingdee.bos.framework.session.LoginModule";
        } else if (objectName.startsWith("$bosobj$")) {
            String _objectName = objectName.substring(8, objectName.length());
            sessionID = (String)ServerSessionContainer.getCurrentSession().get((Object)"bos_sessionid");
            if (sessionID == null) {
                logger.info((Object)"Can't find user sessionID in ServerSession!");
                throw new IllegalStateException("Please login first!");
            }
            manager = SessionManager.getInstance();
            sessionInfo = manager.getSession(sessionID);
            if (sessionInfo == null) {
                throw new IllegalStateException("Cannot found session info. sessionID is " + sessionID);
            }
            ctx = sessionInfo.getContext();
            bo = MetaDataUtils.getBOFromCache(ctx, BOSObjectType.create((String)_objectName));
            if (bo == null) {
                throw new RuntimeException("cannot found Business Object metadata when create bos object [objectName=" + objectName + ";bostype=" + _objectName + "]");
            }
            className = bo.getBusinessImplName();
            if (className == null) {
                throw new RuntimeException("cannot found Business Impl Name when create bos object [objectName=" + objectName + ";bostype=" + _objectName + ";metadata_pk=" + bo.getFullName() + "]");
            }
        } else if (objectName.startsWith("$dynbosobj$")) {
            pk = objectName.substring(11);
            sessionID = (String)ServerSessionContainer.getCurrentSession().get((Object)"bos_sessionid");
            if (sessionID == null) {
                logger.info((Object)"Can't find user sessionID in ServerSession!");
                throw new IllegalStateException("Please login first!");
            }
            manager = SessionManager.getInstance();
            sessionInfo = manager.getSession(sessionID);
            if (sessionInfo == null) {
                throw new IllegalStateException("Cannot found session info. sessionID is " + sessionID);
            }
            ctx = sessionInfo.getContext();
            bo = (BusinessObjectInfo)MetaDataLoaderFactory.getMetaDataLoader(ctx).get(MetaDataTypeList.ENTITY, MetaDataPK.create(pk));
            if (bo == null) {
                throw new RuntimeException("cannot found Business Object metadata when create bos object [objectName=" + objectName + ";pk=" + pk + "]");
            }
            className = bo.getBusinessImplName();
            if (className == null) {
                throw new RuntimeException("cannot found Business Impl Name when create bos object [objectName=" + objectName + ";pk=" + pk + "]");
            }
        } else {
            className = objectName;
        }
        if ((argTypes == null || argTypes.length == 0) && !objectName.startsWith("$dynbosobj$") && Stateless.class.isAssignableFrom(model)) {
            String key = className + model.toString();
            manager = BOSObjectCache;
            synchronized (manager) {
                IORMModel object = (IORMModel)BOSObjectCache.get((Object)key);
                if (object != null) {
                    return object;
                }
                Class<?> cls = Class.forName(className);
                object = (IORMModel)cls.getConstructor(argTypes).newInstance(initArgs);
                object = object.queryInterface(model);
                BOSObjectCache.put((Object)key, (Object)object);
                return object;
            }
        }
        Class<?> cls = Class.forName(className);
        IORMModel object = (IORMModel)cls.getConstructor(argTypes).newInstance(initArgs);
        if (object instanceof ICommonType) {
            ((ICommonType)object).setPK(MetaDataPK.create(pk));
            ((ICommonType)object).setType(bo.getType());
        }
        return object.queryInterface(model);
    }

    public IORMModel createObject(String objectName, Class model) throws Exception {
        return this.createObject(objectName, model, new Class[0], new Object[0]);
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }

    public IORMModel createRemoteObject(String url, String objectName, Class model) throws Exception {
        return RemoteBOSObjectFactory.getInstance(url, true).createObject(objectName, model);
    }

    public IORMModel createRemoteObject(String url, String objectName, Class model, Class[] argTypes, Object[] initArgs) throws Exception {
        return RemoteBOSObjectFactory.getInstance(url, true).createObject(objectName, model, argTypes, initArgs);
    }

    static {
        BOSObjectCache.setMaxSize(50000);
    }
}

