/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractBaseObjectValue;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.IPropertyChange;
import com.kingdee.util.Null;
import com.kingdee.util.SortedStringObjectMap;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractObjectValue
extends AbstractBaseObjectValue
implements IPropertyChange {
    private static final long serialVersionUID = -1783963448121361612L;
    protected transient Map oldValues;
    private transient boolean avalilable = true;
    private transient boolean syncOldValue = false;

    protected AbstractObjectValue(boolean init) {
        super(init);
    }

    public AbstractObjectValue(int initialCapacity) {
        super(initialCapacity);
    }

    public AbstractObjectValue(int initialCapacity, String pkField) {
        super(initialCapacity, pkField);
    }

    public AbstractObjectValue(int initialCapacity, String pkField, boolean isMD) {
        super(initialCapacity, pkField, isMD);
    }

    public AbstractObjectValue() {
    }

    protected AbstractObjectValue(String pkField) {
        super(pkField);
    }

    private static final String localedKeyName(String key, Locale locale) {
        String keyLower = key.trim() + "_" + BOSLocaleUtil.getShortCode(locale);
        return keyLower.toLowerCase();
    }

    @Override
    public Object put(String key, Object value, Locale locale) {
        Object objectValue = super.put(key, value, locale);
        if (this.isAvailable() && this.isSyncOldValue() && this.oldValues != null) {
            Locale defaultLocale;
            if (locale == null) {
                locale = ContextUtils.getLocaleFromEnv();
            }
            if ((defaultLocale = this.getDefaultLocale()) != null && locale.equals(defaultLocale)) {
                this.oldValues.put(AbstractObjectValue.localedKeyName(key, defaultLocale), value);
            } else {
                key = AbstractObjectValue.localedKeyName(key, locale);
            }
            this.oldValues.put(key.toLowerCase(), value);
        }
        return objectValue;
    }

    @Override
    public Object put(String key, Object value) throws ORMCoreException {
        Object objectValue = super.put(key, value);
        if (this.isAvailable() && this.isSyncOldValue() && this.oldValues != null) {
            this.oldValues.put(key.toLowerCase(), value);
        }
        return objectValue;
    }

    public boolean isValueChange() {
        if (!this.isAvailable() || this.oldValues == null) {
            return false;
        }
        return !this.compare(this.values, this.oldValues);
    }

    public void resetValue() {
        if (!this.isAvailable()) {
            return;
        }
        if (this.oldValues == null) {
            return;
        }
        for (Map.Entry entry : this.oldValues.entrySet()) {
            Object value = entry.getValue();
            if (value == null || !(value instanceof IObjectCollection)) continue;
            ((AbstractObjectCollection)value).resetValue();
        }
        this.values.clear();
        this.values.putAll(this.oldValues);
    }

    public void copyNewToOld() {
        if (!this.isAvailable()) {
            return;
        }
        if (this.oldValues == null) {
            this.oldValues = new SortedStringObjectMap(this.values.size());
        }
        for (Map.Entry entry : this.values.entrySet()) {
            Object value = entry.getValue();
            if (value == null || !(value instanceof IObjectCollection)) continue;
            ((IPropertyChange)value).copyNewToOld();
        }
        this.oldValues.clear();
        this.oldValues.putAll(this.values);
    }

    public boolean compareNewToOld() {
        return this.compare(this.values, this.oldValues);
    }

    private boolean compare(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (!(obj1 instanceof Map) || !(obj2 instanceof Map)) {
            return false;
        }
        Map value1 = null;
        Map value2 = null;
        if (((Map)obj1).size() < ((Map)obj2).size()) {
            value1 = (Map)obj2;
            value2 = (Map)obj1;
        } else {
            value1 = (Map)obj1;
            value2 = (Map)obj2;
        }
        try {
            for (Map.Entry e : value1.entrySet()) {
                boolean isEqual;
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value instanceof AbstractObjectCollection ? !(isEqual = ((AbstractObjectCollection)value).compareNewToOld()) : !(isEqual = AbstractObjectValue.compareValue(value, value2.get(key))))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    private static boolean compareValue(Object value1, Object value2) {
        if (value1 instanceof Boolean || value2 instanceof Boolean) {
            Boolean bool1 = value1 == null ? Boolean.FALSE : (Boolean)value1;
            Boolean bool2 = value2 == null ? Boolean.FALSE : (Boolean)value2;
            return bool1.booleanValue() == bool2.booleanValue();
        }
        if (AbstractObjectValue.isEmptyObject(value1) && AbstractObjectValue.isEmptyObject(value2)) {
            return true;
        }
        if (AbstractObjectValue.isEmptyObject(value1) || AbstractObjectValue.isEmptyObject(value2)) {
            return false;
        }
        if (value1 instanceof Byte) {
            return ((Byte)value1).compareTo((Byte)value2) == 0;
        }
        if (value1 instanceof Short) {
            return ((Short)value1).compareTo((Short)value2) == 0;
        }
        if (value1 instanceof Integer) {
            return ((Integer)value1).compareTo((Integer)value2) == 0;
        }
        if (value1 instanceof Long) {
            return ((Long)value1).compareTo((Long)value2) == 0;
        }
        if (value1 instanceof Float) {
            return ((Float)value1).compareTo((Float)value2) == 0;
        }
        if (value1 instanceof Double) {
            return ((Double)value1).compareTo((Double)value2) == 0;
        }
        if (value1 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
        }
        if (value1 instanceof String) {
            return ((String)value1).equals((String)value2);
        }
        if (value1 instanceof Date) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Time) {
            return ((Time)value1).compareTo((Time)value2) == 0;
        }
        if (value1 instanceof Timestamp) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Object[]) {
            Object[] arrValue1 = (Object[])value1;
            Object[] arrValue2 = (Object[])value2;
            if (arrValue1.length != arrValue2.length) {
                return false;
            }
            boolean retValue = true;
            for (int i = 0; i < arrValue1.length && retValue; ++i) {
                retValue = AbstractObjectValue.compareValue(arrValue1[i], arrValue2[i]);
            }
            return retValue;
        }
        if (value1 instanceof AbstractObjectValue) {
            AbstractObjectValue objectValue1 = (AbstractObjectValue)value1;
            AbstractObjectValue objectValue2 = (AbstractObjectValue)value2;
            String pkField1 = objectValue1.getPKField();
            String pkField2 = objectValue1.getPKField();
            if (pkField1 != null && pkField2 != null) {
                if (pkField1.equals(pkField2)) {
                    return AbstractObjectValue.compareValue(objectValue1.get(pkField1), objectValue2.get(pkField2));
                }
                return false;
            }
        }
        return value1.equals(value2);
    }

    private static boolean isEmptyObject(Object s) {
        if (s instanceof String) {
            return ((String)s).trim().length() == 0;
        }
        return s == null || s == Null.NULL;
    }

    public void setAvailable(boolean avalilable) {
        this.avalilable = avalilable;
    }

    public boolean isAvailable() {
        return this.avalilable;
    }

    public void setSyncOldValue(boolean syncOldValue) {
        for (Object value : this.values.values()) {
            if (!(value instanceof AbstractObjectCollection) || value == null) continue;
            ((AbstractObjectCollection)value).setSyncOldValue(syncOldValue);
        }
        this.syncOldValue = syncOldValue;
    }

    public boolean isSyncOldValue() {
        return this.syncOldValue;
    }

    void setOldValues(Map value) {
        if (value == null) {
            return;
        }
        if (this.oldValues == null) {
            this.oldValues = new SortedStringObjectMap(value.size());
        }
        this.oldValues.putAll(value);
    }

    protected static boolean equals(Object thiz, Object that) {
        if (thiz == that) {
            return true;
        }
        if (thiz == null) {
            return that == null;
        }
        return thiz.equals(that);
    }

    protected static int hashCode(Object t) {
        if (t == null) {
            return 0;
        }
        return t.hashCode();
    }
}

