/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao;

import com.ibm.db2.jcc.DB2Sqlca;
import com.ibm.db2.jcc.am.SqlDataException;
import com.ibm.db2.jcc.am.SqlException;
import com.kingdee.bos.dao.DataLimitExceedException;
import java.sql.SQLException;

public class JDBCExceptionHandler {
    public static Exception convertException(SQLException e) {
        String sqlstat = e.getSQLState();
        int code = e.getErrorCode();
        if (sqlstat == null) {
            try {
                DB2Sqlca sqllca = null;
                if (e instanceof SqlException) {
                    SqlException db2Exception = (SqlException)e;
                    sqllca = db2Exception.getSqlca();
                } else if (e instanceof SqlDataException) {
                    SqlDataException db2Exception = (SqlDataException)e;
                    sqllca = db2Exception.getSqlca();
                }
                if (sqllca != null) {
                    sqlstat = sqllca.getSqlState();
                    code = sqllca.getSqlCode();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if ("01004".equals(sqlstat) || "72000".equals(sqlstat) || "22001".equals(sqlstat) || "22003".equals(sqlstat)) {
            DataLimitExceedException dle = new DataLimitExceedException("DataLimit", e);
            dle.setSQLState(sqlstat);
            dle.setVendorCode(code);
            return dle;
        }
        return e;
    }
}

