/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class ConfigureResourceLoader {
    private static Logger logger = Logger.getLogger(ConfigureResourceLoader.class);
    private static Map loaders = new HashMap(8);
    private static String configureDir;
    private String ais;
    private String configureJar;
    private JarFile jf;
    private static ConfigureResourceLoader nullInstance;

    private static void processOldJar() {
        String cd = ConfigureResourceLoader.getConfigureDir();
        if (cd.indexOf("/client/") > 0) {
            return;
        }
        File cDir = new File(cd);
        if (cDir.exists()) {
            File oj;
            File cp = new File(cDir, "configure.properties");
            Properties prop = new Properties();
            if (cp.exists()) {
                try {
                    prop.load(new FileInputStream(cp));
                }
                catch (FileNotFoundException e) {
                    logger.warn((Object)e, (Throwable)e);
                }
                catch (IOException e) {
                    logger.warn((Object)e, (Throwable)e);
                }
                if ("true".equalsIgnoreCase(prop.getProperty("processedOldJar"))) {
                    return;
                }
            }
            if ((oj = new File(cDir, "dynamic-configure-metas.jar")).exists()) {
                try {
                    ArrayList<String> ids = ConfigMDUtil.getDataCenterIDs();
                    for (String id : ids) {
                        File child = new File(cDir, id);
                        if (!child.exists()) {
                            child.mkdir();
                        }
                        File nj = new File(child, "dynamic-configure-metas.jar");
                        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(oj));
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(nj));
                        int num = 0;
                        byte[] buffer = new byte[4096];
                        while ((num = bis.read(buffer)) >= 0) {
                            bos.write(buffer, 0, num);
                        }
                        bis.close();
                        bos.close();
                        nj.setLastModified(oj.lastModified());
                    }
                    prop.setProperty("processedOldJar", "true");
                    prop.store(new FileOutputStream(cp), null);
                    oj.renameTo(new File(cDir, "dynamic-configure-metas.jar.bak"));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private static void initLoaders() {
        File[] children;
        String cd = ConfigureResourceLoader.getConfigureDir();
        File cDir = new File(cd);
        if (cDir.exists() && (children = cDir.listFiles()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                try {
                    File file;
                    if (!children[i].isDirectory() || !(file = new File(children[i], "dynamic-configure-metas.jar")).exists()) continue;
                    ConfigureResourceLoader loader = new ConfigureResourceLoader(file.getName(), file.getCanonicalPath());
                    loader.init();
                    loaders.put(children[i].getName(), loader);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
        nullInstance = new ConfigureResourceLoader("nullInstance", "nullInstance");
    }

    public static ConfigureResourceLoader getInstance(Context ctx) {
        String ais = ConfigMDUtil.getAIS(ctx);
        return ConfigureResourceLoader.getInstance(ais);
    }

    public static synchronized ConfigureResourceLoader getInstance(String ais) {
        if (StringUtils.isEmpty((String)ais)) {
            return nullInstance;
        }
        ConfigureResourceLoader loader = (ConfigureResourceLoader)loaders.get(ais);
        if (loader == null) {
            loader = new ConfigureResourceLoader(ais, ConfigureResourceLoader.getConfigureJar(ais));
            loader.init();
            loaders.put(ais, loader);
        }
        return loader;
    }

    public static synchronized Map getAllLoaders() {
        return (Map)((HashMap)loaders).clone();
    }

    private ConfigureResourceLoader(String ais, String configJar) {
        this.ais = ais;
        this.configureJar = configJar;
    }

    public synchronized InputStream getResourceAsStream(String name) {
        if (this.jf == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (name.startsWith("/")) {
            if (name.length() > 1) {
                name = name.substring(1);
            } else {
                return null;
            }
        }
        try {
            ZipEntry entry = this.jf.getEntry(name);
            if (entry == null) {
                return null;
            }
            InputStream is = this.jf.getInputStream(entry);
            if (is == null) {
                return null;
            }
            return new BufferedInputStream(is);
        }
        catch (IOException ignore) {
            logger.debug((Object)ignore, (Throwable)ignore);
            int n = 2;
            for (int i = 0; i < n; ++i) {
                try {
                    return this.getResourceAsStream0(name);
                }
                catch (IOException ioe) {
                    if (i == n - 1) {
                        logger.error((Object)ioe, (Throwable)ioe);
                        return null;
                    }
                    logger.debug((Object)ioe, (Throwable)ioe);
                    continue;
                }
            }
            logger.warn((Object)"ConfigureResourceLoader should't happen! Maybe has bug!");
            return null;
        }
    }

    private InputStream getResourceAsStream0(String name) throws IOException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            logger.error((Object)e1, (Throwable)e1);
        }
        this.init();
        if (this.jf == null) {
            return null;
        }
        ZipEntry entry = this.jf.getEntry(name);
        if (entry == null) {
            return null;
        }
        InputStream is = this.jf.getInputStream(entry);
        if (is == null) {
            return null;
        }
        return new BufferedInputStream(is);
    }

    public synchronized void clear() {
        if (this.jf != null) {
            try {
                this.jf.close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
            this.jf = null;
        }
    }

    public synchronized void init() {
        File file = new File(this.configureJar);
        if (file.exists()) {
            try {
                this.jf = new JarFile(file);
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else {
            this.jf = null;
        }
    }

    public String getConfigureJar() {
        return this.configureJar;
    }

    public String getAis() {
        return this.ais;
    }

    public static String getConfigureJar(Context ctx) {
        String ais = ConfigMDUtil.getAIS(ctx);
        return ConfigureResourceLoader.getConfigureJar(ais);
    }

    public static String getConfigureJar(String ais) {
        String configureDir = ConfigureResourceLoader.getConfigureDir();
        if (StringUtils.isEmpty((String)ais)) {
            return configureDir + "/" + "dynamic-configure-metas.jar";
        }
        return configureDir + "/" + ais + "/" + "dynamic-configure-metas.jar";
    }

    private static synchronized String getConfigureDir() {
        if (configureDir != null) {
            return configureDir;
        }
        configureDir = System.getProperty("configure.path");
        if (StringUtils.isEmpty((String)configureDir)) {
            String home = System.getProperty("EAS_HOME");
            String rpcConfig = System.getProperty("ormrpc.config");
            configureDir = rpcConfig != null && rpcConfig.toLowerCase().indexOf("client") > 0 || home != null && home.toLowerCase().indexOf("client") > 0 ? home + "/client/metas/" + "configure" : home + "/server/metas/" + "configure";
        }
        return configureDir;
    }

    public synchronized IMetaDataPK[] getMetaDataPKsByType(BOSObjectType type, String pkgName, boolean deep) {
        if (this.jf == null) {
            return new IMetaDataPK[0];
        }
        String suffix = Utils.getMetaDataSuffix(type);
        ArrayList<MetaDataPK> pks = new ArrayList<MetaDataPK>();
        Enumeration<JarEntry> enu = this.jf.entries();
        while (enu.hasMoreElements()) {
            String entryName;
            JarEntry entry = enu.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(suffix)) continue;
            String fullName = entryName.substring(0, entryName.lastIndexOf(46));
            fullName = fullName.replace('/', '.');
            String pkg = null;
            if (fullName.indexOf(46) > 0) {
                pkg = fullName.substring(0, fullName.lastIndexOf(46));
            }
            if (pkgName == null) {
                if (pkg != null) continue;
                pks.add(MetaDataPK.create(fullName));
                continue;
            }
            if (pkg == null) continue;
            if (deep) {
                if (!pkg.equals(pkgName) && !pkg.startsWith(pkgName + ".")) continue;
                pks.add(new MetaDataPK(fullName));
                continue;
            }
            if (!pkg.endsWith(pkgName)) continue;
            pks.add(new MetaDataPK(fullName));
        }
        return pks.toArray(new IMetaDataPK[0]);
    }

    public static synchronized boolean exist(String name) {
        if (loaders.size() > 0) {
            for (ConfigureResourceLoader loader : loaders.values()) {
                InputStream is = loader.getResourceAsStream(name);
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e, (Throwable)e);
                }
                return true;
            }
        }
        return false;
    }

    public static synchronized void removeLoader(String ais) {
        loaders.remove(ais);
    }

    static {
        try {
            ConfigureResourceLoader.processOldJar();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            ConfigureResourceLoader.initLoaders();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

