/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.ICurrentProvider;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

public class Current {
    private static final String PROVIDER_CLASS_NAME = "com.kingdee.bos.dao.xml.impl.CurrentProvider";
    private static final String PROVIDER_PROPERTY_KEY = "metadata.current.provider_classname";
    private String solutionDefaultLocale;
    private static final String DEFAULT_LOCALE;
    private ICurrentProvider provider;

    public Current() {
        this((String)null);
    }

    public Current(ICurrentProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Current's provider is null.");
        }
        this.provider = provider;
    }

    public Current(String providerClassName) {
        Class pclass = null;
        pclass = Current.newClassInstance(providerClassName);
        if (pclass == null) {
            String prop = null;
            try {
                prop = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(Current.PROVIDER_PROPERTY_KEY);
                    }
                });
            }
            catch (Throwable _) {
                // empty catch block
            }
            pclass = Current.newClassInstance(prop);
            if (pclass == null) {
                pclass = Current.newClassInstance(PROVIDER_CLASS_NAME);
            }
        }
        if (pclass == null) {
            throw new IllegalArgumentException("Can't get PCurrent Provider Class.");
        }
        try {
            this.provider = (ICurrentProvider)pclass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't get PCurrent Provider Object," + pclass + " no default Constructor.");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't get PCurrent Provider Object," + pclass + " default Constructor not public.");
        }
    }

    public Context getContext() {
        return this.provider.getContext();
    }

    public String getLocale() {
        String l = this.provider.getSessionLocale();
        if (l == null) {
            l = this.solutionDefaultLocale;
        }
        if (l == null) {
            l = DEFAULT_LOCALE;
        }
        return l;
    }

    private static Class newClassInstance(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        Class<?> rtv = null;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            rtv = tcl.loadClass(name);
        }
        catch (ClassNotFoundException cnf) {
            try {
                rtv = Class.forName(name);
            }
            catch (ClassNotFoundException cnf1) {
                // empty catch block
            }
        }
        return rtv;
    }

    public String getSolutionDefaultLocale() {
        return this.solutionDefaultLocale;
    }

    public void setSolutionDefaultLocale(String solutionDefaultLocale) {
        this.solutionDefaultLocale = solutionDefaultLocale;
    }

    static {
        Locale dl = LocaleUtils.getDefaultOriginLocale();
        DEFAULT_LOCALE = LocaleUtils.getLocaleString((Locale)dl);
    }
}

