/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.xml.impl.AbstractProxyStateManager;
import com.kingdee.bos.dao.xml.impl.DocumentStateEnum;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.dao.xml.impl.StateProxyManager;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public final class DocumentProxyStateManager
extends AbstractProxyStateManager {
    private static Logger logger = Logger.getLogger(DocumentProxyStateManager.class);
    private static volatile boolean repeatLog = true;
    private static final Set<String> logged = new HashSet<String>();
    private static boolean globalMdbview;
    private static final String SOLUTION_TYPE;
    public String uri;
    private String type;
    private volatile IStateManager ref = null;
    private transient boolean mdbview;
    private DocumentStateEnum docState = DocumentStateEnum.WHOLE;
    private final transient StateReferenceWatch watch = new StateReferenceWatch();
    private final transient ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private Project.Projects projects;

    public DocumentProxyStateManager(String pkg, String name, String type) {
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)type)) {
            throw new IllegalArgumentException("TODO");
        }
        this.uri = new MetaDataPK2(pkg, name, type).getKey();
        this.type = type;
    }

    public DocumentProxyStateManager(String url) {
        MetaDataPK2 pk2 = new MetaDataPK2(url);
        this.uri = pk2.getKey();
        this.type = pk2.getType();
    }

    public DocumentProxyStateManager() {
    }

    @Override
    public Object getStateValue(String key) {
        if ("name".equals(key)) {
            return MetaDataPK2.getNameFromURL(this.uri);
        }
        if ("package".equals(key)) {
            return MetaDataPK2.getPackageFromURL(this.uri);
        }
        return super.getStateValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStateManager getDelegate() {
        boolean isWrite;
        IStateManager sm;
        block17: {
            sm = null;
            IStateManager sm2 = null;
            isWrite = false;
            try {
                this.rwl.readLock().lock();
                if (this.ref == null) {
                    this.rwl.readLock().unlock();
                    this.rwl.writeLock().lock();
                    try {
                        if (this.ref == null) {
                            MDLoader loader = MDLoader.getInstance();
                            if (loader == null) {
                                throw new IllegalStateException("Solution not init.");
                            }
                            IStateManager rtv = this.mdbview || globalMdbview && !this.uri.endsWith(SOLUTION_TYPE) ? loader.findMD4Mdbview(new MetaDataPK2(this.uri)) : loader.findMD(new MetaDataPK2(this.uri), this.docState, this.projects);
                            if (rtv == null && (repeatLog || !repeatLog && !logged.contains(this.uri))) {
                                logged.add(this.uri);
                                if (DocumentStateEnum.WHOLE.equals((Object)this.docState)) {
                                    logger.error((Object)("Can't find " + this.uri));
                                } else {
                                    logger.error((Object)("Can't find " + this.uri + "    docState: " + (Object)((Object)this.docState)));
                                }
                            }
                            this.ref = ConfigMDUtil.isExMapContains(this.uri) ? null : rtv;
                            sm2 = rtv;
                            isWrite = true;
                        }
                    }
                    catch (DataAccessException e) {
                        logger.error((Object)e, (Throwable)((Object)e));
                    }
                    finally {
                        this.rwl.readLock().lock();
                        this.rwl.writeLock().unlock();
                    }
                    sm = sm2;
                    break block17;
                }
                sm = this.ref;
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
        if (isWrite) {
            this.watch.write(sm);
        } else {
            this.watch.read(sm);
        }
        return sm;
    }

    public void setDelegate(IStateManager sm) {
        this.rwl.writeLock().lock();
        this.ref = sm;
        this.watch.write(sm);
        this.rwl.writeLock().unlock();
    }

    @Override
    public void clear() {
        this.rwl.writeLock().lock();
        IStateManager s = this.ref;
        this.ref = null;
        if (s != null) {
            s.clear();
        }
        this.rwl.writeLock().unlock();
    }

    public int hashCode() {
        return MetaDataPK2.getFullNameFromURL(this.uri).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DocumentProxyStateManager) {
            return ((DocumentProxyStateManager)o).uri.equals(this.uri);
        }
        return false;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.trueClone) {
            return this;
        }
        return MDLoader.getInstance().loadMD(new MetaDataPK2(this.uri), this.projects).getStateManager();
    }

    public void setMdbview(boolean mdbview) {
        this.mdbview = mdbview;
    }

    public static void setGlobalMdbview(boolean mdbview) {
        globalMdbview = mdbview;
    }

    public void setDocState(DocumentStateEnum docState) {
        this.docState = docState;
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        super.marshal(marshaller);
        marshaller.writeObject((Object)this.projects);
        marshaller.writeObject((Object)this.type);
        if (this.trueClone) {
            this.getDelegate();
            marshaller.writeObject((Object)(this.getRealFullName() + '!' + MetaDataPK2.getTypeFromURL(this.uri)));
            marshaller.writeObject((Object)this.ref);
        } else {
            marshaller.writeObject((Object)this.uri);
        }
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        super.unmarshal(unmarshaller);
        this.projects = (Project.Projects)unmarshaller.readObject();
        this.type = (String)unmarshaller.readObject();
        this.uri = (String)unmarshaller.readObject();
        if (this.trueClone) {
            this.ref = (IStateManager)unmarshaller.readObject();
        }
    }

    public static boolean isRepeatLog() {
        return repeatLog;
    }

    public static void setRepeatLog(boolean repeatLog) {
        DocumentProxyStateManager.repeatLog = repeatLog;
    }

    public String getRealPackage() {
        return (String)super.getStateValue("package");
    }

    public String getRealName() {
        return (String)super.getStateValue("name");
    }

    public String getRealFullName() {
        String pkg = this.getRealPackage();
        String name = this.getRealName();
        if (StringUtils.isEmpty((String)pkg)) {
            return name;
        }
        return pkg + "." + name;
    }

    public Project.Projects getProjects() {
        return this.projects;
    }

    public void setProjects(Project.Projects projects) {
        this.projects = projects;
        this.watch.resetKey();
    }

    public boolean isNull() {
        IStateManager sm = this.getDelegate();
        if (sm instanceof DynamicStateManager) {
            return ((DynamicStateManager)sm).isNull();
        }
        return false;
    }

    static {
        SOLUTION_TYPE = MetaDataTypeList.SOLUTION.toString();
    }

    private class StateReferenceWatch {
        private String key = null;
        private int i = 0;

        private StateReferenceWatch() {
        }

        String getKey() {
            if (this.key != null) {
                return this.key;
            }
            String k = DocumentProxyStateManager.this.uri;
            if (DocumentProxyStateManager.this.projects != null) {
                k = k + Project.Projects.getKey(DocumentProxyStateManager.this.projects);
            }
            this.key = k;
            return this.key;
        }

        void resetKey() {
            this.key = null;
        }

        void read(IStateManager sm) {
            if (sm != null && this.i > 10 && !this.exclude()) {
                StateProxyManager.getInstance().get(this.getKey(), DocumentProxyStateManager.this);
                this.i = 0;
            }
            ++this.i;
        }

        void write(IStateManager sm) {
            if (!this.exclude()) {
                StateProxyManager.getInstance().put(this.getKey(), DocumentProxyStateManager.this);
            }
        }

        private boolean exclude() {
            return SOLUTION_TYPE.equals(DocumentProxyStateManager.this.type);
        }
    }
}

