/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.ILoaderProvider;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.dao.xml.impl.RootNameHandler;
import com.kingdee.bos.dao.xml.impl.RootNameHandlerExcepiton;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.PKIndexs;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class MDObjectCreatorFactory {
    static Creator getCommonCreator(ILoaderProvider loader, MetaDataPK2 pk2) {
        DynamicCreator lastCreator = new DynamicCreator(loader, pk2);
        lastCreator.setPrevious(new InfoCreator(loader, pk2)).setPrevious(new BasicCreator(loader, pk2)).setPrevious(new MetaCreatorWrapper(loader, pk2));
        return lastCreator;
    }

    static Creator getNoConfigureCreator(ILoaderProvider loader, MetaDataPK2 pk2) {
        DynamicCreator lastCreator = new DynamicCreator(loader, pk2);
        lastCreator.setPrevious(new BasicCreator(loader, pk2)).setPrevious(new MetaCreatorWrapper(loader, pk2));
        return lastCreator;
    }

    static Creator getConfigureCreator(ILoaderProvider loader, MetaDataPK2 pk2) {
        BasicCreator lastCreator = new BasicCreator(loader, pk2);
        lastCreator.setPrevious(new MetaCreatorWrapper(loader, pk2));
        return lastCreator;
    }

    static Creator getDynamicCreator(ILoaderProvider loader, MetaDataPK2 pk2, Project.Projects depends) {
        DynamicCreator lastCreator = new DynamicCreator(loader, pk2, depends);
        lastCreator.setPrevious(new InfoCreator(loader, pk2, depends)).setPrevious(new BasicCreator(loader, pk2)).setPrevious(new MetaCreatorWrapper(loader, pk2));
        return lastCreator;
    }

    static class MetaCreatorWrapper
    extends MetaCreator {
        MetaCreatorWrapper(ILoaderProvider loader, String type) {
            super(loader, type);
        }

        MetaCreatorWrapper(ILoaderProvider loader, MetaDataPK2 pk2) {
            super(loader, pk2.getType());
        }

        @Override
        AbstractMetaDataValue innerCreate() {
            if (MetaDataTypeList.ABSTRACTTABLE.toString().equals(this.type)) {
                return null;
            }
            return super.innerCreate();
        }
    }

    static class MetaCreator
    extends AbstractCreator {
        private static final Logger logger = Logger.getLogger(MetaCreator.class);
        protected ILoaderProvider loader;
        protected String type;
        protected String secondName;

        MetaCreator(ILoaderProvider loader, String type) {
            this(loader, type, null);
        }

        MetaCreator(ILoaderProvider loader, String type, String secondName) {
            this.type = type;
            this.secondName = secondName;
            this.loader = loader;
        }

        @Override
        AbstractMetaDataValue innerCreate() {
            String className = null;
            try {
                EntityObjectInfo eoi = this.loader.getMetaLoader().loadMeta(BOSObjectType.create((String)this.type));
                if (!StringUtils.isEmpty((String)this.secondName)) {
                    MetaDataPK pk = MetaDataPK.create(eoi.getPackage(), this.secondName);
                    eoi = (EntityObjectInfo)this.loader.getMetaLoader().loadMetametaData(pk);
                }
                className = eoi.getObjectValueClass();
                Class<?> clazz = Class.forName(className);
                clazz = Class.forName(className);
                return (AbstractMetaDataValue)clazz.newInstance();
            }
            catch (Exception e) {
                logger.debug((Object)("Create InfoInstance for type[" + this.type + "] failed! ClassName[" + className + "]"));
                return null;
            }
        }
    }

    static class BasicCreator
    extends AbstractCreator {
        private static final Logger logger = Logger.getLogger(BasicCreator.class);
        private ILoaderProvider loader;
        private MetaDataPK2 pk2;

        public BasicCreator(ILoaderProvider loader, MetaDataPK2 pk2) {
            this.pk2 = pk2;
            this.loader = loader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        AbstractMetaDataValue innerCreate() {
            String resName = this.pk2.getPath();
            InputStream is = this.loader.getMetaDataClassLoader().getResourceAsStream(resName);
            Object dom = null;
            String name = null;
            if (is != null) {
                RootNameHandler rootNameHandler = new RootNameHandler();
                try {
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    parser.parse(is, (DefaultHandler)rootNameHandler);
                }
                catch (RootNameHandlerExcepiton se) {
                    name = rootNameHandler.getName();
                }
                catch (Exception e) {
                    logger.debug((Object)("basic create metadata info failed, parse from file error. pk=" + this.pk2.getKey()));
                    AbstractMetaDataValue abstractMetaDataValue = null;
                    return abstractMetaDataValue;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (name == null) {
                logger.debug((Object)("basic create metadata info failed, get no content from file. pk=" + this.pk2.getKey()));
                return null;
            }
            AbstractMetaDataValue obj = new MetaCreator(this.loader, this.pk2.getType(), name).create();
            return obj;
        }
    }

    static class DynamicCreator
    extends AbstractCreator {
        private static final Logger logger = Logger.getLogger(DynamicCreator.class);
        private ILoaderProvider loader;
        private MetaDataPK2 pk2;
        private Project.Projects depends;

        public DynamicCreator(ILoaderProvider loader, MetaDataPK2 pk2) {
            this.pk2 = pk2;
            this.loader = loader;
            this.depends = null;
        }

        public DynamicCreator(ILoaderProvider loader, MetaDataPK2 pk2, Project.Projects depends) {
            this(loader, pk2);
            this.depends = depends;
        }

        @Override
        AbstractMetaDataValue innerCreate() {
            String name = null;
            RootNameHandler rootNameHandler = new RootNameHandler();
            try {
                InputStream[] iss = DBConfigureResourceLoader.getResourceAsStream(this.pk2, BOSObjectType.create((String)this.pk2.getType()), this.depends);
                if (iss != null && iss.length > 0) {
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    parser.parse(iss[0], (DefaultHandler)rootNameHandler);
                }
            }
            catch (RootNameHandlerExcepiton se) {
                name = rootNameHandler.getName();
            }
            catch (Exception e) {
                logger.debug((Object)("dynamic create metadata info failed, get resource from db error. pk=" + this.pk2.getKey()));
                return null;
            }
            if (name == null) {
                logger.debug((Object)("dynamic create metadata info failed, get no content from db. pk=" + this.pk2.getKey()));
                return null;
            }
            AbstractMetaDataValue obj = new MetaCreator(this.loader, this.pk2.getType(), name).create();
            return obj;
        }
    }

    static class InfoCreator
    extends AbstractCreator {
        private ILoaderProvider loader;
        private MetaDataPK2 pk2;
        private Project.Projects depends;

        InfoCreator(ILoaderProvider loader, MetaDataPK2 pk2) {
            this.loader = loader;
            this.pk2 = pk2;
            this.depends = null;
        }

        InfoCreator(ILoaderProvider loader, MetaDataPK2 pk2, Project.Projects depends) {
            this(loader, pk2);
            this.depends = depends;
        }

        @Override
        AbstractMetaDataValue innerCreate() {
            AbstractMetaDataValue obj = null;
            String type = this.pk2.getType();
            PKIndexs pkIndexs = this.loader.getMDContext().pkIndexs;
            if (MetaDataTypeList.DATATABLE.toString().equalsIgnoreCase(type)) {
                obj = new DataTableInfo();
            } else if (MetaDataTypeList.CROSSTABLE.toString().equalsIgnoreCase(type)) {
                obj = new CrossTableInfo();
            } else if (MetaDataTypeList.EXTENDEDTABLE.toString().equalsIgnoreCase(type)) {
                obj = new ExtendedTableInfo();
            } else if (MetaDataTypeList.JOINQUERY.toString().equalsIgnoreCase(type)) {
                obj = new JoinQueryInfo();
            } else if (MetaDataTypeList.UNIONQUERY.toString().equalsIgnoreCase(type)) {
                obj = new UnionQueryInfo();
            } else if (MetaDataTypeList.ABSTRACTTABLE.toString().equals(type)) {
                BOSObjectType rt = pkIndexs.getRealType(this.depends, this.pk2);
                if (MetaDataTypeList.DATATABLE.equals((Object)rt)) {
                    obj = new DataTableInfo();
                } else if (MetaDataTypeList.CROSSTABLE.equals((Object)rt)) {
                    obj = new CrossTableInfo();
                } else if (MetaDataTypeList.EXTENDEDTABLE.equals((Object)rt)) {
                    obj = new ExtendedTableInfo();
                }
            } else if (MetaDataTypeList.BASEQUERY.toString().equals(this.pk2.getType())) {
                BOSObjectType rt = pkIndexs.getRealType(this.depends, this.pk2);
                if (MetaDataTypeList.JOINQUERY.equals((Object)rt)) {
                    obj = new JoinQueryInfo();
                } else if (MetaDataTypeList.UNIONQUERY.equals((Object)rt)) {
                    obj = new UnionQueryInfo();
                }
            }
            return obj;
        }
    }

    static abstract class AbstractCreator
    implements Creator {
        private Creator previous = null;

        AbstractCreator() {
        }

        @Override
        public final AbstractMetaDataValue create() {
            AbstractMetaDataValue obj = null;
            Creator previous = this.previous();
            if (previous != null) {
                obj = previous.create();
            }
            if (obj != null) {
                return obj;
            }
            return this.innerCreate();
        }

        abstract AbstractMetaDataValue innerCreate();

        AbstractCreator setPrevious(Creator pre) {
            this.previous = pre;
            if (pre instanceof AbstractCreator) {
                return (AbstractCreator)pre;
            }
            return null;
        }

        Creator previous() {
            return this.previous;
        }
    }

    static class MDObject {
        AbstractMetaDataValue obj;
        Element dom;

        MDObject() {
        }
    }

    static interface Creator {
        public AbstractMetaDataValue create();
    }
}

