/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLStore;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.ContainerHolder;
import com.kingdee.bos.dao.xml.impl.ElementProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MapStateManager;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.dao.xml.impl.PathStack;
import com.kingdee.bos.dao.xml.impl.RefrenceHolder;
import com.kingdee.bos.engine.impl.MetadataXMLAssembler;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class MDParser {
    private static final Logger logger = Logger.getLogger(MDParser.class);
    private final MDLoader provider;
    String solutionName;
    private final MetadataXMLAssembler assembler;
    private Set<String> localeNames;
    private boolean inited = false;

    public MDParser(MDLoader provider) {
        this.provider = provider;
        this.assembler = new MetadataXMLAssembler(provider.metaLoader);
        try {
            this.initLocales();
        }
        catch (Exception _) {
            logger.error((Object)"Cant NOT init Metadata solution. Maybe MetadataPath error", (Throwable)_);
            throw new IllegalAccessError("Cant NOT init Metadata solution. Maybe MetadataPath error" + _);
        }
    }

    private MDLoader getProvider() {
        if (this.provider != null) {
            return this.provider;
        }
        return MDLoader.getInstance();
    }

    private synchronized void initLocales() throws JDOMException, IOException {
        if (!this.inited) {
            InputStream slis = this.getProvider().getSolutionStream();
            Element root = XMLParser.parseXML((InputStream)slis).getRootElement();
            slis.close();
            Namespace nameSpace = root.getNamespace();
            this.solutionName = root.getChildTextTrim("name", nameSpace);
            Element dl = root.getChild("defaultLang", nameSpace).getChild("key", nameSpace);
            String dlName = dl.getAttributeValue("value");
            ArrayList<String> langs = new ArrayList<String>(4);
            String defaultLang = null;
            List ls = root.getChild("languages", nameSpace).getChildren("language", nameSpace);
            int size = ls.size();
            for (int i = 0; i < size; ++i) {
                Element element = (Element)ls.get(i);
                String locale = element.getChildText("localeString", nameSpace);
                langs.add(locale);
                String name = element.getChildTextTrim("name", nameSpace);
                if (!name.equals(dlName)) continue;
                defaultLang = locale;
            }
            List<LanguageInfo> configLangs = BOSLocaleUtil.getConfigLanguages();
            this.localeNames = new HashSet<String>(3);
            this.localeNames.add(defaultLang);
            if (configLangs.size() == 0) {
                this.localeNames.addAll(langs);
            } else {
                for (LanguageInfo languageInfo : configLangs) {
                    this.localeNames.add(languageInfo.getLocaleString());
                }
            }
            this.inited = true;
        }
        assert (this.inited) : "Init Locale error";
        assert (this.localeNames != null) : "Mutil languages info NOT inited.";
    }

    public IStateManager parseMDFromStream(EntityObjectInfo meta, InputStream is, InputStream isFrag) throws Exception {
        return this.parseMDFromStream(meta, is, isFrag, null);
    }

    public IStateManager parseMDFromStream(EntityObjectInfo meta, InputStream is, InputStream isFrag, Project.Projects projects) throws Exception {
        if (is == null && isFrag == null) {
            return null;
        }
        Element root = null;
        if (isFrag == null) {
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        } else if (is == null) {
            root = XMLParser.parseXML((InputStream)isFrag).getRootElement();
        } else {
            Document doc = XMLParser.parseXML((InputStream)is);
            Document docFrag = XMLParser.parseXML((InputStream)isFrag);
            Document docMerged = this.assembler.merge(meta, doc, docFrag);
            root = docMerged.getRootElement();
        }
        if (is != null) {
            is.close();
        }
        if (isFrag != null) {
            isFrag.close();
        }
        return this.parseMDFromDOM(meta, root, projects);
    }

    public IStateManager parseMDFromDOM(EntityObjectInfo meta, Element dom) {
        return this.parseMDFromDOM(meta, dom, null);
    }

    public IStateManager parseMDFromDOM(EntityObjectInfo meta, Element dom, Project.Projects projects) {
        Element root = dom;
        Map<String, Map<String, String>> resource = this.prepareResource(meta, root);
        PathStack stack = new PathStack();
        AbstractMetaDataValue shell = (AbstractMetaDataValue)this.getInstanceByMeta(meta, null);
        ArrayList<RefrenceHolder> appended = new ArrayList<RefrenceHolder>();
        this.parse0(meta, shell, root, resource, stack, appended, projects);
        IStateManager sm = shell.getStateManager();
        int size = appended.size();
        for (int i = 0; i < size; ++i) {
            RefrenceHolder holder = (RefrenceHolder)appended.get(i);
            holder.parse();
        }
        return sm;
    }

    private void parse0(EntityObjectInfo meta, AbstractMDValue shell, Element element, Map<String, Map<String, String>> resource, PathStack stack, List<RefrenceHolder> appended, Project.Projects projects) {
        String propName;
        PropertyInfo prop;
        int i;
        int size;
        PropertyCollection props;
        IStateManager sm = shell.getStateManager();
        if (sm == null) {
            sm = new MapStateManager();
            shell.setStateManager(sm);
        }
        String eleName = element.getName();
        PathStack.Entry entry = new PathStack.Entry(eleName, meta.getType().toString(), shell);
        stack.push(entry);
        Namespace ns = element.getNamespace();
        try {
            props = meta.getLogicalKeyPropertiesRuntime();
            size = props.size();
            for (i = 0; i < size; ++i) {
                prop = props.get(i);
                propName = prop.getName();
                String propValue = element.getChildTextTrim(propName, ns);
                sm.setStateValue(propName, propValue);
                entry.kvs.put(propName, propValue);
            }
        }
        catch (Throwable _) {
            // empty catch block
        }
        this.processExtendedProperty(sm, element, resource);
        props = meta.getInheritedPropertiesRuntime();
        size = props.size();
        for (i = 0; i < size; ++i) {
            prop = props.get(i);
            propName = prop.getName();
            Element subElement = element.getChild(propName, ns);
            if (subElement == null) continue;
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                String propValue = subElement.getTextTrim();
                if (ownProp.isMultilingual()) {
                    this.processLocaleValue(sm, propName, propValue, resource);
                    continue;
                }
                sm.setStateValue(propName, propValue);
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
            RelationshipInfo relation = linkProp.getRelationship();
            EntityObjectInfo subMeta = relation.getSupplierObject();
            CardinalityType car = relation.getSupplierCardinality();
            if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)car) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)car)) {
                this.processCollection(relation, sm, propName, subMeta, subElement, resource, stack, appended, projects);
                continue;
            }
            RelationshipType type = relation.getType();
            if (RelationshipType.COMPOSITION.equals((Object)type)) {
                AbstractMDElement subShell = (AbstractMDElement)this.getInstanceByMeta(subMeta, null);
                sm.setStateValue(propName, subShell);
                EntityObjectInfo subMeta1 = subMeta;
                try {
                    subMeta1 = this.getProvider().metaLoader.loadMeta(subShell.getBOSType());
                }
                catch (MissingDAOMetaDataException e) {
                    // empty catch block
                }
                this.parse0(subMeta1, subShell, subElement, resource, stack, appended, projects);
                continue;
            }
            String xpath = relation.getString("xmlNodeRelationship");
            if (StringUtils.isEmpty((String)xpath)) {
                if (subElement.getChildren().size() == 0 && subElement.getAttributes().size() == 0) {
                    sm.setStateValue(propName, null);
                }
                ContainerHolder holder = new ContainerHolder(sm, propName);
                this.linkDocumentRef(holder, subMeta, subElement, projects);
                continue;
            }
            this.linkElementRef(new ContainerHolder(sm, propName), subMeta, subElement, xpath, stack, appended, projects);
        }
        stack.pop();
        sm.trimToSize();
    }

    private void linkElementRef(ContainerHolder holder, EntityObjectInfo targetMeta, Element currentNode, String xpath, PathStack stack, List<RefrenceHolder> appended, Project.Projects projects) {
        StringTokenizer token = new StringTokenizer(xpath, "$");
        String docDesc = token.nextToken();
        String docType = token.nextToken();
        String eleDesc = token.nextToken();
        Element docElement = this.getPathElement(currentNode, docDesc);
        AbstractMetaDataValue doc = this.getDocObject(docElement, docType, projects);
        AbstractMetaDataValue ownerDoc = (AbstractMetaDataValue)stack.firstEntry().obj;
        if (docType.startsWith("(uioj)") && (doc == null || ownerDoc instanceof WebUIObjectInfo)) {
            doc = ownerDoc;
        }
        PathStack path = new PathStack();
        this.processElementPath(targetMeta, currentNode, eleDesc, path);
        boolean isSelfRef = false;
        if (!path.hasEntityProperty()) {
            isSelfRef = this.equalsByPK(doc, ownerDoc);
        }
        if (isSelfRef) {
            doc = (AbstractMetaDataValue)stack.firstEntry().obj;
            RefrenceHolder append = new RefrenceHolder(doc, path, holder);
            appended.add(append);
        } else {
            if (doc == null) {
                try {
                    AbstractMDElement targetObject = this.getFooObject(targetMeta, path);
                    holder.link(targetObject);
                }
                catch (Exception _) {
                    // empty catch block
                }
                return;
            }
            ElementProxyStateManager elementProxy = new ElementProxyStateManager(doc, path);
            if ("metametadata.entity.baseProperty".equals(targetMeta.getFullName()) || "metametadata.bizrule.baseRule".equals(targetMeta.getFullName())) {
                AbstractMDValue shell = null;
                AbstractMetaDataValue noStopDoc = doc;
                if (this.equalsByPK(noStopDoc, ownerDoc)) {
                    noStopDoc = ownerDoc;
                }
                ElementProxyStateManager realProxy = new ElementProxyStateManager(noStopDoc, path);
                AbstractMDValue realValue = realProxy.resolveDelegate();
                try {
                    shell = (AbstractMDValue)realValue.getClass().newInstance();
                }
                catch (Exception _) {
                    logger.fatal((Object)"get real type error.", (Throwable)_);
                }
                shell.setStateManager(elementProxy);
                holder.link(shell);
            } else {
                AbstractMDElement eleObject = (AbstractMDElement)this.getInstanceByMeta(targetMeta, null);
                eleObject.setStateManager(elementProxy);
                holder.link(eleObject);
            }
        }
    }

    private boolean equalsByPK(AbstractMetaDataValue a, AbstractMetaDataValue b) {
        if (a == null || b == null) {
            return false;
        }
        try {
            if (a.getFullName().equals(b.getFullName())) {
                BOSObjectType atype = a.getBOSType();
                BOSObjectType btype = b.getBOSType();
                try {
                    if (Utils.getMetaDataSuffix(atype).equals(Utils.getMetaDataSuffix(btype))) {
                        return true;
                    }
                }
                catch (Exception _) {
                    return false;
                }
            }
            return false;
        }
        catch (Throwable _) {
            return false;
        }
    }

    private Element getPathElement(Element node, String script) {
        Element elem = node;
        StringTokenizer token = new StringTokenizer(script, ".");
        String temp = null;
        while (token.hasMoreElements()) {
            temp = token.nextToken();
            if (temp.equalsIgnoreCase("root")) {
                elem = elem.getDocument().getRootElement();
            } else if (temp.equalsIgnoreCase("parent")) {
                elem = elem.getParent();
            } else if (!temp.equalsIgnoreCase("this")) {
                elem = elem.getChild(temp, elem.getNamespace());
            }
            if (elem != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("can NOT find Document's Desc Element for Path[" + script + "]"));
            }
            return null;
        }
        return elem;
    }

    private AbstractMetaDataValue getDocObject(Element docElement, String type, Project.Projects projects) {
        type = type.substring(1, 5);
        if (docElement == null) {
            return null;
        }
        String pkg = docElement.getChildTextTrim("package", docElement.getNamespace());
        String name = docElement.getChildTextTrim("name", docElement.getNamespace());
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)pkg)) {
            List keys = docElement.getChildren("key", docElement.getNamespace());
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                Element item = (Element)keys.get(i);
                String keyName = item.getAttributeValue("name");
                if (StringUtils.isEmpty((String)name) && "name".equals(keyName)) {
                    name = item.getAttributeValue("value");
                }
                if (!StringUtils.isEmpty((String)pkg) || !"package".equals(keyName)) continue;
                pkg = item.getAttributeValue("value");
            }
        }
        return this.getProvider().loadMD(new MetaDataPK2(pkg, name, type), projects);
    }

    private void processElementPath(EntityObjectInfo targetMeta, Element node, String xpath, PathStack paths) {
        StringTokenizer token = new StringTokenizer(xpath, "/");
        while (token.hasMoreTokens()) {
            String path = token.nextToken();
            String meta = targetMeta.getType().toString();
            int pos = path.indexOf(40);
            if (pos != -1) {
                meta = path.substring(1, 5);
                path = path.substring(6);
            }
            String refPropName = path.substring(0, path.indexOf(91));
            String elePath = path.substring(path.indexOf(91) + 1, path.indexOf(93));
            Element eleElement = this.getPathElement(node, elePath);
            PathStack.Entry entry = new PathStack.Entry(refPropName, meta, null);
            if (eleElement != null) {
                List keys = eleElement.getChildren("key", eleElement.getNamespace());
                int size = keys.size();
                for (int i = 0; i < size; ++i) {
                    Element key = (Element)keys.get(i);
                    entry.kvs.put(key.getAttributeValue("name"), key.getAttributeValue("value"));
                }
            }
            paths.push(entry);
        }
    }

    private void linkDocumentRef(ContainerHolder holder, EntityObjectInfo refMeta, Element subElement, Project.Projects projects) {
        AbstractMDValue doc = this.getDocumentRef(refMeta, subElement, projects);
        holder.link(doc);
    }

    private AbstractMDValue getDocumentRef(EntityObjectInfo refMeta, Element subElement, Project.Projects projects) {
        String pkg = null;
        String name = null;
        List keys = subElement.getChildren("key", subElement.getNamespace());
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            Element key = (Element)keys.get(i);
            String kname = key.getAttributeValue("name");
            String kvalue = key.getAttributeValue("value");
            if ("package".equals(kname)) {
                pkg = kvalue;
                continue;
            }
            if (!"name".equals(kname)) continue;
            name = kvalue;
        }
        MetaDataPK2 pk2 = new MetaDataPK2(pkg, name, refMeta.getType().toString());
        AbstractMetaDataValue doc = this.getProvider().loadMD(pk2, projects);
        return doc;
    }

    private void processCollection(RelationshipInfo relation, IStateManager target, String propName, EntityObjectInfo subMeta, Element collElement, Map<String, Map<String, String>> resource, PathStack stack, List<RefrenceHolder> appended, Project.Projects projects) {
        IObjectCollection coll = this.getCollectionByMeta(subMeta);
        target.setStateValue(propName, coll);
        assert (propName.equals(collElement.getName()));
        PathStack.Entry entry = new PathStack.Entry(propName, subMeta.getType().toString(), coll);
        stack.push(entry);
        boolean isComp = RelationshipType.COMPOSITION.equals((Object)relation.getType());
        List eles = collElement.getChildren();
        if (isComp) {
            for (int i = 0; i < eles.size(); ++i) {
                Element element = (Element)eles.get(i);
                AbstractMDValue subObject = this.getInstanceByMeta(subMeta, element.getName());
                EntityObjectInfo subMeta1 = subMeta;
                try {
                    subMeta1 = this.getProvider().metaLoader.loadMeta(subObject.getBOSType());
                }
                catch (MissingDAOMetaDataException e) {
                    // empty catch block
                }
                coll.addObjectDirect(subObject);
                this.parse0(subMeta1, subObject, element, resource, stack, appended, projects);
            }
        } else {
            for (int i = 0; i < eles.size(); ++i) {
                Element element = (Element)eles.get(i);
                String xpath = relation.getString("xmlNodeRelationship");
                if (StringUtils.isEmpty((String)xpath)) {
                    this.linkDocumentRef(new ContainerHolder(coll), subMeta, element, projects);
                    continue;
                }
                this.linkElementRef(new ContainerHolder(coll), subMeta, element, xpath, stack, appended, projects);
            }
        }
        stack.pop();
        coll.updateIndex();
        coll.trimToSize();
    }

    private void processLocaleValue(IStateManager target, String propName, String key, Map<String, Map<String, String>> resource) {
        for (String locale : this.localeNames) {
            String value = resource.get(locale).get(key);
            if (value == null) continue;
            target.setLocaleValue(propName, value, locale);
        }
    }

    private void processExtendedProperty(IStateManager target, Element root, Map<String, Map<String, String>> resource) {
        String epKey = XMLStore.getMutlilingualKey(root);
        Map<String, String> exs = resource.get(epKey);
        if (exs == null) {
            epKey = XMLStore.getMutlilingualKey2(root);
            exs = resource.get(epKey);
        }
        if (exs != null) {
            target.getExtendedProperties().putAll(exs);
        }
    }

    private AbstractMDValue getInstanceByMeta(EntityObjectInfo meta, String secondName) {
        try {
            if (!StringUtils.isEmpty((String)secondName)) {
                try {
                    MetaDataPK pk = MetaDataPK.create(meta.getPackage(), secondName);
                    meta = (EntityObjectInfo)this.getProvider().metaLoader.loadMetametaData(pk);
                }
                catch (Exception _) {
                    // empty catch block
                }
            }
            String clazzName = meta.getObjectValueClassRuntime();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                clazz = Class.forName(clazzName);
            }
            Object obj = clazz.newInstance();
            if (!(obj instanceof AbstractMDValue)) {
                clazz = Class.forName(clazzName);
                obj = clazz.newInstance();
            }
            return (AbstractMDValue)obj;
        }
        catch (Exception _) {
            logger.fatal((Object)"Can NOT instance MD Info Object.", (Throwable)_);
            throw new RuntimeException("ferror", _);
        }
    }

    private IObjectCollection getCollectionByMeta(EntityObjectInfo meta) {
        String clazzName = meta.getObjectCollectionClass();
        try {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                clazz = Class.forName(clazzName);
            }
            Object obj = clazz.newInstance();
            if (!(obj instanceof IObjectCollection)) {
                clazz = Class.forName(clazzName);
                obj = clazz.newInstance();
            }
            return (IObjectCollection)obj;
        }
        catch (Throwable _) {
            return null;
        }
    }

    private Map<String, Map<String, String>> prepareResource(EntityObjectInfo meta, Element rootEleement) {
        HashMap<String, Map<String, String>> rtv = new HashMap<String, Map<String, String>>();
        for (String name : this.localeNames) {
            HashMap localeBag = new HashMap(30);
            rtv.put(name, localeBag);
        }
        Element resource = rootEleement.getChild("resource", rootEleement.getNamespace());
        List rss = resource.getChildren("rs", rootEleement.getNamespace());
        int size = rss.size();
        for (int i = 0; i < size; ++i) {
            this.processResource(meta, rtv, (Element)rss.get(i));
        }
        return rtv;
    }

    private void processResource(EntityObjectInfo meta, Map<String, Map<String, String>> bag, Element rs) {
        String key = rs.getAttributeValue("key");
        List langs = rs.getChildren("lang", rs.getNamespace());
        int pos = key.indexOf("extendedProperty.");
        if (pos != -1) {
            Element lang;
            String componentName = key.substring(0, pos);
            String exKey = key.substring(pos + 17, key.length());
            Map<String, String> ex = bag.get(componentName);
            if (ex == null) {
                ex = new HashMap<String, String>(3);
                bag.put(componentName, ex);
            }
            String value = null;
            Iterator i$ = langs.iterator();
            while (i$.hasNext() && "null".equals(value = (lang = (Element)i$.next()).getAttributeValue("value"))) {
            }
            if (!"null".equals(value)) {
                ex.put(exKey, value);
            }
        } else {
            String s;
            for (Element lang : langs) {
                String lname = lang.getAttributeValue("locale");
                if (!this.localeNames.contains(lname)) continue;
                String value = lang.getAttributeValue("value");
                if (key.startsWith("bizEnum")) {
                    if ("null".equals(value)) {
                        value = key.endsWith(".alias") ? "" : null;
                    }
                } else if (StringUtils.isEmpty((String)value) || "null".equals(value)) {
                    if (key.endsWith(".alias")) {
                        int m = key.lastIndexOf("[");
                        int n = key.lastIndexOf("].");
                        if (m > 0 && n > 0) {
                            s = key.substring(m + 1, n);
                            int l = s.lastIndexOf(46);
                            if (l >= 0) {
                                s = s.substring(l + 1);
                            }
                            value = s;
                        }
                    } else {
                        value = null;
                    }
                }
                if (value == null) continue;
                bag.get(lname).put(key, value);
            }
            if (ResourceListenerManager.isMultiLanguages()) {
                int m = key.indexOf("[");
                int n = key.indexOf("].");
                if (m > 0 && n > 0) {
                    String pk = key.substring(m + 1, n);
                    String locale = null;
                    if (ConfigMDUtil.isClient()) {
                        locale = LocaleUtils.getLocaleString((Locale)ConfigMDUtil.getContext().getOriginLocale());
                    }
                    for (String lname : this.localeNames) {
                        if (locale != null && !lname.equals(locale) || StringUtils.isEmpty((String)(s = ResourceListenerManager.getString((IMetaDataPK)MetaDataPK.create(pk), meta.getType(), LocaleUtils.getLocale((String)lname), key)))) continue;
                        bag.get(lname).put(key, s);
                    }
                }
            }
        }
    }

    private AbstractMDElement getFooObject(EntityObjectInfo targetMeta, PathStack path) {
        try {
            String className = targetMeta.getObjectValueClassRuntime();
            Class<?> clazz = Class.forName(className);
            AbstractMDElement targetObject = (AbstractMDElement)clazz.newInstance();
            Map values = path.lastEntry().kvs;
            for (Map.Entry entry : values.entrySet()) {
                targetObject.put((String)entry.getKey(), entry.getValue());
            }
            targetObject.getStateManager().setStateValue("_state_", "true");
            return targetObject;
        }
        catch (Exception _) {
            return null;
        }
    }

    public IStateManager parseMDFromDOM4Mdbview(EntityObjectInfo meta, Element dom) {
        int i;
        PropertyCollection props;
        Element element = dom;
        AbstractMetaDataValue shell = (AbstractMetaDataValue)this.getInstanceByMeta(meta, null);
        IStateManager sm = shell.getStateManager();
        Namespace ns = element.getNamespace();
        Map<String, Map<String, String>> resource = this.prepareResource(meta, element);
        try {
            props = meta.getLogicalKey().getKeyPropertys();
            for (i = 0; i < props.size(); ++i) {
                PropertyInfo prop = props.get(i);
                String propName = prop.getName();
                String propValue = element.getChildTextTrim(propName, ns);
                sm.setStateValue(propName, propValue);
            }
        }
        catch (Throwable _) {
            // empty catch block
        }
        this.processExtendedProperty(sm, element, resource);
        props = meta.getInheritedPropertiesRuntime();
        int size = props.size();
        for (i = 0; i < size; ++i) {
            String xpath;
            RelationshipType type;
            Element subElement;
            PropertyInfo prop = props.get(i);
            String propName = prop.getName();
            if (!"package".equals(propName) && !"name".equals(propName) && !"alias".equals(propName) && !"description".equals(propName) && !"bosType".equals(propName) && !"baseEntity".equals(propName) && !"isAbstract".equals(propName) || (subElement = element.getChild(propName, ns)) == null) continue;
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                String propValue = subElement.getTextTrim();
                if (ownProp.isMultilingual()) {
                    this.processLocaleValue(sm, propName, propValue, resource);
                    continue;
                }
                sm.setStateValue(propName, propValue);
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
            RelationshipInfo relation = linkProp.getRelationship();
            EntityObjectInfo subMeta = relation.getSupplierObject();
            CardinalityType car = relation.getSupplierCardinality();
            if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)car) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)car) || RelationshipType.COMPOSITION.equals((Object)(type = relation.getType())) || !StringUtils.isEmpty((String)(xpath = relation.getString("xmlNodeRelationship")))) continue;
            if (subElement.getChildren().size() == 0 && subElement.getAttributes().size() == 0) {
                sm.setStateValue(propName, null);
            }
            ContainerHolder holder = new ContainerHolder(sm, propName);
            this.linkDocumentRef(holder, subMeta, subElement, null);
        }
        return sm;
    }

    public IStateManager parseMDFromStream(EntityObjectInfo meta, InputStream is, InputStream[] isFrag, Project.Projects projects) throws Exception {
        if (is == null && isFrag == null) {
            return null;
        }
        Element root = null;
        if (isFrag == null || isFrag.length == 0) {
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        } else if (is == null) {
            Document docMerged = XMLParser.parseXML((InputStream)isFrag[0]);
            for (int i = 1; i < isFrag.length; ++i) {
                Document docFrag = XMLParser.parseXML((InputStream)isFrag[i]);
                docMerged = this.assembler.merge(meta, docMerged, docFrag);
            }
            root = docMerged.getRootElement();
        } else {
            Document doc;
            Document docMerged = doc = XMLParser.parseXML((InputStream)is);
            for (int i = 0; i < isFrag.length; ++i) {
                Document docFrag = XMLParser.parseXML((InputStream)isFrag[i]);
                docMerged = this.assembler.merge(meta, docMerged, docFrag);
            }
            root = docMerged.getRootElement();
        }
        if (is != null) {
            is.close();
        }
        if (isFrag != null) {
            for (int i = 0; i < isFrag.length; ++i) {
                isFrag[i].close();
            }
        }
        return this.parseMDFromDOM(meta, root, projects);
    }
}

