/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.LRUCache;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public final class MetaDataPK2
extends MetaDataPK {
    public static final char TYPE_SPLIT = '!';
    private static final char NAME_SPLIT = '.';
    private static final Pattern uriPat = Pattern.compile("^[\\w]+(\\.[\\w]+)*![\\w]+$");
    public static final String PACKAGE_KEY = "package";
    public static final String NAME_KEY = "name";
    public static final String TYPE_KEY = "bosType";
    private String uri;
    private static LRUCache<String, MetaDataPK2> map = new LRUCache(100000);

    public MetaDataPK2() {
        super(true);
    }

    public MetaDataPK2(String fullname, String type) {
        this(null, fullname, type);
    }

    public MetaDataPK2(String pkg, String name, String type) {
        super(true);
        this.setURI(MetaDataPK2.computeURI(pkg, name, type));
    }

    public MetaDataPK2(String uri) {
        super(true);
        this.setURI(uri);
    }

    public String getURI() {
        return this.uri;
    }

    private void setURI(String uri) {
        if (!MetaDataPK2.check(uri)) {
            throw new IllegalArgumentException("MetaDataPK2 URI[" + uri + "] invalid!");
        }
        this.uri = uri.intern();
    }

    private static boolean check(String uri) {
        if (StringUtils.isEmpty((String)uri)) {
            return false;
        }
        return uriPat.matcher(uri).matches();
    }

    private static String computeURI(String pkg, String name, String type) {
        StringBuffer buff = new StringBuffer();
        if (!StringUtils.isEmpty((String)pkg)) {
            buff.append(pkg);
            buff.append('.');
        }
        if (!StringUtils.isEmpty((String)name)) {
            buff.append(name);
        }
        if (!StringUtils.isEmpty((String)type)) {
            buff.append('!');
            buff.append(type);
        }
        return buff.toString();
    }

    @Override
    public String getFullName() {
        return MetaDataPK2.getFullNameFromURL(this.uri);
    }

    @Override
    public String getName() {
        return MetaDataPK2.getNameFromURL(this.uri);
    }

    @Override
    public String getPackage() {
        return MetaDataPK2.getPackageFromURL(this.uri);
    }

    public String getType() {
        return MetaDataPK2.getTypeFromURL(this.uri);
    }

    public String getKey() {
        return this.uri;
    }

    public String getPath() {
        String suffix = Utils.getMetaDataSuffix(BOSObjectType.create((String)this.getType()));
        return "/" + this.getFullName().replace('.', '/') + suffix;
    }

    public String getPath2() {
        String suffix = Utils.getMetaDataSuffix(BOSObjectType.create((String)this.getType()));
        return this.getFullName().replace('.', '/') + suffix;
    }

    @Override
    public int compareTo(Object o) {
        return this.uri.compareTo(((MetaDataPK2)o).uri);
    }

    @Override
    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MetaDataPK2) {
            return this.uri.equals(((MetaDataPK2)o).uri);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.uri;
    }

    public static String getPackageFromURL(String url) {
        int pos = url.lastIndexOf(46);
        if (pos < 0) {
            pos = 0;
        }
        return url.substring(0, pos);
    }

    public static String getNameFromURL(String url) {
        int pos1 = url.lastIndexOf(46);
        int pos2 = url.lastIndexOf(33);
        return url.substring(pos1 + 1, pos2);
    }

    public static String getTypeFromURL(String url) {
        int pos = url.lastIndexOf(33);
        return url.substring(pos + 1);
    }

    public static String getFullNameFromURL(String url) {
        int pos = url.lastIndexOf(33);
        return url.substring(0, pos);
    }

    public static MetaDataPK2 fromPath(String path) {
        if (path.charAt(0) == File.separatorChar) {
            path = path.substring(1);
        }
        int pos = path.lastIndexOf(46);
        String suffix = path.substring(pos + 1);
        String fullname = path.substring(0, pos);
        String type = Utils.getBOSTypeBySuffix(suffix);
        return new MetaDataPK2(fullname.replace(File.separatorChar, '.'), type);
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.uri);
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.setURI((String)unmarshaller.readObject());
    }

    public static MetaDataPK2 createPK2(String pkg, String name, String type) {
        String uri = MetaDataPK2.computeURI(pkg, name, type);
        MetaDataPK2 pk2 = (MetaDataPK2)map.get((Object)uri);
        if (pk2 == null) {
            pk2 = new MetaDataPK2(uri);
            map.put((Object)uri, (Object)pk2);
        }
        return pk2;
    }
}

