/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.layout.JSONUtils;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBUpdateInfoSet
implements Serializable {
    List infos = new ArrayList();

    public void addDBUpdateInfo(DBUpdateInfo info) {
        if (info == null) {
            return;
        }
        Iterator iter = this.infos.iterator();
        while (iter.hasNext()) {
            DBUpdateInfo have = (DBUpdateInfo)iter.next();
            if (!have.equals(info)) continue;
            iter.remove();
        }
        this.infos.add(info);
        this.sort();
    }

    public void delDBUupdateInfo(DBUpdateInfo info) {
        if (info == null) {
            return;
        }
        Iterator iter = this.infos.iterator();
        while (iter.hasNext()) {
            DBUpdateInfo have = (DBUpdateInfo)iter.next();
            if (!have.equals(info)) continue;
            iter.remove();
        }
        this.sort();
    }

    public void addDBUpdateInfo(List list) {
        if (list == null) {
            return;
        }
        for (Object obj : list) {
            if (!(obj instanceof DBUpdateInfo)) continue;
            this.addDBUpdateInfo((DBUpdateInfo)obj);
        }
    }

    public void delDBUpdateInfo(List list) {
        if (list == null) {
            return;
        }
        for (Object obj : list) {
            if (!(obj instanceof DBUpdateInfo)) continue;
            this.delDBUupdateInfo((DBUpdateInfo)obj);
        }
    }

    public List getDBUpdateInfoSet() {
        return this.infos;
    }

    public String toSql() {
        StringBuffer sb = new StringBuffer();
        for (DBUpdateInfo com : this.infos) {
            sb.append(com.getSql().getValue() + "\n");
        }
        return sb.toString();
    }

    public void printSql() {
        System.out.println(this.toSql());
    }

    public JSONObject toJSONObject() throws Exception {
        JSONObject base = new JSONObject();
        ArrayList<Map> list = new ArrayList<Map>(this.infos.size());
        for (DBUpdateInfo com : this.infos) {
            list.add(com.toMap());
        }
        base.put("updatesql", list);
        return base;
    }

    public static DBUpdateInfoSet toDBUpdateInfoSet(String json) throws Exception {
        DBUpdateInfoSet info = new DBUpdateInfoSet();
        if (!StringUtils.isEmpty((String)json)) {
            JSONObject base = new JSONObject(json);
            JSONArray array = JSONUtils.getJSONArray(base, "updatesql");
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                JSONObject obj = array.getJSONObject(i);
                Integer type = JSONUtils.getIntger(obj, "type");
                String tableName = JSONUtils.getString(obj, "tableName");
                String name = JSONUtils.getString(obj, "name");
                String sql = JSONUtils.getString(obj, "sql");
                Integer forDBType = JSONUtils.getIntger(obj, "forDBType");
                if (type == null || tableName == null || name == null || sql == null || forDBType == null) continue;
                DBUpdateInfo com = new DBUpdateInfo(type, tableName, name, sql, forDBType);
                info.addDBUpdateInfo(com);
            }
            info.sort();
        }
        return info;
    }

    public void sort() {
        ComparatorDBUpdateInfo comparator = new ComparatorDBUpdateInfo();
        Collections.sort(this.infos, comparator);
    }

    class ComparatorDBUpdateInfo
    implements Comparator {
        ComparatorDBUpdateInfo() {
        }

        public int compare(Object arg0, Object arg1) {
            if (!(arg0 instanceof DBUpdateInfo) || !(arg1 instanceof DBUpdateInfo)) {
                return -1;
            }
            DBUpdateInfo db0 = (DBUpdateInfo)arg0;
            DBUpdateInfo db1 = (DBUpdateInfo)arg1;
            if (db0.getType().isNull() || db1.getType().isNull()) {
                return -1;
            }
            return db0.getType().getValue() - db1.getType().getValue();
        }
    }
}

