/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.IXMLDAO;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.DevMDException;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class MetaDataLoaderBridge
implements IXMLDAO {
    private static Logger logger = Logger.getLogger(MetaDataLoaderBridge.class);
    private Context ctx = null;
    private BOSObjectType bosType = null;

    private IDevMetadataLoader getMDLoader() {
        return (IDevMetadataLoader)this.ctx.get((Object)"DEVMETADATALOADER");
    }

    public MetaDataLoaderBridge(Context ctx, BOSObjectType bosType, IDevMetadataLoader mdLoader) {
        this.ctx = ctx;
        this.bosType = bosType;
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }

    @Override
    public BOSObjectType getType() {
        return this.bosType;
    }

    @Override
    public boolean exists(IObjectPK pk) throws DataAccessException {
        return this.getMDLoader().exist(this.bosType, (IMetaDataPK)pk);
    }

    @Override
    public IObjectValue getValue(IObjectPK pk) throws DataAccessException {
        try {
            AbstractMetaDataValue rtv = this.getMDLoader().loadMetadata(this.bosType, (IMetaDataPK)pk);
            return rtv;
        }
        catch (MDNotFoundException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public IObjectPK addnew(IObjectValue value) throws DataAccessException {
        try {
            AbstractMetaDataValue md = (AbstractMetaDataValue)value;
            this.getMDLoader().saveMetadata(md);
            return MetaDataPK.create(md.getFullName());
        }
        catch (MDSaveException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void addnew(IObjectPK pk, IObjectValue value) throws DataAccessException {
        try {
            AbstractMetaDataValue md = (AbstractMetaDataValue)value;
            IMetaDataPK pk2 = (IMetaDataPK)pk;
            md.setName(pk2.getName());
            md.setPackage(pk2.getPackage());
            this.getMDLoader().saveMetadata(md);
        }
        catch (MDSaveException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void update(IObjectPK pk, IObjectValue value) throws DataAccessException {
        try {
            AbstractMetaDataValue md = (AbstractMetaDataValue)value;
            IMetaDataPK pk2 = (IMetaDataPK)pk;
            md.setName(pk2.getName());
            md.setPackage(pk2.getPackage());
            this.getMDLoader().saveMetadata(md);
        }
        catch (MDSaveException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void delete(IObjectPK pk) throws DataAccessException {
        try {
            this.getMDLoader().deleteMetadata(this.bosType, (IMetaDataPK)pk);
        }
        catch (MDSaveException e) {
            throw new DataAccessException(e);
        }
        catch (DevMDException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public IObjectPK[] getPKList() throws DataAccessException {
        return this.getPKList("");
    }

    @Override
    public IObjectCollection getCollection() throws DataAccessException {
        return this.getCollection("");
    }

    @Override
    public IObjectCollection getCollection(String pgName) throws DataAccessException {
        try {
            String suffix = Utils.getMetaDataSuffix(this.bosType);
            int NUM = suffix.length();
            SortedMap pk2s = this.getMDLoader().getMetadataByPackage(pgName, null, null, true);
            XMLLoader loader = this.getMDLoader().getMetametaLoader();
            EntityObjectInfo meta = loader.loadMeta(this.bosType);
            String className = meta.getObjectCollectionClass();
            IObjectCollection opks = (IObjectCollection)Class.forName(className).newInstance();
            for (String pk : pk2s.keySet()) {
                if (!pk.endsWith(suffix)) continue;
                pk = pk.substring(0, pk.length() - NUM);
                pk = pk.replace('/', '.');
                MetaDataPK mpk = MetaDataPK.create(pk);
                AbstractMetaDataValue amd = this.getMDLoader().loadMetadata(this.bosType, mpk);
                if (StringUtils.equals((String)mpk.getPackage(), (String)amd.getPackage()) && StringUtils.equals((String)mpk.getName(), (String)amd.getName())) {
                    opks.addObject(amd);
                    continue;
                }
                logger.warn((Object)(amd.getFullName() + " in " + "package: " + (mpk.getPackage() == null ? "" : mpk.getPackage()) + ", packageName or name is not matched!"));
            }
            return opks;
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public IObjectPK[] getPKList(String pgName) throws DataAccessException {
        try {
            String suffix = Utils.getMetaDataSuffix(this.bosType);
            int NUM = suffix.length();
            SortedMap pk2s = this.getMDLoader().getMetadataByPackage(pgName, null, null, true);
            ArrayList<MetaDataPK> opks = new ArrayList<MetaDataPK>(pk2s.size());
            for (String pk : pk2s.keySet()) {
                if (!pk.endsWith(suffix)) continue;
                opks.add(MetaDataPK.create(pk.substring(0, pk.length() - NUM)));
            }
            return opks.toArray(new IObjectPK[opks.size()]);
        }
        catch (DevMDException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public Map loadResource(IObjectPK pk) throws DataAccessException {
        try {
            return this.getMDLoader().loadResource(this.bosType, (IMetaDataPK)pk);
        }
        catch (MDNotFoundException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public Map loadResource(InputStream is) throws DataAccessException {
        throw new DataAccessException();
    }

    @Override
    public void storeResource(IObjectPK pk, Map resource) throws DataAccessException {
        try {
            this.getMDLoader().saveResource(this.bosType, (IMetaDataPK)pk, resource);
        }
        catch (MDSaveException e) {
            throw new DataAccessException(e);
        }
        catch (MDNotFoundException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void storeResource(IObjectValue metadata, Map resources) throws DataAccessException {
        try {
            this.getMDLoader().saveResource((AbstractMetaDataValue)metadata, resources);
        }
        catch (MDSaveException e) {
            throw new DataAccessException(e);
        }
        catch (MDNotFoundException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void storeResource(InputStream is, OutputStream os, Map hash) throws DataAccessException {
        throw new DataAccessException();
    }

    @Override
    public void loadMetametaData(IObjectPK pk) throws DataAccessException {
        XMLAccessEngine.loadMetametaData(this.ctx, pk);
    }

    @Override
    public void check(IObjectPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), pk, filter, report, os);
    }

    @Override
    public void check(IObjectPK pk, CheckReportFilter filter, ICheckReport report) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), pk, filter, report);
    }

    @Override
    public void check(IObjectPK pk, CheckReportFilter filter, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), pk, filter, os);
    }

    @Override
    public IObjectValue load(InputStream is) throws DataAccessException {
        throw new DataAccessException();
    }

    @Override
    public void store(IObjectValue ov, OutputStream os) throws DataAccessException {
        throw new DataAccessException();
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), ui, filter, report, os);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), ui, filter, report);
    }

    @Override
    public void check(AbstractMetaDataValue ui, CheckReportFilter filter, OutputStream os) throws DataAccessException {
        XMLAccessEngine.getXMLChecker(this.ctx).check(this.getType(), ui, filter, os);
    }
}

