/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.difftool;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.difftool.FileMetaInfo;
import com.kingdee.bos.engine.difftool.Log;
import com.kingdee.bos.engine.difftool.MetaBase;
import com.kingdee.bos.engine.difftool.PathsHelper;
import com.kingdee.bos.engine.difftool.XMLDiffer;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.XMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jdom.Document;

public class Differ {
    private static final Logger logger = Logger.getLogger((String)"bos.metadata.diff.Main");
    private static final String[] METAMETA_PKS = new String[]{"metametadata.bizrule.action", "metametadata.bizrule.baseExpression", "metametadata.bizrule.baseRule", "metametadata.bizrule.computationRule", "metametadata.bizrule.condition", "metametadata.bizrule.conditionRule", "metametadata.bizrule.constraintRule", "metametadata.bizrule.groupExpression", "metametadata.bizrule.method", "metametadata.bizrule.parameter", "metametadata.bizrule.property", "metametadata.bizrule.ruleSet", "metametadata.bizrule.simpleExpression", "metametadata.bizunit.bizField", "metametadata.bizunit.bizFieldTemplateSet", "metametadata.bizunit.bizFieldView", "metametadata.bizunit.bizTemplate", "metametadata.bizunit.bizUnit", "metametadata.bo.businessObject", "metametadata.bo.method", "metametadata.bo.paramAssociation", "metametadata.bo.parameter", "metametadata.bo.strategy", "metametadata.bot.BOTDelRevRule", "metametadata.bot.BOTDelRevRuleSegment", "metametadata.bot.BOTGrouping", "metametadata.bot.BOTMapping", "metametadata.bot.BOTRelation", "metametadata.bot.BOTRelationEntry", "metametadata.bot.BOTRevRule", "metametadata.bot.BOTRevRuleSegment", "metametadata.bot.BOTRule", "metametadata.bot.BOTRuleSegment", "metametadata.common.abstractMeta", "metametadata.common.constraint", "metametadata.data.abstractTable", "metametadata.data.column", "metametadata.data.crossTable", "metametadata.data.dataTable", "metametadata.data.extendedTable", "metametadata.data.fkColumnPair", "metametadata.data.foreignKey", "metametadata.data.index", "metametadata.data.indexColumn", "metametadata.data.keyMap", "metametadata.data.primaryKey", "metametadata.data.primaryKeyColumn", "metametadata.data.tableMap", "metametadata.datax.dataX", "metametadata.eai.Activity", "metametadata.eai.Adapter", "metametadata.eai.Application", "metametadata.eai.ApplicationNode", "metametadata.eai.DataExchange", "metametadata.eai.DataSource", "metametadata.eai.Integration", "metametadata.eai.RoutePolicy", "metametadata.eai.ServicesRequire", "metametadata.eai.Task", "metametadata.entity.baseProperty", "metametadata.entity.constraint", "metametadata.entity.defaultView", "metametadata.entity.entityObject", "metametadata.entity.extendedField", "metametadata.entity.filter", "metametadata.entity.filterItem", "metametadata.entity.linkProperty", "metametadata.entity.logicalKey", "metametadata.entity.numericConstraint", "metametadata.entity.ownProperty", "metametadata.entity.regexConstraint", "metametadata.entity.relationship", "metametadata.entity.scriptConstraint", "metametadata.entity.selectorItem", "metametadata.entity.sorterItem", "metametadata.event.event", "metametadata.event.eventMethod", "metametadata.event.formalParameter", "metametadata.event.parameterMapping", "metametadata.facade.facade", "metametadata.function.functionObject", "metametadata.function.operation", "metametadata.function.uiActionRef", "metametadata.management.application.application", "metametadata.management.application.appview", "metametadata.management.application.dependence", "metametadata.management.application.metadata", "metametadata.management.application.referSubSystem", "metametadata.management.application.subSystem", "metametadata.management.baseTemplateRef", "metametadata.management.baseTemplateRefSet", "metametadata.management.deployOption", "metametadata.management.language", "metametadata.management.package", "metametadata.management.solution", "metametadata.management.suffix", "metametadata.mdquery.configItem", "metametadata.mdquery.cube", "metametadata.mdquery.dataSource", "metametadata.mdquery.dimension", "metametadata.mdquery.dimensionUsage", "metametadata.mdquery.hierarchy", "metametadata.mdquery.level", "metametadata.mdquery.mdQuery", "metametadata.mdquery.measure", "metametadata.mdquery.property", "metametadata.query.baseQuery", "metametadata.query.join", "metametadata.query.joinItem", "metametadata.query.joinQuery", "metametadata.query.parameter", "metametadata.query.propertyRef", "metametadata.query.propertyUnit", "metametadata.query.queryField", "metametadata.query.queryFilter", "metametadata.query.queryFilterItem", "metametadata.query.queryPK", "metametadata.query.querySorterItem", "metametadata.query.subEntity", "metametadata.query.subObject", "metametadata.query.subQuery", "metametadata.query.unionQuery", "metametadata.query.virtualField", "metametadata.query.virtualQuery", "metametadata.report.linkUI", "metametadata.report.parameter", "metametadata.report.parameterMapping", "metametadata.report.report", "metametadata.report.template", "metametadata.resource.bizDataType", "metametadata.resource.bizEnum", "metametadata.resource.bizException", "metametadata.resource.bizExceptionSubItem", "metametadata.resource.enumValue", "metametadata.resource.i18nResource", "metametadata.resource.imageResource", "metametadata.resource.resource", "metametadata.resource.resourceItem", "metametadata.rule.rule", "metametadata.rule.ruleMethod", "metametadata.rule.ruleProperty", "metametadata.service.log.item", "metametadata.service.log.log", "metametadata.service.log.logBizRef", "metametadata.service.log.methodRef", "metametadata.service.mutex.item", "metametadata.service.mutex.mutex", "metametadata.service.param", "metametadata.service.permission.bizProperty", "metametadata.service.permission.bizRef", "metametadata.service.permission.dependence", "metametadata.service.permission.entityObjectRef", "metametadata.service.permission.permission", "metametadata.service.permission.permissionItem", "metametadata.service.permission.refPermissionItem", "metametadata.service.service", "metametadata.ui.action", "metametadata.ui.component", "metametadata.ui.dataObject", "metametadata.ui.eventBinding", "metametadata.ui.layout", "metametadata.ui.property", "metametadata.ui.propertyBinding", "metametadata.ui.status", "metametadata.ui.statusItem", "metametadata.ui.uiObject", "metametadata.view.metaDataBrief", "metametadata.view.metaDataBriefView", "metametadata.workflow.wfRole", "metametadata.workflow.workFlow", "metametadata.webpage.webPageObject", "metametadata.webcomponent.webComponentObject", "metadata.webmacro.WebMacro", "metadata.webrule.WebRule", "metametadata.webcontrol.webControlObject"};
    private final MetaBase baseMeta;
    private final Log diffLog;
    private final XMLDiffer xmlDiffer;
    private final MetaBase newMeta;

    public static void main(String[] args) throws Exception {
        String outdir;
        File dir;
        long start = System.currentTimeMillis();
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getLogger((String)"bos.metadata.diff").setLevel(Level.DEBUG);
        if (args.length != 3) {
            logger.error((Object)"\u4e3b\u7a0b\u5e8f\u8f93\u5165\u53c2\u6570\u683c\u5f0f\u4e0d\u5bf9\uff0c\u7a0b\u5e8f\u9000\u51fa\u3002");
            System.out.println("\u6bd4\u8f83\u7a0b\u5e8f\u7684\u8f93\u5165\u53c2\u6570\u4e0d\u5bf9\u3002\u5fc5\u987b\u662f\uff1a Differ <logdir> <newMetadata> <baseMetadata>");
            System.exit(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\n -- \u5f00\u59cb\u68c0\u67e5\u7a0b\u5e8f\u8f93\u5165\u53c2\u6570\u7684\u5408\u6cd5\u6027...");
        }
        if (!(dir = new File(outdir = args[0])).isDirectory()) {
            System.out.println("\u65e5\u5fd7\u8f93\u51fa\u76ee\u5f55\u4e0d\u662f\u5408\u6cd5\u7684\u76ee\u5f55\u3002outdir=" + outdir);
            System.exit(1);
        }
        if (!dir.canWrite()) {
            System.out.println("\u65e5\u5fd7\u8f93\u51fa\u76ee\u5f55\u65e0\u5199\u6743\u9650\u3002outdir=" + outdir);
            System.exit(1);
        }
        String newMetadata = args[1];
        logger.info((Object)("NewMetadata dir is: " + newMetadata));
        String baseMetadata = args[2];
        logger.info((Object)("BaseMetadata dir is: " + baseMetadata));
        List appendNew = PathsHelper.expandPaths(newMetadata);
        if (appendNew.size() == 0) {
            logger.error((Object)"new\u5143\u6570\u636e\u5c55\u5f00\u5f8c\u4e3a\u7a7a\u3002");
            System.exit(1);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("NewMetadata Detail dirs is: " + appendNew));
        }
        List appendBase = PathsHelper.expandPaths(baseMetadata);
        if (appendBase.size() == 0) {
            logger.error((Object)"base\u5143\u6570\u636e\u5c55\u5f00\u5f8c\u4e3a\u7a7a\u3002");
            System.exit(1);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("BaseMetadata Detail dirs is: " + appendBase));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\n -- \u5f00\u59cb\u6784\u9020\u6bd4\u8f83\u5bf9\u8c61...");
        }
        Differ differ = new Differ(dir, appendNew, appendBase);
        differ.initLoadFiles();
        Map fileResult = differ.fileDiff();
        Set detailDiff = (Set)fileResult.get("Mod");
        differ.detailDiff(detailDiff);
        differ.log(fileResult);
        long used = System.currentTimeMillis() - start;
        logger.info((Object)("OK! used " + used + " ms"));
    }

    Differ(File out, List news, List bases) throws IOException {
        this.diffLog = new Log(out);
        XMLLoader metaLoader = this.initMetametaLoader();
        this.xmlDiffer = new XMLDiffer(metaLoader, this.diffLog);
        this.newMeta = new MetaBase(news);
        this.baseMeta = new MetaBase(bases);
    }

    private XMLLoader initMetametaLoader() {
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)"");
        XMLLoader xmlLoader = new XMLLoader(ctx, new String[0]);
        MetaDataPK pk = null;
        try {
            for (int i = 0; i < METAMETA_PKS.length; ++i) {
                pk = MetaDataPK.create(METAMETA_PKS[i]);
                xmlLoader.loadMetametaData(pk);
            }
        }
        catch (Exception _) {
            logger.error((Object)("\u88c5\u8f7d\u5143\u5143\u6570\u636e\u9519\u8bef\u3002metameta pk = " + pk), (Throwable)_);
            throw new IllegalStateException("\u88c5\u8f7d\u5143\u5143\u6570\u636e\u9519\u8bef\u3002metameta pk = " + pk);
        }
        return xmlLoader;
    }

    private void initLoadFiles() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\n \u5f00\u59cb\u521d\u59cb\u5316new\u5143\u6570\u636e\u96c6\u5408...");
        }
        this.newMeta.init();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\n \u5f00\u59cb\u521d\u59cb\u5316base\u5143\u6570\u636e\u96c6\u5408...");
        }
        this.baseMeta.init();
    }

    private Map fileDiff() throws IOException {
        Map newFiles = this.newMeta.allEntryMap();
        Map baseFiles = this.baseMeta.allEntryMap();
        TreeSet base2Files = new TreeSet(baseFiles.values());
        HashMap rtv = new HashMap(4);
        TreeSet<FileMetaInfo> added = new TreeSet<FileMetaInfo>();
        TreeSet<FileMetaInfo> moded = new TreeSet<FileMetaInfo>();
        for (Map.Entry entry : newFiles.entrySet()) {
            String name = (String)entry.getKey();
            FileMetaInfo fmi = (FileMetaInfo)entry.getValue();
            FileMetaInfo other = (FileMetaInfo)baseFiles.get(name);
            if (other != null) {
                if (fmi.st != -1L && fmi.st == other.st && fmi.length == other.length) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("NO Change File: " + fmi.entryName));
                    }
                } else {
                    moded.add(fmi);
                    logger.info((Object)("\u53ef\u80fd\u4fee\u6539File: " + fmi.entryName));
                }
                base2Files.remove(other);
                continue;
            }
            added.add(fmi);
            logger.info((Object)("\u65b0\u589eFile: " + fmi.entryName));
        }
        for (FileMetaInfo fmi : base2Files) {
            logger.warn((Object)("\u5220\u9664File: " + fmi.entryName));
        }
        rtv.put("Add", added);
        rtv.put("Del", base2Files);
        rtv.put("Mod", moded);
        return rtv;
    }

    private void detailDiff(Set entrys) {
        for (FileMetaInfo fmi : entrys) {
            String name = fmi.entryName;
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                String suffix = name.substring(pos + 1);
                String type = Utils.getBOSTypeBySuffix(suffix);
                if (type == null) {
                    fmi.status = 1;
                    continue;
                }
                InputStream is = null;
                Document devDOM = null;
                Document baseDOM = null;
                try {
                    is = this.newMeta.getEntryInputStream(name);
                    devDOM = XMLParser.parseXML((InputStream)is);
                    is.close();
                }
                catch (Exception _) {
                    logger.error((Object)("newMeta\u5e93\u89e3\u6790XML\u9519\u8befFile: " + name), (Throwable)_);
                }
                try {
                    is = this.baseMeta.getEntryInputStream(name);
                    baseDOM = XMLParser.parseXML((InputStream)is);
                    is.close();
                }
                catch (Exception _) {
                    logger.error((Object)("baseMeta\u5e93\u89e3\u6790XML\u9519\u8befFile: " + name), (Throwable)_);
                }
                boolean changed = this.xmlDiffer.diff(fmi, devDOM, baseDOM);
                if (changed) {
                    fmi.status = 3;
                    continue;
                }
                fmi.status = 2;
                continue;
            }
            fmi.status = 1;
        }
    }

    private void log(Map rtv) throws IOException {
        this.diffLog.logFiles(rtv);
    }
}

