/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.engine.impl.IResBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DirResBase
implements IResBase {
    private File root;

    public DirResBase(File dir) {
        this.root = dir;
    }

    @Override
    public boolean isReadOnly() {
        return !this.root.canWrite();
    }

    @Override
    public boolean entryExist(String entryName) {
        File entry = new File(this.root, entryName);
        return entry.exists();
    }

    @Override
    public long entryLastModified(String entryName) throws MDNotFoundException {
        File entry = new File(this.root, entryName);
        if (entry.exists()) {
            return entry.lastModified();
        }
        return -1L;
    }

    @Override
    public void deleteEntry(String entryName) throws IOException {
        File entry = new File(this.root, entryName);
        entry.delete();
    }

    @Override
    public File getBase() {
        return this.root;
    }

    @Override
    public InputStream getInputStream(String entryName) throws IOException {
        File entry = new File(this.root, entryName);
        if (entry.length() == 0L) {
            return null;
        }
        FileInputStream fis = new FileInputStream(entry);
        return new BufferedInputStream(fis);
    }

    @Override
    public OutputStream getOutputStream(String entryName) throws IOException {
        File entry = new File(this.root, entryName);
        if (!entry.exists()) {
            File parent = entry.getParentFile();
            parent.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(entry);
        return new BufferedOutputStream(fos);
    }

    public String toString() {
        try {
            return this.root.getCanonicalPath();
        }
        catch (IOException e) {
            return "\u83b7\u53d6\u8d44\u6e90\u5e93\u7684\u8def\u5f84\u5f02\u5e38\u3002";
        }
    }

    @Override
    public void clean() throws IOException {
        File[] files = this.root.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                file.delete();
                continue;
            }
            if (!file.isDirectory()) continue;
            this.doClean(file);
        }
    }

    private void doClean(File dir) throws IOException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                file.delete();
                continue;
            }
            if (!file.isDirectory()) continue;
            this.doClean(file);
        }
        dir.delete();
    }

    @Override
    public void setEntryLastModified(String entryName, long ts) throws MDNotFoundException {
        File entry = new File(this.root, entryName);
        if (entry.exists()) {
            entry.setLastModified(ts);
        }
    }

    @Override
    public long entryLength(String entryName) {
        File entry = new File(this.root, entryName);
        if (entry.exists()) {
            return entry.length();
        }
        return -1L;
    }

    @Override
    public void close() {
    }
}

