/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.config;

import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.config.AISChangedEvent;
import com.kingdee.bos.framework.config.AISChangedListener;
import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.BOSDeployInfoManager;
import com.kingdee.bos.framework.config.DMCInfo;
import com.kingdee.bos.framework.config.DestinationInfo;
import com.kingdee.bos.framework.config.LicenseInfo;
import com.kingdee.bos.framework.config.ListenerInfo;
import com.kingdee.bos.framework.config.MessageServiceInfo;
import com.kingdee.bos.framework.config.ORMServiceLocationInfo;
import com.kingdee.bos.framework.config.SolutionChangedEvent;
import com.kingdee.bos.framework.config.SolutionChangedListener;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.framework.config.WorkflowInfo;
import com.kingdee.bos.metadata.mdquery.ConfigItemInfo;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public abstract class AbstractDeployInfoManager
implements IDeployInfoManager {
    private static Logger logger = Logger.getLogger(AbstractDeployInfoManager.class);
    protected static EventListenerList listenerList = new EventListenerList();
    protected Map configItems = new HashMap();
    protected Map solutionDeployInfos = new HashMap();
    protected Map properties = new HashMap();
    protected LicenseInfo license = new LicenseInfo();
    protected DMCInfo dmc = new DMCInfo();
    protected MessageServiceInfo message = new MessageServiceInfo();
    protected Map ORMServices = new HashMap();
    protected WorkflowInfo workflow = new WorkflowInfo();
    protected boolean isLazyLoadMetaData = false;
    protected boolean isNonEJB = false;
    protected int criticalCollection = 0;
    protected int criticalCollection4Log = 0;
    protected int criticalIDList = 0;
    protected int criticalQueryPKs = 0;
    protected int criticalSetSize = 0;
    protected boolean useSelectCache = true;
    protected boolean realRowCount = true;

    public static void addAISChangedListener(AISChangedListener l) {
        listenerList.add(AISChangedListener.class, l);
    }

    public static void addSolutionChangedListener(SolutionChangedListener l) {
        listenerList.add(SolutionChangedListener.class, l);
    }

    public static void removeAISChangedListener(AISChangedListener l) {
        listenerList.remove(AISChangedListener.class, l);
    }

    public static void removeSolutionChangedListener(SolutionChangedListener l) {
        listenerList.remove(SolutionChangedListener.class, l);
    }

    public void fireAISChangedEvent(AISChangedEvent e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AISChangedListener.class) continue;
            try {
                ((AISChangedListener)listeners[i + 1]).valueChanged(e);
                continue;
            }
            catch (Throwable exception) {
                logger.error((Object)exception);
            }
        }
    }

    public void fireSolutionChangedEvent(SolutionChangedEvent e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SolutionChangedListener.class) continue;
            try {
                ((SolutionChangedListener)listeners[i + 1]).valueChanged(e);
                continue;
            }
            catch (Throwable exception) {
                logger.error((Object)exception);
            }
        }
    }

    protected AbstractDeployInfoManager() {
    }

    @Override
    public List getConfigItems() {
        Iterator it = this.configItems.entrySet().iterator();
        ArrayList configs = new ArrayList();
        while (it.hasNext()) {
            configs.add(it.next().getValue());
        }
        return configs;
    }

    @Override
    public ConfigurationItem getConfigItem(String configName) {
        List list = this.getConfigItems();
        for (int i = 0; i < list.size(); ++i) {
            ConfigurationItem config = (ConfigurationItem)list.get(i);
            if (config.getName() == null || !config.getName().equalsIgnoreCase(configName)) continue;
            return config;
        }
        return null;
    }

    @Override
    public void addConfigItem(ConfigItemInfo config) {
        this.configItems.put(config.getName(), config);
    }

    @Override
    public void removeConfigItem(String configName) {
        this.configItems.remove(configName);
    }

    @Override
    public SolutionDeployInfo getSolutionDeployInfo(String name) {
        return (SolutionDeployInfo)this.solutionDeployInfos.get(name);
    }

    @Override
    public List getSolutionDeployInfos() {
        Iterator it = this.solutionDeployInfos.entrySet().iterator();
        ArrayList slns = new ArrayList();
        while (it.hasNext()) {
            slns.add(it.next().getValue());
        }
        return slns;
    }

    @Override
    public void addSolutionDeployInfo(SolutionDeployInfo slnDeployInfo) {
        this.solutionDeployInfos.put(slnDeployInfo.getName(), slnDeployInfo);
        this.storeSolution();
        SolutionChangedEvent e = new SolutionChangedEvent(SolutionChangedEvent.ADD, slnDeployInfo);
        this.fireSolutionChangedEvent(e);
    }

    @Override
    public void removeSolutionDeployInfo(String slnName) {
        SolutionDeployInfo slnDeployInfo = this.getSolutionDeployInfo(slnName);
        this.solutionDeployInfos.remove(slnName);
        this.storeSolution();
        SolutionChangedEvent e = new SolutionChangedEvent(SolutionChangedEvent.DELETE, slnDeployInfo);
        this.fireSolutionChangedEvent(e);
    }

    @Override
    public void addAISDeployInfo(String slnName, AISDeployInfo aisDeployInfo) {
        this.addAISDeployInfo(slnName, null, aisDeployInfo);
    }

    @Override
    public void addAISDeployInfo(String slnName, String metaDataPath, AISDeployInfo aisDeployInfo) {
        SolutionDeployInfo slnInfo = this.getSolutionDeployInfo(slnName);
        if (slnInfo == null) {
            slnInfo = new SolutionDeployInfo();
            slnInfo.setName(slnName);
        }
        if (metaDataPath != null) {
            slnInfo.setMetaDataPath(metaDataPath);
        }
        slnInfo.addAISInfo(aisDeployInfo);
        this.storeSolution();
        SolutionDeployInfo slnDeployInfo = this.getSolutionDeployInfo(slnName);
        AISChangedEvent e = new AISChangedEvent(AISChangedEvent.ADD, slnDeployInfo, aisDeployInfo);
        this.fireAISChangedEvent(e);
    }

    @Override
    public AISDeployInfo getAISDeployInfo(String slnName, String aisName) {
        SolutionDeployInfo slnInfo = this.getSolutionDeployInfo(slnName);
        if (slnInfo != null) {
            return slnInfo.getAISInfo(aisName);
        }
        return null;
    }

    @Override
    public void removeAISDeployInfo(String slnName, String aisName) {
        AISDeployInfo aisDeployInfo = this.getAISDeployInfo(slnName, aisName);
        SolutionDeployInfo slnInfo = this.getSolutionDeployInfo(slnName);
        if (slnInfo != null) {
            slnInfo.removeAISInfo(aisName);
        }
        this.storeSolution();
        SolutionDeployInfo slnDeployInfo = this.getSolutionDeployInfo(slnName);
        AISChangedEvent e = new AISChangedEvent(AISChangedEvent.DELETE, slnDeployInfo, aisDeployInfo);
        this.fireAISChangedEvent(e);
    }

    @Override
    public boolean isLazyLoadMetaData() {
        return this.isLazyLoadMetaData;
    }

    @Override
    public void setLazyLoadMetaData(boolean isLazyLoadMetaData) {
        this.isLazyLoadMetaData = isLazyLoadMetaData;
    }

    @Override
    public boolean isNonEJB() {
        return this.isNonEJB;
    }

    @Override
    public void setNonEJB(boolean ejb) {
        this.isNonEJB = ejb;
    }

    @Override
    public int getCriticalIDList() {
        return this.criticalIDList;
    }

    @Override
    public void setCriticalIDList(int value) {
        this.criticalIDList = value;
    }

    @Override
    public int getCriticalQueryPKs() {
        return this.criticalQueryPKs;
    }

    @Override
    public void setCriticalQueryPKs(int value) {
        this.criticalQueryPKs = value;
    }

    @Override
    public int getCriticalCollection() {
        return this.criticalCollection;
    }

    @Override
    public void setCriticalCollection(int value) {
        this.criticalCollection = value;
    }

    @Override
    public int getCriticalCollection4Log() {
        return this.criticalCollection4Log;
    }

    @Override
    public void setCriticalCollection4Log(int value) {
        this.criticalCollection4Log = value;
    }

    @Override
    public int getCriticalSetSize() {
        return this.criticalSetSize;
    }

    @Override
    public void setCriticalSetSize(int value) {
        this.criticalSetSize = value;
    }

    @Override
    public boolean isUseSelectCache() {
        return this.useSelectCache;
    }

    @Override
    public void setUseSelectCache(boolean useSelectCache) {
        this.useSelectCache = useSelectCache;
    }

    @Override
    public LicenseInfo getLicenseInfo() {
        return this.license;
    }

    @Override
    public void setLicenseInfo(LicenseInfo license) {
        this.license = license;
        this.storeLicense();
    }

    @Override
    public void setLicenseFileReader(String licenseFileReader) {
        if (this.license == null) {
            return;
        }
        this.license.setLicenseFileReader(licenseFileReader);
        this.storeLicense();
    }

    @Override
    public void setSoftwareName(String softwareName) {
        if (this.license == null) {
            return;
        }
        this.license.setSoftwareName(softwareName);
        this.storeLicense();
    }

    @Override
    public void setSerialNumber(String serialNumber) {
        if (this.license == null) {
            return;
        }
        this.license.setSerialNumber(serialNumber);
        this.storeLicense();
    }

    @Override
    public DMCInfo getDMCInfo() {
        return this.dmc;
    }

    @Override
    public void setDMCInfo(DMCInfo dmc) {
        this.dmc = dmc;
        this.storeDMC();
    }

    @Override
    public MessageServiceInfo getMessageServiceInfo() {
        return this.message;
    }

    @Override
    public void setMessageServiceInfo(MessageServiceInfo message) {
        this.message = message;
        this.storeMessage();
    }

    @Override
    public void addListenerInfo(ListenerInfo listenerInfo) {
        if (this.message == null) {
            this.message = new MessageServiceInfo();
        }
        this.message.addListenerInfo(listenerInfo);
        this.storeMessage();
    }

    @Override
    public ListenerInfo getListenerInfo(String lisName) {
        if (this.message != null) {
            return this.message.getListener(lisName);
        }
        return null;
    }

    @Override
    public void removeListenerInfo(String lisName) {
        if (this.message != null) {
            this.message.removeListener(lisName);
        }
        this.storeMessage();
    }

    @Override
    public void addDestinationInfo(DestinationInfo destinationInfo) {
        this.addDestinationInfo(null, destinationInfo);
    }

    @Override
    public void addDestinationInfo(String defaultDestination, DestinationInfo destinationInfo) {
        if (this.message == null) {
            this.message = new MessageServiceInfo();
        }
        if (defaultDestination != null) {
            this.message.setDefaultDestination(defaultDestination);
        }
        this.message.addDestinationInfo(destinationInfo);
        this.storeMessage();
    }

    @Override
    public DestinationInfo getDestinationInfo(String desName) {
        if (this.message != null) {
            return this.message.getDestination(desName);
        }
        return null;
    }

    @Override
    public void removeDestinationInfo(String desName) {
        if (this.message != null) {
            this.message.removeDestination(desName);
        }
        this.storeMessage();
    }

    @Override
    public String getServiceType() {
        if (this.message != null) {
            return this.message.getServiceType();
        }
        return null;
    }

    @Override
    public String getDefaultDestination() {
        if (this.message != null) {
            return this.message.getDefaultDestination();
        }
        return null;
    }

    @Override
    public void setServiceType(String serviceType) {
        if (this.message == null) {
            return;
        }
        this.message.setServiceType(serviceType);
        this.storeMessage();
    }

    @Override
    public void setDefaultDestination(String defaultDestination) {
        if (this.message == null) {
            return;
        }
        this.message.setDefaultDestination(defaultDestination);
        this.storeMessage();
    }

    @Override
    public ORMServiceLocationInfo getORMServiceLocationInfo(String name) {
        return (ORMServiceLocationInfo)this.ORMServices.get(name);
    }

    @Override
    public List getORMServiceLocationInfos() {
        Iterator it = this.ORMServices.entrySet().iterator();
        ArrayList orms = new ArrayList();
        while (it.hasNext()) {
            orms.add(it.next().getValue());
        }
        return orms;
    }

    @Override
    public void addORMServiceLocationInfo(ORMServiceLocationInfo ormInfo) {
        this.ORMServices.put(ormInfo.getName(), ormInfo);
        this.storeORMService();
    }

    @Override
    public void removeORMServiceLocationInfo(String ormName) {
        this.ORMServices.remove(ormName);
        this.storeORMService();
    }

    @Override
    public WorkflowInfo getWorkflowInfo() {
        return this.workflow;
    }

    @Override
    public void setWorkflowInfo(WorkflowInfo workflow) {
        this.workflow = workflow;
        this.storeWorkflow();
    }

    @Override
    public void setIsEnableScheduler(boolean isEnableScheduler) {
        if (this.workflow == null) {
            return;
        }
        this.workflow.setIsEnableScheduler(isEnableScheduler);
        this.storeWorkflow();
    }

    @Override
    public void setSchedulerIdleWaiteTime(int schedulerIdleWaiteTime) {
        if (this.workflow == null) {
            return;
        }
        this.workflow.setSchedulerIdleWaiteTime(schedulerIdleWaiteTime);
        this.storeWorkflow();
    }

    @Override
    public void setSchedulerThreadPoolSize(int schedulerThreadPoolSize) {
        if (this.workflow == null) {
            return;
        }
        this.workflow.setSchedulerThreadPoolSize(schedulerThreadPoolSize);
        this.storeWorkflow();
    }

    @Override
    public void setWorkflowTransQueueTime(int workflowTransQueueTime) {
        if (this.workflow == null) {
            return;
        }
        this.workflow.setWorkflowTransQueueTime(workflowTransQueueTime);
        this.storeWorkflow();
    }

    @Override
    public void setIsInitWfService(boolean isInitWfService) {
        if (this.workflow == null) {
            return;
        }
        this.workflow.setIsInitWfService(isInitWfService);
        this.storeWorkflow();
    }

    @Override
    public void setWorkflowServerKey(String workflowServerKey) {
        if (this.workflow == null) {
            return;
        }
        this.workflow.setWorkflowServerKey(workflowServerKey);
        this.storeWorkflow();
    }

    @Override
    public String getProvider(String name) {
        if (this.workflow == null) {
            return null;
        }
        return this.workflow.getProvider(name);
    }

    @Override
    public Map getProviders() {
        if (this.workflow == null) {
            return null;
        }
        return this.workflow.getProviders();
    }

    @Override
    public void addProvider(String name, String provider) {
        if (this.workflow != null) {
            this.workflow.addProvider(name, provider);
        }
        this.storeWorkflow();
    }

    @Override
    public void removeProvider(String name) {
        if (this.workflow != null) {
            this.workflow.removeProvider(name);
        }
        this.storeWorkflow();
    }

    @Override
    public String getLogConfig(String name) {
        if (this.workflow == null) {
            return null;
        }
        return this.workflow.getLogConfig(name);
    }

    @Override
    public Map getLogCoinfigs() {
        if (this.workflow == null) {
            return null;
        }
        return this.workflow.getLogConfigs();
    }

    @Override
    public void addLogConfig(String name, String value) {
        if (this.workflow != null) {
            this.workflow.addLogConfig(name, value);
        }
        this.storeWorkflow();
    }

    @Override
    public void removeLogCoinfig(String name) {
        if (this.workflow != null) {
            this.workflow.removeLogCoinfig(name);
        }
        this.storeWorkflow();
    }

    @Override
    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public boolean isRealRowCount() {
        return this.realRowCount;
    }

    @Override
    public void setRealRowCount(boolean value) {
        this.realRowCount = value;
    }

    @Override
    public abstract void load();

    @Override
    public abstract void storeLicense();

    @Override
    public abstract void storeDMC();

    @Override
    public abstract void storeMessage();

    @Override
    public abstract void storeORMService();

    @Override
    public abstract void storeWorkflow();

    @Override
    public abstract void storeSolution();

    @Override
    public abstract void storeDebugOption();

    static {
        try {
            String className = "com.kingdee.bos.support.quartz.SchedulerAISChangedListener";
            Class<?> listenerClass = Class.forName(className);
            Object listener = listenerClass.newInstance();
            BOSDeployInfoManager.addAISChangedListener((AISChangedListener)listener);
            className = "com.kingdee.bos.workflow.enactment.WorkflowAISChangedListener";
            listenerClass = Class.forName(className);
            listener = listenerClass.newInstance();
            BOSDeployInfoManager.addAISChangedListener((AISChangedListener)listener);
            className = "com.kingdee.bos.support.quartz.SchedulerSolutionChangedListener";
            listenerClass = Class.forName(className);
            listener = listenerClass.newInstance();
            BOSDeployInfoManager.addSolutionChangedListener((SolutionChangedListener)listener);
            className = "com.kingdee.bos.workflow.enactment.WorkflowSolutionChangedListener";
            listenerClass = Class.forName(className);
            listener = listenerClass.newInstance();
            BOSDeployInfoManager.addSolutionChangedListener((SolutionChangedListener)listener);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

