/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.framework.session.LoginModuleListener;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.log4j.Logger;

public class LoginModuleListenerManager {
    private static Logger logger = Logger.getLogger(LoginModuleListenerManager.class);
    private static List listeners = new ArrayList();

    private static void init() {
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("loginModuleListeners");
        if (ci == null) {
            return;
        }
        Map map = ci.getProperties();
        int i = 0;
        for (String className : map.values()) {
            try {
                Class<?> c = Class.forName(className);
                listeners.add((LoginModuleListener)c.newInstance());
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static synchronized void register(LoginModuleListener listener) {
        listeners.add(listener);
    }

    public static synchronized void unregister(LoginModuleListener listener) {
        listeners.remove(listener);
    }

    public static synchronized void beforeLogin(Callback[] cb) {
        for (LoginModuleListener listener : listeners) {
            listener.beforeLogin(cb);
        }
    }

    public static synchronized void afterLogin(Callback[] cb, boolean success) {
        for (LoginModuleListener listener : listeners) {
            listener.afterLogin(cb, success);
        }
    }

    static {
        try {
            LoginModuleListenerManager.init();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

