/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.DocumentProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.validate.IValidate;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.util.StringUtils;
import java.io.ObjectStreamException;
import java.util.Locale;

public abstract class AbstractMetaDataValue
extends AbstractMDValue
implements IValidate {
    private transient ValidateMetaData vld = null;
    public static final String RES_LAST_MODIFIED = "Resource_Last_Modified";
    private transient String fullName = null;
    private transient int packLen = -1;
    public static final String IS_DYNAMIC = "isDynamic";
    private int code = 0;

    protected AbstractMetaDataValue(boolean init) {
        super(init);
        this.init();
    }

    protected AbstractMetaDataValue() {
        this.init();
    }

    protected AbstractMetaDataValue(IStateManager sm) {
        super(sm);
        this.init();
    }

    @Override
    protected void clearVariableWhenValueChanged(String key) {
        super.clearVariableWhenValueChanged(key);
        if ("package".equals(key) || "name".equals(key)) {
            this.fullName = null;
            this.packLen = -1;
            return;
        }
    }

    public String getPackage() {
        this.initFullName();
        if (this.packLen <= 0) {
            return null;
        }
        return this.fullName.substring(0, this.packLen);
    }

    public void setPackage(String pgName) {
        this.setString("package", pgName);
    }

    public String getName() {
        this.initFullName();
        if (StringUtils.isEmpty((String)this.fullName) || this.fullName.length() == this.packLen) {
            return null;
        }
        return this.fullName.substring(this.packLen + 1);
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    private void initFullName() {
        if (this.fullName == null) {
            String pkg = this.getString("package");
            String name = this.getString("name");
            if (StringUtils.isEmpty((String)pkg)) {
                this.fullName = name;
                this.packLen = -1;
            } else {
                this.fullName = StringUtils.isEmpty((String)name) ? pkg : pkg + "." + name;
                this.packLen = pkg.length();
            }
        }
    }

    public String getFullName() {
        this.initFullName();
        return this.fullName;
    }

    public String getRealFullName() {
        String pkg = this.getRealPackage();
        String name = this.getRealName();
        if (StringUtils.isEmpty((String)pkg)) {
            return name;
        }
        return pkg + "." + name;
    }

    public String getAlias() {
        return this.getAlias(null);
    }

    public void setAlias(String alias) {
        this.setAlias(alias, null);
    }

    public String getAlias(Locale locale) {
        return (String)this.get("alias", locale);
    }

    public void setAlias(String alias, Locale locale) {
        this.put("alias", alias, locale);
    }

    public String getDisplayName() {
        return this.getAlias() == null ? this.getName() : this.getAlias();
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(Locale locale) {
        return (String)this.get("description", locale);
    }

    public void setDescription(String description) {
        this.setDescription(description, null);
    }

    public void setDescription(String description, Locale locale) {
        this.put("description", description, locale);
    }

    protected ValidateMetaData getValidate() {
        if (this.vld == null) {
            this.vld = new ValidateMetaData();
        }
        return this.vld;
    }

    @Override
    public ValidateList validate() {
        this.vld = this.getValidate();
        this.vld.validatePackageName(this.getPackage());
        this.vld.validateMetaDataName(this.getName());
        this.vld.validateEASPolice(this);
        return this.vld.getValidateList();
    }

    public void setUserDefined(boolean isUserDefined) {
        this.put("userDefined", isUserDefined);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    @Override
    public String toString() {
        String pkg = this.getString("package");
        String name = this.getString("name");
        return this.getClass().getName() + "@" + pkg + "." + name;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.trueClone) {
            return this;
        }
        IStateManager sm = this.getStateManager();
        if (sm instanceof DocumentProxyStateManager) {
            MetaDataPK2 pk2 = new MetaDataPK2(((DocumentProxyStateManager)sm).uri);
            DocumentProxyStateManager dsm = (DocumentProxyStateManager)sm;
            try {
                return MDLoader.getInstance().loadMD(pk2, dsm.getProjects());
            }
            catch (Exception _) {
                // empty catch block
            }
        }
        return this;
    }

    public void setDirty(boolean dirty) {
        this.put("dirty", dirty);
    }

    public boolean isDirty() {
        return this.getBoolean("dirty");
    }

    public void setDynamic(boolean b) {
        super.setExtendedProperty(IS_DYNAMIC, String.valueOf(b));
    }

    public boolean isDynamic() {
        String v = super.getExtendedProperty(IS_DYNAMIC);
        return "true".equalsIgnoreCase(v);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AbstractMetaDataValue)) {
            return false;
        }
        AbstractMetaDataValue that = (AbstractMetaDataValue)o;
        return AbstractMetaDataValue.equals(this.getName(), that.getName()) && AbstractMetaDataValue.equals(this.getPackage(), that.getPackage()) && AbstractMetaDataValue.equals(this.getBOSType(), that.getBOSType());
    }

    @Override
    public int hashCode() {
        if (this.code == 0) {
            int h = AbstractMetaDataValue.hashCode(this.getFullName());
            this.code = h += AbstractMetaDataValue.hashCode(this.getBOSType());
        }
        return this.code;
    }
}

