/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.metadata.AbstractMetaDataCache;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.InnerMetaDataLoaderFactory;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.MetaDataLazyLoadCache;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MetaDataLoaderFactory {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.MetaDataLoaderFactory");
    private static volatile IMetaDataLoader clientCache = null;
    private static String clientMetaDataPath = null;

    public static IMetaDataLoader getRemoteMetaDataLoader() {
        return MetaDataLoaderFactory.getMetaDataLoader(null);
    }

    public static IMetaDataLoader getLocalMetaDataLoader(Context ctx) {
        return MetaDataLoaderFactory.getMetaDataLoader(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMetaDataLoader getMetaDataLoader(Context ctx) {
        if (ctx != null) {
            ConfigMDUtil.setContextToThread(ctx);
            return InnerMetaDataLoaderFactory.getInstance(ctx);
        }
        if (clientCache != null) return clientCache;
        Class<MetaDataLoaderFactory> clazz = MetaDataLoaderFactory.class;
        synchronized (MetaDataLoaderFactory.class) {
            IMetaDataLoader loader;
            if (clientCache != null) return clientCache;
            Context bosCtx = new Context();
            if (clientMetaDataPath == null) {
                bosCtx.put((Object)"METADATAPATH", (Object)"");
            } else {
                bosCtx.put((Object)"METADATAPATH", (Object)clientMetaDataPath);
            }
            clientCache = loader = InnerMetaDataLoaderFactory.getInstance(bosCtx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loader;
        }
    }

    public static synchronized void setClientMetaDataPath(String clientMetaDataPath) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Set Client Metadata path: " + clientMetaDataPath));
            logger.info((Object)("       Old Metadata path: " + MetaDataLoaderFactory.clientMetaDataPath));
        }
        MetaDataLoaderFactory.clientMetaDataPath = clientMetaDataPath;
    }

    public static String getClientMetaDataPath() {
        return clientMetaDataPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeMetaDataLoader(Context ctx) {
        if (ctx != null) {
            InnerMetaDataLoaderFactory.close(ctx);
            return;
        }
        IMetaDataLoader temp = null;
        Class<MetaDataLoaderFactory> clazz = MetaDataLoaderFactory.class;
        synchronized (MetaDataLoaderFactory.class) {
            if (clientCache != null) {
                temp = clientCache;
                clientCache = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (temp == null) return;
            ((AbstractMetaDataCache)temp).close();
            return;
        }
    }

    public static synchronized void closeAllMetaDataLoader() {
        logger.info((Object)"closeAllMetaDataLoader.");
        MetaDataLoaderFactory.closeMetaDataLoader(null);
        InnerMetaDataLoaderFactory.closeAll();
        XMLAccessEngine.clearEngines();
        MetaDataClassLoader.closeAll();
    }

    public static synchronized void addSource(String jarFile, Context ctx) throws IOException {
        MetaDataLazyLoadCache load = clientCache != null ? (MetaDataLazyLoadCache)clientCache : (MetaDataLazyLoadCache)InnerMetaDataLoaderFactory.getInstance(ctx);
        MDContextFactory.addSource(load.loader.cl.getMDContext(), jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clearAll(Context ctx) {
        if (ctx != null) {
            MetaDataLoaderFactory.getMetaDataLoader(ctx).clearAll();
            return;
        }
        IMetaDataLoader temp = null;
        Class<MetaDataLoaderFactory> clazz = MetaDataLoaderFactory.class;
        synchronized (MetaDataLoaderFactory.class) {
            if (clientCache != null) {
                temp = clientCache;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (temp == null) return;
            temp.clearAll();
            return;
        }
    }
}

