/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;

public final class MetaDataUtils {
    private static final char DOT = '.';
    public static final String ENTITY_PKMAPPING = "entity_pkmapping.properties";
    public static final String FACADE_PKMAPPING = "facade_pkmapping.properties";

    private MetaDataUtils() {
    }

    public static String getClassName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        int pos = fullName.lastIndexOf(46);
        if (pos > 0) {
            return fullName.substring(pos + 1);
        }
        return fullName;
    }

    public static String getPackageName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        int pos = fullName.lastIndexOf(46);
        if (pos > 0) {
            return fullName.substring(0, pos);
        }
        return "";
    }

    public static String upcastName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        name = name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
        return name;
    }

    public static ColumnInfo getColumnByName(DataTableInfo table, String columnName) {
        if (table == null || columnName == null) {
            return null;
        }
        int j = table.getColumns().size();
        for (int i = 0; i < j; ++i) {
            ColumnInfo col = table.getColumns().get(i);
            if (!col.getName().equalsIgnoreCase(columnName)) continue;
            return col;
        }
        return null;
    }

    public static PropertyInfo getPropertyByName(EntityObjectInfo bo, String propName) {
        for (int i = bo.getProperties().size() - 1; i >= 0; --i) {
            PropertyInfo prop = bo.getInheritedNoDuplicatedPropertiesRuntime().get(i);
            if (!prop.getName().equalsIgnoreCase(propName)) continue;
            return prop;
        }
        return null;
    }

    public static BusinessObjectInfo getBOFromCache(Context ctx, BOSObjectType type) throws BOSException {
        BusinessObjectInfo meta = MetaDataLoaderFactory.getLocalMetaDataLoader(ctx).getBusinessObject(type);
        if (meta == null) {
            throw new MissingDAOMetaDataException("EJBFactory: Cannot load metadata from cache: [" + type + "]");
        }
        return meta;
    }

    public static BusinessObjectInfo getBOFromCache(Context ctx, IMetaDataPK pk) throws BOSException {
        BusinessObjectInfo meta = (BusinessObjectInfo)MetaDataLoaderFactory.getLocalMetaDataLoader(ctx).get(MetaDataTypeList.ENTITY, pk);
        return meta;
    }

    public static ColumnInfo getColumnInfoByPropFromEntity(EntityObjectInfo bo, PropertyInfo prop) throws InvalidDAOMetaDataException {
        if (bo == null || prop == null) {
            throw new InvalidDAOMetaDataException("The parameters error!   bo :" + bo + ",  prop:" + prop);
        }
        if (prop.getMappingField() == null) {
            return null;
        }
        ColumnInfo col = bo.getMappingFieldOfProperty(prop);
        if (col == null) {
            throw new InvalidDAOMetaDataException("Can't find propertyInfo! entityObjectInfo=" + bo.getName() + ",  propertyInfo=" + prop.getName());
        }
        return col;
    }
}

