/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.framework.GetterFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class PKIndexs {
    private static final Logger logger = Logger.getLogger(PKIndexs.class);
    private final Map<BOSObjectType, Set<IMetaDataPK>> base = new HashMap<BOSObjectType, Set<IMetaDataPK>>();
    private final Map<BOSObjectType, Set<IMetaDataPK>> fileConfig = null;
    private final Map<String, Map<BOSObjectType, Set<IMetaDataPK>>> dbConfig = new HashMap<String, Map<BOSObjectType, Set<IMetaDataPK>>>();
    private final Map<String, Map<BOSObjectType, Set<IMetaDataPK>>> dbConfigSelf = new HashMap<String, Map<BOSObjectType, Set<IMetaDataPK>>>();
    private static final List<BOSObjectType> table = new ArrayList<BOSObjectType>(4);
    private static final List<BOSObjectType> query = new ArrayList<BOSObjectType>(3);

    public IMetaDataPK[] getMetaDataPKs(BOSObjectType type) {
        return this.getMetaDataPKs(type, null, null);
    }

    public IMetaDataPK[] getMetaDataPKs(BOSObjectType type, Project.Projects depends) {
        return this.getMetaDataPKs(type, null, depends);
    }

    public IMetaDataPK[] getMetaDataPKs(BOSObjectType type, String pkgName) {
        return this.getMetaDataPKs(type, pkgName, true, null);
    }

    public IMetaDataPK[] getMetaDataPKs(BOSObjectType type, String pkgName, Project.Projects depends) {
        return this.getMetaDataPKs(type, pkgName, true, depends);
    }

    public IMetaDataPK[] getMetaDataPKs(BOSObjectType type, String pkgName, boolean isRecursive) {
        return this.getMetaDataPKs(type, pkgName, isRecursive, null);
    }

    public Set<IMetaDataPK> getFromDB4Self(BOSObjectType type, Project.Projects depends) {
        String key = Project.Projects.getKey(depends);
        if (key == null) {
            return null;
        }
        Map<BOSObjectType, Set<IMetaDataPK>> sets = this.initDBConfigSelf(depends, key);
        if (sets != null) {
            return sets.get(type);
        }
        return null;
    }

    private Set<IMetaDataPK> getFromDB(BOSObjectType type, Project.Projects depends) {
        String key = Project.Projects.getKey(depends);
        if (key == null) {
            return null;
        }
        Map<BOSObjectType, Set<IMetaDataPK>> sets = this.initDBConfig(depends, key);
        if (sets != null) {
            return sets.get(type);
        }
        return null;
    }

    private Set<IMetaDataPK> get(BOSObjectType type, Project.Projects depends) {
        Set<IMetaDataPK> tmp = this.base.get(type);
        if (MetaDataTypeList.SOLUTION.equals((Object)type)) {
            return tmp;
        }
        HashSet<IMetaDataPK> pks = new HashSet<IMetaDataPK>();
        if (tmp != null) {
            pks.addAll(tmp);
        }
        if (this.fileConfig != null && (tmp = this.fileConfig.get(type)) != null) {
            pks.addAll(tmp);
        }
        if ((tmp = this.getFromDB(type, depends)) != null) {
            pks.addAll(tmp);
        }
        return pks;
    }

    public Map<BOSObjectType, Set<IMetaDataPK>> getMetaDataPKsFromDB(Project.Projects depends) {
        String key = Project.Projects.getKey(depends);
        if (key == null) {
            return Collections.emptyMap();
        }
        Map<BOSObjectType, Set<IMetaDataPK>> tmp = this.initDBConfig(depends, key);
        if (tmp != null && !tmp.isEmpty()) {
            return tmp;
        }
        return Collections.emptyMap();
    }

    public IMetaDataPK[] getMetaDataPKs(BOSObjectType type, String pkgName, boolean isRecursive, Project.Projects depends) {
        Set<IMetaDataPK> pks = this.get(type, depends);
        Set<Object> filterPKs = new HashSet();
        Object[] result = null;
        if (StringUtils.isEmpty((String)pkgName) && isRecursive) {
            filterPKs = pks;
        } else if (StringUtils.isEmpty((String)pkgName) && !isRecursive) {
            Iterator<IMetaDataPK> iter = pks.iterator();
            IMetaDataPK pk = null;
            while (iter.hasNext()) {
                pk = iter.next();
                if (!StringUtils.isEmpty((String)pk.getPackage())) continue;
                filterPKs.add(pk);
            }
        } else if (!StringUtils.isEmpty((String)pkgName)) {
            Iterator<IMetaDataPK> iter = pks.iterator();
            IMetaDataPK pk = null;
            String filterPkgName = null;
            while (iter.hasNext()) {
                pk = iter.next();
                filterPkgName = pk.getPackage();
                if (filterPkgName == null || !isRecursive || !filterPkgName.equals(pkgName) && !filterPkgName.startsWith(pkgName + ".")) continue;
                filterPKs.add(pk);
            }
        }
        if (filterPKs == null) {
            return new IMetaDataPK[0];
        }
        result = filterPKs.toArray(new IMetaDataPK[0]);
        Arrays.sort(result);
        return result;
    }

    public IMetaDataPK[] getMetaDataPKsExcludePackage(BOSObjectType type, List<String> pkgs, Project.Projects depends) {
        Set<IMetaDataPK> pks = this.get(type, depends);
        Set<Object> filterPKs = new HashSet();
        Object[] result = null;
        if (pkgs == null || pkgs.size() == 0) {
            filterPKs = pks;
        } else {
            Iterator<IMetaDataPK> iter = pks.iterator();
            IMetaDataPK pk = null;
            String filterPkgName = null;
            while (iter.hasNext()) {
                pk = iter.next();
                filterPkgName = pk.getPackage();
                if (filterPkgName == null) {
                    filterPKs.add(pk);
                    continue;
                }
                if (this.include(pkgs, filterPkgName)) continue;
                filterPKs.add(pk);
            }
        }
        result = filterPKs.toArray(new IMetaDataPK[0]);
        Arrays.sort(result);
        return result;
    }

    public BOSObjectType getRealType(Project.Projects depends, MetaDataPK2 pk2) {
        if (pk2 == null) {
            return null;
        }
        String fullName = pk2.getFullName();
        Map<BOSObjectType, Set<IMetaDataPK>> type2pks = this.getMetaDataPKsFromDB(depends);
        if (type2pks != null) {
            for (Set<IMetaDataPK> pks : type2pks.values()) {
                for (IMetaDataPK pk : pks) {
                    if (!fullName.equals(pk.getFullName()) || !(pk instanceof MetaDataPK2)) continue;
                    return BOSObjectType.create((String)((MetaDataPK2)pk).getType());
                }
            }
        }
        return BOSObjectType.create((String)pk2.getType());
    }

    private boolean include(List<String> pkgs, String filterPkgName) {
        for (String pkgName : pkgs) {
            if (!filterPkgName.equals(pkgName) && !filterPkgName.startsWith(pkgName + ".")) continue;
            return true;
        }
        return false;
    }

    public void loadFileToBase(File file) {
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> e = jar.entries();
            String entryName = null;
            String suffix = null;
            while (e.hasMoreElements()) {
                entryName = e.nextElement().toString();
                suffix = this.getEntrySuffix(entryName);
                if (suffix == null || !MDContext.supportedTypes.contains(suffix)) continue;
                this.putEntryInCache(this.base, BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix)), this.getEntryPK(entryName));
            }
        }
        catch (Exception ioe) {
            throw new IllegalArgumentException("Error Meta Jar:" + file.getAbsolutePath() + ". Cause:" + ioe.getMessage());
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"METADATA: Load PKIndex from file error.", (Throwable)e);
            }
        }
    }

    void loadDirectoryToBase(File file) {
        this.loadDirectoryToBase(file, null);
    }

    private void loadDirectoryToBase(File file, String pgName) {
        String[] metas = file.list();
        if (metas == null || metas.length <= 0) {
            return;
        }
        String fileName2 = null;
        String suffix = null;
        for (String fileName2 : metas) {
            if (fileName2.indexOf(46) >= 0) {
                suffix = this.getEntrySuffix(fileName2);
                if (suffix == null || !MDContext.supportedTypes.contains(suffix)) continue;
                this.putEntryInCache(this.base, BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix)), MetaDataPK.create(pgName, this.getEntryName(fileName2)));
                continue;
            }
            File child = new File(file, fileName2);
            if (!child.isDirectory()) continue;
            String fullPkgName = null;
            fullPkgName = StringUtils.isEmpty((String)pgName) ? fileName2 : pgName + "." + fileName2;
            this.loadDirectoryToBase(child, fullPkgName);
        }
    }

    void putToBase(BOSObjectType bosType, IMetaDataPK pk) {
        this.putEntryInCache(this.base, bosType, pk);
    }

    private void putEntryInCache(Map<BOSObjectType, Set<IMetaDataPK>> cache, BOSObjectType bosType, IMetaDataPK pk) {
        Set<IMetaDataPK> pkCache = cache.get(bosType);
        if (pkCache == null) {
            pkCache = new HashSet<IMetaDataPK>();
            cache.put(bosType, pkCache);
        }
        pkCache.add(MetaDataPK.create(pk));
    }

    private String getEntrySuffix(String entryName) {
        return entryName.substring(entryName.lastIndexOf(46) + 1, entryName.length());
    }

    private String getEntryName(String entry) {
        return entry.substring(0, entry.indexOf(46));
    }

    private IMetaDataPK getEntryPK(String entry) {
        String pgName = null;
        String metaName = null;
        if (entry.indexOf(47) == 0) {
            entry = entry.substring(1, entry.length());
        }
        if (entry.indexOf(47) != -1) {
            pgName = entry.substring(0, entry.lastIndexOf(47)).replace('/', '.');
        }
        metaName = entry.substring(entry.lastIndexOf(47) + 1, entry.lastIndexOf(46));
        return MetaDataPK.create(pgName, metaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<BOSObjectType, Set<IMetaDataPK>> initDBConfig(Project.Projects depends, String key) {
        if (key == null) {
            return null;
        }
        Map sets = this.dbConfig.get(key);
        if (sets == null) {
            Map<String, Map<BOSObjectType, Set<IMetaDataPK>>> map = this.dbConfig;
            synchronized (map) {
                sets = this.dbConfig.get(key);
            }
            if (sets == null) {
                try {
                    sets = ConfigMDUtil.isClient() && depends == null ? (Map)GetterFactory.getGetterInfo4Client().get("MetaDataPK") : DBConfigureResourceLoader.getMetaDataPKs(depends);
                }
                catch (Exception e) {
                    logger.error((Object)"METADATA: Load PKIndex from DB error.", (Throwable)e);
                    throw new RuntimeException(e);
                }
                if (sets == null) {
                    sets = new HashMap();
                }
                map = this.dbConfig;
                synchronized (map) {
                    if (this.dbConfig.get(key) == null) {
                        this.dbConfig.put(key, sets);
                    }
                }
            }
        }
        return sets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<BOSObjectType, Set<IMetaDataPK>> initDBConfigSelf(Project.Projects depends, String key) {
        if (key == null) {
            return null;
        }
        HashMap sets = this.dbConfigSelf.get(key);
        if (sets == null && Project.Projects.isNeedHandle(depends)) {
            Map<String, Map<BOSObjectType, Set<IMetaDataPK>>> map = this.dbConfigSelf;
            synchronized (map) {
                sets = this.dbConfigSelf.get(key);
            }
            if (sets == null) {
                try {
                    sets = DBConfigureResourceLoader.getMetaDataPKs(depends, true);
                }
                catch (BOSException e) {
                    logger.error((Object)"METADATA: Load PKIndex from DB error.", (Throwable)e);
                }
                if (sets == null) {
                    sets = new HashMap();
                }
                map = this.dbConfigSelf;
                synchronized (map) {
                    if (this.dbConfigSelf.get(key) == null) {
                        this.dbConfigSelf.put(key, sets);
                    }
                }
            }
        }
        return sets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(boolean isAll) {
        Map<String, Map<BOSObjectType, Set<IMetaDataPK>>> map = this.dbConfig;
        synchronized (map) {
            if (isAll) {
                this.dbConfig.clear();
            } else {
                MDContext.clearAis(this.dbConfig, true);
            }
        }
        map = this.dbConfigSelf;
        synchronized (map) {
            if (isAll) {
                this.dbConfigSelf.clear();
            } else {
                MDContext.clearAis(this.dbConfigSelf, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(Project.Projects depends) {
        Map<String, Map<BOSObjectType, Set<IMetaDataPK>>> map = this.dbConfig;
        synchronized (map) {
            MDContext.clear(this.dbConfig, depends);
        }
        map = this.dbConfigSelf;
        synchronized (map) {
            MDContext.clear(this.dbConfigSelf, depends);
        }
    }

    public static List<BOSObjectType> getPolymType(BOSObjectType type) {
        if (table.contains(type)) {
            return table;
        }
        if (query.contains(type)) {
            return query;
        }
        ArrayList<BOSObjectType> list = new ArrayList<BOSObjectType>(1);
        list.add(type);
        return list;
    }

    public boolean isExistInBase(BOSObjectType type, IMetaDataPK pk) {
        List<BOSObjectType> types = PKIndexs.getPolymType(type);
        for (int i = 0; i < types.size(); ++i) {
            Set<IMetaDataPK> set = this.base.get(types.get(i));
            if (set == null || !set.contains(pk)) continue;
            return true;
        }
        return false;
    }

    public boolean isExistInDB(BOSObjectType type, IMetaDataPK pk, Project.Projects depends) {
        List<BOSObjectType> types = PKIndexs.getPolymType(type);
        Map<BOSObjectType, Set<IMetaDataPK>> map = this.getMetaDataPKsFromDB(depends);
        if (pk instanceof MetaDataPK2) {
            pk = MetaDataPK.create(pk.getFullName());
        }
        for (int i = 0; i < types.size(); ++i) {
            Set<IMetaDataPK> set = map.get(types.get(i));
            if (set == null || !set.contains(pk)) continue;
            return true;
        }
        return false;
    }

    public boolean isExist(BOSObjectType type, IMetaDataPK pk, Project.Projects depends) {
        if (!this.isExistInBase(type, pk)) {
            return this.isExistInDB(type, pk, depends);
        }
        return true;
    }

    public MetaDataPK2[] getAddNewPKs(Project.Projects depends) {
        ArrayList<MetaDataPK2> pks = new ArrayList<MetaDataPK2>();
        Map<BOSObjectType, Set<IMetaDataPK>> map = this.getMetaDataPKsFromDB(depends);
        if (map == null) {
            return null;
        }
        for (BOSObjectType type : map.keySet()) {
            Set<IMetaDataPK> set = map.get(type);
            if (set == null) continue;
            for (IMetaDataPK pk : set) {
                if (this.isExistInBase(type, pk)) continue;
                MetaDataPK2 pk2 = new MetaDataPK2(pk.getFullName(), type.toString());
                pks.add(pk2);
            }
        }
        return pks.toArray(new MetaDataPK2[0]);
    }

    public void addPK(BOSObjectType type, IMetaDataPK pk, Project.Projects depends) {
        if (pk == null || type == null) {
            return;
        }
        pk = MetaDataPK.create(pk);
        Set<IMetaDataPK> pks = this.getFromDB4Self(type, depends);
        if (pks != null) {
            pks.add(pk);
        }
        if ((pks = this.getFromDB(type, depends)) != null) {
            pks.add(pk);
        }
    }

    static {
        table.add(MetaDataTypeList.ABSTRACTTABLE);
        table.add(MetaDataTypeList.DATATABLE);
        table.add(MetaDataTypeList.CROSSTABLE);
        table.add(MetaDataTypeList.EXTENDEDTABLE);
        query.add(MetaDataTypeList.JOINQUERY);
        query.add(MetaDataTypeList.UNIONQUERY);
        query.add(MetaDataTypeList.BASEQUERY);
    }
}

