/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.access.IAccess;
import com.kingdee.bos.metadata.access.ISelectHandler;
import com.kingdee.bos.metadata.access.MDSelect;
import com.kingdee.bos.metadata.access.MDSelectHandler;
import com.kingdee.bos.metadata.access.MetaDataAccessLoader;
import com.kingdee.bos.metadata.access.MetaDataAccessLoaderChain;
import com.kingdee.bos.metadata.access.SimpleMD;
import com.kingdee.bos.metadata.access.SimpleSelectHandler;

public abstract class MDAccess<S extends MDSelect, T extends SimpleMD, M extends AbstractMetaDataValue>
implements IAccess<S, T> {
    protected final Context ctx;

    public MDAccess(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public abstract T create(S var1) throws BOSException;

    protected ISelectHandler<S, T, M> getSelectHandler(ISelectHandler<S, T, M> nHandler) {
        return new SimpleSelectHandler<S, T, M>(new MDSelectHandler<S, T, M>(nHandler));
    }

    protected M getMDByLoader(M md, S select) throws BOSException {
        return MDAccess.getMDByLoader(this.ctx, md, ((MDSelect)select).getAccessLoader());
    }

    public static final <L extends AbstractMetaDataValue> L getMDByLoader(Context ctx, L md, MetaDataAccessLoader.Description desc) throws BOSException {
        if (desc == null || md == null) {
            return md;
        }
        MetaDataAccessLoader<L> loader = MDAccess.getLoader(ctx, desc);
        if (loader != null) {
            return loader.get(md, desc.getParams());
        }
        return md;
    }

    private static final <L extends AbstractMetaDataValue> MetaDataAccessLoader<L> getLoader(Context ctx, MetaDataAccessLoader.Description desc) throws BOSException {
        if (desc == null) {
            return null;
        }
        String[] loaderNames = desc.getLoaderNames();
        if (loaderNames != null) {
            if (loaderNames.length == 1) {
                return MetaDataAccessLoader.newInstance(ctx, loaderNames[0]);
            }
            MetaDataAccessLoaderChain loader = new MetaDataAccessLoaderChain(ctx);
            for (int i = 0; i < loaderNames.length; ++i) {
                MetaDataAccessLoader tmp = MetaDataAccessLoader.newInstance(ctx, loaderNames[i]);
                loader.add(tmp);
            }
            return loader;
        }
        return null;
    }
}

