/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.access.CustomizedAccess;
import com.kingdee.bos.metadata.access.CustomizedSelect;
import com.kingdee.bos.metadata.access.IMetaDataAccess;
import com.kingdee.bos.metadata.access.Select;
import com.kingdee.bos.metadata.access.Simple;
import com.kingdee.bos.metadata.access.SimpleValue;
import com.kingdee.bos.metadata.access.entity.EntityAccess;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.management.SimpleSolution;
import com.kingdee.bos.metadata.access.management.SolutionAccess;
import com.kingdee.bos.metadata.access.management.SolutionSelect;
import com.kingdee.bos.metadata.access.query.QueryAccess;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.access.ui.SimpleUI;
import com.kingdee.bos.metadata.access.ui.UIAccess;
import com.kingdee.bos.metadata.access.ui.UISelect;
import com.kingdee.bos.util.BOSObjectType;
import org.apache.log4j.Logger;

public class MetaDataAccess
extends AbstractBOSObject
implements IMetaDataAccess {
    private static final Logger logger = Logger.getLogger(MetaDataAccess.class);
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"MDAC");

    public MetaDataAccess(Context ctx) {
        super(ctx);
        this.registerInterface(IMetaDataAccess.class, this);
    }

    public MetaDataAccess() {
        this.registerInterface(IMetaDataAccess.class, this);
    }

    @Override
    public SimpleValue[] select(Select[] selects) throws BOSException {
        if (selects == null || selects.length == 0) {
            return new SimpleValue[0];
        }
        SimpleValue[] simples = new SimpleValue[selects.length];
        for (int i = 0; i < selects.length; ++i) {
            if (selects[i] instanceof EntitySelect) {
                simples[i] = this.select((EntitySelect)selects[i]);
                continue;
            }
            if (selects[i] instanceof QuerySelect) {
                simples[i] = this.select((QuerySelect)selects[i]);
                continue;
            }
            if (!(selects[i] instanceof CustomizedSelect)) continue;
            simples[i] = this.select((CustomizedSelect)selects[i]);
        }
        return simples;
    }

    @Override
    public SimpleQuery select(QuerySelect select) throws BOSException {
        QueryAccess qc = new QueryAccess(this.getContext());
        return qc.create(select);
    }

    @Override
    public SimpleEntity select(EntitySelect select) throws BOSException {
        EntityAccess ec = new EntityAccess(this.getContext());
        return ec.create(select);
    }

    public Simple select(CustomizedSelect select) throws BOSException {
        CustomizedAccess access = CustomizedAccess.getInstance(this.getContext(), select.getCustomizedAccessName());
        if (access == null) {
            return null;
        }
        return access.create(select);
    }

    @Override
    public SimpleSolution select(SolutionSelect select) throws BOSException {
        SolutionAccess ec = new SolutionAccess();
        return ec.create(select);
    }

    @Override
    public SimpleUI select(UISelect select) throws BOSException {
        UIAccess access = new UIAccess(this.getContext());
        return access.create(select);
    }

    @Override
    public BOSObjectType getType() {
        return BOSTYPE;
    }
}

