/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.access.SelectException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class MetaDataAccessLoader<M extends AbstractMetaDataValue> {
    protected final Context ctx;

    public MetaDataAccessLoader(Context ctx) {
        this.ctx = ctx;
    }

    public abstract M get(M var1, Params var2) throws BOSException;

    static <T extends AbstractMetaDataValue> MetaDataAccessLoader<T> newInstance(Context ctx, String loaderName) throws SelectException {
        if (loaderName == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(loaderName);
            return (MetaDataAccessLoader)c.getConstructor(Context.class).newInstance(ctx);
        }
        catch (Exception e) {
            throw new SelectException("create MetaDataAccessLoader instance error. className:" + loaderName, e);
        }
    }

    public static class Params
    implements Serializable {
        private static final long serialVersionUID = -5492590381311171987L;
        private final Map<String, Object> params = new HashMap<String, Object>(2);

        public Object get(String key) {
            return this.params.get(key);
        }

        public void put(String key, Object value) {
            this.params.put(key, value);
        }

        public void put(Params other) {
            if (other != null) {
                this.params.putAll(other.params);
            }
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            Iterator<Map.Entry<String, Object>> ite = this.params.entrySet().iterator();
            StringBuilder str = new StringBuilder();
            boolean isFirst = true;
            while (ite.hasNext()) {
                if (isFirst) {
                    isFirst = true;
                } else {
                    str.append(",");
                }
                Map.Entry<String, Object> entry = ite.next();
                str.append(entry.getKey());
                str.append("=");
                str.append(entry.getValue());
            }
            return super.toString();
        }
    }

    public static class Description
    implements Serializable {
        private static final long serialVersionUID = -1342118036911961942L;
        private final String[] loaderNames;
        private final Params params = new Params();

        public Description(String ... loaderNames) {
            this.loaderNames = loaderNames;
        }

        public void setParam(String key, Object value) {
            this.params.put(key, value);
        }

        public Object getParam(String key) {
            return this.params.get(key);
        }

        Params getParams() {
            return this.params;
        }

        String[] getLoaderNames() {
            return this.loaderNames;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            if (this.loaderNames == null) {
                return null;
            }
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < this.loaderNames.length; ++i) {
                if (i != 0) {
                    str.append(",");
                }
                str.append(this.loaderNames[i]);
            }
            str.append("[");
            str.append(this.params);
            str.append("]");
            return str.toString();
        }

        public Description merge(Description desc) {
            int i;
            if (desc == null) {
                return this;
            }
            HashSet<String> names = new HashSet<String>();
            if (this.loaderNames != null) {
                for (i = 0; i < this.loaderNames.length; ++i) {
                    names.add(this.loaderNames[i]);
                }
            }
            if (desc.loaderNames != null) {
                for (i = 0; i < desc.loaderNames.length; ++i) {
                    names.add(desc.loaderNames[i]);
                }
            }
            Description d = new Description(names.toArray(new String[0]));
            d.params.put(this.params);
            d.params.put(desc.params);
            return d;
        }
    }
}

