/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.access.AbstractSelectHandler;
import com.kingdee.bos.metadata.access.ResultSet;
import com.kingdee.bos.metadata.access.SelectContext;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.EntryOrderInfo;
import com.kingdee.bos.metadata.access.entity.PropertySelect;
import com.kingdee.bos.metadata.access.entity.PropertySelectHandler;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EntitySelectHandler
extends AbstractSelectHandler<EntitySelect, SimpleEntity, EntityObjectInfo> {
    @Override
    protected void innerHandle(SelectContext ctx, EntitySelect select, ResultSet<SimpleEntity, EntityObjectInfo> result) throws BOSException {
        OwnPropertyInfo prop;
        SimpleEntity se = result.getSelectData();
        EntityObjectInfo entity = result.getMetadata();
        this.handlePropertySelect(ctx, se, entity, select.propertySelected());
        if (select.isGenerateCodeSelected()) {
            se.setGenerateCode(entity.getIsGenerateCode());
        }
        if (select.objectValueClassSelected()) {
            se.setObjectValueClass(entity.getObjectValueClassRuntime());
        }
        if (select.logicalKeyPropertiesSelected()) {
            PropertyCollection props = entity.getLogicalKeyPropertiesRuntime();
            String[] lp = new String[props.size()];
            int size = props.size();
            for (int i = 0; i < size; ++i) {
                lp[i] = props.get(i).getName();
            }
            se.setLogicalKeyProperties(lp);
        }
        if (select.sequencePropertySelected() && (prop = entity.getSequenceProperty()) != null) {
            se.setSequenceProperty(prop.getName());
        }
        if (select.entryOrderInfoSelected()) {
            se.setEntryOrderInfo(this.buildEntryOrderInfo(entity));
        }
        if (select.pkFieldsSelected()) {
            ArrayList<String> pks = new ArrayList<String>();
            this.handlePKField(entity, null, pks);
            se.setPKFields(pks.toArray(new String[0]));
        }
    }

    private List<EntryOrderInfo> buildEntryOrderInfo(EntityObjectInfo entity) {
        ArrayList<EntryOrderInfo> orders = null;
        EntityObjectInfo.Compositions comps = entity.getCompositions();
        for (EntityObjectInfo.Prop2ChildBoMapping prop : comps.one2many) {
            if (orders == null) {
                orders = new ArrayList<EntryOrderInfo>(2);
            }
            OwnPropertyInfo seq = prop.childBO.getSequenceProperty();
            EntryOrderInfo order = new EntryOrderInfo(prop.prop.getName(), seq == null ? null : seq.getName());
            order.setSubEntries(this.buildEntryOrderInfo(prop.childBO));
            orders.add(order);
        }
        return orders;
    }

    private void handlePKField(EntityObjectInfo entity, String prefix, List<String> pks) {
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        Iterator iter = pc.iterator();
        while (iter.hasNext()) {
            String pk;
            RelationshipInfo relation;
            PropertyInfo childProperty = (PropertyInfo)iter.next();
            if (!(childProperty instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)childProperty).getRelationship()).getType())) continue;
            if (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED) {
                pk = prefix == null ? childProperty.getName() : prefix + "." + childProperty.getName();
                pks.add(pk);
                if (!entity.equals(relation.getClientObject())) continue;
                this.handlePKField(relation.getSupplierObject(), pk, pks);
                continue;
            }
            if (relation.getSupplierCardinality() != CardinalityType.ONE && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_ONE || !entity.equals(relation.getClientObject())) continue;
            pk = prefix == null ? childProperty.getName() : prefix + "." + childProperty.getName();
            pks.add(pk);
            this.handlePKField(relation.getSupplierObject(), pk, pks);
        }
    }

    private void handlePropertySelect(SelectContext ctx, SimpleEntity se, EntityObjectInfo entity, PropertySelect propertySelect) throws BOSException {
        if (propertySelect == null) {
            return;
        }
        SimplePropertyCollection spCol = se.properties();
        PropertySelectHandler propertySelectHandler = null;
        ResultSet<SimpleProperty, PropertyInfo> pResult = null;
        while (propertySelect != null) {
            SimpleProperty sp;
            PropertyInfo prop;
            String[] names = propertySelect.nameSelected();
            if (names == null) {
                propertySelect = (PropertySelect)propertySelect.next();
                continue;
            }
            if (propertySelectHandler == null) {
                propertySelectHandler = new PropertySelectHandler(entity);
            }
            int propertyType = propertySelect.propertyType();
            if (this.isSelectAll(names)) {
                spCol.clear();
                PropertyCollection propCol = entity.getPropertiesRuntime();
                int size = propCol.size();
                for (int i = 0; i < size; ++i) {
                    prop = propCol.get(i);
                    if (!this.filter(propertyType, prop, entity)) continue;
                    sp = new SimpleProperty();
                    pResult = new ResultSet<SimpleProperty, PropertyInfo>(sp, prop);
                    propertySelectHandler.handle(ctx, propertySelect, pResult);
                    spCol.add(sp);
                }
                break;
            }
            for (int i = 0; i < names.length; ++i) {
                String realName = names[i];
                EntityObjectInfo realEntity = entity;
                if (realName.indexOf(".") > 0) {
                    String[] path = realName.split("\\.");
                    for (int j = 0; !(j >= path.length - 1 || (prop = realEntity.getPropertyByNameRuntime(path[j])) instanceof LinkPropertyInfo && (realEntity = PropertySelectHandler.getEntity(realEntity, (LinkPropertyInfo)prop)) == null); ++j) {
                    }
                    realName = path[path.length - 1];
                }
                if (realEntity == null || realName == null || !this.filter(propertyType, prop = realEntity.getPropertyByNameRuntime(realName), realEntity)) continue;
                sp = new SimpleProperty();
                pResult = new ResultSet<SimpleProperty, PropertyInfo>(sp, prop);
                propertySelectHandler.handle(ctx, propertySelect, pResult);
                sp.setString("name", names[i]);
                if (realName != names[i]) {
                    sp.setHost(realEntity.getFullName());
                }
                spCol.add(sp);
            }
            propertySelect = (PropertySelect)propertySelect.next();
        }
    }

    private boolean filter(int propertyType, PropertyInfo prop, EntityObjectInfo entity) {
        if (prop == null) {
            return false;
        }
        switch (propertyType) {
            case 0: {
                return true;
            }
            case 1: {
                return prop instanceof OwnPropertyInfo;
            }
            case 2: {
                return prop instanceof LinkPropertyInfo;
            }
            case 3: {
                boolean isGenerateCode = entity.getIsGenerateCode();
                return !isGenerateCode || prop.isConfigured();
            }
        }
        return false;
    }
}

