/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizunit.AbstractBizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizMethodCollection;
import com.kingdee.bos.metadata.bizunit.BizMethodInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.UIActionRefInfo;
import com.kingdee.util.StringUtils;

public class EditUIFunctionProxy
extends AbstractProxy {
    private FunctionObjectInfo function;

    public EditUIFunctionProxy(Context ctx, FunctionObjectInfo function) {
        this.function = function;
    }

    @Override
    public void update() throws BIMException {
        if (this.function == null) {
            return;
        }
        String nameExt = "editUIFunc";
        if (this.bizUnit.getObjectState() == ObjectStateType.NEW && this.function == null) {
            throw new IllegalStateException("function can not be null");
        }
        BizMethodCollection methodCol = this.bizUnit.getMethods();
        OperationCollection operCol = this.function.getOperation();
        this.syncFunctionOpersByBizField(methodCol, operCol);
    }

    private void syncFunctionOpersByBizField(BizMethodCollection methodCol, OperationCollection operCol) throws BIMException {
        int n = methodCol.size();
        for (int i = 0; i < n; ++i) {
            BizMethodInfo method = methodCol.get(i);
            ObjectStateType stateType = method.getObjectState();
            OperationInfo operation = null;
            if (stateType.equals((Object)ObjectStateType.UNCHANGE)) continue;
            if (stateType.equals((Object)ObjectStateType.NEW)) {
                String generateUIAction = method.getGenerateUIAction();
                if (!"generateAllUIAction".equalsIgnoreCase(generateUIAction) && !"generateEditUIAction".equalsIgnoreCase(generateUIAction)) continue;
                operation = new OperationInfo();
                operation.getExtendedProperties().put("userDefined", ConvertUtils.getUserDefinedVaule());
                this.updateOperation(method, operation);
                operCol.add(operation);
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.DELETING)) {
                operation = EditUIFunctionProxy.getOperationByName(operCol, method.getMethodName());
                if (operation == null) continue;
                operCol.remove(operation);
                continue;
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED) || (operation = EditUIFunctionProxy.getOperationByName(operCol, method.getMethodName())) == null) continue;
            this.updateOperation(method, operation);
        }
    }

    private void updateOperation(BizMethodInfo method, OperationInfo operation) throws BIMException {
        if (method == null) {
            throw new IllegalArgumentException("method can not be null");
        }
        String name = operation.getName();
        if (StringUtils.isEmpty((String)operation.getName())) {
            name = EditUIFunctionProxy.generateOperationName(method, this.function.getOperation());
            method.setUIOperationName(name);
        }
        operation.setName(name);
        operation.setAlias(method.getAlias());
        operation.setDescription(method.getDescription());
        UIActionRefInfo actionRef = new UIActionRefInfo();
        actionRef.setUIObjectRef(this.bizUnit.getEditUI());
        actionRef.setActionRefName(StringUtils.headCharUpperCase((String)method.getActionName()));
        if (this.bizUnit.getEditUI() != null && this.bizUnit.getEditUI().getStatuses().size() > 1) {
            actionRef.setUiStaus(this.bizUnit.getEditUI().getStatuses().get(1).getName());
        }
        ParameterInfo param = new ParameterInfo();
        param.setName("billID");
        param.setAlias("\u5355\u636e\u5185\u7801");
        param.setDescription("\u5355\u636e\u5185\u7801");
        param.setDataType("BOSUuid");
        actionRef.getParameters().add(param);
        operation.setUiActionRef(actionRef);
        operation.setEntityObjectRef(this.bizUnit.getEntity());
        operation.setEvent(AbstractBizUnitCtrl.getEventName(this.bizUnit.getEntity(), method.getMethodName()));
        MethodInfo entityMethod = this.bizUnit.getEntity().getMethodByName(method.getMethodName());
        if (entityMethod != null) {
            operation.setEventMethod(entityMethod.getInnerID());
        }
    }

    public static String generateOperationName(BizMethodInfo method, OperationCollection operCol) {
        String name = method.getName();
        OperationInfo operation = EditUIFunctionProxy.getOperationByName(operCol, name);
        if (operation != null) {
            int i = 0;
            while (operation != null) {
                name = method.getName() + i++;
                operation = EditUIFunctionProxy.getOperationByName(operCol, name);
            }
        }
        return name;
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.function == null) {
            return;
        }
        ObjectStateType stateType = this.bizUnit.getObjectState();
        if (stateType.equals((Object)ObjectStateType.DELETED) && !this.function.isUserDefined()) {
            throw new BIMException("can not delete system defined function");
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        OperationCollection operCol = this.function.getOperation();
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bf = bfCol.get(i);
            stateType = bf.getObjectState();
            OperationInfo operation = EditUIFunctionProxy.getOperationByName(operCol, bf.getColumnName());
            if (stateType.equals((Object)ObjectStateType.DELETED)) {
                if (operation == null || ConvertUtils.isUserDefined(operation)) continue;
                throw new BIMException("can not delete system defined function");
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED) || operation == null || ConvertUtils.isUserDefined(operation)) continue;
            throw new BIMException("can not change system defined function");
        }
    }

    public static OperationInfo getOperationByName(OperationCollection operCol, String operName) {
        OperationInfo operation = null;
        int n = operCol.size();
        for (int i = 0; i < n; ++i) {
            if (StringUtils.isEmpty((String)operCol.get(i).getName()) || !operCol.get(i).getName().equals(operName)) continue;
            operation = operCol.get(i);
            break;
        }
        return operation;
    }
}

