/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizType;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bizunit.proxy.TableProxy;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.event.EventCollection;
import com.kingdee.bos.metadata.event.EventInfo;
import com.kingdee.bos.metadata.event.EventMethodCollection;
import com.kingdee.bos.metadata.event.EventMethodInfo;
import com.kingdee.bos.metadata.event.FormalParameterInfo;
import com.kingdee.bos.metadata.event.ParameterMappingInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class EntityExtProxy
extends AbstractProxy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.bizunit.proxy.EntityProxy");
    private EntityObjectInfo entity;

    public EntityExtProxy(Context ctx, EntityObjectInfo entity) {
        this.entity = entity;
    }

    @Override
    public void update() throws BIMException {
        if (this.entity == null) {
            return;
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        PropertyCollection propCol = this.entity.getProperties();
        this.syncPropertyByBizField(bfCol, propCol, this.entity);
    }

    private boolean ignoreBizField(BizFieldInfo bf) {
        BizDataType dataType = bf.getBizDataType();
        return dataType == null || dataType.equals((Object)BizDataType.PANEL) || dataType.equals((Object)BizDataType.TABFOLDER) || dataType.equals((Object)BizDataType.LABEL) || dataType.equals((Object)BizDataType.BUTTON) || dataType.equals((Object)BizDataType.BUTTONGROUP) || dataType.equals((Object)BizDataType.KDSEPARATOR) || dataType.equals((Object)BizDataType.RADIOBUTTON);
    }

    private void syncPropertyByBizField(BizFieldCollection bfCol, PropertyCollection propCol, EntityObjectInfo entityInfo) throws BIMException {
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bf = bfCol.get(i);
            ObjectStateType stateType = bf.getObjectState();
            if (this.ignoreBizField(bf)) continue;
            if (stateType.equals((Object)ObjectStateType.UNCHANGE)) {
                if (!(bf instanceof BizGroupFieldInfo)) continue;
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.NEW)) {
                if (bf instanceof BizGroupFieldInfo || DataSourceType.BASEDATAEXT.equals((Object)bf.getDataSourceType()) && !bf.isNeedSave()) continue;
                if (bf.getDataSource() != null && bf.getBizDataType().equals((Object)BizDataType.OBJECT)) {
                    LinkPropertyInfo lkprop = this.createLinkProperty(bf, entityInfo);
                    propCol.add(lkprop);
                    continue;
                }
                OwnPropertyInfo ownprop = this.createOwnProperty(bf, entityInfo);
                propCol.add(ownprop);
                continue;
            }
            if (stateType.equals((Object)ObjectStateType.DELETING)) {
                PropertyInfo prop;
                if (bf instanceof BizGroupFieldInfo) {
                    if (bf.isSaved() || (prop = entityInfo.getPropertyByName(bf.getPropertyName())) == null) continue;
                    propCol.remove(prop);
                    continue;
                }
                if (bf.getDataSource() != null && bf.isSaved() || (prop = entityInfo.getPropertyByName(bf.getPropertyName())) == null) continue;
                propCol.remove(prop);
                continue;
            }
            if (!stateType.equals((Object)ObjectStateType.CHANGED) || StringUtils.isEmpty((String)bf.getPropertyName()) || EntityExtProxy.getPropertyByName(propCol, bf.getPropertyName()) == null || bf instanceof BizGroupFieldInfo) continue;
            if (bf.getDataSource() != null) {
                this.updateLinkProperty(bf, entityInfo);
                continue;
            }
            this.updateOwnProperty(bf, entityInfo);
        }
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.entity == null) {
            return;
        }
        ObjectStateType stateType = this.bizUnit.getObjectState();
        if (stateType.equals((Object)ObjectStateType.DELETED) && !this.entity.isUserDefined()) {
            throw new BIMException("\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u5b9a\u4e49\u7684\u5b9e\u4f53\u5b57\u6bb5!");
        }
        BizFieldCollection bfCol = this.bizUnit.getFields();
        this.checkValid(bfCol, this.entity);
    }

    private void checkValid(BizFieldCollection bfCol, EntityObjectInfo entityInfo) throws BIMException {
        int n = bfCol.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo property;
            BizFieldInfo bf = bfCol.get(i);
            if (this.ignoreBizField(bf)) continue;
            ObjectStateType stateType = bf.getObjectState();
            if (stateType.equals((Object)ObjectStateType.UNCHANGE)) {
                if (!(bf instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
                this.checkValid(group.getFields(), group.getEntityObject());
                continue;
            }
            boolean isParentProperty = false;
            if (bf.getPropertyName() == null || entityInfo == null) {
                property = null;
            } else {
                property = entityInfo.getPropertyByName(bf.getPropertyName());
                boolean bl = isParentProperty = !entityInfo.getProperties().contains(property);
            }
            if (stateType.equals((Object)ObjectStateType.CHANGED)) {
                EntityObjectInfo oldEntity;
                if (property != null && isParentProperty && !this.canChange(bf, property)) {
                    throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u7236\u5b9e\u4f53\u7684\u5c5e\u6027 " + property.getName());
                }
                if (bf instanceof BizGroupFieldInfo) {
                    BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
                    String oldName = (String)bf.getOldValue("name");
                    if (group.getName() == null || !group.getName().equals(oldName)) {
                        throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5206\u5f55\u4f53\u7684\u540d\u79f0!");
                    }
                    oldEntity = (EntityObjectInfo)group.getOldValue("entityObject");
                    if (oldEntity != null && group.getEntityObject() != null && !group.getEntityObject().getFullName().equals(oldEntity.getFullName())) {
                        throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5206\u5f55\u4f53\u5f15\u7528\u7684\u5b9e\u4f53\uff01");
                    }
                    if (group.getEntityObject() == null) continue;
                    this.checkValid(group.getFields(), group.getEntityObject());
                    continue;
                }
                if (bf.getDataSource() != null) {
                    EntityObjectInfo oldEntity2 = (EntityObjectInfo)bf.getOldValue("dataSource");
                    EntityObjectInfo currentEntity = bf.getDataSource();
                    if (currentEntity == null) {
                        throw new BIMException("\u5173\u8054\u5b57\u6bb5\u7684\u5f15\u7528\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (oldEntity2 == null || currentEntity.getFullName().equals(oldEntity2.getFullName())) continue;
                    throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5173\u8054\u5b57\u6bb5\u7684\u5f15\u7528\u5bf9\u8c61");
                }
                boolean oldPersistence = false;
                Object obj = bf.getOldValue("persistence");
                if (obj instanceof Integer) {
                    int value = (Integer)obj;
                    oldPersistence = value == 1;
                }
                if (bf.isPersistence() != oldPersistence) {
                    throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5b57\u6bb5\u7684\u6301\u4e45\u6027\u5c5e\u6027\uff01");
                }
                oldEntity = (EntityObjectInfo)bf.getOldValue("dataSource");
                if (oldEntity == null) continue;
                throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u5173\u8054\u5b57\u6bb5\u7684\u5f15\u7528\u5bf9\u8c61\uff01");
            }
            if (stateType.equals((Object)ObjectStateType.NEW)) {
                property = entityInfo == null ? null : entityInfo.getPropertyByName(bf.getName());
                if (property != null) {
                    throw new BIMException("\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728:" + bf.getName());
                }
                if (bf instanceof BizGroupFieldInfo) {
                    BizGroupFieldInfo group = (BizGroupFieldInfo)bf;
                    this.checkValid(group.getFields(), group.getEntityObject());
                    continue;
                }
                if (bf.getDataSource() == null) continue;
                continue;
            }
            if (!stateType.equals((Object)ObjectStateType.DELETING) || ConvertUtils.isDevMode() || property == null) continue;
            if (!property.isUserDefined()) {
                throw new BIMException("\u4e0d\u80fd\u5220\u9664\u7cfb\u7edf\u5b9a\u4e49\u7684\u5b57\u6bb5: " + property.getName());
            }
            if (!isParentProperty) continue;
            throw new BIMException("\u4e0d\u80fd\u6539\u53d8\u7236\u5b9e\u4f53\u7684\u5b57\u6bb5: " + property.getName());
        }
    }

    private boolean canChange(BizFieldInfo bf, PropertyInfo property) throws BIMException {
        if (property instanceof LinkPropertyInfo) {
            return !bf.isPropertyChanged("bizDataType") && !bf.isPropertyChanged("dataSource");
        }
        OwnPropertyInfo ownprop = (OwnPropertyInfo)property;
        String name = bf.getName();
        if (!name.equals(property.getName())) {
            return false;
        }
        BizDataType dt = bf.getBizDataType();
        return !bf.isPropertyChanged("bizDataType") || EntityExtProxy.getPropertyType(dt).equals(ownprop.getDataType());
    }

    private OwnPropertyInfo createOwnProperty(BizFieldInfo bf, EntityObjectInfo entityInfo) throws BIMException {
        OwnPropertyInfo prop = new OwnPropertyInfo();
        prop.setName(EntityExtProxy.generatePropertyName(bf, entityInfo));
        prop.setDataType(EntityExtProxy.getPropertyType(bf.getBizDataType()));
        prop.getExtendedProperties().put("bizDataType", bf.getBizDataType().getName());
        if (bf.getBizDataType().equals((Object)BizDataType.ENUM)) {
            BizEnumInfo bizenum = bf.getEnumType();
            if (bizenum == null) {
                throw new BIMException("bizData has enum type, but without enum info");
            }
            prop.setMetadataRef(bizenum.getFullName());
        }
        prop.setPrecision(bf.getPrecision());
        prop.setDecimalDigits(bf.getScale());
        if (bf.getDefaultValue() != null) {
            prop.setDefaultValue(bf.getDefaultValue());
        }
        prop.setLength(bf.getLength());
        if (bf.isPersistence()) {
            ColumnInfo column = new ColumnInfo();
            column.setName("F" + prop.getName());
            prop.setMappingField(column);
        }
        prop.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        prop.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        if (bf.getDataSourceType() != null && bf.getDataSourceType().equals((Object)DataSourceType.BASEDATAEXT)) {
            prop.getExtendedProperties().put("DataSourceType", bf.getDataSourceType().toString());
            prop.getExtendedProperties().put("DataField", bf.getDataField());
        }
        this.setPropExtendedProperties(prop, bf);
        return prop;
    }

    private void updateOwnProperty(BizFieldInfo bf, EntityObjectInfo entityInfo) throws BIMException {
        String propName = bf.getPropertyName();
        if (StringUtils.isEmpty((String)propName)) {
            return;
        }
        OwnPropertyInfo prop = (OwnPropertyInfo)EntityExtProxy.getPropertyByName(entityInfo.getProperties(), propName);
        if (prop == null) {
            return;
        }
        if (!bf.getName().equals(propName)) {
            prop.setName(EntityExtProxy.generatePropertyName(bf, this.entity));
        }
        prop.setDataType(EntityExtProxy.getPropertyType(bf.getBizDataType()));
        prop.getExtendedProperties().put("bizDataType", bf.getBizDataType().getName());
        if (bf.getBizDataType().equals((Object)BizDataType.ENUM)) {
            BizEnumInfo bizenum = bf.getEnumType();
            if (bizenum == null) {
                throw new BIMException("bizData has enum type, but without enum info");
            }
            prop.setMetadataRef(bizenum.getFullName());
        }
        prop.setPrecision(bf.getPrecision());
        prop.setDecimalDigits(bf.getScale());
        if (bf.getDefaultValue() != null) {
            prop.setDefaultValue(bf.getDefaultValue());
        }
        prop.setLength(bf.getLength());
        if (bf.isPersistence()) {
            ColumnInfo column = TableProxy.getColumnByName(entityInfo.getTable().getColumns(), bf.getColumnName());
            prop.setMappingField(column);
        }
        prop.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        prop.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        if (bf.getDataSourceType() != null && bf.getDataSourceType().equals((Object)DataSourceType.BASEDATAEXT)) {
            prop.getExtendedProperties().put("DataSourceType", bf.getDataSourceType().toString());
            prop.getExtendedProperties().put("DataField", bf.getDataField());
        }
        prop.setExtendedProperty("ColWidthInKDTable", bf.getExtendedProperty("ColWidthInKDTable") == null ? "50" : bf.getExtendedProperty("ColWidthInKDTable"));
    }

    private LinkPropertyInfo createLinkProperty(BizFieldInfo bf, EntityObjectInfo entityInfo) throws BIMException {
        LinkPropertyInfo linkprop = new LinkPropertyInfo();
        linkprop.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        if (bf.getDataField() != null) {
            linkprop.getExtendedProperties().put("dataField", bf.getDataField());
        }
        linkprop.setName(EntityExtProxy.generatePropertyName(bf, entityInfo));
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage(this.bizUnit.getEntity().getPackage());
        String relationName = "R_" + entityInfo.getName() + "_" + bf.getDataSource().getName() + "_" + bf.getName();
        relation.setName(relationName);
        relation.setType(RelationshipType.ASSOCIATION);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
        relation.setClientObject(entityInfo);
        relation.setSupplierObject(bf.getDataSource());
        relation.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        linkprop.setRelationship(relation);
        EntityViewInfo defaultView = entityInfo.getDefaultView();
        if (defaultView == null) {
            defaultView = new EntityViewInfo();
            entityInfo.setDefaultView(defaultView);
        }
        if (StringUtils.isEmpty((String)bf.getDataField())) {
            int iPos = bf.getDataField().indexOf("+");
            String selectorName = bf.getDataField();
            if (iPos != -1) {
                selectorName = selectorName.substring(0, iPos).trim();
            }
            SelectorItemCollection selector = defaultView.getSelector();
            SelectorItemInfo item = new SelectorItemInfo(bf.getDataSource().getName() + "." + selectorName);
            selector.add(item);
        }
        ColumnInfo column = TableProxy.getColumnByName(entityInfo.getTable().getColumns(), bf.getColumnName());
        linkprop.setMappingField(column);
        linkprop.setAlias(bf.getAlias() == null ? "" : bf.getAlias());
        linkprop.setDescription(bf.getDescription() == null ? "" : bf.getDescription());
        this.setPropExtendedProperties(linkprop, bf);
        return linkprop;
    }

    private void setPropExtendedProperties(PropertyInfo prop, BizFieldInfo bf) {
        prop.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isInCode", "false");
        } else if ("true".equalsIgnoreCase(bf.getExtendedProperty("isInCode"))) {
            prop.setExtendedProperty("isInCode", "true");
        } else {
            prop.setExtendedProperty("isInCode", "false");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isForMapping", "false");
        } else if ("false".equalsIgnoreCase(bf.getExtendedProperty("isForMapping"))) {
            prop.setExtendedProperty("isForMapping", "false");
        } else {
            prop.setExtendedProperty("isForMapping", "true");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isForGrouping", "false");
        } else if ("true".equalsIgnoreCase(bf.getExtendedProperty("isForGrouping"))) {
            prop.setExtendedProperty("isForGrouping", "true");
        } else {
            prop.setExtendedProperty("isForGrouping", "false");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isForMatching", "false");
        } else if ("true".equalsIgnoreCase(bf.getExtendedProperty("isForMatching"))) {
            prop.setExtendedProperty("isForMatching", "true");
        } else {
            prop.setExtendedProperty("isForMatching", "false");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            prop.setExtendedProperty("isForWrittenBack", "false");
        } else if ("true".equalsIgnoreCase(bf.getExtendedProperty("isForWrittenBack"))) {
            prop.setExtendedProperty("isForWrittenBack", "true");
        } else {
            prop.setExtendedProperty("isForWrittenBack", "false");
        }
        if (BizType.BaseData.equals((Object)this.bizUnit.getBizType())) {
            if ("true".equalsIgnoreCase(this.bizUnit.getExtendedProperty("isAsstAcctType"))) {
                prop.setExtendedProperty("isAsstAcctType", "true");
            } else {
                prop.setExtendedProperty("isAsstAcctType", "false");
            }
        } else {
            this.bizUnit.setExtendedProperty("isAsstAcctType", "false");
        }
        prop.setExtendedProperty("isVisibleForKDTable", String.valueOf(bf.getFieldView().isListVisible()));
        prop.setExtendedProperty("ColWidthInKDTable", bf.getExtendedProperty("ColWidthInKDTable") == null ? "50" : bf.getExtendedProperty("ColWidthInKDTable"));
    }

    private void updateLinkProperty(BizFieldInfo bf, EntityObjectInfo entityInfo) throws BIMException {
        String propName = bf.getPropertyName();
        LinkPropertyInfo prop = (LinkPropertyInfo)EntityExtProxy.getPropertyByName(entityInfo.getProperties(), propName);
        if (prop == null) {
            return;
        }
        if (!bf.getName().equals(propName)) {
            prop.setName(EntityExtProxy.generatePropertyName(bf, this.entity));
        }
        prop.setAlias(bf.getAlias());
        prop.setDescription(bf.getDescription());
        if (bf.getDataField() != null) {
            prop.getExtendedProperties().put("dataField", bf.getDataField());
        }
    }

    public static DataType getPropertyType(BizDataType bizType) throws BIMException {
        DataType dataType = null;
        if (bizType.equals((Object)BizDataType.STRING)) {
            dataType = DataType.STRING;
        } else if (bizType.equals((Object)BizDataType.DATE)) {
            dataType = DataType.DATE;
        } else if (bizType.equals((Object)BizDataType.INTEGER)) {
            dataType = DataType.INTEGER;
        } else if (bizType.equals((Object)BizDataType.QUANTITY)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataType.AMOUNT)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataType.PRICE)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataType.NOTE)) {
            dataType = DataType.STRING;
        } else if (bizType.equals((Object)BizDataType.BOOLEAN)) {
            dataType = DataType.BOOLEAN;
        } else if (bizType.equals((Object)BizDataType.DECIMAL)) {
            dataType = DataType.DECIMAL;
        } else if (bizType.equals((Object)BizDataType.IMAGE)) {
            dataType = DataType.BYTEARRAY;
        } else if (bizType.equals((Object)BizDataType.ENUM)) {
            dataType = DataType.ENUM;
        } else if (bizType.equals((Object)BizDataType.TIME)) {
            dataType = DataType.TIME;
        } else {
            throw new BIMException("unknow bizType:" + (Object)((Object)bizType));
        }
        return dataType;
    }

    public static PropertyInfo getPropertyByName(PropertyCollection propCol, String name) {
        PropertyInfo property = null;
        int n = propCol.size();
        for (int i = 0; i < n; ++i) {
            if (!propCol.get(i).getName().equals(name)) continue;
            property = propCol.get(i);
            break;
        }
        return property;
    }

    public static MethodInfo getMethodByName(MethodCollection methodCol, String name) {
        MethodInfo method = null;
        int n = methodCol.size();
        for (int i = 0; i < n; ++i) {
            if (!methodCol.get(i).getName().equals(name)) continue;
            method = methodCol.get(i);
            break;
        }
        return method;
    }

    public static String generatePropertyName(BizFieldInfo bf, EntityObjectInfo entityInfo) {
        String name = bf.getName();
        PropertyInfo property = entityInfo.getPropertyByName(name);
        if (property != null) {
            int i = 0;
            while (property != null) {
                name = bf.getName() + i++;
                property = entityInfo.getPropertyByName(name);
            }
        }
        return name;
    }

    private static EventInfo addEventForMethod(EntityObjectInfo entity, MethodInfo method) {
        String methodInnerID = method.getInnerID();
        EventCollection eventCol = entity.getEvents();
        int n = eventCol.size();
        for (int i = 0; i < n; ++i) {
            EventInfo event = eventCol.get(i);
            EventMethodCollection eventMethodCol = event.getEventMethods();
            if (eventMethodCol.get(methodInnerID) == null) continue;
            return event;
        }
        EventInfo event = new EventInfo();
        event.setName(method.getName() + "Event");
        event.setAlias(method.getAlias() + "\u4e8b\u4ef6");
        EventMethodInfo eventMethod = new EventMethodInfo();
        eventMethod.setName(methodInnerID);
        eventMethod.setEntityMethod(method);
        int n2 = method.getParameters().size();
        for (int j = 0; j < n2; ++j) {
            ParameterInfo cloneParam = (ParameterInfo)method.getParameters().get(j).clone();
            FormalParameterInfo fp = new FormalParameterInfo();
            fp.setParameter(cloneParam);
            event.getFormalParameters().add(fp);
            ParameterMappingInfo paramMapping = new ParameterMappingInfo();
            paramMapping.setActualParameterIndex(j);
            paramMapping.setFormalParameterInnerID(fp.getInnerID());
            if (j == 0) {
                paramMapping.setBOPK(true);
            }
            eventMethod.getParameterMappings().add(paramMapping);
        }
        event.getEventMethods().add(eventMethod);
        entity.getEvents().add(event);
        return event;
    }

    private static void removeEventForMethod(EntityObjectInfo entity, MethodInfo method) {
        String methodInnerID = method.getInnerID();
        EventCollection eventCol = entity.getEvents();
        int n = eventCol.size();
        for (int i = 0; i < n; ++i) {
            EventInfo event = eventCol.get(i);
            EventMethodCollection eventMethodCol = event.getEventMethods();
            if (eventMethodCol.get(methodInnerID) == null) continue;
            eventCol.removeObject(methodInnerID);
        }
    }
}

