/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizTemplateInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.bizunitproxy.ListUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ListUIProxy
extends AbstractProxy
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.bizunit.proxy.ListUIProxy");
    private UIObjectInfo uiObject;

    public ListUIProxy(Context ctx, UIObjectInfo uiObject) {
        this.uiObject = uiObject;
    }

    @Override
    public void update() throws BIMException {
        ComponentInfo tabControl;
        UIProxyHelper uiProxyHelper = UIProxyHelper.getInstance();
        if (this.uiObject == null) {
            return;
        }
        String nameExt = "ListUI";
        if (this.bizUnit.getObjectState() == ObjectStateType.NEW) {
            this.uiObject.setName(this.bizUnit.getName() + nameExt);
            this.uiObject.setReleasePackage(this.bizUnit.getPackage() + ".client");
            this.uiObject.setReleaseClass(this.bizUnit.getName() + nameExt);
            this.uiObject.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            BizTemplateInfo template = this.bizUnit.getTemplate();
            if (template != null) {
                UIObjectInfo ui = template.getEditUI();
                if (ui != null) {
                    this.uiObject.setParent(ui);
                    this.uiObject = UIObjectAssembler.assembleUI(ContextManager.getContext(), this.uiObject);
                    DataObjectInfo dataObj = uiProxyHelper.findDataObject(this.uiObject, template, true);
                    if (dataObj != null) {
                        uiProxyHelper.overrideDataObject(dataObj, this.bizUnit, true);
                    }
                } else {
                    String dataObjName = uiProxyHelper.findDataObjectName(this.uiObject, this.bizUnit, true);
                    if (dataObjName == null) {
                        dataObjName = uiProxyHelper.bindingDataObject(this.uiObject, this.bizUnit, true);
                    }
                    if (dataObjName == null) {
                        throw new BIMException("No EntityInfo in this BizUnit");
                    }
                    uiProxyHelper.initUIObjectInfo(this.uiObject);
                    uiProxyHelper.createListTemplateUI(this.uiObject, template, dataObjName);
                }
            } else {
                uiProxyHelper.initUIObjectInfo(this.uiObject);
            }
        } else if (this.bizUnit.getObjectState() == ObjectStateType.CHANGED) {
            // empty if block
        }
        this.uiObject.setTitle(this.bizUnit.getAlias());
        String dataObjName = "";
        if (this.uiObject.getDataObjects() == null || this.uiObject.getDataObjects().size() <= 0) {
            return;
        }
        dataObjName = this.uiObject.getDataObjects().get(0).getName();
        uiProxyHelper.updateKDTableForQuery(this.uiObject, this.bizUnit, dataObjName, true);
        if ("TreeDetail4Detail".equalsIgnoreCase(this.bizUnit.getBimTemplateType()) && (tabControl = UIProxyHelper.findControlByName(this.uiObject, "bottomPanel")) != null) {
            BizFieldCollection bizFields = this.bizUnit.getFields();
            int n = bizFields.size();
            for (int i = 0; i < n; ++i) {
                BizGroupFieldInfo groupField;
                if (!(bizFields.get(i) instanceof BizGroupFieldInfo) || (groupField = (BizGroupFieldInfo)bizFields.get(i)).getQuery() == null) continue;
                if (ObjectStateType.NEW.equals((Object)bizFields.get(i).getObjectState())) {
                    ListUIProxy.createKDTableByQuery(this.bizUnit, this.uiObject, tabControl, groupField);
                    continue;
                }
                if (ObjectStateType.DELETED.equals((Object)bizFields.get(i).getObjectState())) continue;
                if (ObjectStateType.DELETING.equals((Object)bizFields.get(i).getObjectState())) {
                    if (!"TreeDetail4Detail".equalsIgnoreCase(this.bizUnit.getBimTemplateType())) continue;
                    ListUIProxy.removeKDTableByQuery(this.bizUnit, this.uiObject, tabControl, groupField);
                    if (groupField.isSaved()) continue;
                    groupField.setQuery(null);
                    continue;
                }
                this.updateKDTableByQuery(this.bizUnit, this.uiObject, tabControl, groupField);
            }
        }
        uiProxyHelper.updateBizMethod(this.uiObject, this.bizUnit, false);
    }

    private static void addKDTableToBottomPanel(ComponentInfo container, ComponentInfo kdTable, UIObjectInfo uiObject) {
        List list = UIProxyHelper.findControlsByClassType(container, "com.kingdee.bos.ctrl.kdf.table.KDTable");
        if (list.size() == 0) {
            container.removeAllChild(uiObject);
            kdTable.setConstraint("Center");
            UIProxyHelper.addChild(container, kdTable, uiObject);
        } else {
            ComponentInfo tabPage;
            ComponentInfo tabControl;
            List tabControls = UIProxyHelper.findControlsByClassType(container, "com.kingdee.bos.ctrl.swing.KDTabbedPane");
            if (tabControls.size() > 0) {
                tabControl = (ComponentInfo)tabControls.get(0);
            } else {
                tabControl = ListUIProxy.createTabControl("tabControl");
                container.removeAllChild(uiObject);
                UIProxyHelper.addChild(container, tabControl, uiObject);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    tabPage = ListUIProxy.createTabPagePanel(i);
                    tabPage.setConstraint(((ComponentInfo)list.get(i)).getExtendedProperty("tabPageName"));
                    UIProxyHelper.addChild(tabControl, tabPage, uiObject);
                    UIProxyHelper.addChild(tabPage, (ComponentInfo)list.get(i), uiObject);
                }
            }
            tabPage = ListUIProxy.createTabPagePanel(list.size());
            tabPage.setConstraint(kdTable.getExtendedProperty("tabPageName"));
            UIProxyHelper.addChild(tabControl, tabPage, uiObject);
            UIProxyHelper.addChild(tabPage, kdTable, uiObject);
        }
    }

    private static ComponentInfo createTabControl(String name) {
        ComponentInfo tabbedPane = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDTabbedPane");
        tabbedPane.setName(name);
        tabbedPane.setConstraint("Center");
        tabbedPane.setContainer(true);
        PropertyCollection props = tabbedPane.getProperties();
        props.add(ListUIProxy.createVisibleProperty(true));
        return tabbedPane;
    }

    private static PropertyInfo createVisibleProperty(boolean visible) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("visible");
        prop.setType("boolean");
        prop.setValue(String.valueOf(visible));
        prop.setOverride(true);
        return prop;
    }

    private static ComponentInfo createTabPagePanel(int index) {
        ComponentInfo tabPage = new ComponentInfo("com.kingdee.bos.ctrl.swing.KDPanel");
        tabPage.setName("tabPanel" + index);
        tabPage.setConstraint("Center");
        tabPage.setContainer(true);
        LayoutInfo layout = new LayoutInfo();
        layout.setName("borderLayout" + index);
        layout.setType("BorderLayout");
        layout.setValue("0,0");
        tabPage.setLayoutInfo(layout);
        PropertyCollection props = tabPage.getProperties();
        props.add(ListUIProxy.createVisibleProperty(true));
        return tabPage;
    }

    private static void removeKDTableFromBottomPanel(ComponentInfo container, ComponentInfo kdTable, UIObjectInfo uiObject) {
        ComponentInfo parentContainer = kdTable.getParent();
        if (container.equals(parentContainer)) {
            container.removeChild(uiObject, kdTable);
        } else {
            ComponentInfo tabControl = null;
            List list = UIProxyHelper.findControlsByClassType(container, "com.kingdee.bos.ctrl.swing.KDTabbedPane");
            if (list.size() > 0) {
                tabControl = (ComponentInfo)list.get(0);
                while (parentContainer != null && !tabControl.equals(parentContainer.getParent())) {
                    parentContainer = parentContainer.getParent();
                }
                if (parentContainer != null) {
                    tabControl.removeChild(uiObject, parentContainer);
                }
            } else {
                while (parentContainer != null && !container.equals(parentContainer.getParent())) {
                    parentContainer = parentContainer.getParent();
                }
                if (parentContainer != null) {
                    container.removeChild(uiObject, parentContainer);
                }
            }
        }
        List list = UIProxyHelper.findControlsByClassType(container, "com.kingdee.bos.ctrl.kdf.table.KDTable");
        if (list.size() == 0) {
            container.removeAllChild(uiObject);
        } else if (list.size() == 1) {
            container.removeAllChild(uiObject);
            UIProxyHelper.addChild(container, (ComponentInfo)list.get(0), uiObject);
        }
    }

    private void updateKDTableByQuery(BizUnitInfo bizUnit, UIObjectInfo uiObject, ComponentInfo container, BizGroupFieldInfo groupField) {
        JoinQueryInfo query = groupField.getQuery();
        DataObjectInfo dataObject = UIProxyHelper.findDataObjectByType(uiObject, query.getFullName());
        if (dataObject != null) {
            List list = UIProxyHelper.findControlsByDataObject(container, dataObject);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ComponentInfo kdTable = (ComponentInfo)list.get(i);
                if (!"com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(kdTable.getClassType())) continue;
                BizFieldCollection fields = groupField.getFields();
                Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
                Vector<BizFieldInfo> updBizFields = new Vector<BizFieldInfo>();
                Vector<BizFieldInfo> delBizFields = new Vector<BizFieldInfo>();
                int m = fields.size();
                for (int j = 0; j < m; ++j) {
                    BizFieldInfo bizField = fields.get(j);
                    if (!bizField.isGenControl() || bizField instanceof BizGroupFieldInfo) continue;
                    if (ObjectStateType.NEW.equals((Object)bizField.getObjectState())) {
                        newBizFields.add(bizField);
                        continue;
                    }
                    if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState())) {
                        updBizFields.add(bizField);
                        continue;
                    }
                    if (!ObjectStateType.DELETING.equals((Object)bizField.getObjectState())) continue;
                    delBizFields.add(bizField);
                }
                if (newBizFields.size() == 0 && updBizFields.size() == 0 && delBizFields.size() == 0) {
                    return;
                }
                PropertyInfo property = kdTable.getProperties().get("formatXml");
                if (property == null) {
                    return;
                }
                TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
                BizFieldInfo[] tempFields = new BizFieldInfo[delBizFields.size()];
                System.arraycopy(delBizFields.toArray(), 0, tempFields, 0, delBizFields.size());
                UIProxyHelper.getInstance().delKDTableColumn(uiObject, kdTable, tableInfo, tempFields, false);
                tempFields = new BizFieldInfo[updBizFields.size()];
                System.arraycopy(updBizFields.toArray(), 0, tempFields, 0, updBizFields.size());
                ListUIProxyHelper.updKDTableColumn(bizUnit, kdTable, tableInfo, tempFields, dataObject.getName());
                tempFields = new BizFieldInfo[newBizFields.size()];
                System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
                ListUIProxyHelper.addKDTableColumn(bizUnit, kdTable, tableInfo, tempFields, dataObject.getName());
                property.setValue(KDTableDesignerHelper.getXmlFrom(tableInfo));
            }
        }
    }

    private static void removeKDTableByQuery(BizUnitInfo bizUnit, UIObjectInfo uiObject, ComponentInfo container, BizGroupFieldInfo groupField) {
        JoinQueryInfo query = groupField.getQuery();
        DataObjectInfo dataObject = UIProxyHelper.findDataObjectByType(uiObject, query.getFullName());
        if (dataObject != null) {
            uiObject.getDataObjects().remove(dataObject);
            List list = UIProxyHelper.findControlsByDataObject(container, dataObject);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ComponentInfo component = (ComponentInfo)list.get(i);
                ListUIProxy.removeKDTableFromBottomPanel(container, component, uiObject);
            }
        }
    }

    private static void createKDTableByQuery(BizUnitInfo bizUnit, UIObjectInfo uiObject, ComponentInfo container, BizGroupFieldInfo groupField) {
        JoinQueryInfo query = groupField.getQuery();
        DataObjectInfo dataObject = new DataObjectInfo();
        dataObject.setName(query.getName());
        dataObject.setType(query.getFullName());
        dataObject.setObjectType(query.getBOSType().toString());
        dataObject.setHerited(false);
        uiObject.getDataObjects().add(dataObject);
        ComponentInfo kdtControl = new ComponentInfo("com.kingdee.bos.ctrl.kdf.table.KDTable");
        kdtControl.setName("kdt" + StringUtils.headCharUpperCase((String)groupField.getName()));
        kdtControl.setConstraint("Center", false);
        kdtControl.setExtendedProperty("tabPageName", groupField.getAlias());
        ListUIProxy.addKDTableToBottomPanel(container, kdtControl, uiObject);
        BizFieldCollection fields = groupField.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        Vector<BizFieldInfo> newBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (!bizField.isGenControl() || !ObjectStateType.NEW.equals((Object)bizField.getObjectState())) continue;
            newBizFields.add(bizField);
        }
        BizFieldInfo[] tempFields = new BizFieldInfo[newBizFields.size()];
        System.arraycopy(newBizFields.toArray(), 0, tempFields, 0, newBizFields.size());
        ListUIProxyHelper.bindingKDTableProperty(bizUnit, tempFields, dataObject.getName(), kdtControl);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("id.text");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(dataObject.getName());
        propertyBindingInfo.setBingdingField("id");
        propertyBindingInfo.setFieldType(String.class.getName());
        propertyBindingInfo.setOverride(true);
        kdtControl.getPropertyBindings().add(propertyBindingInfo);
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.uiObject == null) {
            return;
        }
    }
}

