/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.query.util.Query4EntityUtil;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.util.StringUtils;

public class QueryProxyHelper {
    public static QueryPKInfo getQueryPKFromLogiaclKey(QueryInfo query, LogicalKeyInfo key) throws BOSException {
        if (key == null || query == null) {
            throw new BOSException("The entity's logicalKey is null && query is null");
        }
        QueryPKInfo queryPK = new QueryPKInfo();
        PropertyCollection props = key.getKeyPropertys();
        if (props == null) {
            throw new BOSException(" key is null");
        }
        QueryFieldInfo field = new QueryFieldInfo(query);
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            field.setIsFilter(true);
            field.setIsSelector(true);
            field.setName(props.get(i).getName());
            field.setReturnType(ConstDataType.STRING);
            PropertyRefInfo ref = new PropertyRefInfo(field, (SubEntityInfo)query.getMainObject(), props.get(i));
            field.getPropertyRefs().add(ref);
            field.setFormulaString("#0");
            queryPK.getKeyPropertys().add(field);
        }
        return queryPK;
    }

    public static JoinQueryInfo createQueryByEntity(EntityObjectInfo entity, IMetaDataPK metadataPK) throws BOSException {
        int i;
        if (entity == null) {
            throw new BOSException("The Entity is null!");
        }
        JoinQueryInfo jqy = new JoinQueryInfo();
        jqy.setPackage(metadataPK.getPackage());
        jqy.setName(metadataPK.getName());
        SubEntityInfo main = new SubEntityInfo(jqy, entity);
        jqy.getSubObjects().add(main);
        SelectorItemCollection selectors = new SelectorItemCollection();
        SorterItemCollection sorters = new SorterItemCollection();
        FilterInfo filter = new FilterInfo();
        jqy.setQueryPK(QueryProxyHelper.getQueryPKFromLogiaclKey(jqy, entity.getLogicalKey()));
        if (entity.getDefaultView() != null) {
            if (entity.getDefaultView().getSelector().size() > 0) {
                selectors.addObjectCollection(entity.getDefaultView().getSelector());
            }
            if (entity.getDefaultView().getSorter().size() > 0) {
                sorters.addObjectCollection(entity.getDefaultView().getSorter());
            }
            if (entity.getDefaultView().getFilter() != null) {
                filter.setMaskString(entity.getDefaultView().getFilter().getMaskString());
                filter.getFilterItems().addObjectCollection(entity.getDefaultView().getFilter().getFilterItems());
            }
        }
        if (selectors.size() == 0) {
            PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
            int n = props.size();
            for (int i2 = 0; i2 < n; ++i2) {
                SelectorItemInfo item = new SelectorItemInfo(props.get(i2).getName());
                selectors.add(item);
            }
        }
        int n = selectors.size();
        for (i = 0; i < n; ++i) {
            String propName = selectors.get(i).getPropertyName();
            Query4EntityUtil.processPropertyName(jqy, propName, true, ContextManager.getContext());
        }
        n = sorters.size();
        for (i = 0; i < n; ++i) {
            QueryUtil.processQuerySorter(jqy, sorters.get(i));
        }
        QueryUtil.processQueryFilter(jqy, filter);
        return jqy;
    }

    public static JoinQueryInfo createSubQueryByEntity(EntityObjectInfo mainEntity, String entryName, IMetaDataPK metadataPK) throws BOSException {
        int i;
        if (mainEntity == null || StringUtils.isEmpty((String)entryName)) {
            throw new BOSException("The Entity is null!");
        }
        PropertyInfo prop = mainEntity.getPropertyByName(entryName, true);
        if (prop == null || !(prop instanceof LinkPropertyInfo)) {
            throw new BOSException("The LinkProperty is null!");
        }
        EntityObjectInfo subEntity = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject();
        JoinQueryInfo jqy = new JoinQueryInfo();
        jqy.setPackage(metadataPK.getPackage());
        jqy.setName(metadataPK.getName());
        SubEntityInfo main = new SubEntityInfo(jqy, mainEntity);
        jqy.getSubObjects().add(main);
        SelectorItemCollection selectors = new SelectorItemCollection();
        SorterItemCollection sorters = new SorterItemCollection();
        FilterInfo filter = new FilterInfo();
        jqy.setQueryPK(QueryProxyHelper.getQueryPKFromLogiaclKey(jqy, mainEntity.getLogicalKey()));
        PropertyCollection props = subEntity.getInheritedNoDuplicatedProperties();
        int n = props.size();
        for (i = 0; i < n; ++i) {
            SelectorItemInfo item = new SelectorItemInfo(prop.getName() + "." + props.get(i).getName());
            selectors.add(item);
        }
        n = selectors.size();
        for (i = 0; i < n; ++i) {
            String propName = selectors.get(i).getPropertyName();
            Query4EntityUtil.processPropertyName(jqy, propName, true, ContextManager.getContext());
        }
        n = sorters.size();
        for (i = 0; i < n; ++i) {
            QueryUtil.processQuerySorter(jqy, sorters.get(i));
        }
        QueryUtil.processQueryFilter(jqy, filter);
        QueryProxyHelper.processQueryPK(jqy.getQueryPK(), jqy.getUnits());
        return jqy;
    }

    public static void processQueryPK(QueryPKInfo queryPK, PropertyUnitCollection propCol) {
        if (queryPK == null || queryPK.getKeyPropertys().size() == 0) {
            return;
        }
        int n = queryPK.getKeyPropertys().size();
        for (int i = 0; i < n; ++i) {
            boolean isFind = false;
            QueryFieldInfo field = queryPK.getKeyPropertys().get(i);
            if (field.getPropertyRefs().size() == 1) {
                String fieldFullName = field.getPropertyRefs().get(0).getSubEntity().getName() + "." + field.getPropertyRefs().get(0).getRefProperty().getName();
                int m = propCol.size();
                for (int j = 0; j < m; ++j) {
                    String propFullName;
                    PropertyUnitInfo prop = propCol.get(j);
                    if (prop == null || !(prop instanceof QueryFieldInfo) || prop.getPropertyRefs() == null || prop.getPropertyRefs().size() != 1 || prop.getPropertyRefs().get(0).getSubEntity() == null || prop.getPropertyRefs().get(0).getSubEntity().getName() == null || prop.getPropertyRefs().get(0).getRefProperty() == null || prop.getPropertyRefs().get(0).getRefProperty().getName() == null || !StringUtils.equalsIgnoreCase((String)fieldFullName, (String)(propFullName = prop.getPropertyRefs().get(0).getSubEntity().getName() + "." + prop.getPropertyRefs().get(0).getRefProperty().getName()))) continue;
                    field = (QueryFieldInfo)prop;
                    isFind = true;
                    break;
                }
            }
            if (isFind) continue;
            propCol.add(field);
        }
    }
}

