/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizMethodInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import java.io.Serializable;

public class RuleSetProxy
extends AbstractProxy
implements Serializable {
    private RuleSetInfo ruleSet;

    public RuleSetProxy(Context ctx, RuleSetInfo ruleSet) {
        this.ruleSet = ruleSet;
    }

    @Override
    public void update() throws BIMException {
        if (this.ruleSet == null) {
            return;
        }
        String nameExt = "RuleSet";
        if (this.bizUnit.getObjectState() == ObjectStateType.NEW) {
            this.ruleSet.setName(this.bizUnit.getName() + nameExt);
            this.ruleSet.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        }
        this.ruleSet.getRules().clear();
        int n = this.bizUnit.getFields().size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo field = this.bizUnit.getFields().get(i);
            this.addRulesToRuleSet(field);
        }
        int n2 = this.bizUnit.getMethods().size();
        for (int i = 0; i < n2; ++i) {
            BizMethodInfo method = this.bizUnit.getMethods().get(i);
            int m = method.getConditionRules().size();
            for (int j = 0; j < m; ++j) {
                this.ruleSet.getRules().add(method.getConditionRules().get(j));
            }
        }
    }

    private void addRulesToRuleSet(BizFieldInfo field) {
        if (field == null) {
            return;
        }
        int m = field.getConditionRules().size();
        for (int j = 0; j < m; ++j) {
            this.ruleSet.getRules().add(field.getConditionRules().get(j));
        }
        if (field instanceof BizGroupFieldInfo) {
            BizGroupFieldInfo groupField = (BizGroupFieldInfo)field;
            int m2 = groupField.getFields().size();
            for (int j = 0; j < m2; ++j) {
                BizFieldInfo subField = groupField.getFields().get(j);
                this.addRulesToRuleSet(subField);
            }
        }
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.ruleSet == null) {
            return;
        }
    }
}

