/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizFieldViewInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;

public class TableEditUIProxy
extends AbstractProxy
implements Serializable {
    private UIObjectInfo uiObject;

    public TableEditUIProxy(Context ctx, UIObjectInfo uiObject) {
        this.uiObject = uiObject;
    }

    @Override
    public void update() throws BIMException {
        if (this.uiObject == null) {
            return;
        }
        String dataObjName = "";
        if (this.uiObject.getDataObjects() != null && this.uiObject.getDataObjects().size() > 0) {
            dataObjName = this.uiObject.getDataObjects().get(0).getName();
        }
        if (StringUtils.isEmpty((String)dataObjName)) {
            return;
        }
        ComponentInfo tableControl = UIProxyHelper.findControlByName(this.uiObject, "tblMain");
        if (tableControl != null) {
            int n = this.bizUnit.getFields().size();
            for (int i = 0; i < n; ++i) {
                BizFieldInfo bizField = this.bizUnit.getFields().get(i);
                if (bizField instanceof BizGroupFieldInfo) continue;
                if (ObjectStateType.NEW.equals((Object)bizField.getObjectState())) {
                    this.addColumn(tableControl, bizField, this.bizUnit.getEntity(), dataObjName);
                    continue;
                }
                if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState())) {
                    this.updateColumn(tableControl, bizField);
                    continue;
                }
                if (!ObjectStateType.DELETING.equals((Object)bizField.getObjectState())) continue;
                this.removeColumn(tableControl, bizField);
            }
        }
    }

    private static ColumnInfo findTableColumnByName(TableInfo tableInfo, String columnName) {
        if (tableInfo == null || StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        int n = tableInfo.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnInfo column = (ColumnInfo)tableInfo.getColumns().get(i);
            if (!columnName.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addColumn(ComponentInfo tableControl, BizFieldInfo field, EntityObjectInfo entity, String dataObjName) {
        CardinalityType cardinal;
        HeaderInfo headerInfo;
        if (tableControl == null || field == null) {
            return;
        }
        PropertyInfo property = tableControl.getProperties().get("formatXml");
        if (property == null) return;
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
        if (tableInfo.getHeaderCount() == 0) {
            headerInfo = new HeaderInfo();
            headerInfo.setName("header");
            tableInfo.addHeader(headerInfo);
        } else {
            headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
        }
        String columnName = field.getName();
        ColumnInfo column = TableEditUIProxy.findTableColumnByName(tableInfo, columnName);
        if (column != null) return;
        String propName = field.getPropertyName();
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        if (StringUtils.isEmpty((String)propName)) {
            if (!DataSourceType.BASEDATAEXT.equals((Object)field.getDataSourceType()) || StringUtils.isEmpty((String)field.getDataField())) return;
            propName = field.getDataField();
            prop = EditUIProxyHelper.getPropertyByName(entity, field.getDataField());
        } else {
            prop = EditUIProxyHelper.getPropertyByName(entity, propName);
        }
        if (prop == null) {
            return;
        }
        if (prop instanceof LinkPropertyInfo ? !CardinalityType.ONE.equals((Object)(cardinal = ((LinkPropertyInfo)prop).getRelationship().getClientCardinality())) && !CardinalityType.ZERO_TO_ONE.equals((Object)cardinal) : !(prop instanceof OwnPropertyInfo)) {
            return;
        }
        column = new ColumnInfo();
        column.setName(columnName);
        BizFieldViewInfo fieldView = field.getFieldView();
        if (fieldView != null) {
            column.setHide(!fieldView.isVisible());
            column.setWidth(fieldView.getWidth() > 0 ? fieldView.getWidth() : -1);
            column.setLock(!fieldView.isEnable());
        }
        if (field.getBizDataType() == BizDataType.DECIMAL || field.getBizDataType() == BizDataType.AMOUNT || field.getBizDataType() == BizDataType.PRICE || field.getBizDataType() == BizDataType.QUANTITY) {
            if (field.getFieldView().getDecimalLength() > 0) {
                column.setFormatString(EditUIProxyHelper.getNumberFormat(field.getFieldView().getDecimalLength()));
            } else {
                column.setFormatString(EditUIProxyHelper.getNumberFormat(field.getScale()));
            }
        } else if (field.getBizDataType() == BizDataType.INTEGER) {
            column.setFormatString("%r{0}f");
        } else if (field.getBizDataType() == BizDataType.DATE) {
            column.setFormatString("%r{yyyy-M-d}t");
        } else if (field.getBizDataType() == BizDataType.TIME) {
            column.setFormatString("h:mm:ss");
        }
        tableInfo.addColumn(column);
        CellInfo cell = new CellInfo();
        String cellName = field.getAlias();
        if (StringUtils.isEmpty((String)cellName)) {
            cell.setName(field.getName());
        } else {
            cell.setName(cellName);
        }
        cell.setColSpan(0);
        cell.setRowSpan(0);
        headerInfo.addCell(cell);
        PropertyBindingInfo propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName(columnName + ".text");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(dataObjName);
        propertyBindingInfo.setBingdingField(propName);
        propertyBindingInfo.setOverride(true);
        if (prop instanceof OwnPropertyInfo) {
            propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
        } else if (prop instanceof LinkPropertyInfo) {
            propertyBindingInfo.setFieldType(Object.class.getName());
        }
        tableControl.getPropertyBindings().add(propertyBindingInfo);
        property.setValue(KDTableDesignerHelper.getXmlFrom(tableInfo));
        property.setOverride(true);
    }

    private void updateColumn(ComponentInfo tableControl, BizFieldInfo bizField) {
    }

    private void removeColumn(ComponentInfo tableControl, BizFieldInfo bizField) {
        if (tableControl == null || bizField == null) {
            return;
        }
        PropertyInfo property = tableControl.getProperties().get("formatXml");
        if (property != null) {
            HeaderInfo headerInfo;
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(property.getValue());
            if (tableInfo.getHeaderCount() == 0) {
                headerInfo = new HeaderInfo();
                headerInfo.setName("header");
                tableInfo.addHeader(headerInfo);
            } else {
                headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
            }
            String columnName = bizField.getName();
            ColumnInfo column = TableEditUIProxy.findTableColumnByName(tableInfo, columnName);
            if (column != null) {
                int index = tableInfo.getColumns().indexOf(column);
                if (headerInfo != null && headerInfo.getCellCount() > index) {
                    headerInfo.removeCell((CellInfo)headerInfo.getCells().get(index));
                }
                tableInfo.removeColumn(column);
                tableControl.getPropertyBindings().removeObject(columnName + ".text");
                property.setValue(KDTableDesignerHelper.getXmlFrom(tableInfo));
                property.setOverride(true);
            }
        }
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.uiObject == null) {
            return;
        }
    }
}

