/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.InvalidMetaDataException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.BusinessObjectCollection;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.STMethodEntry;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class BusinessObjectInfo
extends AbstractMetaDataValue
implements Serializable {
    public static final String GEN_BUSINESSIMPL_CODE = "genBusinessImplCode";
    private transient BOSObjectType bosType = null;
    private volatile transient Map<String, MethodCollection> allmethodMap = new HashMap<String, MethodCollection>();
    public static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"bzob");

    protected BusinessObjectInfo(boolean init) {
        super(init);
        this.put("methods", new MethodCollection());
        this.setAccessLevel(AccessLevel.PUBLIC);
        this.setSubClassingMode(SubClassingMode.NORMAL);
    }

    protected BusinessObjectInfo() {
        this.put("methods", new MethodCollection());
        this.setAccessLevel(AccessLevel.PUBLIC);
        this.setSubClassingMode(SubClassingMode.NORMAL);
    }

    public boolean isSubFrom(BusinessObjectInfo p) {
        if (this == p) {
            return true;
        }
        if (this.getFullName().equals(p.getFullName())) {
            return true;
        }
        if (this.getParent() != null && this.getParent().isSubFrom(p)) {
            return true;
        }
        BusinessObjectCollection sts = this.getExtendStereoTypes();
        int size = sts.size();
        for (int i = 0; i < size; ++i) {
            BusinessObjectInfo st = sts.get(i);
            if (!st.isSubFrom(p)) continue;
            return true;
        }
        return false;
    }

    public List getSTList() {
        LinkedList rtv = new LinkedList();
        if (this.isStereoType()) {
            return rtv;
        }
        this.innerSTList(rtv);
        return rtv;
    }

    public Set getSTSet() {
        LinkedList rtv = new LinkedList();
        this.innerSTList(rtv);
        return new HashSet(rtv);
    }

    private void innerSTList(List bag) {
        BusinessObjectCollection sts = this.getExtendStereoTypes();
        for (int i = 0; i < sts.size(); ++i) {
            BusinessObjectInfo bo = sts.get(i);
            bo.innerSTList(bag);
        }
        if (this.isStereoType()) {
            bag.add(this);
        }
    }

    public Collection getAllSTNoListenerMethods() {
        if (this.isStereoType()) {
            return null;
        }
        LinkedList<STMethodEntry> rtv = new LinkedList<STMethodEntry>();
        HashSet<MethodInfo> index = new HashSet<MethodInfo>();
        List sts = this.getSTList();
        for (BusinessObjectInfo st : sts) {
            MethodCollection mc = st.getMethods();
            for (int i = 0; i < mc.size(); ++i) {
                MethodInfo m = mc.get(i);
                if (m.getIsListenerMethod() || index.contains(m)) continue;
                index.add(m);
                rtv.add(new STMethodEntry(st, m));
            }
        }
        return rtv;
    }

    public List getListenerMethodMatchList(MethodInfo method) {
        if (this.isStereoType()) {
            return null;
        }
        LinkedList<BusinessObjectInfo> rtv = new LinkedList<BusinessObjectInfo>();
        List sts = this.getSTList();
        for (BusinessObjectInfo st : sts) {
            MethodCollection mc = st.getMethods();
            for (int i = 0; i < mc.size(); ++i) {
                MethodInfo m = mc.get(i);
                if (!m.getIsListenerMethod() || !method.matchSTMethod(m)) continue;
                rtv.add(st);
            }
        }
        return rtv;
    }

    public Collection getMustOverrideParentMethods() {
        if (this.isStereoType()) {
            return null;
        }
        LinkedList rtv = new LinkedList();
        return rtv;
    }

    public boolean isStereoType() {
        return this.getBoolean("stereoType");
    }

    public void setStereoType(boolean stereoType) {
        this.setBoolean("stereoType", stereoType);
    }

    public abstract BusinessObjectCollection getExtendStereoTypes();

    public abstract BusinessObjectCollection addExtendStereoType(BusinessObjectInfo var1);

    public String getBusinessImplFactory() {
        if (StringUtils.isEmpty((String)this.getBusinessImplName())) {
            return "";
        }
        return this.getBusinessImplName() + "Factory";
    }

    public String getBusinessImplName() {
        return this.getString("businessImplName");
    }

    public void setBusinessImplName(String bizImplName) {
        this.setString("businessImplName", bizImplName);
    }

    public String getBusinessAgent() {
        return this.getBusinessImplName() + "Agent";
    }

    public String getBusinessInterface() {
        String implName = this.getBusinessImplName();
        if (StringUtils.isEmpty((String)implName)) {
            return "";
        }
        int index = implName.lastIndexOf(46);
        if (index != -1) {
            return implName.substring(0, index + 1) + "I" + implName.substring(index + 1);
        }
        return "I" + implName;
    }

    public String getBusinessControllerName() {
        return this.getString("businessControllerName");
    }

    public void setBusinessControllerName(String bizCtrlName) {
        this.setString("businessControllerName", bizCtrlName);
    }

    public String getEJBName() {
        String temp = this.getBusinessControllerName();
        if (StringUtils.isEmpty((String)temp)) {
            return "";
        }
        int index = temp.lastIndexOf(46);
        if (index != -1) {
            return temp.substring(index + 1);
        }
        return temp;
    }

    public String getBusinessControllerHome() {
        if (StringUtils.isEmpty((String)this.getBusinessControllerName())) {
            return "";
        }
        return this.getBusinessControllerName() + "RemoteHome";
    }

    public String getBusinessControllerLocaleHome() {
        if (StringUtils.isEmpty((String)this.getBusinessControllerName())) {
            return "";
        }
        return this.getBusinessControllerName() + "LocalHome";
    }

    public String getBusinessControllerLocal() {
        if (StringUtils.isEmpty((String)this.getBusinessControllerName())) {
            return "";
        }
        return this.getBusinessControllerName() + "Local";
    }

    public String getBusinessControllerBean() {
        if (StringUtils.isEmpty((String)this.getBusinessControllerName())) {
            return "";
        }
        return this.getBusinessControllerName() + "Bean";
    }

    public String getAbstractBusinessControllerBean() {
        String temp = this.getBusinessControllerBean();
        if (StringUtils.isEmpty((String)temp)) {
            return "";
        }
        int index = temp.lastIndexOf(46);
        if (index != -1) {
            return temp.substring(0, index + 1) + "Abstract" + temp.substring(index + 1);
        }
        return "Abstract" + temp;
    }

    public String getRuntimeBusinessControllerBean() {
        String ctrlBeanEx = this.getExtendedProperty("controllerBeanEx");
        if (!StringUtils.isEmpty((String)ctrlBeanEx)) {
            return ctrlBeanEx;
        }
        if (this.isPIBO()) {
            return this.getBusinessControllerName() + "BeanPIEx";
        }
        if (StringUtils.isEmpty((String)this.getBusinessControllerName())) {
            return "";
        }
        return this.getBusinessControllerName() + "Bean";
    }

    public String getBusinessControllerRemote() {
        if (StringUtils.isEmpty((String)this.getBusinessControllerName())) {
            return "";
        }
        return this.getBusinessControllerName() + "Remote";
    }

    public BOSObjectType getType() {
        if (this.bosType != null) {
            return this.bosType;
        }
        String type = this.getString("bosType");
        if (StringUtils.isEmpty((String)type)) {
            return null;
        }
        this.bosType = BOSObjectType.create((String)type);
        return this.bosType;
    }

    public void setType(BOSObjectType bosType) {
        this.bosType = bosType;
        this.put("bosType", bosType.toString());
    }

    public void clearType() {
        this.bosType = null;
    }

    public AccessLevel getAccessLevel() {
        return AccessLevel.PUBLIC;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.setString("accessLevel", AccessLevel.PUBLIC.getName());
    }

    public SubClassingMode getSubClassingMode() {
        SubClassingMode scm = SubClassingMode.getEnum(this.getString("subClassingMode"));
        if (scm != null) {
            return scm;
        }
        return SubClassingMode.NORMAL;
    }

    public void setSubClassingMode(SubClassingMode subClassingMode) {
        if (subClassingMode != null) {
            this.setString("subClassingMode", subClassingMode.getName());
        }
    }

    public MethodCollection getMethods() {
        return (MethodCollection)this.get("methods");
    }

    public MethodCollection getAllMethodsRuntime() {
        if (this.allmethodMap.get(ConfigMDUtil.getAIS()) == null) {
            this.allmethodMap.put(ConfigMDUtil.getAIS(), this.getAllMethods());
        }
        return this.allmethodMap.get(ConfigMDUtil.getAIS());
    }

    public MethodCollection getAllMethods() {
        ArrayList<BusinessObjectInfo> parents = new ArrayList<BusinessObjectInfo>();
        BusinessObjectInfo boCur = this;
        do {
            parents.add(boCur);
        } while ((boCur = boCur.getParent()) != null);
        HashMap<String, MethodInfo> stage = new HashMap<String, MethodInfo>();
        for (int i = parents.size() - 1; i >= 0; --i) {
            boCur = (BusinessObjectInfo)parents.get(i);
            MethodCollection mc = boCur.getMethods();
            int size = mc.size();
            for (int j = 0; j < size; ++j) {
                MethodInfo method = mc.get(j);
                String key = method.getInnerID();
                if (key == null) {
                    key = BusinessObjectInfo.computeMethodType(method);
                }
                stage.put(key, method);
            }
        }
        MethodCollection rtv = new MethodCollection();
        Iterator it = stage.values().iterator();
        while (it.hasNext()) {
            rtv.add((MethodInfo)it.next());
        }
        return rtv;
    }

    private static String computeMethodType(MethodInfo method) {
        if (method == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(method.getAccessLevel().getName());
        buff.append(' ');
        String dataType = method.getDataType();
        String typeRef = method.getMetaDataRef();
        buff.append(dataType);
        if (!StringUtils.isEmpty((String)typeRef)) {
            buff.append('<');
            buff.append(typeRef);
            buff.append('>');
        }
        buff.append(' ');
        buff.append(method.getName());
        buff.append('(');
        ParameterCollection pc = method.getParameters();
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            ParameterInfo para = pc.get(i);
            if (i != 0) {
                buff.append(',');
            }
            dataType = para.getDataType();
            typeRef = para.getMetaDataRef();
            buff.append(dataType);
            if (StringUtils.isEmpty((String)typeRef)) continue;
            buff.append('<');
            buff.append(typeRef);
            buff.append('>');
        }
        buff.append(')');
        return buff.toString();
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    public abstract BusinessObjectInfo getParent();

    public abstract boolean isSystemMethod(MethodInfo var1);

    @Override
    public ValidateList validate() {
        boolean isAbstract;
        int i;
        super.validate();
        ValidateMetaData vld = this.getValidate();
        vld.validateClassName("Business Implements class Name", this.getBusinessImplName());
        vld.validateClassName("Business Controller class Name", this.getBusinessControllerName());
        if (this.isStereoType() && this.getParent() != null) {
            vld.addError(this.getFullName() + " \uff1aStereoType BusinessObject Can not have Parent!");
        }
        BusinessObjectCollection boc = this.getExtendStereoTypes();
        HashMap tempIndex = new HashMap();
        for (i = 0; i < boc.size(); ++i) {
            BusinessObjectInfo bo = boc.get(i);
            if (!bo.isStereoType()) {
                vld.addError(this.getFullName() + " extended " + bo.getFullName() + "is not a StereoType.");
            }
            if (tempIndex.containsKey(bo)) {
                vld.addWarning(this.getFullName() + " extended StereoType " + bo.getFullName() + " times.");
            }
            tempIndex.put(bo, null);
            if (this.getBOSType().equals((Object)bo.getBOSType())) continue;
            vld.addError("BO" + this.getFullName() + " extended StereoType " + bo.getFullName() + " is not the same BOSType.");
        }
        for (i = 0; i < this.getMethods().size(); ++i) {
            MethodInfo method = this.getMethods().get(i);
            for (int j = i + 1; j < this.getMethods().size(); ++j) {
                MethodInfo m2 = this.getMethods().get(j);
                if (!method.getName().equals(m2.getName()) || !method.getParameters().equals(m2.getParameters())) continue;
                vld.addError("BO [" + this.getFullName() + "] define method [" + method.toString() + "] more times.");
            }
            List inhMethods = this.getInheritedMethods();
            for (int j = 0; j < inhMethods.size(); ++j) {
                MethodInfo m2 = (MethodInfo)inhMethods.get(j);
                if (!method.getName().equals(m2.getName()) || !method.getParameters().equals(m2.getParameters()) || method.getDataType() == null && m2.getDataType() == null || method.getDataType() != null && method.getDataType().equals(m2.getDataType()) || "boolean".equalsIgnoreCase(method.getDataType()) && "boolean".equalsIgnoreCase(m2.getDataType())) continue;
                vld.addError("BO [" + this.getFullName() + "] defined method [" + method.toString() + "] not the same return type with parent defined.");
            }
        }
        Set sts = this.getSTSet();
        HashMap<MethodInfo, BusinessObjectInfo> methodNameIndex = new HashMap<MethodInfo, BusinessObjectInfo>();
        for (BusinessObjectInfo st : sts) {
            MethodCollection mc = st.getMethods();
            boolean exist = false;
            for (int i2 = 0; i2 < mc.size(); ++i2) {
                MethodInfo method = mc.get(i2);
                if (method.getIsListenerMethod()) continue;
                if (!this.isStereoType()) {
                    for (int k = 0; k < this.getMethods().size(); ++k) {
                        MethodInfo myMethod = this.getMethods().get(k);
                        if (!myMethod.getName().equals(method.getName()) || !myMethod.getParameters().equals(method.getParameters())) continue;
                        vld.addError("StereoType method [" + st.getFullName() + " - " + method.toString() + "] is over by BO method [" + this.getFullName() + " - " + myMethod.toString() + "] !");
                        break;
                    }
                }
                for (Map.Entry en : methodNameIndex.entrySet()) {
                    MethodInfo temp = (MethodInfo)en.getKey();
                    BusinessObjectInfo bo = (BusinessObjectInfo)en.getValue();
                    if (!temp.getName().equals(method.getName()) || !temp.getParameters().equals(method.getParameters())) continue;
                    exist = true;
                    if (temp.getDataType() == null && method.getDataType() == null || temp.getDataType() != null && temp.getDataType().equals(method.getDataType()) || "boolean".equalsIgnoreCase(temp.getDataType()) && "boolean".equalsIgnoreCase(method.getDataType())) {
                        vld.addWarning("StereoType method [" + st.getFullName() + " - " + method.toString() + "] [" + bo.getFullName() + " - " + temp.toString() + "] define more times in ST Hierarchy.");
                        break;
                    }
                    vld.addError("StereoType method [" + st.getFullName() + " - " + method.toString() + "] [" + bo.getFullName() + " - " + temp.toString() + "] not return the same type.");
                    break;
                }
                if (exist) continue;
                methodNameIndex.put(method, st);
            }
        }
        boolean bl = isAbstract = this.getSubClassingMode() == SubClassingMode.ABSTRACT;
        if (this.getMethods() != null) {
            int size = this.getMethods().size();
            for (int i3 = 0; i3 < size; ++i3) {
                MethodInfo mi;
                vld.addValidateList(this.getMethods().get(i3).validate(isAbstract));
                if (this.isStereoType() || !(mi = this.getMethods().get(i3)).getIsListenerMethod()) continue;
                vld.addWarning(this.getFullName() + " : ListenerMethod [" + mi.getName() + " ID=" + mi.getInnerID() + "] can only define in StereoType.");
            }
        }
        this.validateMethodInnerIDDuplicate(vld);
        return vld.getValidateList();
    }

    private void validateSTCircle() throws BOSException {
        if (this.isStereoType()) {
            Stack stack = new Stack();
            this.checkST(this, stack);
        }
    }

    private void checkST(BusinessObjectInfo st, Stack stack) throws BOSException {
        stack.push(st);
        BusinessObjectCollection sts = st.getExtendStereoTypes();
        for (int i = 0; i < sts.size(); ++i) {
            BusinessObjectInfo nextst = sts.get(i);
            if (stack.contains(nextst)) {
                throw new InvalidMetaDataException("The inherited tree of stereotype ia a circle![" + st.getFullName() + " extends " + nextst.getFullName() + "]");
            }
            this.checkST(nextst, stack);
        }
        stack.pop();
    }

    private List getInheritedMethods() {
        LinkedList<MethodInfo> rtv = new LinkedList<MethodInfo>();
        for (BusinessObjectInfo curr = this.getParent(); curr != null; curr = curr.getParent()) {
            MethodCollection mc = curr.getMethods();
            for (int i = 0; i < mc.size(); ++i) {
                rtv.add(mc.get(i));
            }
        }
        return rtv;
    }

    protected void validateMethodInnerIDDuplicate(ValidateMetaData vld) {
        MethodCollection methods = null;
        MethodInfo method = null;
        String innerID = null;
        Hashtable<String, MethodInfo> table = new Hashtable<String, MethodInfo>();
        for (BusinessObjectInfo bo = this; bo != null; bo = bo.getParent()) {
            methods = bo.getMethods();
            int len = methods.size();
            for (int i = 0; i < len; ++i) {
                method = methods.get(i);
                innerID = method.getInnerID();
                if (innerID == null) continue;
                if (table.containsKey(innerID)) {
                    vld.addError(bo.getFullName() + " Duplicated method innerid!\n\t " + method.toString() + " : " + ((MethodInfo)table.get(innerID)).toString());
                    continue;
                }
                table.put(innerID, method);
            }
        }
    }

    public MethodInfo getInheritedMethodByID(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("Method InnerID is null");
        }
        MethodCollection mc = this.getAllMethodsRuntime();
        for (int i = 0; i < mc.size(); ++i) {
            MethodInfo info = mc.get(i);
            if (!id.equals(info.getInnerID())) continue;
            return info;
        }
        return null;
    }

    public boolean isPIBO() {
        MethodCollection ms = this.getMethods();
        for (int i = 0; i < ms.size(); ++i) {
            MethodInfo m = ms.get(i);
            if (!m.isPIMethod()) continue;
            return true;
        }
        return false;
    }

    public MethodCollection getAllNoDuplicatedMethods() {
        int j;
        ArrayList<BusinessObjectInfo> parents = new ArrayList<BusinessObjectInfo>();
        BusinessObjectInfo boCur = this;
        do {
            parents.add(boCur);
        } while ((boCur = boCur.getParent()) != null);
        ArrayList<String> signs = new ArrayList<String>();
        HashMap<String, MethodInfo> map = new HashMap<String, MethodInfo>();
        for (int i = parents.size() - 1; i >= 0; --i) {
            boCur = (BusinessObjectInfo)parents.get(i);
            MethodCollection mc = boCur.getMethods();
            int size = mc.size();
            for (j = 0; j < size; ++j) {
                MethodInfo method = mc.get(j);
                String sign = method.toString();
                signs.remove(sign);
                signs.add(sign);
                map.put(sign, method);
            }
        }
        MethodCollection rtv = new MethodCollection();
        j = signs.size();
        for (int i = 0; i < j; ++i) {
            MethodInfo method = (MethodInfo)map.get(signs.get(i));
            rtv.add(method);
        }
        return rtv;
    }

    public boolean isGenBusinessImplCode() {
        String v = super.getExtendedProperty(GEN_BUSINESSIMPL_CODE);
        return !"false".equalsIgnoreCase(v);
    }

    public void setGenBusinessImplCode(boolean b) {
        super.setExtendedProperty(GEN_BUSINESSIMPL_CODE, String.valueOf(b));
    }

    public static class MatchedMethodEntry {
        private MethodInfo stMethod;
        private MethodInfo boMethod;
        private boolean inherited = false;

        public MatchedMethodEntry(MethodInfo bo, boolean inh) {
            this(bo, inh, null);
        }

        public MatchedMethodEntry(MethodInfo bo, boolean inh, MethodInfo st) {
            this.stMethod = st;
            this.boMethod = bo;
            this.inherited = inh;
        }

        public MethodInfo getSTMethod() {
            return this.stMethod;
        }

        public MethodInfo getBOMethod() {
            return this.boMethod;
        }

        public boolean isInheritedMethod() {
            return this.inherited;
        }

        public boolean isSTMatched() {
            return this.stMethod != null;
        }

        public boolean isListenerMethod() {
            if (this.stMethod == null) {
                throw new IllegalStateException("This method is not StereoType matched.");
            }
            return this.stMethod.getIsListenerMethod();
        }
    }
}

