/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.ConditionRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.EventType;
import com.kingdee.bos.metadata.bizrule.common.RuleCollection;
import com.kingdee.bos.metadata.bizrule.util.RuleJCodeWriter;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.code.ui.UICodeWriterHelper;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.management.ISolutionCtrl;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.IBizEnumCtrl;
import com.kingdee.bos.metadata.ui.ActionExtendPropertyHelper;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingCollection;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.dtp.BorderPropertyUtil;
import com.kingdee.bos.ui.dtp.EventInfoHelper;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AbstractUICodeWriter
extends CodeWriterBase {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.code.AbstractUICodeWriter");
    private boolean multiLanguage = true;
    private UIObjectInfo model;
    private UIObjectInfo resultModel;
    private ComponentCollection components;
    private ComponentInfo toolBar;
    private ComponentInfo menuBar;
    private ComponentInfo rootPanel;
    private static final String MENUBAR = "menuBar";
    private static final String TOOLBAR = "toolBar";
    private static final String imp1 = "org.apache.log4j.*";
    private static final String imp2 = "java.awt.*";
    private static final String imp3 = "java.awt.event.*";
    private static final String imp4 = "java.util.*";
    private static final String imp5 = "javax.swing.border.*";
    private static final String imp6 = "javax.swing.BorderFactory";
    private static final String imp7 = "javax.swing.event.*";
    private static final String imp8 = "com.kingdee.bos.ctrl.swing.*";
    private static final String imp9 = "com.kingdee.bos.ctrl.kdf.table.*";
    private static final String imp10 = "com.kingdee.bos.ctrl.kdf.data.event.*";
    private static final String imp11 = "com.kingdee.bos.dao.*";
    private static final String imp12 = "com.kingdee.bos.dao.query.*";
    private static final String imp13 = "com.kingdee.bos.metadata.*";
    private static final String imp14 = "com.kingdee.bos.metadata.entity.*";
    private static final String imp15 = "com.kingdee.bos.ui.face.*";
    private static final String imp16 = "com.kingdee.bos.ui.util.ResourceBundleHelper";
    private static final String imp17 = "com.kingdee.bos.util.BOSUuid";
    private static final String imp18 = "com.kingdee.bos.service.ServiceContext";
    private static final String imp19 = "com.kingdee.jdbc.rowset.IRowSet";
    private static final String imp20 = "com.kingdee.util.enums.EnumUtils";
    private static final String imp21 = "javax.swing.KeyStroke";
    private static final String imp22 = "com.kingdee.bos.ui.face.UIRuleUtil";
    private static final String imp23 = "com.kingdee.bos.ctrl.swing.event.*";
    private static final String imp24 = "com.kingdee.bos.ctrl.kdf.util.style.*";
    private static final String imp25 = "com.kingdee.bos.ctrl.kdf.table.event.*";
    private static final String imp26 = "com.kingdee.bos.ctrl.extendcontrols.*";
    private static final String imp27 = "com.kingdee.bos.ctrl.kdf.util.render.*";
    private static final String TBUTTONGROUP = "com.kingdee.bos.ctrl.swing.KDButtonGroup";
    private static final String TSCROLLPANE = "com.kingdee.bos.ctrl.swing.KDScrollPane";
    private static final String KDMENUBAR = "com.kingdee.bos.ctrl.swing.KDMenuBar";
    private static final String KDMENU = "com.kingdee.bos.ctrl.swing.KDMenu";
    private static final String KDTABLE = "com.kingdee.bos.ctrl.kdf.table.KDTable";
    private static final String KDTABBEDPANE = "com.kingdee.bos.ctrl.swing.KDTabbedPane";
    private static final String KDDATEPICKER = "com.kingdee.bos.ctrl.swing.KDDatePicker";
    private static final String KDTIMEPICKER = "com.kingdee.bos.ctrl.swing.KDTimePicker";
    private static final String KDFORMATTEDTEXTFIELD = "com.kingdee.bos.ctrl.swing.KDFormattedTextField";
    private static final String KDNUMBERTEXTFIELD = "com.kingdee.bos.ctrl.swing.KDNumberTextField";
    private static final String KDSPINNER = "com.kingdee.bos.ctrl.swing.KDSpinner";
    private static final String KDCONTAINER = "com.kingdee.bos.ctrl.swing.KDContainer";
    private static final String KDBIZPROMPTBOX = "com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox";
    private static final String KDPANEL = "com.kingdee.bos.ctrl.swing.KDPanel";
    private static final String baseClassName = "CoreUIObject";
    private boolean hasBindTable = false;
    private boolean hasBindQuery = false;
    private boolean hasBindWorkFlow = false;
    private String bindObjectType = "";
    private Hashtable headerList = new Hashtable();
    private ArrayList queryList = new ArrayList();
    private ArrayList cloneQueryList = new ArrayList();
    private boolean needGenerateQueryExecutor = false;
    private String firstFocusControlName = null;

    public AbstractUICodeWriter(UIObjectInfo model) {
        this(model, true);
    }

    public AbstractUICodeWriter(UIObjectInfo model, boolean multiLanguage) {
        this.model = model;
        this.multiLanguage = multiLanguage;
        this.components = this.model.getComponents();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            if (this.components.get(i).getParent() != null) continue;
            if (this.components.get(i).getClassType().indexOf("Panel") >= 0) {
                this.rootPanel = this.components.get(i);
                continue;
            }
            if (this.components.get(i).getClassType().indexOf("MenuBar") >= 0) {
                this.menuBar = this.components.get(i);
                continue;
            }
            if (this.components.get(i).getClassType().indexOf("ToolBar") < 0) continue;
            this.toolBar = this.components.get(i);
        }
        this.components = this.treeToCol(this.model.getComponents());
    }

    protected void writePackage() {
        this.out.append(this.writeNote("output package name", new String[0], ""));
        if (this.model.getReleasePackage() != null) {
            this.out.append("package " + this.model.getReleasePackage() + ';' + '\n');
        }
        this.out.append('\n');
        this.out.append("import org.apache.log4j.*;\n");
        this.out.append('\n');
        this.out.append("import java.awt.*;\n");
        this.out.append("import java.awt.event.*;\n");
        this.out.append("import java.util.*;\n");
        this.out.append("import javax.swing.border.*;\n");
        this.out.append("import javax.swing.BorderFactory;\n");
        this.out.append("import javax.swing.event.*;\n");
        this.out.append("import javax.swing.KeyStroke;\n");
        this.out.append('\n');
        this.out.append("import com.kingdee.bos.ctrl.swing.*;\n");
        this.out.append("import com.kingdee.bos.ctrl.kdf.table.*;\n");
        this.out.append("import com.kingdee.bos.ctrl.kdf.data.event.*;\n");
        this.out.append("import com.kingdee.bos.dao.*;\n");
        this.out.append("import com.kingdee.bos.dao.query.*;\n");
        this.out.append("import com.kingdee.bos.metadata.*;\n");
        this.out.append("import com.kingdee.bos.metadata.entity.*;\n");
        this.out.append("import com.kingdee.bos.ui.face.*;\n");
        this.out.append("import com.kingdee.bos.ui.util.ResourceBundleHelper;\n");
        this.out.append("import com.kingdee.bos.util.BOSUuid;\n");
        this.out.append("import com.kingdee.bos.service.ServiceContext;\n");
        this.out.append("import com.kingdee.jdbc.rowset.IRowSet;\n");
        this.out.append("import com.kingdee.util.enums.EnumUtils;\n");
        this.out.append("import com.kingdee.bos.ui.face.UIRuleUtil;\n");
        this.out.append("import com.kingdee.bos.ctrl.swing.event.*;\n");
        this.out.append("import com.kingdee.bos.ctrl.kdf.table.event.*;\n");
        this.out.append("import com.kingdee.bos.ctrl.extendcontrols.*;\n");
        this.out.append("import com.kingdee.bos.ctrl.kdf.util.render.*;\n");
        if ("ListUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName()))) {
            this.out.append("import com.kingdee.bos.ctrl.swing.event.*;\n");
        }
        this.out.append('\n');
    }

    private void writeClass() {
        this.out.append(this.writeNote("output class name", new String[0], ""));
        this.out.append("public abstract class " + this.getClassName());
        this.out.append(this.addBlank("extends"));
        UIObjectInfo currentModel = this.getCurrentModel();
        if (currentModel.getParent() == null) {
            this.out.append(baseClassName);
        } else if (StringUtils.isEmpty((String)currentModel.getParent().getReleasePackage())) {
            this.out.append(currentModel.getParent().getReleaseClass());
        } else {
            this.out.append(currentModel.getParent().getReleasePackage() + "." + currentModel.getParent().getReleaseClass());
        }
        this.out.append('\n');
    }

    protected ComponentInfo getTableComonentInfo() {
        int m = this.components.size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            if (cInfo.getClassType() == null || !cInfo.getClassType().equalsIgnoreCase(KDTABLE)) continue;
            return cInfo;
        }
        return null;
    }

    protected JoinQueryInfo getBindedQueryForListUI() {
        DataObjectInfo dInfo;
        IObjectValue objectValue = null;
        int n = this.model.getDataObjects().size();
        for (int i = 0; i < n && !(dInfo = this.model.getDataObjects().get(i)).getObjectType().equals(MetaDataTypeList.ENTITY.toString()); ++i) {
            if (!dInfo.getObjectType().equals(MetaDataTypeList.UNIONQUERY.toString()) && !dInfo.getObjectType().equals(MetaDataTypeList.JOINQUERY.toString())) continue;
            objectValue = dInfo.getInstanceOfQueryForBim();
            if (objectValue == null || !(objectValue instanceof JoinQueryInfo)) break;
            return (JoinQueryInfo)objectValue;
        }
        return null;
    }

    protected void writeGetSelectedTreeKeyValue() {
        this.out.append('\n');
        this.out.append(this.writeNote("output getSelectedTreeKeyValue method", new String[0], ""));
        this.out.append(this.tab + "protected com.kingdee.bos.dao.IObjectPK getSelectedTreeKeyValue()" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return null;" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    protected void writeGetMergeColumnKeys() {
        ArrayList queryFieldNames;
        ComponentInfo bindedTable = this.getTableComonentInfo();
        JoinQueryInfo bindedQuery = this.getBindedQueryForListUI();
        if (bindedTable == null || bindedQuery == null) {
            return;
        }
        ArrayList<String> mergeColumnKeys = new ArrayList<String>();
        try {
            queryFieldNames = bindedQuery.getMergeQueryFieldNames();
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            return;
        }
        if (queryFieldNames == null || queryFieldNames.size() == 0) {
            return;
        }
        if (this.headerList.containsKey(bindedTable.getName()) && this.headerList.get(bindedTable.getName()) != null) {
            String[] tableColumnNames = (String[])this.headerList.get(bindedTable.getName());
            PropertyBindingCollection pbCol = bindedTable.getPropertyBindings();
            for (String tableColumnName : tableColumnNames) {
                int n = pbCol.size();
                for (int j = 0; j < n; ++j) {
                    String bindedQueryFieldName;
                    String bindedTableColumnName;
                    PropertyBindingInfo pbInfo = pbCol.get(j);
                    if (pbInfo.getPropertyName().indexOf(".text") < 0 || !tableColumnName.equalsIgnoreCase(bindedTableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")) || !queryFieldNames.contains(bindedQueryFieldName = pbInfo.getBingdingField())) continue;
                    mergeColumnKeys.add(tableColumnName);
                }
            }
            this.out.append('\n');
            this.out.append(this.writeNote("output getMergeColumnKeys method", new String[0], ""));
            this.out.append(this.tab + "public String[] getMergeColumnKeys()" + '\n');
            this.writeBegin();
            this.tabAdd();
            StringBuffer sbTemp = new StringBuffer();
            int n = mergeColumnKeys.size();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    sbTemp.append("\"" + mergeColumnKeys.get(i).toString() + "\"");
                    continue;
                }
                sbTemp.append(",\"" + mergeColumnKeys.get(i).toString() + "\"");
            }
            this.out.append(this.tab + "return new String[] {" + sbTemp.toString() + "};" + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    private void writeVariable() {
        this.out.append(this.tab + "protected" + ' ' + "Logger logger;" + '\n');
        if (this.getCurrentModel().getParent() == null) {
            this.out.append(this.tab + "protected" + ' ' + "ResourceBundleHelper resHelper = null;" + '\n');
        }
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            if (cInfo.isHerited() || cInfo == this.rootPanel || cInfo == this.menuBar || cInfo == this.toolBar) continue;
            this.out.append(this.tab + "protected" + ' ' + cInfo.getClassType() + ' ' + cInfo.getName() + ';' + '\n');
        }
        IObjectValue objectValue = null;
        int n2 = this.model.getDataObjects().size();
        for (int i = 0; i < n2; ++i) {
            DataObjectInfo dInfo = this.model.getDataObjects().get(i);
            if (dInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) {
                objectValue = dInfo.getInstance();
                if (objectValue == null || !(objectValue instanceof EntityObjectInfo)) continue;
                this.out.append(this.tab + "protected" + ' ' + ((EntityObjectInfo)objectValue).getObjectValueClass() + ' ' + dInfo.getName() + " = null" + ';' + '\n');
                continue;
            }
            if (!dInfo.getObjectType().equals(MetaDataTypeList.UNIONQUERY.toString()) && !dInfo.getObjectType().equals(MetaDataTypeList.JOINQUERY.toString())) continue;
            if (!dInfo.isHerited()) {
                this.out.append(this.tab + "protected" + ' ' + "EntityViewInfo " + dInfo.getName() + " = null" + ';' + '\n');
                this.out.append(this.tab + "protected" + ' ' + "IMetaDataPK " + dInfo.getName() + "PK;");
                this.queryList.add(dInfo.getName());
                this.cloneQueryList.add(dInfo.getName());
                continue;
            }
            this.cloneQueryList.clear();
            for (int j = 0; j < this.queryList.size(); ++j) {
                this.cloneQueryList.add(this.queryList.get(j));
            }
            this.cloneQueryList.add(dInfo.getName());
        }
        int n3 = this.model.getActions().size();
        for (int i = 0; i < n3; ++i) {
            ActionInfo aInfo = this.model.getActions().get(i);
            if (aInfo.isHerited()) continue;
            this.out.append(this.tab + "protected" + ' ' + aInfo.getClassName() + ' ' + aInfo.getName() + " = null" + ';' + '\n');
        }
        int n4 = this.model.getStatuses().size();
        for (int i = 0; i < n4; ++i) {
            StatusInfo sInfo = this.model.getStatuses().get(i);
            if (sInfo.isHerited()) continue;
            this.out.append(this.tab + "public final static String STATUS_" + sInfo.getName().toUpperCase() + " = \"" + sInfo.getName() + "\";" + '\n');
        }
    }

    private void writeConstruct() {
        this.out.append('\n');
        this.out.append(this.writeNote("output class constructor", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + this.getClassName() + '(' + ')' + ' ' + "throws Exception" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + ')' + ';' + '\n');
        if (this.model.getDataObjects().size() > 0) {
            this.out.append(this.tab + "this.defaultObjectName = \"" + this.model.getDataObjects().get(0).getName() + "\";" + '\n');
        }
        this.out.append(this.tab + "logger = getLogger(Abstract" + this.model.getReleaseClass() + ".class);" + '\n');
        this.out.append(this.tab + "jbInit();" + '\n');
        if ("EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            String name = !StringUtils.isEmpty((String)this.model.getReleasePackage()) ? this.model.getReleasePackage() + "." + StringUtils.replace((String)this.model.getReleaseClass(), (String)"EditUI", (String)"") : StringUtils.replace((String)this.model.getReleaseClass(), (String)"EditUI", (String)"");
            this.out.append(this.tab + name + "HMD hmd = new " + name + "HMD();" + '\n');
            this.out.append(this.tab + "this.setBillHeadEdit(hmd);" + '\n');
        }
        this.tabSub();
        this.writeEnd();
    }

    private void writeGetLogger() {
        this.out.append('\n');
        this.out.append(this.writeNote("output getLogger(Class type) method", new String[]{"type"}, ""));
        this.out.append(this.tab + "public Logger getLogger(Class type)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return Logger.getLogger(type);" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeInitFunction() {
        try {
            int i;
            this.out.append('\n');
            this.out.append(this.writeNote("output jbInit method", new String[0], ""));
            this.out.append(this.tab + "private void jbInit" + '(' + ')' + ' ' + "throws" + ' ' + "Exception" + '\n');
            this.writeBegin();
            this.tabAdd();
            if (this.multiLanguage) {
                this.out.append(this.tab + "this.resHelper = new ResourceBundleHelper(Abstract" + this.model.getReleaseClass() + ".class.getName());" + '\n');
                this.out.append(this.tab + "this.setUITitle(resHelper.getString(\"this.title\"));" + '\n');
            } else {
                this.out.append(this.tab + "this.setUITitle(\"" + this.getCurrentModel().getTitle() + "\");" + '\n');
            }
            int n = this.model.getDataObjects().size();
            for (int i2 = 0; i2 < n; ++i2) {
                DataObjectInfo dInfo = this.model.getDataObjects().get(i2);
                String doObjectType = dInfo.getObjectType();
                if (!MetaDataTypeList.UNIONQUERY.toString().equals(doObjectType) && !MetaDataTypeList.JOINQUERY.toString().equals(doObjectType)) continue;
                this.out.append(this.tab + dInfo.getName() + "PK = new MetaDataPK(\"" + this.getPackageName(dInfo.getType()) + "\",\"" + this.getClassName(dInfo.getType()) + "\")" + ';' + '\n');
            }
            boolean needTempStr = true;
            int n2 = this.model.getActions().size();
            for (int i3 = 0; i3 < n2; ++i3) {
                ActionInfo aInfo = this.model.getActions().get(i3);
                if (aInfo.isHerited() && !aInfo.isOverride()) continue;
                this.out.append(this.tab + "// " + aInfo.getName() + '\n');
                if (!aInfo.isHerited()) {
                    this.out.append(this.tab + "this." + aInfo.getName() + " = new " + aInfo.getClassName() + "(this)" + ';' + '\n');
                } else {
                    String actionName = aInfo.getName();
                    if (needTempStr) {
                        this.out.append(this.tab + "String _tempStr = null;" + '\n');
                    }
                    this.out.append(this.tab + actionName + ".setEnabled(" + String.valueOf(aInfo.isEnabled()) + ");" + '\n');
                    this.out.append(this.tab + actionName + ".setDaemonRun(" + aInfo.isDaemonRun() + ");" + '\n');
                    this.writeActionProperty(aInfo, actionName, false);
                    needTempStr = false;
                }
                if (aInfo.isBindWorkFlow()) {
                    this.out.append(this.tab + "this." + aInfo.getName() + ".setBindWorkFlow(true);" + '\n');
                }
                this.writeActionInitExtendProperty(this.out, aInfo.getActionExtendProperty(), "this." + aInfo.getName());
            }
            int n3 = this.components.size();
            for (i = 0; i < n3; ++i) {
                ComponentInfo cInfo = this.components.get(i);
                if (cInfo.isHerited()) continue;
                String componentName = this.getComponentName(cInfo);
                if (cInfo == this.rootPanel || this.model.getParent() != null && (cInfo == this.menuBar || cInfo == this.toolBar)) continue;
                this.out.append(this.tab + componentName + " = new " + cInfo.getClassType() + "();" + '\n');
            }
            n3 = this.components.size();
            for (i = 0; i < n3; ++i) {
                ComponentInfo cInfo = this.components.get(i);
                if (cInfo.isHerited() || TBUTTONGROUP.equals(cInfo.getClassType())) continue;
                String componentName = this.getComponentName(cInfo);
                this.out.append(this.tab + componentName + ".setName(\"" + cInfo.getName() + "\");" + '\n');
            }
            int m = this.components.size();
            for (int i4 = 0; i4 < m; ++i4) {
                EventBindingCollection ebInfos;
                String listenerType;
                ComponentInfo table;
                int j;
                ComponentInfo cInfo = this.components.get(i4);
                String componentName = this.getComponentName(cInfo);
                if (cInfo.isHerited()) {
                    if (cInfo == this.rootPanel) {
                        this.out.append(this.tab + "// " + cInfo.getName() + '\n');
                    }
                } else {
                    this.out.append(this.tab + "// " + cInfo.getName() + '\n');
                }
                int n4 = cInfo.getProperties().size();
                for (j = 0; j < n4; ++j) {
                    PropertyInfo pInfo = cInfo.getProperties().get(j);
                    if (cInfo.isHerited() && !pInfo.isOverride() || !pInfo.getName().equalsIgnoreCase("action")) continue;
                    this.out.append(this.tab + this.getExpression(cInfo, pInfo) + '\n');
                }
                n4 = cInfo.getProperties().size();
                for (j = 0; j < n4; ++j) {
                    PropertyInfo pInfo = cInfo.getProperties().get(j);
                    if (pInfo.getName().equalsIgnoreCase("action") || pInfo.getName().equalsIgnoreCase("ButtonGroup")) continue;
                    if (cInfo.getClassType().equalsIgnoreCase(KDTABLE) && pInfo.getName().equalsIgnoreCase("formatXML")) {
                        if (pInfo.getValue() != null && !pInfo.getValue().equals("")) {
                            this.headerList.put(cInfo.getName(), KDTableDesignerHelper.getTableInfoFrom(pInfo.getValue()).getColumnNameList());
                        }
                    } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox") && pInfo.getName().equalsIgnoreCase("_multiLangItem")) continue;
                    if (cInfo.isHerited() && !pInfo.isOverride()) continue;
                    this.out.append(this.tab + this.getExpression(cInfo, pInfo) + '\n');
                }
                if (KDBIZPROMPTBOX.equalsIgnoreCase(cInfo.getClassType())) {
                    String bimUIType = null;
                    bimUIType = ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName());
                    if ("EditUI".equalsIgnoreCase(bimUIType)) {
                        String companyIDFieldName = null;
                        String ctrlUnitIDFieldName = null;
                        String f7QueryPK = null;
                        PropertyInfo queryPKProp = cInfo.getPropertyByName("queryInfo");
                        if (queryPKProp != null) {
                            f7QueryPK = queryPKProp.getValue();
                        }
                        if (!StringUtils.isEmpty(f7QueryPK)) {
                            block59: {
                                try {
                                    JoinQueryInfo queryInfo = new JoinQueryCtrl(ContextManager.getContext()).getValue(new MetaDataPK(f7QueryPK));
                                    if (queryInfo == null) break block59;
                                    SubObjectCollection subObjs = queryInfo.getSubObjects();
                                    int n1 = subObjs.size();
                                    for (int i1 = 0; i1 < n1; ++i1) {
                                        SubObjectInfo subObj = subObjs.get(i1);
                                        if (!(subObj instanceof SubEntityInfo)) continue;
                                        if (((SubEntityInfo)subObj).getEntityRef().getFullName().equalsIgnoreCase("com.kingdee.eas.basedata.org.app.CompanyOrgUnit")) {
                                            companyIDFieldName = ((SubEntityInfo)subObj).getName() + ".id";
                                            if (StringUtils.isEmpty(ctrlUnitIDFieldName)) continue;
                                        } else {
                                            if (!((SubEntityInfo)subObj).getEntityRef().getFullName().equalsIgnoreCase("com.kingdee.eas.basedata.org.app.CtrlUnit")) continue;
                                            ctrlUnitIDFieldName = ((SubEntityInfo)subObj).getName() + ".id";
                                            if (StringUtils.isEmpty((String)companyIDFieldName)) {
                                                continue;
                                            }
                                        }
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    logger.error((Object)"error", (Throwable)e);
                                }
                            }
                            if (!StringUtils.isEmpty(companyIDFieldName) || !StringUtils.isEmpty(ctrlUnitIDFieldName)) {
                                this.out.append(this.tab + "EntityViewInfo evi" + cInfo.getName() + " = new EntityViewInfo ();" + '\n');
                                this.out.append(this.tab + "com.kingdee.bos.metadata.entity.FilterInfo filter" + cInfo.getName() + " = new com.kingdee.bos.metadata.entity.FilterInfo();" + '\n');
                                if (!StringUtils.isEmpty((String)companyIDFieldName)) {
                                    this.out.append(this.tab + "if (com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentFIUnit() != null) " + '\n');
                                    this.out.append(this.tab + "\tfilter" + cInfo.getName() + ".getFilterItems().add(new FilterItemInfo(\"" + companyIDFieldName + "\",com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentFIUnit().getString(\"id\")));" + '\n');
                                } else if (!StringUtils.isEmpty(ctrlUnitIDFieldName)) {
                                    this.out.append(this.tab + "if (com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentCtrlUnit() != null) " + '\n');
                                    this.out.append(this.tab + "\tfilter" + cInfo.getName() + ".getFilterItems().add(new FilterItemInfo(\"" + ctrlUnitIDFieldName + "\",com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentCtrlUnit().getString(\"id\")));" + '\n');
                                }
                                this.out.append(this.tab + "evi" + cInfo.getName() + ".setFilter(filter" + cInfo.getName() + ");" + '\n');
                                this.out.append(this.tab + this.getComponentName(cInfo) + ".setEntityViewInfo(evi" + cInfo.getName() + ");" + '\n');
                            }
                        }
                    }
                }
                RuleCollection rules = cInfo.getRules();
                boolean hasWriteCallInitialFunction = false;
                boolean hasAddChangeEventListener = false;
                ComponentInfo control = cInfo;
                String controlName = cInfo.getName();
                if (!StringUtils.isEmpty((String)cInfo.getExtendedProperty(cInfo.getBimUIObjectPK())) && (table = this.getEntryTable(new MetaDataPK(cInfo.getBimUIObjectPK()))) != null) {
                    control = table;
                    controlName = controlName + "_" + table.getName();
                    rules = table.getRules();
                }
                if (rules != null && rules.size() > 0 && "EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName()))) {
                    int n5 = rules.size();
                    for (int j2 = 0; j2 < n5; ++j2) {
                        if (!(rules.get(j2) instanceof ConditionRuleInfo)) continue;
                        ConditionRuleInfo conditionRule = (ConditionRuleInfo)rules.get(j2);
                        if (!hasWriteCallInitialFunction && conditionRule.getEventType() == EventType.INITIAL) {
                            this.out.append(this.tab + controlName + "_Initialize();" + '\n');
                            hasWriteCallInitialFunction = true;
                        }
                        if (hasAddChangeEventListener || conditionRule.getEventType() != EventType.CHANGE) continue;
                        String temp = RuleJCodeWriter.getAddDataChangedListenerCode(control, "getTable(" + cInfo.getName() + ")", controlName + "_Changed");
                        if (!StringUtils.isEmpty((String)temp)) {
                            this.out.append(this.tab + temp + '\n');
                        }
                        hasAddChangeEventListener = true;
                    }
                }
                Hashtable<String, EventBindingCollection> adapterMap = new Hashtable<String, EventBindingCollection>();
                int n6 = cInfo.getEventBindings().size();
                for (int j3 = 0; j3 < n6; ++j3) {
                    EventBindingInfo ebInfo = cInfo.getEventBindings().get(j3);
                    listenerType = ebInfo.getListenerType();
                    listenerType = listenerType.substring(listenerType.lastIndexOf(".") + 1);
                    String adapterType = ebInfo.getListenerAdapter();
                    if (adapterType.indexOf("Adapter") >= 0) {
                        if (adapterMap.containsKey(adapterType)) {
                            ebInfos = (EventBindingCollection)adapterMap.get(adapterType);
                        } else {
                            ebInfos = new EventBindingCollection();
                            adapterMap.put(adapterType, ebInfos);
                        }
                        ebInfos.add(ebInfo);
                        continue;
                    }
                    if (ebInfo.isHerited() || cInfo.isHerited() && !ebInfo.isWriteCode()) continue;
                    this.out.append(this.tab + componentName + ".add" + listenerType + "(new " + ebInfo.getListenerAdapter() + "() {" + '\n');
                    this.tabAdd();
                    this.out.append(this.tab + "public void " + ebInfo.getEventName() + "(" + ebInfo.getEventType() + " e) {" + '\n');
                    this.tabAdd();
                    String eventType = ebInfo.getEventType();
                    if (eventType.indexOf(".") >= 0) {
                        eventType = eventType.substring(eventType.lastIndexOf(".") + 1);
                    }
                    if (eventType.equalsIgnoreCase("ActionEvent")) {
                        this.out.append(this.tab + "beforeActionPerformed(e);" + '\n');
                    }
                    this.out.append(this.tab + "try {" + '\n');
                    this.tabAdd();
                    this.out.append(this.tab + ebInfo.getMethodName() + "(e);" + '\n');
                    this.tabSub();
                    this.writeEnd();
                    this.out.append(this.tab + "catch (Exception exc) {" + '\n');
                    this.tabAdd();
                    this.out.append(this.tab + "handUIException(exc);" + '\n');
                    this.tabSub();
                    this.writeEnd();
                    this.out.append(this.tab + "finally {" + '\n');
                    this.tabAdd();
                    if (eventType.equalsIgnoreCase("ActionEvent")) {
                        this.out.append(this.tab + "afterActionPerformed(e);" + '\n');
                    }
                    this.tabSub();
                    this.writeEnd();
                    this.tabSub();
                    this.out.append(this.tab + "}" + '\n');
                    this.tabSub();
                    this.out.append(this.tab + "});" + '\n');
                }
                for (Object key : adapterMap.keySet()) {
                    ebInfos = (EventBindingCollection)adapterMap.get(key);
                    listenerType = ebInfos.get(0).getListenerType();
                    listenerType = listenerType.substring(listenerType.lastIndexOf(".") + 1);
                    this.out.append(this.tab + componentName + ".add" + listenerType + "(new " + ebInfos.get(0).getListenerAdapter() + "() {" + '\n');
                    int n7 = ebInfos.size();
                    for (int j4 = 0; j4 < n7; ++j4) {
                        EventBindingInfo ebInfo = ebInfos.get(j4);
                        if (cInfo.isHerited() && ebInfo.isHerited()) continue;
                        this.out.append(this.tab + "\tpublic void " + ebInfo.getEventName() + "(" + ebInfo.getEventType() + " e) {" + '\n');
                        this.out.append(this.tab + "\t\ttry{" + '\n');
                        this.out.append(this.tab + "\t\t\t" + ebInfo.getMethodName() + "(e);" + '\n');
                        this.out.append(this.tab + "\t\t} catch(Exception exc) {" + '\n');
                        this.out.append(this.tab + "\t\t\thandUIException(exc);" + '\n');
                        this.out.append(this.tab + "\t\t}" + '\n');
                        this.out.append(this.tab + "\t}" + '\n');
                    }
                    this.out.append(this.tab + "});" + '\n');
                }
                if (cInfo.getClassType().equalsIgnoreCase(KDTABLE)) {
                    if (this.bindCloneQuery(cInfo) == null) {
                        this.out.append(this.getBindTableString(cInfo, true, false, true));
                        String sWriteForBim = this.writeKDTableStyleForBIM(cInfo);
                        if (!StringUtils.isEmpty((String)sWriteForBim)) {
                            this.out.append(sWriteForBim);
                        }
                    } else {
                        this.out.append(this.getBindTableString(cInfo, true, true, true));
                        String sWriteForBim = this.writeKDTableStyleForBIM(cInfo);
                        if (!StringUtils.isEmpty((String)sWriteForBim)) {
                            this.out.append(sWriteForBim);
                        }
                        if (!cInfo.isHerited()) {
                            listenerType = "RequestRowSetListener";
                            this.out.append(this.tab + componentName + ".add" + listenerType + "(new " + listenerType + "() {" + '\n');
                            this.out.append(this.tab + "\tpublic void doRequestRowSet(" + StringUtils.replace((String)listenerType, (String)"Listener", (String)"") + "Event e) {" + '\n');
                            this.out.append(this.tab + "\t\t" + cInfo.getName() + "_doRequestRowSet(e);" + '\n');
                            this.out.append(this.tab + "\t}" + '\n');
                            this.out.append(this.tab + "});" + '\n');
                        }
                    }
                }
                if (!cInfo.getClassType().equals(TBUTTONGROUP)) continue;
                int m1 = this.components.size();
                block16: for (int i1 = 0; i1 < m1; ++i1) {
                    ComponentInfo cInfo1 = this.components.get(i1);
                    int n1 = cInfo1.getProperties().size();
                    for (int j1 = 0; j1 < n1; ++j1) {
                        PropertyInfo pInfo1 = cInfo1.getProperties().get(j1);
                        if (!pInfo1.getName().equalsIgnoreCase("ButtonGroup") || !componentName.endsWith(pInfo1.getValue())) continue;
                        this.out.append(this.tab + componentName + ".add(" + this.getComponentName(cInfo1) + ");" + '\n');
                        continue block16;
                    }
                }
            }
            ComponentCollection sortedComponents = this.model.getOrderedComponents();
            String componentNames = "";
            if (sortedComponents != null && !sortedComponents.isEmpty()) {
                int n8 = sortedComponents.size();
                for (int i5 = 0; i5 < n8; ++i5) {
                    ComponentInfo cInfo = sortedComponents.get(i5);
                    componentNames = i5 == 0 ? componentNames + cInfo.getName() : componentNames + "," + cInfo.getName();
                }
                this.out.append(this.tab + "this.setFocusTraversalPolicy(new com.kingdee.bos.ui.UIFocusTraversalPolicy(new java.awt.Component[] {" + componentNames + "}));" + '\n');
                this.out.append(this.tab + "this.setFocusCycleRoot(true);" + '\n');
                this.firstFocusControlName = sortedComponents.get(0).getName();
            }
            this.tabSub();
            this.writeEnd();
            this.writeInitUIContentLayout();
            this.writeInitUIMenuBarLayout();
            this.writeInitUIToolBarLayout();
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private String getColumnBindQueryPK(ComponentInfo cInfo, String columnName) {
        if (StringUtils.isEmpty((String)columnName) || !this.headerList.containsKey(cInfo.getName())) {
            return null;
        }
        String[] columns = (String[])this.headerList.get(cInfo.getName());
        String bindObjectName = "";
        String tableColumnName = "";
        String sQueryPK = null;
        boolean hasFoundBindingField = false;
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            bindObjectName = pbInfo.getBindingObject();
            String sbindField = pbInfo.getBingdingField();
            int m = this.model.getDataObjects().size();
            for (int i = 0; i < m; ++i) {
                RelationshipInfo relationShip;
                EntityObjectInfo supplyEntityInfo;
                EntityObjectInfo entity;
                com.kingdee.bos.metadata.entity.PropertyInfo prop;
                IObjectValue objectValue;
                if (!this.model.getDataObjects().get(i).getName().equals(bindObjectName) || (objectValue = this.model.getDataObjects().get(i).getInstance()) == null || !(objectValue instanceof EntityObjectInfo) || (prop = this.getPropertyByName(entity = (EntityObjectInfo)objectValue, sbindField)) == null || !(prop instanceof LinkPropertyInfo) || (supplyEntityInfo = (relationShip = ((LinkPropertyInfo)prop).getRelationship()).getSupplierObject()) == null || StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) continue;
                return sQueryPK;
            }
        }
        return null;
    }

    private com.kingdee.bos.metadata.entity.PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n && (prop = subEntity.getPropertyByName(propertys[i], true)) != null && prop instanceof LinkPropertyInfo; ++i) {
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            prop = null;
            break;
        }
        return prop;
    }

    private com.kingdee.bos.metadata.entity.PropertyInfo getColumnBindProperty(ComponentInfo cInfo, String columnName) {
        if (StringUtils.isEmpty((String)columnName) || !this.headerList.containsKey(cInfo.getName())) {
            return null;
        }
        String[] columns = (String[])this.headerList.get(cInfo.getName());
        String bindObjectName = "";
        String tableColumnName = "";
        boolean hasFoundBindingField = false;
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            bindObjectName = pbInfo.getBindingObject();
            String sbindField = pbInfo.getBingdingField();
            int m = this.model.getDataObjects().size();
            for (int i = 0; i < m; ++i) {
                IObjectValue objectValue;
                if (!this.model.getDataObjects().get(i).getName().equals(bindObjectName) || (objectValue = this.model.getDataObjects().get(i).getInstance()) == null || !(objectValue instanceof EntityObjectInfo)) continue;
                EntityObjectInfo entity = (EntityObjectInfo)objectValue;
                return this.getPropertyByName(entity, sbindField);
            }
        }
        return null;
    }

    private String writeKDTableStyleForBIM(ComponentInfo cInfo) {
        String sOut = "";
        String sBimUIType = "";
        sBimUIType = ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName());
        if ("EditUI".equalsIgnoreCase(sBimUIType) || "ListUI".equalsIgnoreCase(sBimUIType) || "EntryUI".equalsIgnoreCase(sBimUIType)) {
            this.out.append(this.tab + this.getComponentName(cInfo) + ".checkParsed();" + '\n');
            if ("EditUI".equalsIgnoreCase(sBimUIType) || "EntryUI".equalsIgnoreCase(sBimUIType)) {
                String columnName = "";
                String[] columns = null;
                if (this.headerList.containsKey(cInfo.getName()) && this.headerList.get(cInfo.getName()) != null) {
                    columns = (String[])this.headerList.get(cInfo.getName());
                    int n = columns.length;
                    for (int i = 0; i < n; ++i) {
                        String f7QueryPK = this.getColumnBindQueryPK(cInfo, columns[i]);
                        String preFixName = cInfo.getName() + "_" + columns[i];
                        String companyIDFieldName = null;
                        String ctrlUnitIDFieldName = null;
                        if (!StringUtils.isEmpty((String)f7QueryPK)) {
                            block33: {
                                try {
                                    JoinQueryInfo queryInfo = new JoinQueryCtrl(ContextManager.getContext()).getValue(new MetaDataPK(f7QueryPK));
                                    if (queryInfo == null) break block33;
                                    SubObjectCollection subObjs = queryInfo.getSubObjects();
                                    int m = subObjs.size();
                                    for (int j = 0; j < m; ++j) {
                                        SubObjectInfo subObj = subObjs.get(j);
                                        if (!(subObj instanceof SubEntityInfo)) continue;
                                        if (((SubEntityInfo)subObj).getEntityRef().getFullName().equalsIgnoreCase("com.kingdee.eas.basedata.org.app.CompanyOrgUnit")) {
                                            companyIDFieldName = ((SubEntityInfo)subObj).getName() + ".id";
                                            if (StringUtils.isEmpty(ctrlUnitIDFieldName)) continue;
                                        } else {
                                            if (!((SubEntityInfo)subObj).getEntityRef().getFullName().equalsIgnoreCase("com.kingdee.eas.basedata.org.app.CtrlUnit")) continue;
                                            ctrlUnitIDFieldName = ((SubEntityInfo)subObj).getName() + ".id";
                                            if (StringUtils.isEmpty((String)companyIDFieldName)) {
                                                continue;
                                            }
                                        }
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    logger.error((Object)"error", (Throwable)e);
                                }
                            }
                            this.out.append(this.tab + "KDBizPromptBox " + preFixName + "_PromptBox = new KDBizPromptBox();" + '\n');
                            this.out.append(this.tab + preFixName + "_PromptBox.setQueryInfo(\"" + f7QueryPK + "\");" + '\n');
                            this.out.append(this.tab + preFixName + "_PromptBox.setVisible(true);" + '\n');
                            this.out.append(this.tab + preFixName + "_PromptBox.setEditable(true);" + '\n');
                            this.out.append(this.tab + preFixName + "_PromptBox.setDisplayFormat(\"$name$\");" + '\n');
                            this.out.append(this.tab + preFixName + "_PromptBox.setEditFormat(\"$number$\");" + '\n');
                            this.out.append(this.tab + preFixName + "_PromptBox.setCommitFormat(\"$number$\");" + '\n');
                            this.out.append(this.tab + "KDTDefaultCellEditor " + preFixName + "_CellEditor = new KDTDefaultCellEditor(" + preFixName + "_PromptBox);" + '\n');
                            this.out.append(this.tab + this.getComponentName(cInfo) + ".getColumn(\"" + columns[i] + "\").setEditor(" + preFixName + "_CellEditor);" + '\n');
                            this.out.append(this.tab + "ObjectValueRender " + preFixName + "_OVR = new ObjectValueRender();" + '\n');
                            this.out.append(this.tab + preFixName + "_OVR.setFormat(new BizDataFormat(\"$name$\"));" + '\n');
                            this.out.append(this.tab + this.getComponentName(cInfo) + ".getColumn(\"" + columns[i] + "\").setRenderer(" + preFixName + "_OVR);" + '\n');
                            if (StringUtils.isEmpty((String)companyIDFieldName) && StringUtils.isEmpty((String)ctrlUnitIDFieldName)) continue;
                            this.out.append(this.tab + "EntityViewInfo evi" + preFixName + " = new EntityViewInfo ();" + '\n');
                            this.out.append(this.tab + "com.kingdee.bos.metadata.entity.FilterInfo filter" + preFixName + " = new com.kingdee.bos.metadata.entity.FilterInfo();" + '\n');
                            if (!StringUtils.isEmpty((String)companyIDFieldName)) {
                                this.out.append(this.tab + "if (com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentFIUnit() != null) " + '\n');
                                this.out.append(this.tab + "\tfilter" + preFixName + ".getFilterItems().add(new FilterItemInfo(\"" + companyIDFieldName + "\",com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentFIUnit().getString(\"id\")));" + '\n');
                            } else if (!StringUtils.isEmpty((String)ctrlUnitIDFieldName)) {
                                this.out.append(this.tab + "if (com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentCtrlUnit() != null) " + '\n');
                                this.out.append(this.tab + "\tfilter" + preFixName + ".getFilterItems().add(new FilterItemInfo(\"" + ctrlUnitIDFieldName + "\",com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentCtrlUnit().getString(\"id\")));" + '\n');
                            }
                            this.out.append(this.tab + "evi" + preFixName + ".setFilter(filter" + preFixName + ");" + '\n');
                            this.out.append(this.tab + preFixName + "_PromptBox.setEntityViewInfo(evi" + preFixName + ");" + '\n');
                            continue;
                        }
                        com.kingdee.bos.metadata.entity.PropertyInfo prop = this.getColumnBindProperty(cInfo, columns[i]);
                        if (prop == null || prop.getMappingField() == null || prop.getMappingField().getTypeName() == null) continue;
                        if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).getDataType() == DataType.ENUM) {
                            BizEnumInfo enumInfo = ((OwnPropertyInfo)prop).getEnumType();
                            if (enumInfo == null) continue;
                            this.out.append(this.tab + "KDComboBox " + preFixName + "_ComboBox = new KDComboBox();" + '\n');
                            this.out.append(this.tab + preFixName + "_ComboBox.setName(\"" + preFixName + "_ComboBox\");" + '\n');
                            this.out.append(this.tab + preFixName + "_ComboBox.setVisible(true);" + '\n');
                            this.out.append(this.tab + preFixName + "_ComboBox.addItems(EnumUtils.getEnumList(\"" + enumInfo.getClassName() + "\").toArray());" + '\n');
                            this.out.append(this.tab + "KDTDefaultCellEditor " + preFixName + "_CellEditor = new KDTDefaultCellEditor(" + preFixName + "_ComboBox);" + '\n');
                            this.out.append(this.tab + this.getComponentName(cInfo) + ".getColumn(\"" + columns[i] + "\").setEditor(" + preFixName + "_CellEditor);" + '\n');
                            continue;
                        }
                        if (prop.getMappingField().getTypeName().equals(SQLType.DATETIME)) {
                            this.out.append(this.tab + "KDDatePicker " + preFixName + "_DatePicker = new KDDatePicker();" + '\n');
                            this.out.append(this.tab + preFixName + "_DatePicker.setName(\"" + preFixName + "_DatePicker\");" + '\n');
                            this.out.append(this.tab + preFixName + "_DatePicker.setVisible(true);" + '\n');
                            this.out.append(this.tab + preFixName + "_DatePicker.setEditable(true);" + '\n');
                            this.out.append(this.tab + "KDTDefaultCellEditor " + preFixName + "_CellEditor = new KDTDefaultCellEditor(" + preFixName + "_DatePicker);" + '\n');
                            this.out.append(this.tab + this.getComponentName(cInfo) + ".getColumn(\"" + columns[i] + "\").setEditor(" + preFixName + "_CellEditor);" + '\n');
                            continue;
                        }
                        if (prop.getMappingField().getTypeName().equals(SQLType.NVARCHAR)) {
                            this.out.append(this.tab + "KDTextField " + preFixName + "_TextField = new KDTextField();" + '\n');
                            this.out.append(this.tab + preFixName + "_TextField.setName(\"" + preFixName + "_TextField\");" + '\n');
                            this.out.append(this.tab + preFixName + "_TextField.setMaxLength(" + prop.getMappingField().getLength() + ");" + '\n');
                            this.out.append(this.tab + "KDTDefaultCellEditor " + preFixName + "_CellEditor = new KDTDefaultCellEditor(" + preFixName + "_TextField);" + '\n');
                            this.out.append(this.tab + this.getComponentName(cInfo) + ".getColumn(\"" + columns[i] + "\").setEditor(" + preFixName + "_CellEditor);" + '\n');
                            continue;
                        }
                        if (prop instanceof OwnPropertyInfo && DataType.BOOLEAN.equals(((OwnPropertyInfo)prop).getDataType())) {
                            this.out.append(this.tab + "KDCheckBox " + preFixName + "_CheckBox = new KDCheckBox();" + '\n');
                            this.out.append(this.tab + preFixName + "_CheckBox.setName(\"" + preFixName + "_CheckBox\");" + '\n');
                            this.out.append(this.tab + "KDTDefaultCellEditor " + preFixName + "_CellEditor = new KDTDefaultCellEditor(" + preFixName + "_CheckBox);" + '\n');
                            this.out.append(this.tab + this.getComponentName(cInfo) + ".getColumn(\"" + columns[i] + "\").setEditor(" + preFixName + "_CellEditor);" + '\n');
                            continue;
                        }
                        if (!prop.getMappingField().getTypeName().equals(SQLType.INT) && !prop.getMappingField().getTypeName().equals(SQLType.NUMERIC)) continue;
                        this.out.append(this.tab + "KDFormattedTextField " + preFixName + "_TextField = new KDFormattedTextField();" + '\n');
                        this.out.append(this.tab + preFixName + "_TextField.setName(\"" + preFixName + "_TextField\");" + '\n');
                        this.out.append(this.tab + preFixName + "_TextField.setVisible(true);" + '\n');
                        this.out.append(this.tab + preFixName + "_TextField.setEditable(true);" + '\n');
                        this.out.append(this.tab + preFixName + "_TextField.setHorizontalAlignment(2);" + '\n');
                        if (prop.getMappingField().getTypeName().equals(SQLType.INT)) {
                            this.out.append(this.tab + preFixName + "_TextField.setDataType(0);" + '\n');
                        } else {
                            this.out.append(this.tab + preFixName + "_TextField.setDataType(1);" + '\n');
                            this.out.append(this.tab + preFixName + "_TextField.setPrecision(10);" + '\n');
                        }
                        this.out.append(this.tab + "KDTDefaultCellEditor " + preFixName + "_CellEditor = new KDTDefaultCellEditor(" + preFixName + "_TextField);" + '\n');
                        this.out.append(this.tab + this.getComponentName(cInfo) + ".getColumn(\"" + columns[i] + "\").setEditor(" + preFixName + "_CellEditor);" + '\n');
                    }
                }
            }
            if ("ListUI".equalsIgnoreCase(sBimUIType)) {
                String componentName;
                String bindString = "";
                String bindObjectName = "";
                String bindFieldName = "";
                String[] columns = null;
                String[] bindItems = null;
                this.out.append(this.tab + this.getComponentName(cInfo) + ".getGroupManager().setGroup(true);" + '\n');
                if (this.headerList.containsKey(cInfo.getName()) && this.headerList.get(cInfo.getName()) != null) {
                    columns = (String[])this.headerList.get(cInfo.getName());
                    bindItems = new String[columns.length];
                    int n = bindItems.length;
                    for (int j = 0; j < n; ++j) {
                        bindItems[j] = null;
                    }
                }
                boolean hasFoundBindingField = false;
                int n = cInfo.getPropertyBindings().size();
                block7: for (int j = 0; j < n; ++j) {
                    PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
                    if (columns == null || pbInfo.getPropertyName().indexOf(".text") < 0) continue;
                    String columnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
                    if (bindObjectName.equals("")) {
                        bindObjectName = pbInfo.getBindingObject();
                    }
                    int m1 = columns.length;
                    for (int i1 = 0; i1 < m1; ++i1) {
                        if (!columnName.equalsIgnoreCase(columns[i1])) continue;
                        bindItems[i1] = pbInfo.getBingdingField();
                        continue block7;
                    }
                }
                HashMap mergePropMap = new HashMap();
                int m = this.model.getDataObjects().size();
                for (int i = 0; i < m; ++i) {
                    if (!this.model.getDataObjects().get(i).getName().equals(bindObjectName)) continue;
                    IObjectValue objectValue = this.model.getDataObjects().get(i).getInstanceOfQueryForBim();
                    if (objectValue == null || !(objectValue instanceof JoinQueryInfo)) break;
                    JoinQueryInfo joinQuery = (JoinQueryInfo)objectValue;
                    try {
                        SubObjectInfo subObject = joinQuery.getMainObject();
                        EntityObjectInfo mainEntity = null;
                        if (subObject instanceof SubEntityInfo) {
                            mainEntity = ((SubEntityInfo)subObject).getEntityRef();
                        }
                        QueryFieldCollection fields = joinQuery.getUnits().getQueryFields();
                        QueryFieldInfo field = null;
                        int n2 = bindItems.length;
                        for (int j = 0; j < n2; ++j) {
                            if (!fields.contains(bindItems[j])) continue;
                            field = fields.get(bindItems[j]);
                            EntityObjectInfo refEntity = field.getPropertyRefs().get(0).getSubEntity().getEntityRef();
                            com.kingdee.bos.metadata.entity.PropertyInfo prop = field.getPropertyRefs().get(0).getRefProperty();
                            if (mainEntity == null) continue;
                        }
                        break;
                    }
                    catch (BOSException e) {
                        logger.error((Object)"error", (Throwable)e);
                        break;
                    }
                }
                if (!StringUtils.isEmpty((String)(componentName = this.getComponentName(cInfo)))) {
                    int n3 = bindItems.length;
                    for (int j = 0; j < n3; ++j) {
                        String sArray = "";
                        String sFieldName = "";
                        if (StringUtils.isEmpty((String)bindItems[j]) || bindItems[j].indexOf(".") <= 0) continue;
                        sFieldName = bindItems[j].substring(0, bindItems[j].indexOf("."));
                    }
                }
            }
        }
        return sOut;
    }

    private static String getNumberFormat(int precision) {
        String format = "%r{0.";
        for (int i = 0; i < precision; ++i) {
            format = format + "0";
        }
        format = format + "}f";
        return format;
    }

    private boolean isAssociationIntoEntity(EntityObjectInfo leftEntity, EntityObjectInfo rightEntity, com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        PropertyCollection allProps = leftEntity.getInheritedNoDuplicatedProperties();
        int n = allProps.size();
        for (int i = 0; i < n; ++i) {
            LinkPropertyInfo lnk;
            EntityObjectInfo lnkEntity;
            if (!(allProps.get(i) instanceof LinkPropertyInfo) || (lnkEntity = (lnk = (LinkPropertyInfo)allProps.get(i)).getRelationship().getSupplierObject()) != null && lnkEntity.equals(leftEntity)) continue;
            com.kingdee.bos.metadata.entity.PropertyInfo lnkProp = lnk.getRelationship().getSupplierProperty();
            if (lnkEntity != null && lnkEntity.equals(rightEntity) && lnkProp != null && lnkProp.equals(prop)) {
                return !lnk.getRelationship().isMultiRelation();
            }
            if (!this.isAssociationIntoEntity(lnkEntity, rightEntity, prop)) continue;
            return true;
        }
        return false;
    }

    private void writeChangeRuleCode(ComponentInfo cInfo) {
        String componentName = this.getComponentName(cInfo);
        EventBindingInfo ebInfo = EventInfoHelper.getInstance().getChangeEventInfo(cInfo.getClassType());
        if (ebInfo != null) {
            String listenerType = ebInfo.getListenerType();
            listenerType = listenerType.substring(listenerType.lastIndexOf(".") + 1);
            String adapterType = ebInfo.getListenerAdapter();
            this.out.append(this.tab + componentName + ".add" + listenerType + "(new " + ebInfo.getListenerAdapter() + "() {" + '\n');
            this.tabAdd();
            this.out.append(this.tab + "public void " + ebInfo.getEventName() + "(" + ebInfo.getEventType() + " e) {" + '\n');
            this.tabAdd();
            String eventType = ebInfo.getEventType();
            if (eventType.indexOf(".") >= 0) {
                eventType = eventType.substring(eventType.lastIndexOf(".") + 1);
            }
            this.out.append(this.tab + "try {" + '\n');
            this.tabAdd();
            this.out.append(this.tab + cInfo.getName() + "_Changed();" + '\n');
            this.tabSub();
            this.writeEnd();
            this.out.append(this.tab + "catch (Exception exc) {" + '\n');
            this.tabAdd();
            this.out.append(this.tab + "handUIException(exc);" + '\n');
            this.tabSub();
            this.writeEnd();
            this.tabSub();
            this.out.append(this.tab + "}" + '\n');
            this.tabSub();
            this.out.append(this.tab + "});" + '\n');
        }
    }

    private void writeOnShowFunction() {
        if (StringUtils.isEmpty((String)this.firstFocusControlName)) {
            return;
        }
        this.out.append('\n');
        this.out.append(this.writeNote("output onShow method", new String[0], ""));
        this.out.append(this.tab + "public void onShow() throws Exception" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super.onShow();" + '\n');
        this.out.append(this.tab + "this." + this.firstFocusControlName + ".requestFocusInWindow();" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeInitUIContentLayout() {
        this.out.append('\n');
        this.out.append(this.writeNote("output initUIContentLayout method", new String[0], ""));
        this.out.append(this.tab + "public void initUIContentLayout" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        UICodeWriterHelper.getInstance().generateInitUIContentLayoutCode(this.out, this.model, this.tab);
        if ("EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.out.append(this.tab + "initUIDetailLayout();" + '\n');
        }
        this.tabSub();
        this.writeEnd();
    }

    private void writeInitUIMenuBarLayout() {
        this.out.append('\n');
        this.out.append(this.writeNote("output initUIMenuBarLayout method", new String[0], ""));
        this.out.append(this.tab + "public void initUIMenuBarLayout" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        UICodeWriterHelper.getInstance().generateInitUIMenuBarLayoutCode(this.out, this.model, this.tab);
        this.tabSub();
        this.writeEnd();
    }

    private void writeInitUIToolBarLayout() {
        this.out.append('\n');
        this.out.append(this.writeNote("output initUIToolBarLayout method", new String[0], ""));
        this.out.append(this.tab + "public void initUIToolBarLayout" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        UICodeWriterHelper.getInstance().generateInitUIToolBarLayoutCode(this.out, this.model, this.tab);
        this.tabSub();
        this.writeEnd();
    }

    private void writeSetDataFunction() {
        DataObjectInfo dInfo;
        this.out.append('\n');
        this.out.append(this.writeNote("output setDataObject method", new String[0], ""));
        this.out.append(this.tab + "public void setDataObject(IObjectValue dataObject)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super.setDataObject(dataObject);" + '\n');
        if (this.model.getDataObjects().size() > 0) {
            dInfo = this.model.getDataObjects().get(0);
            if (dInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) {
                IObjectValue objectValue = dInfo.getInstance();
                if (objectValue != null && objectValue instanceof EntityObjectInfo) {
                    this.out.append(this.tab + "this." + dInfo.getName() + " = (" + ((EntityObjectInfo)objectValue).getObjectValueClass() + ")dataObject;" + '\n');
                }
            } else if (!dInfo.isHerited() && (dInfo.getObjectType().equals(MetaDataTypeList.UNIONQUERY.toString()) || dInfo.getObjectType().equals(MetaDataTypeList.JOINQUERY.toString()))) {
                this.out.append(this.tab + "this." + dInfo.getName() + " = (EntityViewInfo)dataObject;" + '\n');
            }
        }
        this.tabSub();
        this.writeEnd();
        if (this.model.getDataObjects().size() > 1) {
            this.out.append('\n');
            this.out.append(this.writeNote("output setDataObject method", new String[0], ""));
            this.out.append(this.tab + "public void setDataObject(String key,IObjectValue dataObject)" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "super.setDataObject(key,dataObject);" + '\n');
            boolean isIfBegin = true;
            int n = this.model.getDataObjects().size();
            for (int i = 0; i < n; ++i) {
                dInfo = this.model.getDataObjects().get(i);
                if (dInfo.isHerited()) continue;
                if (isIfBegin) {
                    this.out.append(this.tab + "if (key.equalsIgnoreCase(\"" + dInfo.getName() + "\"))" + '\n');
                    isIfBegin = false;
                } else {
                    this.out.append(this.tab + "else if (key.equalsIgnoreCase(\"" + dInfo.getName() + "\"))" + '\n');
                }
                this.writeBegin();
                this.tabAdd();
                if (dInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) {
                    IObjectValue objectValue = dInfo.getInstance();
                    if (objectValue != null && objectValue instanceof EntityObjectInfo) {
                        this.out.append(this.tab + "this." + dInfo.getName() + " = (" + ((EntityObjectInfo)objectValue).getObjectValueClass() + ")dataObject;" + '\n');
                    }
                } else if (dInfo.getObjectType().equals(MetaDataTypeList.UNIONQUERY.toString()) || dInfo.getObjectType().equals(MetaDataTypeList.JOINQUERY.toString())) {
                    this.out.append(this.tab + "this." + dInfo.getName() + " = (EntityViewInfo)dataObject;" + '\n');
                }
                this.tabSub();
                this.writeEnd();
            }
            this.tabSub();
            this.writeEnd();
        }
    }

    private String getExpression(ComponentInfo cInfo, PropertyInfo pInfo) {
        String expr = "";
        String componentName = this.getComponentName(cInfo);
        if ("com.kingdee.bos.ctrl.swing.KDCurrencyTextField".equalsIgnoreCase(cInfo.getClassType())) {
            if ("value".equalsIgnoreCase(pInfo.getName())) {
                if (!StringUtils.isEmpty((String)pInfo.getValue())) {
                    expr = componentName + ".set" + this.upcastName(pInfo.getName()) + "(new java.math.BigDecimal(" + pInfo.getValue() + "));";
                }
                return expr;
            }
            if ("currency".equalsIgnoreCase(pInfo.getName())) {
                if (!StringUtils.isEmpty((String)pInfo.getValue())) {
                    expr = componentName + ".set" + this.upcastName(pInfo.getName()) + "(Currency.getInstance(\"" + pInfo.getValue() + "\"));";
                }
                return expr;
            }
        }
        if (pInfo.getName().equalsIgnoreCase("items") && ("com.kingdee.bos.ctrl.swing.KDList".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDComboBox".equalsIgnoreCase(cInfo.getClassType()))) {
            if (pInfo.getValue() != null && pInfo.getValue().startsWith("[Enum]")) {
                if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDList")) {
                    expr = componentName + ".setListData(EnumUtils.getEnumList(\"" + this.getEnumClass(pInfo.getValue().substring(6)) + "\").toArray());";
                } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDComboBox")) {
                    expr = componentName + ".addItems(EnumUtils.getEnumList(\"" + this.getEnumClass(pInfo.getValue().substring(6)) + "\").toArray());";
                }
            } else if (this.multiLanguage && pInfo.isMultiLanguage()) {
                if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDList")) {
                    expr = componentName + ".setListData(resHelper.getArray(\"" + StringUtils.replace((String)componentName, (String)"this.", (String)"") + "." + pInfo.getName() + "\"));";
                } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDComboBox")) {
                    expr = componentName + ".addItems(resHelper.getArray(\"" + StringUtils.replace((String)componentName, (String)"this.", (String)"") + "." + pInfo.getName() + "\"));";
                }
            } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDList")) {
                expr = componentName + ".setListData(" + this.getValueString(pInfo, cInfo.getName()) + ");";
            } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDComboBox")) {
                expr = componentName + ".addItems(" + this.getValueString(pInfo, cInfo.getName()) + ");";
            }
        } else {
            expr = this.multiLanguage && pInfo.isMultiLanguage() ? componentName + ".set" + this.upcastName(pInfo.getName()) + "(resHelper.get" + this.getMethodName(pInfo.getType()) + "(\"" + StringUtils.replace((String)componentName, (String)"this.", (String)"") + "." + pInfo.getName() + "\"));" : componentName + ".set" + this.upcastName(pInfo.getName()) + "(" + this.getValueString(pInfo, cInfo.getName()) + ");";
        }
        return expr;
    }

    private String getEnumClass(String metaPK) {
        try {
            IBizEnumCtrl enumCtrl = (IBizEnumCtrl)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.BIZENUM);
            return enumCtrl.getValue(new MetaDataPK(metaPK)).getClassName();
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            return "";
        }
    }

    private String getLoadExpression(ComponentInfo cInfo, PropertyBindingInfo pbInfo) {
        return this.getLoadExpression(cInfo, pbInfo, null);
    }

    private String getLoadExpression(ComponentInfo cInfo, PropertyBindingInfo pbInfo, String value) {
        String expr = "";
        String componentName = this.getComponentName(cInfo);
        String[] s = StringUtils.split((String)pbInfo.getBingdingField(), (String)".");
        String getFieldString = pbInfo.getBindingObject();
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                if (pbInfo.getFieldType().equals("boolean")) {
                    getFieldString = getFieldString + ".is" + this.upcastName(s[i]) + "()";
                    continue;
                }
                getFieldString = getFieldString + ".get" + this.upcastName(s[i]) + "()";
                continue;
            }
            getFieldString = getFieldString + ".get" + this.upcastName(s[i]) + "()";
        }
        if ("com.kingdee.bos.ctrl.swing.KDCurrencyTextField".equalsIgnoreCase(cInfo.getClassType()) && "value".equalsIgnoreCase(pbInfo.getPropertyName())) {
            if (!StringUtils.isEmpty((String)getFieldString)) {
                expr = componentName + ".set" + this.upcastName(pbInfo.getPropertyName()) + "(new java.math.BigDecimal(" + getFieldString + "));";
            }
            return expr;
        }
        expr = value == null ? (pbInfo.getPropertyName().equals("selectedValue") ? componentName + ".set" + this.upcastName(pbInfo.getPropertyName()) + "(" + this.convertType(getFieldString, pbInfo.getFieldType(), pbInfo.getPropertyType()) + ",true);" : componentName + ".set" + this.upcastName(pbInfo.getPropertyName()) + "(" + this.convertType(getFieldString, pbInfo.getFieldType(), pbInfo.getPropertyType()) + ");") : componentName + ".set" + this.upcastName(pbInfo.getPropertyName()) + "(" + value + ");";
        return expr;
    }

    private String getStoreExpression(ComponentInfo cInfo, PropertyBindingInfo pbInfo) {
        String expr = "";
        String componentName = this.getComponentName(cInfo);
        String[] s = StringUtils.split((String)pbInfo.getBingdingField(), (String)".");
        String getFieldString = pbInfo.getBindingObject();
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            getFieldString = i == n - 1 ? getFieldString + ".set" + this.upcastName(s[i]) + "(" : getFieldString + ".get" + this.upcastName(s[i]) + "()";
        }
        if (pbInfo.getPropertyType().equals("boolean")) {
            expr = getFieldString + this.convertType(componentName + ".is" + this.upcastName(pbInfo.getPropertyName()) + "()", pbInfo.getPropertyType(), pbInfo.getFieldType()) + ");";
        } else if ((cInfo.getClassType().equalsIgnoreCase(KDDATEPICKER) || cInfo.getClassType().equalsIgnoreCase(KDTIMEPICKER)) && pbInfo.getPropertyName().equals("value")) {
            expr = Date.class.getName().equals(pbInfo.getFieldType()) ? getFieldString + "com.kingdee.util.DateTimeUtils.truncateDate((java.util.Date)" + componentName + ".get" + this.upcastName(pbInfo.getPropertyName()) + "(java.util.Date.class)));" : getFieldString + "(" + pbInfo.getFieldType() + ")" + componentName + ".get" + this.upcastName(pbInfo.getPropertyName()) + "(" + pbInfo.getFieldType() + ".class));";
        } else if ((cInfo.getClassType().equalsIgnoreCase(KDFORMATTEDTEXTFIELD) || cInfo.getClassType().equalsIgnoreCase(KDNUMBERTEXTFIELD) || cInfo.getClassType().equalsIgnoreCase(KDSPINNER)) && pbInfo.getPropertyName().equals("value")) {
            String fieldType = pbInfo.getFieldType();
            String primitiveTypeExpression = ")." + pbInfo.getFieldType() + "Value()";
            if (pbInfo.getFieldType().equalsIgnoreCase("boolean")) {
                fieldType = "Boolean";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("char")) {
                fieldType = "Char";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("byte")) {
                fieldType = "Byte";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("short")) {
                fieldType = "Short";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("int")) {
                fieldType = "Integer";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("long")) {
                fieldType = "Long";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("float")) {
                fieldType = "Float";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("double")) {
                fieldType = "Double";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("BigDecimal")) {
                fieldType = "java.math.BigDecimal";
            } else {
                primitiveTypeExpression = "";
            }
            String fieldTypeExpression = primitiveTypeExpression.equals("") ? fieldType : "(" + fieldType;
            expr = getFieldString + "(" + fieldTypeExpression + ")" + componentName + ".get" + this.upcastName(pbInfo.getPropertyName()) + "(" + fieldType + ".class)" + primitiveTypeExpression + ");";
        } else {
            expr = getFieldString + this.convertType(componentName + ".get" + this.upcastName(pbInfo.getPropertyName()) + "()", pbInfo.getPropertyType(), pbInfo.getFieldType()) + ");";
        }
        return expr;
    }

    public String convertType(String srcValue, String srcType, String desType) {
        String desValue = "";
        desValue = srcType.equals(desType) || StringUtils.replace((String)srcType, (String)"java.lang.", (String)"").equals(desType) || StringUtils.replace((String)desType, (String)"java.lang.", (String)"").equals(srcType) ? srcValue : (desType.equals("String") || desType.equals("java.lang.String") ? "String.valueOf(" + srcValue + ")" : ((srcType.equals("java.util.Date") || srcType.equals("java.sql.Timestamp") || srcType.equals("java.sql.Time")) && (desType.equals("java.util.Date") || desType.equals("java.sql.Timestamp") || desType.equals("java.sql.Time")) ? (desType.equals("java.util.Date") ? srcValue : "new " + desType + "(" + srcValue + ".getTime())") : (srcType.equals("String") || srcType.equals("java.lang.String") ? (desType.equals("Object") || desType.equals("java.lang.Object") ? srcValue : (desType.equals("float") ? "Float.parseFloat(" + srcValue + ")" : (desType.equals("java.lang.Float") ? "new Float(" + srcValue + ")" : (desType.equals("double") ? "Double.parseDouble(" + srcValue + ")" : (desType.equals("java.lang.Double") ? "new Double(" + srcValue + ")" : (desType.equals("int") ? "Integer.parseInt(" + srcValue + ")" : (desType.equals("java.lang.Integer") ? "new Integer(" + srcValue + ")" : (desType.equals("long") ? "Long.parseLong(" + srcValue + ")" : (desType.equals("java.lang.Long") ? "new Long(" + srcValue + ")" : (desType.equals("boolean") ? "Boolean.valueOf(" + srcValue + ")" : (desType.equals("java.lang.Boolean") ? "new Boolean(" + srcValue + ")" : (desType.equals("java.util.Date") ? "new java.util.Date(" + srcValue + ")" : (desType.equals("java.sql.Date") ? "java.sql.Date.valueOf(" + srcValue + ")" : (desType.equals("BOSUuid") || desType.equals(imp17) ? "BOSUuid.read(" + srcValue + ")" : (desType.equals("java.math.BigDecimal") ? "new java.math.BigDecimal(" + srcValue + ")" : (desType.equals("java.math.BigInteger") ? "new java.math.BigInteger(" + srcValue + ")" : "String.valueOf(" + srcValue + ")")))))))))))))))) : (srcType.equals("Object") || srcType.equals("java.lang.Object") ? (desType.equals("float") ? "Float.parseFloat(String.valueOf(" + srcValue + "))" : (desType.equals("double") ? "Double.parseDouble(String.valueOf(" + srcValue + "))" : (desType.equals("int") ? "Integer.parseInt(String.valueOf(" + srcValue + "))" : (desType.equals("long") ? "Long.parseLong(String.valueOf(" + srcValue + "))" : (desType.equals("boolean") ? "Boolean.valueOf(String.valueOf(" + srcValue + "))" : (desType.indexOf(".") >= 0 ? "(" + desType + ")" + srcValue : srcValue)))))) : (desType.equals("Object") || desType.equals("java.lang.Object") ? (srcType.equals("float") ? "new Float(" + srcValue + ")" : (srcType.equals("double") ? "new Double(" + srcValue + ")" : (srcType.equals("int") ? "new Integer(" + srcValue + ")" : (srcType.equals("long") ? "new Long(" + srcValue + ")" : (srcType.equals("boolean") ? "new Boolean(" + srcValue + ")" : srcValue))))) : srcValue)))));
        return desValue;
    }

    private String getMethodName(String type) {
        String methodName = "";
        methodName = type.equals("java.lang.String") ? "String" : (type.equals("java.lang.Character") ? "Char" : (type.equals("java.awt.Dimension") ? "Dimension" : (type.equals("float") ? "Float" : (type.equals("double") ? "Double" : (type.equals("java.math.BigDecimal") ? "BigDecimal" : (type.equals("int") ? "Int" : (type.equals("long") ? "Long" : (type.equals("boolean") ? "Boolean" : (type.equals("java.util.Date") || type.equals("java.sql.Date") ? "Date" : (type.equals("java.awt.Color") ? "Color" : (type.equals("java.awt.Font") ? "Font" : (type.equals("javax.swing.border.Border") ? "Border" : (type.equals("javax.swing.Icon") ? "Icon" : (type.equals("java.awt.Insets") ? "Insets" : type.substring(type.lastIndexOf(".") + 1)))))))))))))));
        return methodName;
    }

    private String getComponentName(ComponentInfo cInfo) {
        String componentName = cInfo == this.rootPanel ? "this" : (cInfo == this.toolBar ? "this.toolBar" : (cInfo == this.menuBar ? "this.menuBar" : "this." + cInfo.getName()));
        return componentName;
    }

    private String getValueString(PropertyInfo pInfo, String controlName) {
        String args;
        String type = pInfo.getType();
        if (type == null) {
            args = "null";
        } else if (pInfo.getValue() == null && (type.equals("String") || type.equals("java.lang.String"))) {
            args = "\"\"";
        } else if (pInfo.getName().equalsIgnoreCase("action")) {
            args = pInfo.getValue();
        } else if (pInfo.getName().equalsIgnoreCase("items")) {
            String[] s = StringUtils.split((String)pInfo.getValue(), (String)";");
            args = "new String[] {";
            int n = s.length;
            for (int i = 0; i < n; ++i) {
                args = i == 0 ? args + "\"" + s[i] + "\"" : args + ",\"" + s[i] + "\"";
            }
            args = args + "}";
        } else if (type.equals("java.lang.String")) {
            String s = pInfo.getValue();
            s = StringUtils.replace((String)s, (String)"\\", (String)"\\\\");
            s = StringUtils.replace((String)s, (String)"\"", (String)"\\\"");
            args = "\"" + s + "\"";
        } else if (type.equals("java.lang.Character")) {
            args = "'" + pInfo.getValue() + "'";
        } else if (type.equals("java.awt.Dimension")) {
            args = "new Dimension(" + pInfo.getValue() + ")";
        } else if (type.equals("float")) {
            args = pInfo.getValue() + "f";
        } else if (type.equals("int") || type.equals("long") || type.equals("boolean") || type.equals("double")) {
            args = pInfo.getValue();
        } else if (type.equals("java.math.BigDecimal")) {
            args = " new java.math.BigDecimal(" + pInfo.getValue() + ")";
        } else if (type.equals("java.awt.Color")) {
            String[] s = StringUtils.split((String)pInfo.getValue(), (String)",");
            args = "new java.awt.Color(" + s[0].substring(s[0].indexOf("=") + 1) + "," + s[1].substring(s[1].indexOf("=") + 1) + "," + s[2].substring(s[2].indexOf("=") + 1) + ")";
        } else if (type.equals("java.awt.Font")) {
            String[] s = StringUtils.split((String)pInfo.getValue(), (String)",");
            args = "new java.awt.Font(\"" + s[0].substring(s[0].indexOf("=") + 1) + "\"," + s[2].substring(s[2].indexOf("=") + 1) + "," + s[3].substring(s[3].indexOf("=") + 1) + ")";
        } else if (type.equals("javax.swing.border.Border")) {
            args = BorderPropertyUtil.toJavaCode(pInfo.getValue(), controlName);
        } else if (type.equals("javax.swing.Icon")) {
            args = "new javax.swing.ImageIcon(this.getClass().getClassLoader().getResource(\"" + pInfo.getValue() + "\"))";
        } else if (type.equals("java.awt.Insets")) {
            args = "new java.awt.Insets(" + pInfo.getValue() + ")";
        } else {
            String s = pInfo.getValue();
            s = StringUtils.replace((String)s, (String)"\"", (String)"\\\"");
            s = StringUtils.replace((String)s, (String)"\\", (String)"\\\\");
            args = "\"" + s + "\"";
        }
        return args;
    }

    private String bindQuery(ComponentInfo cInfo) {
        int n = cInfo.getPropertyBindings().size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(i);
            if (!this.queryList.contains(pbInfo.getBindingObject())) continue;
            return pbInfo.getBindingObject();
        }
        return null;
    }

    private String bindCloneQuery(ComponentInfo cInfo) {
        int n = cInfo.getPropertyBindings().size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(i);
            if (!this.cloneQueryList.contains(pbInfo.getBindingObject())) continue;
            return pbInfo.getBindingObject();
        }
        return null;
    }

    private void writeLoadFunction() {
        this.out.append('\n');
        this.out.append(this.writeNote("output loadFields method", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + "void" + ' ' + "loadFields" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        if (this.model.getDataObjects().size() > 0) {
            this.out.append(this.tab + "if (this." + this.model.getDataObjects().get(0).getName() + " == null) return;" + '\n');
        }
        int count = 0;
        int m = this.components.size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            String[] columns = null;
            boolean bindTable = false;
            if (this.headerList.containsKey(cInfo.getName()) && this.headerList.get(cInfo.getName()) != null) {
                columns = (String[])this.headerList.get(cInfo.getName());
            }
            int n = cInfo.getPropertyBindings().size();
            for (int j = 0; j < n; ++j) {
                PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
                if (("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equalsIgnoreCase(cInfo.getClassType())) && "_multiLangItem".equals(pbInfo.getPropertyName())) {
                    String tempStr = pbInfo.getBingdingField();
                    if (tempStr.indexOf(46) >= 0) {
                        String tempDataStr = pbInfo.getBindingObject();
                        String[] tempS = StringUtils.split((String)tempStr, (int)46);
                        int mm = tempS.length - 1;
                        this.out.append(this.tab + "if (");
                        for (int kk = 0; kk < mm; ++kk) {
                            tempDataStr = tempDataStr + ".get" + this.upcastName(tempS[kk]) + "()";
                            if (kk != 0) {
                                this.out.append(" && ");
                            }
                            this.out.append(tempDataStr + "!= null");
                        }
                        this.out.append(")\n");
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "com.kingdee.bos.ui.util.UIHelper.loadMultiLangFields(");
                        this.out.append(cInfo.getName());
                        this.out.append(", ");
                        this.out.append(tempDataStr);
                        this.out.append(", \"");
                        this.out.append(tempS[mm]);
                        this.out.append("\");\n");
                        this.tabSub();
                        this.writeEnd();
                        continue;
                    }
                    this.out.append(this.tab + "com.kingdee.bos.ui.util.UIHelper.loadMultiLangFields(");
                    this.out.append(cInfo.getName());
                    this.out.append(", ");
                    this.out.append(pbInfo.getBindingObject());
                    this.out.append(", \"");
                    this.out.append(pbInfo.getBingdingField());
                    this.out.append("\");\n");
                    continue;
                }
                if (this.queryList.contains(pbInfo.getBindingObject())) {
                    this.needGenerateQueryExecutor = true;
                }
                if (this.cloneQueryList.contains(pbInfo.getBindingObject())) {
                    this.hasBindQuery = true;
                    continue;
                }
                if (columns != null && pbInfo.getPropertyName().indexOf(".text") >= 0) {
                    bindTable = true;
                    this.hasBindTable = true;
                    continue;
                }
                if (pbInfo.getBingdingField().indexOf(".") >= 0) {
                    String[] s = StringUtils.split((String)pbInfo.getBingdingField(), (String)".");
                    String getFieldString = "";
                    String cond = pbInfo.getBindingObject();
                    int m1 = s.length - 1;
                    if (pbInfo.getFieldType().equals("String") || pbInfo.getFieldType().equals("java.lang.String")) {
                        m1 = s.length;
                    }
                    for (int i1 = 0; i1 < m1; ++i1) {
                        cond = cond + ".get" + this.upcastName(s[i1]) + "()";
                        getFieldString = i1 == 0 ? getFieldString + cond + " != null" : getFieldString + " && " + cond + " != null";
                    }
                    this.out.append(this.tab + "if (" + getFieldString + ")" + '\n');
                    this.tabAdd();
                    this.out.append(this.tab + this.getLoadExpression(cInfo, pbInfo) + '\n');
                    this.tabSub();
                    if ("text".equals(pbInfo.getPropertyName()) && "com.kingdee.bos.ctrl.swing.KDTextField".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(cInfo.getClassType())) {
                        this.out.append(this.tab + "else" + '\n');
                        this.tabAdd();
                        this.out.append(this.tab + this.getLoadExpression(cInfo, pbInfo, "null") + '\n');
                        this.tabSub();
                    }
                } else if (pbInfo.getFieldType().equals("String") || pbInfo.getFieldType().equals("java.lang.String")) {
                    String cond = pbInfo.getBindingObject();
                    cond = cond + ".get" + this.upcastName(pbInfo.getBingdingField()) + "() != null";
                    this.out.append(this.tab + this.getLoadExpression(cInfo, pbInfo) + '\n');
                } else {
                    this.out.append(this.tab + this.getLoadExpression(cInfo, pbInfo) + '\n');
                }
                ++count;
            }
            if (!bindTable) continue;
            this.out.append(this.getBindTableString(cInfo, true, false, false));
        }
        if ("EntryUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.out.append(this.tab + "updateDetailButton();" + '\n');
        } else if ("EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.out.append(this.tab + "loadDetailData();" + '\n');
        } else if (this.model.getParent() == null && count == 0) {
            this.writeTodo();
        }
        this.tabSub();
        this.writeEnd();
    }

    private String findTableBindingField(String dataObjName, String bindingFieldName) {
        if (StringUtils.isEmpty((String)dataObjName) || StringUtils.isEmpty((String)bindingFieldName)) {
            return "";
        }
        DataObjectInfo dataObjInfo = this.model.getDataObjects().getDataObject(dataObjName);
        IObjectValue tempObjValue = dataObjInfo.getInstance();
        if (tempObjValue == null || !(tempObjValue instanceof EntityObjectInfo)) {
            return "";
        }
        EntityObjectInfo entity = (EntityObjectInfo)tempObjValue;
        String[] s = StringUtils.split((String)bindingFieldName, (String)".");
        for (int i = 0; i < s.length; ++i) {
            com.kingdee.bos.metadata.entity.PropertyInfo pInfo = entity.getPropertyByName(s[i]);
            if (!(pInfo instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relationship = ((LinkPropertyInfo)pInfo).getRelationship();
            if (relationship.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || relationship.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
                String validBindingField = s[0];
                for (int j = 1; j < i; ++j) {
                    validBindingField = validBindingField + "." + s[j];
                }
                return validBindingField;
            }
            entity = relationship.getClientObject();
        }
        return "";
    }

    private String getBindTableString(ComponentInfo cInfo, boolean isLoad, boolean isQuery, boolean isPutContent) {
        int i;
        int m;
        String bindString = "";
        String bindObjectName = "";
        String bindFieldName = "";
        String[] columns = null;
        String[] bindItems = null;
        bindString = isLoad ? "this.bindDataToTable(" : "this.bindTableToData(";
        if (this.headerList.containsKey(cInfo.getName()) && this.headerList.get(cInfo.getName()) != null) {
            columns = (String[])this.headerList.get(cInfo.getName());
            bindItems = new String[columns.length];
            int n = bindItems.length;
            for (int j = 0; j < n; ++j) {
                bindItems[j] = null;
            }
        }
        boolean hasFoundBindingField = false;
        int n = cInfo.getPropertyBindings().size();
        block1: for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (columns == null || pbInfo.getPropertyName().indexOf(".text") < 0) continue;
            String columnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
            if (isQuery) {
                if (bindObjectName.equals("")) {
                    bindObjectName = pbInfo.getBindingObject();
                }
            } else {
                if (pbInfo.getBingdingField().indexOf(".") < 0) continue;
                if (bindObjectName.equals("")) {
                    bindObjectName = pbInfo.getBindingObject();
                }
                if (!hasFoundBindingField && !StringUtils.isEmpty((String)(bindFieldName = this.findTableBindingField(bindObjectName, pbInfo.getBingdingField())))) {
                    hasFoundBindingField = true;
                }
            }
            int m1 = columns.length;
            for (int i1 = 0; i1 < m1; ++i1) {
                if (!columnName.equalsIgnoreCase(columns[i1])) continue;
                bindItems[i1] = pbInfo.getBingdingField();
                continue block1;
            }
        }
        if (!isQuery && bindItems != null) {
            m = bindItems.length;
            for (i = 0; i < m; ++i) {
                if (bindItems[i] == null || bindItems[i].length() <= bindFieldName.length() + 1) continue;
                bindItems[i] = bindItems[i].substring(bindFieldName.length() + 1);
            }
        }
        m = this.model.getDataObjects().size();
        for (i = 0; i < m; ++i) {
            if (!this.model.getDataObjects().get(i).getName().equals(bindObjectName)) continue;
            IObjectValue objectValue = this.model.getDataObjects().get(i).getInstance();
            if (objectValue != null && objectValue instanceof EntityObjectInfo) {
                String[] s = StringUtils.split((String)bindFieldName, (String)".");
                int n2 = s.length;
                for (int j = 0; j < n2; ++j) {
                    com.kingdee.bos.metadata.entity.PropertyInfo pInfo = ((EntityObjectInfo)objectValue).getPropertyByName(s[i]);
                    if (!(pInfo instanceof LinkPropertyInfo)) continue;
                    objectValue = j == n2 - 1 ? ((LinkPropertyInfo)pInfo).getRelationship().getSupplierObject() : ((LinkPropertyInfo)pInfo).getRelationship().getClientObject();
                }
                this.bindObjectType = ((EntityObjectInfo)objectValue).getObjectValueClass();
                break;
            }
            this.bindObjectType = this.upcastName(bindObjectName) + "Info";
            break;
        }
        bindFieldName = this.getGetMethodString(bindObjectName, bindFieldName, "Object");
        String sArray = "new String[] {";
        if (bindItems != null) {
            int n3 = bindItems.length;
            for (int j = 0; j < n3; ++j) {
                sArray = j == 0 ? sArray + "\"" + (bindItems[j] == null ? "" : bindItems[j]) + "\"" : sArray + ",\"" + (bindItems[j] == null ? "" : bindItems[j]) + "\"";
            }
        }
        sArray = sArray + "}";
        bindString = isQuery || isPutContent ? (StringUtils.isEmpty((String)bindObjectName) ? "" : this.tab + this.getComponentName(cInfo) + ".putBindContents(\"" + bindObjectName + "\"," + sArray + ");" + '\n') : this.tab + bindString + this.getComponentName(cInfo) + "," + bindFieldName + ");" + '\n';
        return bindString;
    }

    private void writeStoreFunction() {
        this.out.append('\n');
        this.out.append(this.writeNote("output storeFields method", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + "void" + ' ' + "storeFields" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        if (this.model.getDataObjects().size() > 0) {
            this.out.append(this.tab + "if (this." + this.model.getDataObjects().get(0).getName() + " == null) return;" + '\n');
        }
        int count = 0;
        int m = this.components.size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            String[] columns = null;
            boolean bindTable = false;
            if (this.headerList.containsKey(cInfo.getName()) && this.headerList.get(cInfo.getName()) != null) {
                columns = (String[])this.headerList.get(cInfo.getName());
            }
            int n = cInfo.getPropertyBindings().size();
            for (int j = 0; j < n; ++j) {
                PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
                if (("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equalsIgnoreCase(cInfo.getClassType())) && "_multiLangItem".equals(pbInfo.getPropertyName())) {
                    String tempStr = pbInfo.getBingdingField();
                    if (tempStr.indexOf(46) >= 0) {
                        String tempDataStr = pbInfo.getBindingObject();
                        String[] tempS = StringUtils.split((String)tempStr, (int)46);
                        int mm = tempS.length - 1;
                        this.out.append(this.tab + "if (");
                        for (int kk = 0; kk < mm; ++kk) {
                            tempDataStr = tempDataStr + ".get" + this.upcastName(tempS[kk]) + "()";
                            if (kk != 0) {
                                this.out.append(" && ");
                            }
                            this.out.append(tempDataStr + "!= null");
                        }
                        this.out.append(")\n");
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "com.kingdee.bos.ui.util.UIHelper.storeMultiLangFields(");
                        this.out.append(cInfo.getName());
                        this.out.append(", ");
                        this.out.append(tempDataStr);
                        this.out.append(", \"");
                        this.out.append(tempS[mm]);
                        this.out.append("\");\n");
                        this.tabSub();
                        this.writeEnd();
                        continue;
                    }
                    this.out.append(this.tab + "com.kingdee.bos.ui.util.UIHelper.storeMultiLangFields(");
                    this.out.append(cInfo.getName());
                    this.out.append(", ");
                    this.out.append(pbInfo.getBindingObject());
                    this.out.append(", \"");
                    this.out.append(pbInfo.getBingdingField());
                    this.out.append("\");\n");
                    continue;
                }
                if (this.queryList.contains(pbInfo.getBindingObject())) {
                    this.needGenerateQueryExecutor = true;
                }
                if (this.cloneQueryList.contains(pbInfo.getBindingObject())) {
                    this.hasBindQuery = true;
                    continue;
                }
                if (columns != null && pbInfo.getPropertyName().indexOf(".text") >= 0) {
                    bindTable = true;
                    this.hasBindTable = true;
                    continue;
                }
                if (pbInfo.getBingdingField().indexOf(".") >= 0) {
                    String[] s = StringUtils.split((String)pbInfo.getBingdingField(), (String)".");
                    String getFieldString = "";
                    String cond = pbInfo.getBindingObject();
                    int m1 = s.length - 1;
                    for (int i1 = 0; i1 < m1; ++i1) {
                        cond = cond + ".get" + this.upcastName(s[i1]) + "()";
                        getFieldString = i1 == 0 ? getFieldString + cond + " != null" : getFieldString + " && " + cond + " != null";
                    }
                    this.out.append(this.tab + "if (" + getFieldString + ")" + '\n');
                    this.tabAdd();
                    this.out.append(this.tab + this.getStoreExpression(cInfo, pbInfo) + '\n');
                    this.tabSub();
                } else {
                    this.out.append(this.tab + this.getStoreExpression(cInfo, pbInfo) + '\n');
                }
                ++count;
            }
            if (!bindTable) continue;
            this.out.append(this.getBindTableString(cInfo, false, false, false));
        }
        if ("EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.out.append(this.tab + "storeDetailData();" + '\n');
        } else if (this.model.getParent() == null && count == 0) {
            this.writeTodo();
        }
        this.tabSub();
        this.writeEnd();
    }

    private String getGetMethodString(String objectName, String fieldName, String type) {
        String expr = "";
        String[] s = StringUtils.split((String)fieldName, (String)".");
        String getMethodString = objectName;
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                if (type.equals("boolean")) {
                    getMethodString = getMethodString + ".is" + this.upcastName(s[i]) + "()";
                    continue;
                }
                getMethodString = getMethodString + ".get" + this.upcastName(s[i]) + "()";
                continue;
            }
            getMethodString = getMethodString + ".get" + this.upcastName(s[i]) + "()";
        }
        return getMethodString;
    }

    private void writeMethods() {
        int m = this.components.size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            int n = cInfo.getEventBindings().size();
            for (int j = 0; j < n; ++j) {
                EventBindingInfo ebInfo = cInfo.getEventBindings().get(j);
                if (cInfo.isHerited() && !ebInfo.isWriteCode()) continue;
                this.out.append('\n');
                this.out.append(this.writeNote("output " + ebInfo.getMethodName() + " method", new String[0], ""));
                this.out.append(this.tab + "protected void " + ebInfo.getMethodName() + "(" + ebInfo.getEventType() + " e) throws Exception" + '\n');
                this.writeBegin();
                this.tabAdd();
                if (ebInfo.getCode() != null) {
                    this.out.append(this.tab + ebInfo.getCode() + '\n');
                }
                this.tabSub();
                this.writeEnd();
            }
            if (!cInfo.getClassType().equalsIgnoreCase(KDTABLE) || this.bindQuery(cInfo) == null) continue;
            this.out.append('\n');
            this.out.append(this.writeNote("output " + cInfo.getName() + "_doRequestRowSet method", new String[0], ""));
            this.out.append(this.tab + "protected void " + cInfo.getName() + "_doRequestRowSet(RequestRowSetEvent e)" + '\n');
            this.writeBegin();
            this.tabAdd();
            String bindQueryName = this.bindQuery(cInfo);
            if (bindQueryName != null) {
                this.out.append(this.tab + "if (this." + bindQueryName + " != null)" + '\n');
                this.writeBegin();
                this.tabAdd();
                this.out.append(this.tab + "int start = ((Integer)e.getParam1()).intValue();" + '\n');
                this.out.append(this.tab + "int length = ((Integer)e.getParam2()).intValue() - start + 1;" + '\n');
                this.out.append(this.tab + "try" + '\n');
                this.writeBegin();
                this.tabAdd();
                this.out.append(this.tab + "IQueryExecutor exec = this.getQueryExecutor(this." + bindQueryName + "PK,this." + bindQueryName + ");" + '\n');
                this.out.append(this.tab + "IRowSet rowSet = exec.executeQuery(start,length);" + '\n');
                this.out.append(this.tab + "e.setRowSet(rowSet);" + '\n');
                this.out.append(this.tab + "onGetRowSet(rowSet);" + '\n');
                this.tabSub();
                this.writeEnd();
                this.out.append(this.tab + "catch (Exception ee)" + '\n');
                this.writeBegin();
                this.tabAdd();
                this.out.append(this.tab + "handUIException(ee);" + '\n');
                this.tabSub();
                this.writeEnd();
                this.tabSub();
                this.writeEnd();
            }
            this.tabSub();
            this.writeEnd();
        }
    }

    private void writeActions() {
        String slnName = null;
        try {
            slnName = ((ISolutionCtrl)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.SOLUTION)).getValue().getName();
        }
        catch (BOSException bose) {
            logger.error((Object)"error", (Throwable)bose);
        }
        int n = this.model.getActions().size();
        for (int i = 0; i < n; ++i) {
            ActionInfo action = this.model.getActions().get(i);
            if (action.isHerited()) continue;
            if (action.isBindWorkFlow()) {
                this.hasBindWorkFlow = true;
            }
            this.out.append('\n');
            this.out.append(this.writeNote("output " + action.getClassName() + " class", new String[0], ""));
            this.out.append(this.tab + "protected class " + action.getClassName() + " extends ItemAction" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "public " + action.getClassName() + "()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "this(null);" + '\n');
            this.tabSub();
            this.writeEnd();
            this.out.append(this.tab + "public " + action.getClassName() + "(IUIObject uiObject)" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "super(uiObject);" + '\n');
            this.out.append(this.tab + "String _tempStr = null;" + '\n');
            if (!action.isEnabled()) {
                this.out.append(this.tab + "this.setEnabled(false);" + '\n');
            }
            if (action.isDaemonRun()) {
                this.out.append(this.tab + "this.setDaemonRun(true);" + '\n');
            }
            this.writeActionProperty(action, "this", false);
            this.tabSub();
            this.writeEnd();
            this.out.append(this.tab + "public void actionPerformed(ActionEvent e)" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "innerActionPerformed(\"");
            this.out.append(slnName);
            this.out.append("\", Abstract");
            this.out.append(this.model.getReleaseClass());
            this.out.append(".this, \"");
            this.out.append(action.getClassName());
            this.out.append("\", \"" + this.locastName(action.getClassName() + "_actionPerformed\", e);" + '\n'));
            this.tabSub();
            this.writeEnd();
            this.tabSub();
            this.writeEnd();
        }
    }

    private void writeActionProperty(ActionInfo action, String actionName, boolean isCheckNull) {
        String actionKey = action.getAcceleratorKey();
        if (!StringUtils.isEmpty((String)actionKey)) {
            this.out.append(this.tab + actionName + ".putValue(ItemAction.ACCELERATOR_KEY, KeyStroke.getKeyStroke(\"" + actionKey + "\"));" + '\n');
        }
        if (!StringUtils.isEmpty((String)(actionKey = action.getActionCommandKey()))) {
            this.out.append(this.tab + actionName + ".putValue(ItemAction.ACTION_COMMAND_KEY,\"" + actionKey + "\");" + '\n');
        }
        if (!StringUtils.isEmpty((String)(actionKey = action.getMnemonicKey()))) {
            this.out.append(this.tab + actionName + ".putValue(ItemAction.MNEMONIC_KEY, new Integer(" + actionKey + "));" + '\n');
        }
        if (!StringUtils.isEmpty((String)(actionKey = action.getSmallIcon()))) {
            this.out.append(this.tab + actionName + ".putValue(ItemAction.SMALL_ICON,\"" + actionKey + "\");" + '\n');
        }
        this.out.append(this.tab + "_tempStr = resHelper.getString(\"" + action.getClassName() + ".SHORT_DESCRIPTION\");" + '\n');
        if (isCheckNull) {
            this.out.append(this.tab + "if (! StringUtils.isEmpty(_tempStr))" + '\n');
            this.tabAdd();
        }
        this.out.append(this.tab + actionName + ".putValue(ItemAction.SHORT_DESCRIPTION, _tempStr);" + '\n');
        if (isCheckNull) {
            this.tabSub();
        }
        this.out.append(this.tab + "_tempStr = resHelper.getString(\"" + action.getClassName() + ".LONG_DESCRIPTION\");" + '\n');
        if (isCheckNull) {
            this.out.append(this.tab + "if (! StringUtils.isEmpty(_tempStr))" + '\n');
            this.tabAdd();
        }
        this.out.append(this.tab + actionName + ".putValue(ItemAction.LONG_DESCRIPTION, _tempStr);" + '\n');
        if (isCheckNull) {
            this.tabSub();
        }
        this.out.append(this.tab + "_tempStr = resHelper.getString(\"" + action.getClassName() + ".NAME\");" + '\n');
        if (isCheckNull) {
            this.out.append(this.tab + "if (! StringUtils.isEmpty(_tempStr))" + '\n');
            this.tabAdd();
        }
        this.out.append(this.tab + actionName + ".putValue(ItemAction.NAME, _tempStr);" + '\n');
        if (isCheckNull) {
            this.tabSub();
        }
    }

    private void writeActionInitExtendProperty(StringBuffer out, String extendProperty, String actionName) {
        ActionExtendPropertyHelper helper = new ActionExtendPropertyHelper(extendProperty);
        List pairs = helper.getKeyValuePairs();
        int j = pairs.size();
        for (int i = 0; i < j; ++i) {
            String key = ((String[])pairs.get(i))[0];
            String value = ((String[])pairs.get(i))[1];
            out.append(this.tab + actionName + ".setExtendProperty(\"" + key + "\", \"" + value + "\");" + '\n');
        }
    }

    private void writeActionPerformed() {
        Vector<String> tempVec = new Vector<String>();
        int n = this.model.getActions().size();
        for (int i = 0; i < n; ++i) {
            ActionInfo action = this.model.getActions().get(i);
            if (action.isHerited() && !action.isOverride()) continue;
            if (action.isBindWorkFlow()) {
                this.hasBindWorkFlow = true;
                tempVec.add(action.getName());
            }
            this.out.append('\n');
            this.out.append(this.writeNote("output " + this.locastName(action.getClassName()) + "_actionPerformed", new String[0], ""));
            this.out.append(this.tab + "public void " + this.locastName(action.getClassName()) + "_actionPerformed(ActionEvent e) throws Exception" + '\n');
            this.writeBegin();
            this.tabAdd();
            if (action.getActionPerformed() != null) {
                this.out.append(this.tab + action.getActionPerformed() + '\n');
            } else if (action.isHerited() && action.isOverride()) {
                this.out.append(this.tab + "super." + this.locastName(action.getClassName()) + "_actionPerformed(e);" + '\n');
            } else {
                RuleCollection rules = action.getRules();
                if (rules != null && rules.size() > 0 && "EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName()))) {
                    int m = rules.size();
                    for (int j = 0; j < m; ++j) {
                        if (!(rules.get(j) instanceof ConditionRuleInfo)) continue;
                        this.out.append(RuleJCodeWriter.writeBody(rules.get(j)));
                    }
                }
            }
            this.tabSub();
            this.writeEnd();
        }
    }

    private void writeStatusFunction() {
        this.out.append('\n');
        this.out.append(this.writeNote("output setOprtState method", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + "void" + ' ' + "setOprtState(String oprtType)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super.setOprtState(oprtType);" + '\n');
        boolean isIfBegin = true;
        int m = this.model.getStatuses().size();
        for (int i = 0; i < m; ++i) {
            StatusInfo sInfo = this.model.getStatuses().get(i);
            if (sInfo.isHerited() && !sInfo.isWriteCode() || sInfo.getStatusItems().size() == 0) continue;
            if (isIfBegin) {
                this.out.append(this.tab + "if (STATUS_" + sInfo.getName().toUpperCase() + ".equals(this.oprtState)) {" + '\n');
                isIfBegin = false;
            } else {
                this.out.append(this.tab + "} else if (STATUS_" + sInfo.getName().toUpperCase() + ".equals(this.oprtState)) {" + '\n');
            }
            this.tabAdd();
            int n = sInfo.getStatusItems().size();
            for (int j = 0; j < n; ++j) {
                try {
                    StatusItemInfo siInfo = sInfo.getStatusItems().get(j);
                    if (siInfo.isHerited() && !siInfo.isWriteCode()) continue;
                    String componentName = siInfo.getName();
                    componentName = this.rootPanel != null && this.rootPanel.getName().equals(componentName) ? "this" : (this.menuBar != null && this.menuBar.getName().equals(componentName) ? "this.menuBar" : (this.toolBar != null && this.toolBar.getName().equals(componentName) ? "this.toolBar" : "this." + componentName));
                    if (siInfo.getVisible() != null && !siInfo.getVisible().equals("") && !siInfo.getVisible().equals("<null>")) {
                        this.out.append(this.tab + componentName + ".setVisible(" + siInfo.getVisible() + ");" + '\n');
                    }
                    if (siInfo.getEnabled() == null || siInfo.getEnabled().equals("") || siInfo.getEnabled().equals("<null>")) continue;
                    this.out.append(this.tab + componentName + ".setEnabled(" + siInfo.getEnabled() + ");" + '\n');
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)sInfo.getStatusItems().get(j).toString(), (Throwable)e);
                }
            }
            this.tabSub();
        }
        if (!isIfBegin) {
            this.writeEnd();
        }
        this.tabSub();
        this.writeEnd();
    }

    private void writeGetQueryExecutor() {
        this.out.append('\n');
        this.out.append(this.writeNote("output getQueryExecutor method", new String[0], ""));
        this.out.append(this.tab + "protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK,EntityViewInfo viewInfo)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance(queryPK);" + '\n');
        this.out.append(this.tab + "exec.setObjectView(viewInfo);" + '\n');
        this.out.append(this.tab + "return exec;" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeLoadLineFields() {
        this.out.append('\n');
        this.out.append(this.writeNote("output loadLineFields method", new String[0], ""));
        this.out.append(this.tab + "protected void loadLineFields(KDTable table,IRow row,IObjectValue obj)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "String bindField;" + '\n');
        this.out.append(this.tab + "row.setUserObject(obj);" + '\n');
        this.out.append(this.tab + "for (int i=0,n=table.getColumnCount();i<n;i++)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "bindField = table.getColumn(i).getFieldName();" + '\n');
        this.out.append(this.tab + "if (!com.kingdee.util.StringUtils.isEmpty(bindField))" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "if (bindField.indexOf(\".\")>=0)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "String[] subItems = com.kingdee.util.StringUtils.split(bindField,\".\");" + '\n');
        this.out.append(this.tab + "IObjectValue subObj = obj;" + '\n');
        this.out.append(this.tab + "for (int k=0,l=subItems.length-1;k<l;k++)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "subObj = (IObjectValue)subObj.get(subItems[k]);" + '\n');
        this.out.append(this.tab + "if (subObj == null) break;" + '\n');
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "if (subObj != null)" + '\n');
        this.tabAdd();
        this.out.append(this.tab + "row.getCell(i).setValue(subObj.get(subItems[subItems.length-1]));" + '\n');
        this.tabSub();
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "else" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "    row.getCell(i).setValue(com.kingdee.bos.ui.face.UIRuleUtil.getValue(obj,bindField));" + '\n');
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
    }

    private void writeStoreLineFields() {
        this.out.append('\n');
        this.out.append(this.writeNote("output storeLineFields method", new String[0], ""));
        this.out.append(this.tab + "protected void storeLineFields(KDTable table,IRow row,IObjectValue obj)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "String bindField;" + '\n');
        this.out.append(this.tab + "for (int i=0,n=table.getColumnCount();i<n;i++)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "bindField = table.getColumn(i).getFieldName();" + '\n');
        this.out.append(this.tab + "if (!com.kingdee.util.StringUtils.isEmpty(bindField))" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "if (bindField.indexOf(\".\")>=0)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "String[] subItems = com.kingdee.util.StringUtils.split(bindField,\".\");" + '\n');
        this.out.append(this.tab + "IObjectValue subObj = obj;" + '\n');
        this.out.append(this.tab + "for (int k=0,l=subItems.length-1;k<l;k++)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "subObj = (IObjectValue)subObj.get(subItems[k]);" + '\n');
        this.out.append(this.tab + "if (subObj == null) break;" + '\n');
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "if (subObj != null)" + '\n');
        this.tabAdd();
        this.out.append(this.tab + "subObj.put(subItems[subItems.length-1],row.getCell(i).getValue());" + '\n');
        this.tabSub();
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "else" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "Class type = obj.getClass();" + '\n');
        this.out.append(this.tab + "try {" + '\n');
        this.out.append(this.tab + "    String setMethodName = \"set\" + StringUtils.headCharUpperCase(bindField);" + '\n');
        this.out.append(this.tab + "    java.lang.reflect.Method[] methods = type.getMethods();" + '\n');
        this.out.append(this.tab + "    java.lang.reflect.Method method = null;" + '\n');
        this.out.append(this.tab + "    for (int k=0,l=methods.length;k<l;k++) {" + '\n');
        this.out.append(this.tab + "        if (setMethodName.equalsIgnoreCase(methods[k].getName())) {" + '\n');
        this.out.append(this.tab + "            method = methods[k];" + '\n');
        this.out.append(this.tab + "            break;" + '\n');
        this.out.append(this.tab + "        }" + '\n');
        this.out.append(this.tab + "    }" + '\n');
        this.out.append(this.tab + "    if (method != null)" + '\n');
        this.out.append(this.tab + "        method.invoke(obj,new Object[] {row.getCell(i).getValue()});" + '\n');
        this.out.append(this.tab + "    else" + '\n');
        this.out.append(this.tab + "        obj.put(bindField,row.getCell(i).getValue());" + '\n');
        this.out.append(this.tab + "}" + '\n');
        this.out.append(this.tab + "catch (Exception e) {" + '\n');
        this.out.append(this.tab + "    obj.put(bindField,row.getCell(i).getValue());" + '\n');
        this.out.append(this.tab + "}" + '\n');
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
    }

    private void writeBindTableToData() {
        this.out.append('\n');
        this.out.append(this.writeNote("output bindTableToData method", new String[0], ""));
        this.out.append(this.tab + "protected void bindTableToData(KDTable table,IObjectCollection collection)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "if(collection == null) return;" + '\n');
        this.out.append(this.tab + "collection.clear();" + '\n');
        this.out.append(this.tab + "IObjectValue obj;" + '\n');
        this.out.append(this.tab + "IRow row;" + '\n');
        this.out.append(this.tab + "for (int i=0,n=table.getRowCount();i<n;i++)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "row = table.getRow(i);" + '\n');
        this.out.append(this.tab + "obj = (IObjectValue)row.getUserObject();" + '\n');
        this.out.append(this.tab + "if (obj == null)" + '\n');
        this.tabAdd();
        this.out.append(this.tab + "obj = new " + this.bindObjectType + "();" + '\n');
        this.tabSub();
        this.out.append(this.tab + "if (collection.addObject(obj))" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "storeLineFields(table,row,obj);" + '\n');
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
    }

    private void writeBindDataToTable() {
        this.out.append('\n');
        this.out.append(this.writeNote("output bindDataToTable method", new String[0], ""));
        this.out.append(this.tab + "protected void bindDataToTable(KDTable table,IObjectCollection collection)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "if(collection == null) return;" + '\n');
        this.out.append(this.tab + "table.setUserObject(collection);" + '\n');
        this.out.append(this.tab + "table.removeRows();" + '\n');
        this.out.append(this.tab + "IObjectValue obj;" + '\n');
        this.out.append(this.tab + "IRow row;" + '\n');
        this.out.append(this.tab + "for (int i=0,n=collection.size();i<n;i++)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "obj = collection.getObject(i);" + '\n');
        this.out.append(this.tab + "row = table.addRow(i);" + '\n');
        this.out.append(this.tab + "loadLineFields(table,row,obj);" + '\n');
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
    }

    private ComponentInfo getKDTableComponent(UIObjectInfo entryUI) {
        ComponentCollection cCol = this.treeToCol(entryUI.getComponents());
        int n = cCol.size();
        for (int i = 0; i < n; ++i) {
            if (!KDTABLE.equalsIgnoreCase(cCol.get(i).getClassType())) continue;
            return cCol.get(i);
        }
        return null;
    }

    private void writeGetBindSelectorCollection() {
        this.out.append('\n');
        this.out.append(this.writeNote("output getSelectors method", new String[0], ""));
        this.out.append(this.tab + "public SelectorItemCollection getSelectors()" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "SelectorItemCollection sic = new SelectorItemCollection();" + '\n');
        String componentName = null;
        if (this.model.getDataObjects().size() > 0) {
            componentName = this.model.getDataObjects().get(0).getName();
            IObjectValue obj = this.model.getDataObjects().get(0).getInstance();
            EntityObjectInfo entity = null;
            if (obj != null && obj instanceof EntityObjectInfo) {
                entity = (EntityObjectInfo)obj;
            }
            ArrayList<String> bindingFields = new ArrayList<String>();
            int m = this.components.size();
            for (int i = 0; i < m; ++i) {
                ComponentInfo cInfo = this.components.get(i);
                if (KDPANEL.equalsIgnoreCase(cInfo.getClassType()) && !StringUtils.isEmpty((String)cInfo.getBimUIObjectPK())) {
                    String uiObjectPK = cInfo.getBimUIObjectPK();
                    UIObjectCtrl uiCtrl = new UIObjectCtrl(ContextManager.getContext());
                    try {
                        UIObjectInfo entryUI = uiCtrl.getAllValue(new MetaDataPK(uiObjectPK));
                        cInfo = this.getKDTableComponent(entryUI);
                        if (cInfo == null) {
                            continue;
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)"error", (Throwable)e);
                    }
                }
                int n = cInfo.getPropertyBindings().size();
                for (int j = 0; j < n; ++j) {
                    RelationshipInfo relationShipInfo;
                    com.kingdee.bos.metadata.entity.PropertyInfo prop;
                    DataObjectInfo dataObjInfo;
                    IObjectValue entityInfo;
                    PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
                    if (cInfo.isHerited() && !pbInfo.isOverride() || !componentName.equals(pbInfo.getBindingObject())) continue;
                    String fieldName = pbInfo.getBingdingField();
                    if (KDBIZPROMPTBOX.equalsIgnoreCase(cInfo.getClassType()) && "data".equals(pbInfo.getPropertyName()) && fieldName.indexOf(46) < 0) {
                        fieldName = fieldName + ".*";
                    }
                    if (KDTABLE.equalsIgnoreCase(cInfo.getClassType()) && entity != null) {
                        com.kingdee.bos.metadata.entity.PropertyInfo prop2 = this.getPropertyByName(entity, fieldName);
                        if (prop2 != null && prop2 instanceof LinkPropertyInfo) {
                            bindingFields.add(fieldName + ".*");
                            this.out.append(this.tab + "sic.add(new SelectorItemInfo(\"" + fieldName + ".*" + "\"));" + '\n');
                        } else if (!bindingFields.contains(fieldName)) {
                            bindingFields.add(fieldName);
                            this.out.append(this.tab + "sic.add(new SelectorItemInfo(\"" + fieldName + "\"));" + '\n');
                        }
                    } else if (!bindingFields.contains(fieldName)) {
                        bindingFields.add(fieldName);
                        this.out.append(this.tab + "sic.add(new SelectorItemInfo(\"" + fieldName + "\"));" + '\n');
                    }
                    if (!KDBIZPROMPTBOX.equalsIgnoreCase(cInfo.getClassType())) continue;
                    String bimUIType = null;
                    bimUIType = ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName());
                    if (!"EditUI".equalsIgnoreCase(bimUIType) || !((entityInfo = (dataObjInfo = this.model.getDataObjects().get(0)).getInstance()) instanceof EntityObjectInfo) || !((prop = ((EntityObjectInfo)entityInfo).getPropertyByName(fieldName)) instanceof LinkPropertyInfo) || !RelationshipType.ASSOCIATION.equals((Object)(relationShipInfo = ((LinkPropertyInfo)prop).getRelationship()).getType())) continue;
                    EntityObjectInfo supplyEntityInfo = relationShipInfo.getSupplierObject();
                    boolean bNumberExist = false;
                    boolean bNameExist = false;
                    int l = supplyEntityInfo.getInheritedNoDuplicatedProperties().size();
                    for (int k = 0; k < l; ++k) {
                        com.kingdee.bos.metadata.entity.PropertyInfo propSuplly = supplyEntityInfo.getInheritedNoDuplicatedProperties().get(k);
                        if ("number".equalsIgnoreCase(propSuplly.getName())) {
                            bNumberExist = true;
                        }
                        if ("name".equalsIgnoreCase(propSuplly.getName())) {
                            bNameExist = true;
                        }
                        if (bNumberExist && bNameExist) break;
                    }
                    if (bNumberExist && !bindingFields.contains(fieldName + ".number")) {
                        bindingFields.add(fieldName);
                        this.out.append(this.tab + "sic.add(new SelectorItemInfo(\"" + fieldName + ".number\"));" + '\n');
                    }
                    if (bNameExist && !bindingFields.contains(fieldName + ".name")) {
                        bindingFields.add(fieldName);
                        this.out.append(this.tab + "sic.add(new SelectorItemInfo(\"" + fieldName + ".name\"));" + '\n');
                    }
                    bNumberExist = false;
                    bNameExist = false;
                }
            }
        }
        this.out.append(this.tab + "return sic;" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeUIRuleFunction() {
        boolean genInitialMethod = false;
        boolean genChangeMethod = false;
        boolean genSaveMethod = false;
        int m = this.components.size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo table;
            StringBuffer initialSb = new StringBuffer();
            StringBuffer changeSb = new StringBuffer();
            StringBuffer saveSb = new StringBuffer();
            genInitialMethod = false;
            genChangeMethod = false;
            genSaveMethod = false;
            ComponentInfo cInfo = this.components.get(i);
            RuleCollection rules = cInfo.getRules();
            String controlName = cInfo.getName();
            ComponentInfo control = cInfo;
            if (!StringUtils.isEmpty((String)cInfo.getExtendedProperty(cInfo.getBimUIObjectPK())) && (table = this.getEntryTable(new MetaDataPK(cInfo.getBimUIObjectPK()))) != null) {
                controlName = controlName + "_" + table.getName();
                rules = table.getRules();
                control = table;
            }
            if (rules == null || rules.size() <= 0 || !"EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName()))) continue;
            int n = rules.size();
            for (int j = 0; j < n; ++j) {
                String temp;
                if (!(rules.get(j) instanceof ConditionRuleInfo)) continue;
                ConditionRuleInfo conditionRule = (ConditionRuleInfo)rules.get(j);
                if (conditionRule.getEventType() == EventType.INITIAL) {
                    genInitialMethod = true;
                    temp = RuleJCodeWriter.writeBody(conditionRule);
                    if (!StringUtils.isEmpty((String)temp) && temp.indexOf("rowIndex") >= 0 && control.getClassType().equalsIgnoreCase(KDTABLE)) {
                        temp = "for (int rowIndex=0,n=getTable(" + cInfo.getName() + ")" + ".getRowCount();rowIndex<n;rowIndex++) {" + '\n' + temp + '\n' + "}" + '\n';
                    }
                    initialSb.append(this.tab + temp + '\n');
                    continue;
                }
                if (conditionRule.getEventType() == EventType.CHANGE) {
                    String columnName;
                    genChangeMethod = true;
                    temp = RuleJCodeWriter.writeBody(conditionRule);
                    if (control.getClassType().equalsIgnoreCase(KDTABLE) && !StringUtils.isEmpty((String)(columnName = conditionRule.getExtendedProperty("columnName")))) {
                        temp = "if (\"" + columnName + "\".equalsIgnoreCase(" + "getTable(" + cInfo.getName() + ")" + ".getColumn(colIndex).getKey())) {" + '\n' + temp + '\n' + "}" + '\n';
                    }
                    changeSb.append(this.tab + temp + '\n');
                    continue;
                }
                if (conditionRule.getEventType() != EventType.SUBMIT) continue;
                genSaveMethod = true;
                temp = RuleJCodeWriter.writeBody(conditionRule);
                if (!StringUtils.isEmpty((String)temp) && temp.indexOf("rowIndex") >= 0 && control.getClassType().equalsIgnoreCase(KDTABLE)) {
                    temp = "for (int rowIndex=0,n=getTable(" + cInfo.getName() + ")" + ".getRowCount();rowIndex<n;rowIndex++) {" + '\n' + temp + '\n' + "}" + '\n';
                }
                saveSb.append(this.tab + temp + '\n');
            }
            if (genInitialMethod) {
                this.writeUIRuleFunction(controlName + "_Initialize()", initialSb.toString());
            }
            if (genChangeMethod) {
                if (control.getClassType().equalsIgnoreCase(KDTABLE)) {
                    this.writeUIRuleFunction(controlName + "_Changed(int rowIndex,int colIndex)", changeSb.toString());
                } else {
                    this.writeUIRuleFunction(controlName + "_Changed()", changeSb.toString());
                }
            }
            if (!genSaveMethod) continue;
            this.writeUIRuleFunction(controlName + "_validate()", saveSb.toString());
        }
    }

    private void writeUIRule4TableFunction(String functionName, String bodyCode) {
        this.out.append('\n');
        this.out.append(this.writeNote("output " + functionName + " method", new String[0], ""));
        this.out.append(this.tab + "public void " + functionName + " throws Exception" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(bodyCode);
        this.tabSub();
        this.writeEnd();
    }

    private void writeUIRuleFunction(String functionName, String bodyCode) {
        this.out.append('\n');
        this.out.append(this.writeNote("output " + functionName + " method", new String[0], ""));
        this.out.append(this.tab + "public void " + functionName + " throws Exception" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(bodyCode);
        this.tabSub();
        this.writeEnd();
    }

    private void writeMetaPKFunction() {
        this.out.append('\n');
        this.out.append(this.writeNote("output getMetaDataPK method", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + "IMetaDataPK getMetaDataPK" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        if (this.model.getPackage() == null) {
            this.out.append(this.tab + "return new MetaDataPK(\"\",\"" + this.model.getName() + "\");" + '\n');
        } else {
            this.out.append(this.tab + "return new MetaDataPK(\"" + this.model.getPackage() + "\",\"" + this.model.getName() + "\");" + '\n');
        }
        this.tabSub();
        this.writeEnd();
    }

    private void writeIsBindWorkFlow() {
        this.out.append('\n');
        this.out.append(this.writeNote("output isBindWorkFlow method", new String[0], ""));
        this.out.append(this.tab + "public boolean isBindWorkFlow()" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return true;" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeTodo() {
        this.out.append(this.tab + "// TODO Auto-generated method stub" + '\n');
    }

    @Override
    protected String getClassName() {
        return "Abstract" + this.model.getReleaseClass();
    }

    @Override
    public void write(StringBuffer in) {
        UIObjectInfo currentModel;
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeVariable();
        this.writeConstruct();
        this.writeInitFunction();
        this.writeOnShowFunction();
        this.writeSetDataFunction();
        this.writeLoadFunction();
        this.writeStoreFunction();
        this.writeStatusFunction();
        this.writeMethods();
        this.writeUIRuleFunction();
        if (this.hasBindTable) {
            this.writeBindDataToTable();
            this.writeBindTableToData();
        }
        if (this.hasBindTable || "EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.writeLoadLineFields();
            this.writeStoreLineFields();
        }
        if (this.needGenerateQueryExecutor) {
            this.writeGetQueryExecutor();
        }
        if ((currentModel = this.getCurrentModel()).getParent() == null || currentModel.getDataObjects().size() > 0) {
            this.writeGetBindSelectorCollection();
        }
        this.writeActionPerformed();
        this.writeActions();
        this.writeMetaPKFunction();
        if (this.hasBindWorkFlow) {
            this.writeIsBindWorkFlow();
        }
        this.writeVerifyInputFunction();
        this.writeEASMethods();
        if ("ListUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "BillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.writeGetMergeColumnKeys();
        }
        if ("ListUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "TreeDetail".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.writeGetSelectedTreeKeyValue();
        }
        if ("EntryUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.writeGetDetailCollectoin();
            this.writeCreateNewDetailData();
            this.writeGetBillHeadEdit();
            this.writeSetBillHeadEdit();
            this.writeLoadDetail();
        }
        if ("EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
            this.writeGetPanels();
        }
        this.tabSub();
        this.writeEnd();
    }

    private void writeGetPanels() {
        ComponentInfo cInfo;
        int i;
        ComponentCollection cCol = new ComponentCollection();
        int n = this.components.size();
        for (i = 0; i < n; ++i) {
            cInfo = this.components.get(i);
            if (cInfo.getClassType() == null || !cInfo.getClassType().equalsIgnoreCase(KDPANEL) || StringUtils.isEmpty((String)cInfo.getBimUIObjectPK())) continue;
            cCol.add(cInfo);
        }
        this.out.append('\n');
        this.out.append(this.writeNote("output getPanels method", new String[0], ""));
        this.out.append(this.tab + "public KDPanel[] getPanels()" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "KDPanel[] panels = new KDPanel[" + cCol.size() + "];" + '\n');
        n = cCol.size();
        for (i = 0; i < n; ++i) {
            cInfo = cCol.get(i);
            this.out.append(this.tab + "panels[" + i + "] = " + cCol.get(i).getName() + ";" + '\n');
        }
        this.out.append(this.tab + "return panels;" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private EntityObjectInfo getBindedEntityForTable(ComponentInfo cInfo) {
        com.kingdee.bos.metadata.entity.PropertyInfo prop;
        DataObjectInfo editData;
        IObjectValue objValue;
        String entryPropertyName = this.getBindedEntryPropertyNameForTable(cInfo);
        if (!StringUtils.isEmpty((String)entryPropertyName) && this.model.getDataObjects().size() > 0 && (objValue = (editData = this.model.getDataObjects().get(0)).getInstance()) != null && objValue instanceof EntityObjectInfo && (prop = ((EntityObjectInfo)objValue).getPropertyByName(entryPropertyName, true)) != null && prop instanceof LinkPropertyInfo) {
            RelationshipInfo rel = ((LinkPropertyInfo)prop).getRelationship();
            return rel.getSupplierObject();
        }
        return null;
    }

    private String getBindedEntryPropertyNameForTable(ComponentInfo cInfo) {
        if (cInfo == null || !KDTABLE.equalsIgnoreCase(cInfo.getClassType())) {
            return null;
        }
        String bindedDataFieldName = null;
        PropertyBindingCollection pbCol = cInfo.getPropertyBindings();
        if (pbCol.size() > 0) {
            int n = pbCol.size();
            for (int i = 0; i < n; ++i) {
                PropertyBindingInfo pbInfo = pbCol.get(i);
                if (pbInfo.getPropertyName() == null || pbInfo.getPropertyName().indexOf(".text") <= 0) continue;
                bindedDataFieldName = pbInfo.getBingdingField().substring(0, pbInfo.getBingdingField().indexOf("."));
                break;
            }
        }
        return bindedDataFieldName;
    }

    protected void writeGetDetailCollectoin() {
        String entryPropertyName;
        ComponentInfo table = this.getTableComonentInfo();
        if (table != null && !StringUtils.isEmpty((String)(entryPropertyName = this.getBindedEntryPropertyNameForTable(table)))) {
            this.out.append('\n');
            this.out.append(this.writeNote("output getDetailCollectoin method", new String[0], ""));
            this.out.append(this.tab + "public com.kingdee.eas.framework.BillEntryBaseCollection getDetailCollectoin()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return (com.kingdee.eas.framework.BillEntryBaseCollection) editData.get" + StringUtils.headCharUpperCase((String)entryPropertyName) + "().cast(com.kingdee.eas.framework.BillEntryBaseCollection.class);" + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    protected void writeCreateNewDetailData() {
        ComponentInfo table = this.getTableComonentInfo();
        if (table == null) {
            return;
        }
        EntityObjectInfo entity = this.getBindedEntityForTable(table);
        if (entity != null) {
            this.out.append('\n');
            this.out.append(this.writeNote("output createNewDetailData method", new String[0], ""));
            this.out.append(this.tab + "protected IObjectValue createNewDetailData(KDTable table)" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return new " + entity.getBusinessImplName() + "Info();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    protected void writeGetBillHeadEdit() {
        this.out.append('\n');
        this.out.append(this.writeNote("output getBillHeadEdit method", new String[0], ""));
        this.out.append(this.tab + "public com.kingdee.eas.framework.client.multiDetail.IBill getBillHeadEdit()" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return null;" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    protected void writeSetBillHeadEdit() {
        this.out.append('\n');
        this.out.append(this.writeNote("output setBillHeadEdit method", new String[0], ""));
        this.out.append(this.tab + "public void setBillHeadEdit(com.kingdee.eas.framework.client.multiDetail.IBill newBill)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.tabSub();
        this.writeEnd();
    }

    protected void writeLoadDetail() {
        this.out.append('\n');
        this.out.append(this.writeNote("output loadDetail method", new String[0], ""));
        this.out.append(this.tab + "public void loadDetail(com.kingdee.eas.framework.BillBaseInfo billBaseInfo)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super.loadDetail(billBaseInfo);" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private ComponentInfo getEntryTable(IMetaDataPK entryUIPK) {
        try {
            UIObjectInfo entryUI = new UIObjectCtrl(ContextManager.getContext()).getValue(entryUIPK);
            return this.getKDTableComponent(entryUI);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void writeVerifyInputFunction() {
        StringBuffer tempSB = new StringBuffer();
        boolean needGenThisFunctionCode = false;
        String controlName = null;
        int m = this.components.size();
        block0: for (int i = 0; i < m; ++i) {
            ComponentInfo table;
            ComponentInfo cInfo = this.components.get(i);
            controlName = cInfo.getName();
            RuleCollection rules = cInfo.getRules();
            if (!StringUtils.isEmpty((String)cInfo.getExtendedProperty(cInfo.getBimUIObjectPK())) && (table = this.getEntryTable(new MetaDataPK(cInfo.getBimUIObjectPK()))) != null) {
                controlName = controlName + "_" + table.getName();
                rules = table.getRules();
            }
            if (rules == null || rules.size() <= 0 || !"EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName()))) continue;
            int n = rules.size();
            for (int j = 0; j < n; ++j) {
                ConditionRuleInfo conditionRule;
                if (!(rules.get(j) instanceof ConditionRuleInfo) || (conditionRule = (ConditionRuleInfo)rules.get(j)).getEventType() != EventType.SUBMIT) continue;
                tempSB.append(this.tab + controlName + "_validate();" + '\n');
                needGenThisFunctionCode = true;
                continue block0;
            }
        }
        if (needGenThisFunctionCode) {
            this.out.append('\n');
            this.out.append(this.writeNote("output verifyInput method", new String[0], ""));
            this.out.append(this.tab + "protected void verifyInput(ActionEvent e) throws Exception" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "super.verifyInput(e);" + '\n');
            this.out.append(tempSB.toString() + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    private ComponentCollection treeToCol(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(components.get(i), col);
        }
        return col;
    }

    private void addToCol(ComponentInfo info, ComponentCollection col) {
        int n = info.getComponents().size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(info.getComponents().get(i), col);
        }
        col.add(info);
    }

    private UIObjectInfo getCurrentModel() {
        return this.resultModel == null ? this.model : this.resultModel;
    }

    private void writeEASMethods() {
        String entityClassName;
        String entityFactoryName;
        String editUIName = this.model.getExtendedProperty("editUIName");
        if (StringUtils.isEmpty((String)editUIName)) {
            editUIName = ConvertUtils.getBizUnitOAKPK(this.model.getBizUnitPK(), "editUIPK");
        }
        if (!StringUtils.isEmpty((String)editUIName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output getEditUIName method", new String[0], ""));
            this.out.append(this.tab + "protected String getEditUIName()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return " + editUIName + ".class.getName();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
        if (StringUtils.isEmpty((String)(entityFactoryName = this.model.getExtendedProperty("entityFactoryName")))) {
            entityFactoryName = ConvertUtils.getEntityFactoryName(this.model.getBizUnitPK(), this.model.getFullName());
        }
        if (!StringUtils.isEmpty((String)entityFactoryName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output getBizInterface method", new String[0], ""));
            this.out.append(this.tab + "protected com.kingdee.eas.framework.ICoreBase getBizInterface() throws Exception" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return " + entityFactoryName + ".getRemoteInstance();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
        if (StringUtils.isEmpty((String)(entityClassName = this.model.getExtendedProperty("entityClassName")))) {
            entityClassName = ConvertUtils.getEntityClassName(this.model.getBizUnitPK(), this.model.getFullName());
        }
        if (!StringUtils.isEmpty((String)entityClassName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output createNewData method", new String[0], ""));
            this.out.append(this.tab + "protected IObjectValue createNewData()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + entityClassName + " objectValue = new " + entityClassName + "();" + '\n');
            if ("EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName()))) {
                if ("BillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK())) || "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
                    this.out.append(this.writeNote("set company and user", new String[0], ""));
                    if (this.model.getDataObjects().size() > 0 && ((EntityObjectInfo)this.model.getDataObjects().get(0).getInstance()).getPropertyByName("company", true) != null) {
                        this.out.append(this.tab + "objectValue.setCompany((com.kingdee.eas.basedata.org.CompanyOrgUnitInfo)(com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentFIUnit()));" + '\n');
                    }
                }
                this.out.append(this.tab + "objectValue.setCreator((com.kingdee.eas.base.permission.UserInfo)(com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentUser()));" + '\n');
            }
            this.out.append(this.tab + "return objectValue;" + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }
}

