/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.code.CodeUtil;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.resource.BizExceptionCollection;
import java.util.Vector;

public class AgentCodeWriter
extends CodeWriterBase {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String TEXT_1 = this.NL + "public class ";
    protected final String TEXT_2 = " extends ";
    protected final String TEXT_3 = " implements IObjectValueAgent{" + this.NL + "    public static final BOSObjectType bosType = new BOSObjectType(";
    protected final String TEXT_4 = ");" + this.NL + "    private final AgentManager manager;" + this.NL + "" + this.NL + "    private ";
    protected final String TEXT_5 = " ()" + this.NL + "    {" + this.NL + "        manager = new AgentManager();" + this.NL + "    }" + this.NL + "" + this.NL + "    public static ";
    protected final String TEXT_6 = " find(IObjectPK id) throws BOSException" + this.NL + "    {" + this.NL + "        return (";
    protected final String TEXT_7 = ")AgentManager.find(new ";
    protected final String TEXT_8 = "(), id); " + this.NL + "    }" + this.NL + "" + this.NL + "    public static ";
    protected final String TEXT_9 = " create() throws BOSException" + this.NL + "    {" + this.NL + "        return (";
    protected final String TEXT_10 = ")AgentManager.create(new ";
    protected final String TEXT_11 = "());" + this.NL + "    }" + this.NL + "" + this.NL + "    public void remove() throws BOSException" + this.NL + "    {" + this.NL + "        AgentManager.remove(this);" + this.NL + "    }" + this.NL + "" + this.NL + "    public IObjectPK save() throws BOSException" + this.NL + "    {" + this.NL + "        return AgentManager.save(this);" + this.NL + "    }" + this.NL + "" + this.NL + "    public AgentState getAgentState()" + this.NL + "    {" + this.NL + "        return manager.getAgentState();" + this.NL + "    }" + this.NL + "" + this.NL + "    public void setAgentState(AgentState state)" + this.NL + "    {" + this.NL + "        manager.setAgentState(state);" + this.NL + "    }" + this.NL + "" + this.NL + "    public IObjectValue getTarget()" + this.NL + "    {" + this.NL + "        return this;" + this.NL + "    }" + this.NL;
    protected final String TEXT_12 = this.NL + "    public ";
    protected final String TEXT_13 = " ";
    protected final String TEXT_14 = "(";
    protected final String TEXT_15 = ") throws BOSException";
    protected final String TEXT_16 = this.NL + "    {";
    protected final String TEXT_17 = this.NL + "        ";
    protected final String TEXT_18 = " ctrl = (";
    protected final String TEXT_19 = ")AgentContainerFactory.getInstance().getBOSObject(bosType);";
    protected final String TEXT_20 = this.NL + "        ";
    protected final String TEXT_21 = "ctrl.";
    protected final String TEXT_22 = "(";
    protected final String TEXT_23 = ");" + this.NL + "    }";
    protected final String TEXT_24 = this.NL + "}";
    protected final String TEXT_25 = this.NL;
    private Vector imports = new Vector();
    EntityObjectInfo bo;

    private void initImports() {
        this.imports.clear();
        this.imports.add("com.kingdee.bos.BOSException");
        this.imports.add("com.kingdee.bos.dao.IObjectPK");
        this.imports.add("com.kingdee.bos.dao.IObjectValue");
        this.imports.add("com.kingdee.bos.framework.agent.AgentManager");
        this.imports.add("com.kingdee.bos.framework.agent.AgentState");
        this.imports.add("com.kingdee.bos.framework.agent.IObjectValueAgent");
        this.imports.add("com.kingdee.bos.framework.agent.AgentContainerFactory");
        this.imports.add("com.kingdee.bos.util.BOSObjectType");
    }

    public static String getLeftLastDotStr(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(".") < 0) {
            return null;
        }
        return str.substring(0, str.lastIndexOf("."));
    }

    public static String getRightLastDotStr(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(".") < 0) {
            return null;
        }
        return str.substring(str.lastIndexOf(".") + 1);
    }

    public String dealTypes(String path) {
        if (path == null) {
            return null;
        }
        String path1 = AgentCodeWriter.getLeftLastDotStr(path);
        if (path1 == null) {
            return path;
        }
        String arrStr = "";
        int arrLoc = path.indexOf("[");
        if (arrLoc > -1) {
            arrStr = path.substring(arrLoc);
            path = path.substring(0, arrLoc);
        }
        for (int i = 0; i < this.imports.size(); ++i) {
            String oldPath = (String)this.imports.get(i);
            if (path.equals(oldPath)) {
                return AgentCodeWriter.getRightLastDotStr(path) + arrStr;
            }
            String oldPath1 = AgentCodeWriter.getLeftLastDotStr(oldPath);
            String oldPath2 = AgentCodeWriter.getRightLastDotStr(oldPath);
            if (!path1.equals(oldPath1) || !"*".equals(oldPath2)) continue;
            return AgentCodeWriter.getRightLastDotStr(path) + arrStr;
        }
        this.imports.add(path);
        return AgentCodeWriter.getRightLastDotStr(path) + arrStr;
    }

    protected String getExceptions(BizExceptionCollection bizs) {
        String exceptions = "";
        for (int i = 0; i < bizs.size(); ++i) {
            if (bizs.get(i) == null || MetaDataUtils.getClassName(bizs.get(i).getClassName()).length() == 0) continue;
            this.dealTypes(bizs.get(i).getClassName());
            exceptions = exceptions + ", " + MetaDataUtils.getClassName(bizs.get(i).getClassName());
        }
        return exceptions;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Object arg = argument;
        EntityObjectInfo bo = (EntityObjectInfo)arg;
        this.initImports();
        stringBuffer.append(this.TEXT_1);
        stringBuffer.append(this.dealTypes(bo.getBusinessAgent()));
        stringBuffer.append(" extends ");
        stringBuffer.append(this.dealTypes(bo.getObjectValueClass()));
        stringBuffer.append(this.TEXT_3);
        stringBuffer.append("\"" + bo.getType() + "\"");
        stringBuffer.append(this.TEXT_4);
        stringBuffer.append(this.dealTypes(bo.getBusinessAgent()));
        stringBuffer.append(this.TEXT_5);
        stringBuffer.append(this.dealTypes(bo.getBusinessAgent()));
        stringBuffer.append(this.TEXT_6);
        stringBuffer.append(this.dealTypes(bo.getBusinessAgent()));
        stringBuffer.append(")AgentManager.find(new ");
        stringBuffer.append(this.dealTypes(bo.getBusinessAgent()));
        stringBuffer.append(this.TEXT_8);
        stringBuffer.append(this.dealTypes(bo.getBusinessAgent()));
        stringBuffer.append(this.TEXT_9);
        stringBuffer.append(this.dealTypes(bo.getBusinessAgent()));
        stringBuffer.append(")AgentManager.create(new ");
        stringBuffer.append(this.dealTypes(bo.getBusinessAgent()));
        stringBuffer.append(this.TEXT_11);
        MethodCollection mc = CodeUtil.addExceptionToMethods(bo);
        for (int i = 0; i < mc.size(); ++i) {
            MethodInfo mi = mc.get(i);
            ParameterCollection pc = mi.getParameters();
            String pcStr = "";
            String argStr = "";
            boolean genStatic = true;
            for (int k = 0; k < pc.size(); ++k) {
                ParameterInfo pi = pc.get(k);
                if (pi.getParameterType().toString().equals(bo.getObjectValueClass())) {
                    genStatic = false;
                    if (argStr.equals("")) {
                        argStr = argStr + "this";
                        continue;
                    }
                    argStr = argStr + ", this";
                    continue;
                }
                pcStr = pcStr.equals("") ? pcStr + pi.getParameterType() + " " + pi.getName() : pcStr + ", " + pi.getParameterType() + " " + pi.getName();
                argStr = argStr.equals("") ? argStr + pi.getName() : argStr + ", " + pi.getName();
            }
            String methodName = mi.getName();
            if ("getCollection".equals(mi.getName()) && bo.getBaseEntity() != null) {
                methodName = "get" + MetaDataUtils.getClassName(bo.getObjectCollectionClass());
            } else if ("getValue".equals(mi.getName()) && bo.getBaseEntity() != null) {
                methodName = "get" + MetaDataUtils.getClassName(bo.getObjectValueClass());
            }
            stringBuffer.append(this.TEXT_12);
            stringBuffer.append(genStatic ? "static " : "");
            stringBuffer.append(this.dealTypes(mi.getReturnValueType().toString()));
            stringBuffer.append(" ");
            stringBuffer.append(methodName);
            stringBuffer.append("(");
            stringBuffer.append(pcStr);
            stringBuffer.append(") throws BOSException");
            stringBuffer.append(this.getExceptions(mi.getBizExceptions()));
            stringBuffer.append(this.TEXT_16);
            stringBuffer.append(this.TEXT_17);
            stringBuffer.append(this.dealTypes(bo.getBusinessInterface()));
            stringBuffer.append(" ctrl = (");
            stringBuffer.append(this.dealTypes(bo.getBusinessInterface()));
            stringBuffer.append(")AgentContainerFactory.getInstance().getBOSObject(bosType);");
            stringBuffer.append(this.TEXT_20);
            stringBuffer.append("void".equals(mi.getReturnValueType().toString()) ? "" : "return (" + this.dealTypes(mi.getReturnValueType().toString()) + ")");
            stringBuffer.append("ctrl.");
            stringBuffer.append(methodName);
            stringBuffer.append("(");
            stringBuffer.append(argStr);
            stringBuffer.append(this.TEXT_23);
        }
        stringBuffer.append(this.TEXT_24);
        String nl = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer2 = new StringBuffer();
        String pkgName = MetaDataUtils.getPackageName(bo.getBusinessAgent());
        stringBuffer2.append("package " + pkgName + ";" + nl + nl);
        for (int i = 0; i < this.imports.size(); ++i) {
            String importStr = (String)this.imports.get(i);
            if (pkgName.equals(AgentCodeWriter.getLeftLastDotStr(importStr))) continue;
            stringBuffer2.append("import " + importStr + ";" + nl);
        }
        stringBuffer2.append(stringBuffer);
        stringBuffer = stringBuffer2;
        stringBuffer.append(this.TEXT_25);
        return stringBuffer.toString();
    }

    @Override
    protected String getClassName() {
        return MetaDataUtils.getClassName(this.bo.getBusinessAgent());
    }

    @Override
    public void write(StringBuffer in) {
    }

    @Override
    public StringBuffer write() {
        return new StringBuffer(this.generate(this.bo));
    }

    public AgentCodeWriter(EntityObjectInfo entity) {
        this.bo = entity;
    }
}

