/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;

public class CollectionCodeWriter
extends CodeWriterBase {
    public boolean isMetaData = false;
    private static final String imp1 = "import com.kingdee.bos.dao.AbstractObjectCollection";
    private static final String imp2 = "import com.kingdee.bos.dao.IObjectPK";
    private static final String imp3 = "import com.kingdee.bos.metadata.*";
    private static final String baseName = "AbstractObjectCollection";
    private static final String KEY_OBJECT = "Object";
    private EntityObjectInfo entity;

    public CollectionCodeWriter(EntityObjectInfo en) {
        this.entity = en;
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeConstructor();
        this.writeAdd();
        this.writeRemove();
        this.writeGet();
        this.writeGetByKey();
        this.writeSet();
        this.writeContains();
        this.writeContainsByKey();
        this.writeIndexOf();
        this.tabSub();
        this.writeEnd();
    }

    public void writePackage() {
        String pa = this.getPackageName(this.entity.getObjectCollectionClass());
        if (pa.length() != 0) {
            this.out.append("package");
            this.out.append(this.addBlank(pa) + ';' + '\n');
            this.out.append('\n');
        }
        this.out.append("import com.kingdee.bos.dao.AbstractObjectCollection;\n");
        if (this.isMetaData) {
            this.out.append("import com.kingdee.bos.metadata.*;\n\n");
        } else {
            this.out.append("import com.kingdee.bos.dao.IObjectPK;\n\n");
        }
    }

    public void writeClass() {
        this.out.append("public ");
        this.out.append("class");
        this.out.append(this.addBlank(this.getClassName(this.entity.getObjectCollectionClass())));
        this.out.append("extends");
        this.out.append(this.addBlank(baseName) + '\n');
    }

    @Override
    public String getClassName() {
        return super.getClassName(this.entity.getObjectCollectionClass());
    }

    public String getInfoName() {
        return super.getClassName(this.entity.getObjectValueClass());
    }

    public void writeConstructor() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank(this.getClassName()));
        this.out.append("()\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + this.getInfoName() + '.' + "class" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeAdd() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank("boolean"));
        this.out.append(this.addBracket("add", this.getInfoName() + ' ' + "item"));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + "addObject" + '(' + "item" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank("boolean"));
        this.out.append(this.addBracket("addCollection", this.getClassName() + ' ' + "item"));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + "addObjectCollection" + '(' + "item" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeRemove() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank("boolean"));
        this.out.append(this.addBracket("remove", this.getInfoName() + ' ' + "item"));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + "removeObject" + '(' + "item" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeGet() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank(this.getInfoName()));
        this.out.append(this.addBracket("get", "int index"));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + '(' + this.getInfoName() + ')' + "getObject" + '(' + "index" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeGetByKey() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank(this.getInfoName()));
        if (this.isMetaData) {
            this.out.append(this.addBracket("get", "MetaDataPK key"));
        } else {
            this.out.append(this.addBracket("get", "Object key"));
        }
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + '(' + this.getInfoName() + ')' + "getObject" + '(' + "key" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeSet() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank("void"));
        this.out.append("set(int" + this.addBlank("index") + ',' + this.addBlank(this.getInfoName()) + "item" + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "setObject" + '(' + "index" + ',' + "item" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeContains() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank("boolean"));
        this.out.append(this.addBracket("contains", this.getInfoName() + ' ' + "item"));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + "containsObject" + '(' + "item" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeContainsByKey() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank("boolean"));
        if (this.isMetaData) {
            this.out.append(this.addBracket("contains", "MetaDataPK key"));
        } else {
            this.out.append(this.addBracket("contains", "Object key"));
        }
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + "containsKey" + '(' + "key" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeIndexOf() {
        this.out.append(this.tab + "public");
        this.out.append(this.addBlank("int") + this.addBracket("indexOf", this.getInfoName() + ' ' + "item"));
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + ' ' + "super" + '.' + "indexOf" + '(' + "item" + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }
}

