/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.code.CodeUtil;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.resource.BizExceptionCollection;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class CtrlCodeWriter
extends CodeWriterBase {
    private final String imp1 = "import com.kingdee.bos.BOSException";
    private final String imp2 = "import com.kingdee.bos.metadata.*";
    private final String imp3 = "import com.kingdee.bos.framework.*";
    private final String imp4 = "import com.kingdee.bos.util.*";
    private final String imp5 = "import com.kingdee.bos.Context";
    protected BusinessObjectInfo bo;
    public boolean isMetaData = false;
    protected HashMap impMap;

    public CtrlCodeWriter(BusinessObjectInfo bo) {
        this.bo = bo;
    }

    private void initImpMap() {
        Vector vec1;
        EntityObjectInfo en;
        EntityObjectInfo superEn;
        this.impMap = new HashMap();
        this.impMap.put("import com.kingdee.bos.BOSException", null);
        if (this.isMetaData) {
            this.impMap.put("import com.kingdee.bos.metadata.*", null);
        } else {
            this.impMap.put("import com.kingdee.bos.framework.*", null);
        }
        this.impMap.put("import com.kingdee.bos.util.*", null);
        this.impMap.put("import com.kingdee.bos.Context", null);
        MethodCollection methods = this.bo.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            TypeReference tp;
            if (methods.get(i) == null) continue;
            String fullName = "";
            ParameterCollection params = methods.get(i).getParameters();
            for (int j = 0; j < params.size(); ++j) {
                if (params.get(j) == null || !this.needAddNew(this.getPackageName(fullName = this.getTypeName(tp = params.get(j).getParameterType(this.bo))), fullName)) continue;
                this.impMap.put("import " + fullName, null);
            }
            BizExceptionCollection exps = methods.get(i).getBizExceptions();
            for (int j = 0; j < exps.size(); ++j) {
                if (exps.get(j) == null || !this.needAddNew(this.getPackageName(fullName = exps.get(j).getClassName()), fullName)) continue;
                this.impMap.put("import " + fullName, null);
            }
            tp = methods.get(i).getReturnValueType(this.bo);
            fullName = this.getTypeName(tp);
            if (!this.needAddNew(this.getPackageName(fullName), fullName)) continue;
            this.impMap.put("import " + fullName, null);
        }
        this.addInheritPackageName();
        Vector vec = CodeUtil.getAddedExceptionsName(this.bo);
        if (vec != null) {
            int n = vec.size();
            for (int i = 0; i < n; ++i) {
                this.impMap.put("import " + vec.elementAt(i), null);
            }
        }
        if (this.bo instanceof EntityObjectInfo && (superEn = (en = (EntityObjectInfo)this.bo).getBaseEntity()) != null && (vec1 = CodeUtil.getSuperCollectionMethodException(superEn)) != null) {
            int n = vec1.size();
            for (int i = 0; i < n; ++i) {
                this.impMap.put("import " + vec1.elementAt(i), null);
            }
        }
    }

    protected String getTypeName(TypeReference tp) {
        if (tp.getArrayDimension() == 0) {
            return tp.toString();
        }
        return tp.getArrayElementType().toString();
    }

    protected boolean needAddNew(String packageName, String fullName) {
        if (packageName.length() == 0) {
            return false;
        }
        if (packageName.equals(this.getPackageName(this.getImpName()))) {
            return false;
        }
        return !this.impMap.containsKey("import " + fullName);
    }

    protected void addInheritPackageName() {
        String fullName = this.getBaseCtrlfullName();
        if (fullName.length() != 0 && this.needAddNew(this.getPackageName(fullName), fullName)) {
            this.impMap.put("import " + fullName, null);
        }
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en = (EntityObjectInfo)this.bo;
            String info = en.getObjectValueClass();
            if (en.getRootEntity() != null) {
                if (this.needAddNew(this.getPackageName(info), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getRootEntity().getObjectCollectionClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getRootEntity().getObjectValueClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getObjectCollectionClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
            }
        }
    }

    @Override
    public void write(StringBuffer in) {
        this.initImpMap();
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeConstructor();
        this.writeMethods();
        this.tabSub();
        this.writeEnd();
    }

    protected void writeConstructor() {
    }

    protected String getImpName() {
        return this.bo.getBusinessInterface() == null ? "" : this.bo.getBusinessInterface();
    }

    @Override
    public String getClassName() {
        if (StringUtils.isEmpty((String)this.bo.getBusinessControllerName())) {
            return "";
        }
        return this.getClassName(this.getImpName());
    }

    protected String getBaseCtrlfullName() {
        FacadeInfo en;
        String name = "";
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en2 = (EntityObjectInfo)this.bo;
            if (en2.getBaseEntity() != null) {
                name = en2.getBaseEntity().getBusinessInterface() == null ? "" : en2.getBaseEntity().getBusinessInterface();
            }
        } else if (this.bo instanceof FacadeInfo && (en = (FacadeInfo)this.bo).getBaseFacade() != null) {
            name = en.getBaseFacade().getBusinessInterface() == null ? "" : en.getBaseFacade().getBusinessInterface();
        }
        return name;
    }

    protected String getSubClassMode() {
        if (this.bo.getSubClassingMode() == null || this.bo.getSubClassingMode().toString().length() == 0) {
            return "";
        }
        String subClassMode = this.bo.getSubClassingMode().getName();
        if (subClassMode.equalsIgnoreCase("normal")) {
            subClassMode = "";
        }
        return subClassMode;
    }

    protected void writePackage() {
        String pa = this.getPackageName(this.getImpName());
        if (pa.length() != 0) {
            this.out.append("package");
            this.out.append(this.addBlank(pa) + ';' + '\n' + '\n');
        }
        Iterator it = this.impMap.keySet().iterator();
        while (it.hasNext()) {
            this.out.append((String)it.next() + ';' + '\n');
        }
        this.out.append("\n");
    }

    protected void writeClass() {
        this.out.append("public ");
        this.out.append("interface");
        this.out.append(this.addBlank(this.getClassName()));
        this.out.append("extends");
        String baseEnName = this.getBaseCtrlfullName();
        if (baseEnName.length() == 0) {
            if (this.isMetaData) {
                this.out.append(this.addBlank("IMetaDataCtrl") + '\n');
            } else {
                this.out.append(this.addBlank("IBizCtrl") + '\n');
            }
        } else {
            this.out.append(this.addBlank(this.getClassName(baseEnName)) + '\n');
        }
    }

    protected void writeMethods() {
        MethodCollection methods = CodeUtil.addExceptionToMethods(this.bo);
        for (int i = 0; i < methods.size(); ++i) {
            MethodInfo method = methods.get(i);
            this.writeMethod(method);
        }
    }

    protected boolean isHeriateNeeded(MethodInfo method) {
        return this.bo instanceof EntityObjectInfo && ((EntityObjectInfo)this.bo).getRootEntity() != null && this.bo.isSystemMethod(method) && (method.getName().equalsIgnoreCase("getValue") || method.getName().equalsIgnoreCase("getCollection"));
    }

    protected void writeMethod(MethodInfo method) {
        TypeReference tp = method.getReturnValueType(this.bo);
        String name = this.getMethodName(method, this.bo);
        this.out.append(this.tab + "");
        this.out.append("public" + this.addBlank(this.getClassName(tp.toString())));
        this.out.append(name);
        this.out.append("(");
        this.writeParams(method.getParameters());
        this.out.append(")");
        this.out.append("throws" + this.addBlank("BOSException"));
        this.writeExceptions(method.getBizExceptions());
        this.out.append(";\n");
    }

    protected void writeMethodNote(MethodInfo method) {
        this.out.append(this.tab + "/**" + '\n');
        this.out.append(this.tab + "*" + ' ' + this.getMethodDescription(method));
        if (this.bo.isSystemMethod(method)) {
            this.out.append(" -System defined method\n");
        } else {
            this.out.append(" - User defined method\n");
        }
        for (int i = 0; i < method.getParameters().size(); ++i) {
            ParameterInfo param = method.getParameters().get(i);
            this.out.append(this.tab + "*@param" + ' ' + param.getName() + ' ' + this.getParamDescription(param) + '\n');
        }
        if (!method.getReturnValueType(this.bo).toString().equals("void")) {
            this.out.append(this.tab + "*@return" + '\n');
        }
        this.out.append(this.tab + "*/" + '\n');
    }

    private String getParamDescription(ParameterInfo method) {
        if (method.getDescription() != null && method.getDescription().length() != 0) {
            return method.getDescription();
        }
        if (method.getAlias() != null && method.getAlias().length() != 0) {
            return method.getAlias();
        }
        return method.getName();
    }

    private String getMethodDescription(MethodInfo method) {
        if (method.getDescription() != null && method.getDescription().length() != 0) {
            return method.getDescription();
        }
        if (method.getAlias() != null && method.getAlias().length() != 0) {
            return method.getAlias();
        }
        return method.getName();
    }

    protected void writeParams(ParameterCollection params) {
        for (int i = 0; i < params.size(); ++i) {
            ParameterInfo param = params.get(i);
            if (i != 0) {
                this.out.append(",");
            }
            this.out.append(this.getClassName(param.getParameterType(this.bo).toString()) + this.addBlank(param.getName()));
        }
    }

    protected void writeExceptions(BizExceptionCollection bizs) {
        for (int i = 0; i < bizs.size(); ++i) {
            if (bizs.get(i) == null || this.getClassName(bizs.get(i).getClassName()).length() == 0) continue;
            this.out.append(",");
            this.out.append(this.getClassName(bizs.get(i).getClassName()));
        }
    }

    protected void writeSystemMethod(MethodInfo method) {
    }

    protected void writeSystemMethods() {
    }

    public String getInfoName() {
        if (this.bo instanceof EntityObjectInfo) {
            return ((EntityObjectInfo)this.bo).getObjectValueClass();
        }
        return "";
    }

    public String getCollectionName() {
        if (this.bo instanceof EntityObjectInfo) {
            return ((EntityObjectInfo)this.bo).getObjectCollectionClass();
        }
        return "";
    }
}

