/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class HMDUICodeWriter
extends CodeWriterBase {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.code.HMDUICodeWriter");
    private UIObjectInfo model;
    private ComponentCollection components;
    private static final String imp1 = "com.kingdee.eas.framework.client.multiDetail.Bill";
    private static final String imp2 = "com.kingdee.eas.framework.BillBaseInfo";

    public HMDUICodeWriter(UIObjectInfo model) {
        this.model = model;
        this.components = this.treeToCol(model.getComponents());
    }

    protected void writePackage() {
        this.out.append(this.writeNote("output package name", new String[0], ""));
        if (this.model.getReleasePackage() != null) {
            this.out.append("package " + this.model.getReleasePackage() + ';' + '\n');
        }
        this.out.append('\n');
        this.out.append("import com.kingdee.eas.framework.client.multiDetail.Bill;\n");
        this.out.append("import com.kingdee.eas.framework.BillBaseInfo;\n");
    }

    private void writeClass() {
        this.out.append(this.writeNote("output class name", new String[0], ""));
        this.out.append("public" + this.addBlank("class"));
        this.out.append(this.getClassName());
        this.out.append(this.addBlank("extends"));
        this.out.append("Bill");
        this.out.append('\n');
    }

    private void writeConstruct() {
        this.out.append('\n');
        this.out.append(this.writeNote("output class constructor", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + this.getClassName() + '(' + ')' + ' ' + "throws Exception" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeGetBillBase() {
        IObjectValue objValue;
        if (this.model.getDataObjects().size() > 0 && (objValue = this.model.getDataObjects().get(0).getInstance()) != null && objValue instanceof EntityObjectInfo) {
            this.out.append('\n');
            this.out.append(this.writeNote("output getBillBase method", new String[0], ""));
            this.out.append(this.tab + "public BillBaseInfo getBillBase()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return new " + ((EntityObjectInfo)objValue).getBusinessImplName() + "Info();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    private void writeAddBillDetails() {
        this.out.append('\n');
        this.out.append(this.writeNote("output addBillDetails method", new String[0], ""));
        this.out.append(this.tab + "public void addBillDetails()" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "try" + '\n');
        this.writeBegin();
        this.tabAdd();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            String uiObjectPK;
            ComponentInfo cInfo = this.components.get(i);
            if (cInfo.getClassType() == null || !cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDPanel") || StringUtils.isEmpty((String)cInfo.getBimUIObjectPK()) || StringUtils.isEmpty((String)(uiObjectPK = cInfo.getBimUIObjectPK()))) continue;
            Context ctx = ContextManager.getContext();
            UIObjectCtrl uiCtrl = new UIObjectCtrl(ctx);
            UIObjectInfo entryUI = null;
            try {
                entryUI = uiCtrl.getValueNotCache(MetaDataPK.create(uiObjectPK));
                if (entryUI == null) continue;
                if (!StringUtils.isEmpty((String)(entryUI = UIObjectAssembler.assembleUI(ctx, entryUI)).getReleasePackage())) {
                    this.out.append(this.tab + "this.addBillDetail(new " + entryUI.getReleasePackage() + "." + entryUI.getReleaseClass() + "());" + '\n');
                    continue;
                }
                this.out.append(this.tab + "this.addBillDetail(new " + entryUI.getReleaseClass() + "());" + '\n');
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        this.tabSub();
        this.writeEnd();
        this.out.append(this.tab + "catch (Exception ex)" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.tabSub();
        this.writeEnd();
        this.tabSub();
        this.writeEnd();
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeConstruct();
        this.writeGetBillBase();
        this.writeAddBillDetails();
        this.tabSub();
        this.writeEnd();
    }

    private void writeEASMethods() {
        String entityFactoryName;
        String editUIName = this.model.getExtendedProperty("editUIName");
        if (StringUtils.isEmpty((String)editUIName)) {
            editUIName = ConvertUtils.getBizUnitOAKPK(this.model.getBizUnitPK(), "editUIPK");
        }
        if (!StringUtils.isEmpty((String)editUIName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output getEditUIName method", new String[0], ""));
            this.out.append(this.tab + "protected String getEditUIName()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return " + editUIName + ".class.getName();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
        if (StringUtils.isEmpty((String)(entityFactoryName = this.model.getExtendedProperty("entityFactoryName")))) {
            entityFactoryName = ConvertUtils.getEntityFactoryName(this.model.getBizUnitPK(), this.model.getFullName());
        }
        if (!StringUtils.isEmpty((String)entityFactoryName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output getBizInterface method", new String[0], ""));
            this.out.append(this.tab + "protected com.kingdee.eas.framework.ICoreBase getBizInterface() throws Exception" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return " + entityFactoryName + ".getRemoteInstance();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
        String sUIType = ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName());
        String sTemplateType = ConvertUtils.getBimTemplateType(this.model.getBizUnitPK());
        String entityClassName = this.model.getExtendedProperty("entityClassName");
        if (StringUtils.isEmpty((String)entityClassName)) {
            entityClassName = ConvertUtils.getEntityClassName(this.model.getBizUnitPK(), this.model.getFullName());
        }
        if (!StringUtils.isEmpty((String)sUIType)) {
            if ("ListUI".equalsIgnoreCase(sUIType)) {
                if (!StringUtils.isEmpty((String)sTemplateType)) {
                    if ("TreeBase".equalsIgnoreCase(sTemplateType) && !StringUtils.isEmpty((String)entityFactoryName)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getTreeInterface method", new String[0], ""));
                        this.out.append(this.tab + "protected ITreeBase getTreeInterface() throws Exception" + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "return " + entityFactoryName + ".getRemoteInstance();" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getLongNumberFieldName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getLongNumberFieldName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " return \"longNumber\";" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getRootName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getRootName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        String sTitle = this.model.getAlias();
                        if (sTitle != null) {
                            this.out.append(this.tab + " return \"" + sTitle + "\";" + '\n');
                        } else {
                            this.out.append(this.tab + " return \"root\";" + '\n');
                        }
                        this.tabSub();
                        this.writeEnd();
                    } else if ("TreeDetail".equalsIgnoreCase(sTemplateType) && !StringUtils.isEmpty((String)entityFactoryName)) {
                        String sGroupEditUIName;
                        String sGroupEntityFactoryName = ConvertUtils.getBimGroupEntityFactoryName(this.model.getBizUnitPK());
                        if (!StringUtils.isEmpty((String)sGroupEntityFactoryName)) {
                            this.out.append('\n');
                            this.out.append(this.writeNote("output getTreeInterface method", new String[0], ""));
                            this.out.append(this.tab + "protected ITreeBase getTreeInterface() throws Exception" + '\n');
                            this.writeBegin();
                            this.tabAdd();
                            this.out.append(this.tab + "return " + sGroupEntityFactoryName + ".getRemoteInstance();" + '\n');
                            this.tabSub();
                            this.writeEnd();
                        }
                        if (!StringUtils.isEmpty((String)(sGroupEditUIName = ConvertUtils.getBimGroupEditUIName(this.model.getBizUnitPK())))) {
                            this.out.append('\n');
                            this.out.append(this.writeNote("output getGroupEditUIName method", new String[0], ""));
                            this.out.append(this.tab + "protected String getGroupEditUIName() " + '\n');
                            this.writeBegin();
                            this.tabAdd();
                            this.out.append(this.tab + " return " + sGroupEditUIName.trim() + ".class.getName();" + '\n');
                            this.tabSub();
                            this.writeEnd();
                        }
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getQueryFieldName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getQueryFieldName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " return \"treeid.id\";" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getKeyFieldName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getKeyFieldName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " return \"id\";" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getRootName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getRootName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        String sTitle = this.model.getAlias();
                        if (sTitle != null) {
                            this.out.append(this.tab + " return \"" + sTitle + "\";" + '\n');
                        } else {
                            this.out.append(this.tab + " return \"root\";" + '\n');
                        }
                        this.tabSub();
                        this.writeEnd();
                    } else if ("BillBase".equalsIgnoreCase(sTemplateType)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getKeyFieldName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getKeyFieldName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " return \"id\";" + '\n');
                        this.tabSub();
                        this.writeEnd();
                    }
                }
            } else if ("EditUI".equalsIgnoreCase(sUIType) && !StringUtils.isEmpty((String)sTemplateType)) {
                if ("TreeBase".equalsIgnoreCase(sTemplateType)) {
                    this.out.append('\n');
                    this.out.append(this.writeNote("output SelectorItemCollection method", new String[0], ""));
                    this.out.append(this.tab + "public SelectorItemCollection getSelectors() " + '\n');
                    this.writeBegin();
                    this.tabAdd();
                    this.out.append(this.tab + "SelectorItemCollection selectors = super.getSelectors();" + '\n');
                    this.out.append(this.tab + "selectors.add(new SelectorItemInfo(\"longNumber\"));" + '\n');
                    this.out.append(this.tab + "selectors.add(new SelectorItemInfo(\"parent.*\"));" + '\n');
                    this.out.append(this.tab + "return selectors;" + '\n');
                    this.tabSub();
                    this.writeEnd();
                    this.out.append('\n');
                    this.out.append(this.writeNote("output setDataObject method", new String[0], ""));
                    this.out.append(this.tab + "public void setDataObject(IObjectValue dataObject) " + '\n');
                    this.writeBegin();
                    this.tabAdd();
                    this.out.append(this.tab + "if(STATUS_ADDNEW.equals(getOprtState()))" + '\n');
                    this.writeBegin();
                    this.tabAdd();
                    this.out.append(this.tab + " dataObject.put(\"parent\", getUIContext().get(UIContext.PARENTNODE));" + '\n');
                    this.tabSub();
                    this.writeEnd();
                    this.out.append(this.tab + "super.setDataObject(dataObject);" + '\n');
                    this.tabSub();
                    this.writeEnd();
                } else if ("TreeDetail".equalsIgnoreCase(sTemplateType)) {
                    String sISRelationObject = this.model.getExtendedProperty("bimIsRelationObject");
                    String sbimGroupEntityName = ConvertUtils.getBimGroupEntityName(this.model.getBizUnitPK());
                    if (!StringUtils.isEmpty((String)sbimGroupEntityName) && !"true".equalsIgnoreCase(sISRelationObject)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output setDataObject method", new String[0], ""));
                        this.out.append(this.tab + "public void setDataObject(IObjectValue dataObject) " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "super.setDataObject(dataObject);" + '\n');
                        this.tabAdd();
                        this.out.append(this.tab + "if(STATUS_ADDNEW.equals(getOprtState()))" + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " editData.put(\"treeid\",(" + sbimGroupEntityName.trim() + ")getUIContext().get(UIContext.PARENTNODE));" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.tabSub();
                        this.writeEnd();
                    }
                    String sGroupEntityFactoryName = ConvertUtils.getBimGroupEntityFactoryName(this.model.getBizUnitPK());
                    if (!StringUtils.isEmpty((String)sISRelationObject) && "true".equalsIgnoreCase(sISRelationObject) && !StringUtils.isEmpty((String)sGroupEntityFactoryName)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getTreeInterface method", new String[0], ""));
                        this.out.append(this.tab + "protected ITreeBase getTreeInterface() throws Exception" + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "return " + sGroupEntityFactoryName + ".getRemoteInstance();" + '\n');
                        this.tabSub();
                        this.writeEnd();
                    }
                } else if ("BillBase".equalsIgnoreCase(sTemplateType)) {
                    this.out.append('\n');
                    this.out.append(this.writeNote("output getDetailTable method", new String[0], ""));
                    this.out.append(this.tab + "protected KDTable getDetailTable() " + '\n');
                    this.writeBegin();
                    this.tabAdd();
                    this.out.append(this.tab + "return this.kdtEntrys;" + '\n');
                    this.tabSub();
                    this.writeEnd();
                    String sDetailEntityClassName = ConvertUtils.getBimDetailEntityClassName(this.model.getBizUnitPK());
                    if (!StringUtils.isEmpty((String)sDetailEntityClassName)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output createNewDetailData method", new String[0], ""));
                        this.out.append(this.tab + "protected IObjectValue createNewDetailData(KDTable table)" + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "return new " + sDetailEntityClassName.trim() + "();" + '\n');
                        this.tabSub();
                        this.writeEnd();
                    }
                }
            }
        }
        if (!StringUtils.isEmpty((String)entityClassName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output createNewData method", new String[0], ""));
            this.out.append(this.tab + "protected com.kingdee.bos.dao.IObjectValue createNewData()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return new " + entityClassName + "();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    private ComponentCollection treeToCol(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(components.get(i), col);
        }
        return col;
    }

    private void addToCol(ComponentInfo info, ComponentCollection col) {
        int n = info.getComponents().size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(info.getComponents().get(i), col);
        }
        col.add(info);
    }

    @Override
    protected String getClassName() {
        return StringUtils.replace((String)this.model.getReleaseClass(), (String)"EditUI", (String)"") + "HMD";
    }
}

