/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

class MyJETEmitter
extends JETEmitter {
    private List mClasspathEntries = new ArrayList();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.code.MyJETEmitter");

    public MyJETEmitter(String templateURI) {
        super(templateURI);
    }

    public MyJETEmitter(String[] templateURIPath, String relativeTemplateURI) {
        super(templateURIPath, relativeTemplateURI);
    }

    public void addClasspathVariable(String variableName, String pluginID) throws JETException {
        IPluginDescriptor descriptor = Platform.getPlugin((String)pluginID).getDescriptor();
        ILibrary[] libraries = descriptor.getRuntimeLibraries();
        for (int i = 0; i < libraries.length; ++i) {
            if (!libraries[i].getType().equals("code")) continue;
            URL url = null;
            try {
                url = new URL(descriptor.getInstallURL(), libraries[i].getPath().toString());
            }
            catch (MalformedURLException e) {
                throw new JETException((Throwable)e);
            }
            try {
                Path path = new Path(Platform.asLocalURL((URL)url).getFile());
                if (path.equals(JavaCore.getClasspathVariable((String)variableName))) break;
                JavaCore.setClasspathVariable((String)variableName, (IPath)path, null);
                break;
            }
            catch (JavaModelException e) {
                throw new JETException((Throwable)e);
            }
            catch (IOException e) {
                throw new JETException("Could not resolve URL " + url + " as a JAR file. Library path must point to an existing JAR file.", (Throwable)e);
            }
        }
        IClasspathEntry entry = JavaCore.newVariableEntry((IPath)new Path(variableName), null, null);
        this.addClasspathEntry(entry);
    }

    public void addClasspathEntry(IClasspathEntry entry) {
        this.mClasspathEntries.add(entry);
    }

    public void initialize(IProgressMonitor progressMonitor) throws JETException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(".JETEmitters");
        if (!project.exists()) {
            super.initialize(progressMonitor);
        }
        try {
            project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] existing = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = this.addMissing(existing);
            if (newEntries.length > existing.length) {
                javaProject.setRawClasspath(newEntries, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            }
        }
        catch (CoreException e) {
            throw new JETException((Throwable)e);
        }
        super.initialize(progressMonitor);
    }

    private IClasspathEntry[] addMissing(IClasspathEntry[] existing) {
        if (this.mClasspathEntries.isEmpty()) {
            return existing;
        }
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>(this.mClasspathEntries.size() + existing.length);
        result.addAll(Arrays.asList(existing));
        for (IClasspathEntry entry : this.mClasspathEntries) {
            if (result.contains(entry)) continue;
            logger.debug((Object)("Adding '" + entry + "' to '" + result + "'"));
            result.add(entry);
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    private static String toAppPackage(String packageName) {
        if (StringUtils.isEmpty((String)packageName)) {
            return "";
        }
        if (packageName.indexOf(".client") >= 0) {
            return StringUtils.replace((String)packageName, (String)".client", (String)".app");
        }
        return packageName;
    }
}

