/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.util.StringUtils;

public class UICodeWriter
extends CodeWriterBase {
    private UIObjectInfo model;
    private ComponentCollection components;
    private static final String imp1 = "java.awt.event.*";
    private static final String imp2 = "com.kingdee.eas.framework.*";
    private static final String imp3 = "com.kingdee.bos.dao.IObjectValue";
    private static final String imp4 = "com.kingdee.bos.metadata.entity.SelectorItemCollection";
    private static final String imp5 = "com.kingdee.bos.metadata.entity.SelectorItemInfo";
    private static final String imp6 = "com.kingdee.bos.ctrl.kdf.table.KDTable";
    private static final String imp7 = "com.kingdee.eas.common.client.OprtState";
    private static final String imp8 = "com.kingdee.eas.common.client.UIContext";

    public UICodeWriter(UIObjectInfo model) {
        this.model = model;
        this.components = this.treeToCol(model.getComponents());
    }

    protected void writePackage() {
        this.out.append(this.writeNote("output package name", new String[0], ""));
        if (this.model.getReleasePackage() != null) {
            this.out.append("package " + this.model.getReleasePackage() + ';' + '\n');
        }
        this.out.append('\n');
        this.out.append("import java.awt.event.*;\n");
        this.writeBimPackage();
    }

    protected void writeBimPackage() {
        String sParentName;
        String sUIType = ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName());
        String sTemplateType = ConvertUtils.getBimTemplateType(this.model.getBizUnitPK());
        String sTreeEditUI = ConvertUtils.getBimGroupEditUIName(this.model.getBizUnitPK());
        boolean bImportFrameWork = false;
        if (this.model.getParent() != null && !StringUtils.isEmpty((String)(sParentName = this.model.getParent().getPackage())) && sParentName.indexOf("com.kingdee.eas.framework") >= 0) {
            bImportFrameWork = true;
        }
        if (bImportFrameWork) {
            this.out.append("import com.kingdee.eas.framework.*;\n");
            this.out.append("import com.kingdee.bos.dao.IObjectValue;\n");
        }
        if (!StringUtils.isEmpty((String)sUIType)) {
            if ("ListUI".equalsIgnoreCase(sUIType)) {
                if (!StringUtils.isEmpty((String)sTemplateType) && !"BillBase".equalsIgnoreCase(sTemplateType) && "TreeDetail".equalsIgnoreCase(sTemplateType)) {
                    this.out.append("import com.kingdee.bos.metadata.entity.SelectorItemCollection;\n");
                    this.out.append("import com.kingdee.bos.metadata.entity.SelectorItemInfo;\n");
                    this.out.append("import com.kingdee.eas.common.client.OprtState;\n");
                    this.out.append("import com.kingdee.eas.common.client.UIContext;\n");
                }
            } else if ("EditUI".equalsIgnoreCase(sUIType) && !StringUtils.isEmpty((String)sTemplateType)) {
                if ("TreeBase".equalsIgnoreCase(sTemplateType)) {
                    this.out.append("import com.kingdee.bos.metadata.entity.SelectorItemCollection;\n");
                    this.out.append("import com.kingdee.bos.metadata.entity.SelectorItemInfo;\n");
                    this.out.append("import com.kingdee.eas.common.client.OprtState;\n");
                    this.out.append("import com.kingdee.eas.common.client.UIContext;\n");
                } else if ("TreeDetail".equalsIgnoreCase(sTemplateType)) {
                    this.out.append("import com.kingdee.bos.metadata.entity.SelectorItemCollection;\n");
                    this.out.append("import com.kingdee.bos.metadata.entity.SelectorItemInfo;\n");
                    this.out.append("import com.kingdee.eas.common.client.OprtState;\n");
                    this.out.append("import com.kingdee.eas.common.client.UIContext;\n");
                } else if ("BillBase".equalsIgnoreCase(sTemplateType)) {
                    this.out.append("import com.kingdee.bos.ctrl.kdf.table.KDTable;\n");
                }
            }
        }
    }

    private void writeClass() {
        this.out.append(this.writeNote("output class name", new String[0], ""));
        this.out.append("public" + this.addBlank("class"));
        this.out.append(this.model.getReleaseClass());
        this.out.append(this.addBlank("extends"));
        this.out.append("Abstract" + this.model.getReleaseClass());
        this.out.append('\n');
    }

    private void writeConstruct() {
        this.out.append('\n');
        this.out.append(this.writeNote("output class constructor", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + this.model.getReleaseClass() + '(' + ')' + ' ' + "throws Exception" + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super" + '(' + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeLoadFunction() {
        this.out.append('\n');
        this.out.append(this.writeNote("output loadFields method", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + "void" + ' ' + "loadFields" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        String sUIType = ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName());
        String sTemplateType = ConvertUtils.getBimTemplateType(this.model.getBizUnitPK());
        if (!StringUtils.isEmpty((String)sUIType) && "EditUI".equalsIgnoreCase(sUIType) && !StringUtils.isEmpty((String)sTemplateType) && ("BillBase".equalsIgnoreCase(sTemplateType) || "MBillBase".equalsIgnoreCase(sTemplateType))) {
            this.out.append(this.tab + "setAutoNumber();" + '\n');
        }
        this.out.append(this.tab + "super.loadFields();" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeStoreFunction() {
        this.out.append('\n');
        this.out.append(this.writeNote("output storeFields method", new String[0], ""));
        this.out.append(this.tab + "public" + ' ' + "void" + ' ' + "storeFields" + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "super.storeFields();" + '\n');
        this.tabSub();
        this.writeEnd();
    }

    private void writeMethods() {
        int m = this.components.size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            int n = cInfo.getEventBindings().size();
            for (int j = 0; j < n; ++j) {
                EventBindingInfo ebInfo = cInfo.getEventBindings().get(j);
                this.out.append('\n');
                this.out.append(this.writeNote("output " + ebInfo.getMethodName() + " method", new String[0], ""));
                this.out.append(this.tab + "protected void " + ebInfo.getMethodName() + "(" + ebInfo.getEventType() + " e) throws Exception" + '\n');
                this.writeBegin();
                this.tabAdd();
                this.out.append(this.tab + "super." + ebInfo.getMethodName() + "(e);" + '\n');
                this.tabSub();
                this.writeEnd();
            }
        }
    }

    private void writeActionPerformed() {
        int n = this.model.getActions().size();
        for (int i = 0; i < n; ++i) {
            ActionInfo action = this.model.getActions().get(i);
            this.out.append('\n');
            this.out.append(this.writeNote("output " + this.locastName(action.getClassName()) + "_actionPerformed", new String[0], ""));
            this.out.append(this.tab + "public void " + this.locastName(action.getClassName()) + "_actionPerformed(ActionEvent e) throws Exception " + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "super." + this.locastName(action.getClassName()) + "_actionPerformed(e);" + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    @Override
    protected String getClassName() {
        return this.model.getReleaseClass();
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeConstruct();
        this.writeLoadFunction();
        this.writeStoreFunction();
        this.writeMethods();
        this.writeActionPerformed();
        this.writeEASMethods();
        this.writeCodeRuleFunction();
        this.tabSub();
        this.writeEnd();
    }

    private void writeCodeRuleFunction() {
        String sUIType = ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName());
        String sTemplateType = ConvertUtils.getBimTemplateType(this.model.getBizUnitPK());
        if (!StringUtils.isEmpty((String)sUIType) && "EditUI".equalsIgnoreCase(sUIType) && !StringUtils.isEmpty((String)sTemplateType) && ("BillBase".equalsIgnoreCase(sTemplateType) || "MBillBase".equalsIgnoreCase(sTemplateType))) {
            this.out.append('\n');
            this.out.append(this.writeNote("output setAutoNumber method", new String[0], ""));
            this.out.append(this.tab + "private void setAutoNumber() {" + '\n');
            this.out.append(this.tab + "\tif (editData.getNumber() == null) {" + '\n');
            this.out.append(this.tab + "\t\tString sysNumber = null;" + '\n');
            this.out.append(this.tab + "\t\ttry {" + '\n');
            this.out.append(this.tab + "\t\t\tsysNumber = com.kingdee.eas.framework.FrameWorkUtils.getCodeRuleClient(editData,((com.kingdee.eas.basedata.org.CompanyOrgUnitInfo)com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentFIUnit()).getId().toString());" + '\n');
            this.out.append(this.tab + "    \t}" + '\n');
            this.out.append(this.tab + "\t\tcatch (Exception e) {" + '\n');
            this.out.append(this.tab + "\t\t\thandUIException(e);" + '\n');
            this.out.append(this.tab + "\t\t}" + '\n');
            this.out.append(this.tab + "\t\tif (sysNumber != null && sysNumber.trim().length() > 0) {" + '\n');
            this.out.append(this.tab + "\t\t\teditData.setNumber(sysNumber);" + '\n');
            this.out.append(this.tab + "\t\t\ttxtNumber.setEnabled(false);" + '\n');
            this.out.append(this.tab + "\t\t}" + '\n');
            this.out.append(this.tab + "\t\telse {" + '\n');
            this.out.append(this.tab + "\t\t\ttxtNumber.setEnabled(true);" + '\n');
            this.out.append(this.tab + "\t\t}" + '\n');
            this.out.append(this.tab + "\t}" + '\n');
            this.out.append(this.tab + "\telse {" + '\n');
            this.out.append(this.tab + "\t\tif (editData.getNumber().trim().length() > 0) {" + '\n');
            this.out.append(this.tab + "\t\t\ttxtNumber.setText(editData.getNumber());" + '\n');
            this.out.append(this.tab + "\t\t\ttxtNumber.setEnabled(false);" + '\n');
            this.out.append(this.tab + "\t\t}" + '\n');
            this.out.append(this.tab + "\t\telse {" + '\n');
            this.out.append(this.tab + "\t\t\ttxtNumber.setEnabled(true);" + '\n');
            this.out.append(this.tab + "\t\t}" + '\n');
            this.out.append(this.tab + "\t}" + '\n');
            this.out.append(this.tab + "}" + '\n');
        }
    }

    private void writeEASMethods() {
        String entityFactoryName;
        String editUIName = this.model.getExtendedProperty("editUIName");
        if (StringUtils.isEmpty((String)editUIName)) {
            editUIName = ConvertUtils.getBizUnitOAKPK(this.model.getBizUnitPK(), "editUIPK");
        }
        if (!StringUtils.isEmpty((String)editUIName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output getEditUIName method", new String[0], ""));
            this.out.append(this.tab + "protected String getEditUIName()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return " + editUIName + ".class.getName();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
        if (StringUtils.isEmpty((String)(entityFactoryName = this.model.getExtendedProperty("entityFactoryName")))) {
            entityFactoryName = ConvertUtils.getEntityFactoryName(this.model.getBizUnitPK(), this.model.getFullName());
        }
        if (!StringUtils.isEmpty((String)entityFactoryName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output getBizInterface method", new String[0], ""));
            this.out.append(this.tab + "protected com.kingdee.eas.framework.ICoreBase getBizInterface() throws Exception" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + "return " + entityFactoryName + ".getRemoteInstance();" + '\n');
            this.tabSub();
            this.writeEnd();
        }
        String sUIType = ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName());
        String sTemplateType = ConvertUtils.getBimTemplateType(this.model.getBizUnitPK());
        String entityClassName = this.model.getExtendedProperty("entityClassName");
        if (StringUtils.isEmpty((String)entityClassName)) {
            entityClassName = ConvertUtils.getEntityClassName(this.model.getBizUnitPK(), this.model.getFullName());
        }
        if (!StringUtils.isEmpty((String)sUIType)) {
            if ("ListUI".equalsIgnoreCase(sUIType)) {
                if (!StringUtils.isEmpty((String)sTemplateType)) {
                    if ("TreeBase".equalsIgnoreCase(sTemplateType) && !StringUtils.isEmpty((String)entityFactoryName)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getTreeInterface method", new String[0], ""));
                        this.out.append(this.tab + "protected ITreeBase getTreeInterface() throws Exception" + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "return " + entityFactoryName + ".getRemoteInstance();" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getLongNumberFieldName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getLongNumberFieldName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " return \"longNumber\";" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getRootName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getRootName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        String sTitle = this.model.getAlias();
                        if (sTitle != null) {
                            this.out.append(this.tab + " return \"" + sTitle + "\";" + '\n');
                        } else {
                            this.out.append(this.tab + " return \"root\";" + '\n');
                        }
                        this.tabSub();
                        this.writeEnd();
                    } else if ("TreeDetail".equalsIgnoreCase(sTemplateType) && !StringUtils.isEmpty((String)entityFactoryName)) {
                        String sGroupEditUIName;
                        String sGroupEntityFactoryName = ConvertUtils.getBimGroupEntityFactoryName(this.model.getBizUnitPK());
                        if (!StringUtils.isEmpty((String)sGroupEntityFactoryName)) {
                            this.out.append('\n');
                            this.out.append(this.writeNote("output getTreeInterface method", new String[0], ""));
                            this.out.append(this.tab + "protected ITreeBase getTreeInterface() throws Exception" + '\n');
                            this.writeBegin();
                            this.tabAdd();
                            this.out.append(this.tab + "return " + sGroupEntityFactoryName + ".getRemoteInstance();" + '\n');
                            this.tabSub();
                            this.writeEnd();
                        }
                        if (!StringUtils.isEmpty((String)(sGroupEditUIName = ConvertUtils.getBimGroupEditUIName(this.model.getBizUnitPK())))) {
                            this.out.append('\n');
                            this.out.append(this.writeNote("output getGroupEditUIName method", new String[0], ""));
                            this.out.append(this.tab + "protected String getGroupEditUIName() " + '\n');
                            this.writeBegin();
                            this.tabAdd();
                            this.out.append(this.tab + " return " + sGroupEditUIName.trim() + ".class.getName();" + '\n');
                            this.tabSub();
                            this.writeEnd();
                        }
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getQueryFieldName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getQueryFieldName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " return \"treeid.id\";" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getKeyFieldName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getKeyFieldName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " return \"id\";" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getRootName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getRootName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        String sTitle = this.model.getAlias();
                        if (sTitle != null) {
                            this.out.append(this.tab + " return \"" + sTitle + "\";" + '\n');
                        } else {
                            this.out.append(this.tab + " return \"root\";" + '\n');
                        }
                        this.tabSub();
                        this.writeEnd();
                    } else if ("BillBase".equalsIgnoreCase(sTemplateType)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getKeyFieldName method", new String[0], ""));
                        this.out.append(this.tab + "protected String getKeyFieldName() " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " return \"id\";" + '\n');
                        this.tabSub();
                        this.writeEnd();
                    }
                }
            } else if ("EditUI".equalsIgnoreCase(sUIType) && !StringUtils.isEmpty((String)sTemplateType)) {
                if ("TreeBase".equalsIgnoreCase(sTemplateType)) {
                    this.out.append('\n');
                    this.out.append(this.writeNote("output SelectorItemCollection method", new String[0], ""));
                    this.out.append(this.tab + "public SelectorItemCollection getSelectors() " + '\n');
                    this.writeBegin();
                    this.tabAdd();
                    this.out.append(this.tab + "SelectorItemCollection selectors = super.getSelectors();" + '\n');
                    this.out.append(this.tab + "selectors.add(new SelectorItemInfo(\"longNumber\"));" + '\n');
                    this.out.append(this.tab + "selectors.add(new SelectorItemInfo(\"parent.*\"));" + '\n');
                    this.out.append(this.tab + "return selectors;" + '\n');
                    this.tabSub();
                    this.writeEnd();
                    this.out.append('\n');
                    this.out.append(this.writeNote("output setDataObject method", new String[0], ""));
                    this.out.append(this.tab + "public void setDataObject(IObjectValue dataObject) " + '\n');
                    this.writeBegin();
                    this.tabAdd();
                    this.out.append(this.tab + "if(STATUS_ADDNEW.equals(getOprtState()))" + '\n');
                    this.writeBegin();
                    this.tabAdd();
                    this.out.append(this.tab + " dataObject.put(\"parent\", getUIContext().get(UIContext.PARENTNODE));" + '\n');
                    this.tabSub();
                    this.writeEnd();
                    this.out.append(this.tab + "super.setDataObject(dataObject);" + '\n');
                    this.tabSub();
                    this.writeEnd();
                } else if ("TreeDetail".equalsIgnoreCase(sTemplateType)) {
                    String sISRelationObject = this.model.getExtendedProperty("bimIsRelationObject");
                    String sbimGroupEntityName = ConvertUtils.getBimGroupEntityName(this.model.getBizUnitPK());
                    if (!StringUtils.isEmpty((String)sbimGroupEntityName) && !"true".equalsIgnoreCase(sISRelationObject)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output setDataObject method", new String[0], ""));
                        this.out.append(this.tab + "public void setDataObject(IObjectValue dataObject) " + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "super.setDataObject(dataObject);" + '\n');
                        this.tabAdd();
                        this.out.append(this.tab + "if(STATUS_ADDNEW.equals(getOprtState()))" + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + " editData.put(\"treeid\",(" + sbimGroupEntityName.trim() + ")getUIContext().get(UIContext.PARENTNODE));" + '\n');
                        this.tabSub();
                        this.writeEnd();
                        this.tabSub();
                        this.writeEnd();
                    }
                    String sGroupEntityFactoryName = ConvertUtils.getBimGroupEntityFactoryName(this.model.getBizUnitPK());
                    if (!StringUtils.isEmpty((String)sISRelationObject) && "true".equalsIgnoreCase(sISRelationObject) && !StringUtils.isEmpty((String)sGroupEntityFactoryName)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output getTreeInterface method", new String[0], ""));
                        this.out.append(this.tab + "protected ITreeBase getTreeInterface() throws Exception" + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "return " + sGroupEntityFactoryName + ".getRemoteInstance();" + '\n');
                        this.tabSub();
                        this.writeEnd();
                    }
                } else if ("BillBase".equalsIgnoreCase(sTemplateType)) {
                    this.out.append('\n');
                    this.out.append(this.writeNote("output getDetailTable method", new String[0], ""));
                    this.out.append(this.tab + "protected KDTable getDetailTable() " + '\n');
                    this.writeBegin();
                    this.tabAdd();
                    this.out.append(this.tab + "return this.kdtEntrys;" + '\n');
                    this.tabSub();
                    this.writeEnd();
                    String sDetailEntityClassName = ConvertUtils.getBimDetailEntityClassName(this.model.getBizUnitPK());
                    if (!StringUtils.isEmpty((String)sDetailEntityClassName)) {
                        this.out.append('\n');
                        this.out.append(this.writeNote("output createNewDetailData method", new String[0], ""));
                        this.out.append(this.tab + "protected IObjectValue createNewDetailData(KDTable table)" + '\n');
                        this.writeBegin();
                        this.tabAdd();
                        this.out.append(this.tab + "return new " + sDetailEntityClassName.trim() + "();" + '\n');
                        this.tabSub();
                        this.writeEnd();
                    }
                }
            }
        }
        if (!StringUtils.isEmpty((String)entityClassName)) {
            this.out.append('\n');
            this.out.append(this.writeNote("output createNewData method", new String[0], ""));
            this.out.append(this.tab + "protected com.kingdee.bos.dao.IObjectValue createNewData()" + '\n');
            this.writeBegin();
            this.tabAdd();
            this.out.append(this.tab + entityClassName + " objectValue = new " + entityClassName + "();" + '\n');
            if ("EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(this.model.getBizUnitPK(), this.model.getFullName()))) {
                if ("BillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK())) || "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(this.model.getBizUnitPK()))) {
                    this.out.append(this.writeNote("set company and user", new String[0], ""));
                    if (this.model.getDataObjects().size() > 0 && ((EntityObjectInfo)this.model.getDataObjects().get(0).getInstance()).getPropertyByName("company", true) != null) {
                        this.out.append(this.tab + "objectValue.setCompany((com.kingdee.eas.basedata.org.CompanyOrgUnitInfo)(com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentFIUnit()));" + '\n');
                    }
                }
                this.out.append(this.tab + "objectValue.setCreator((com.kingdee.eas.base.permission.UserInfo)(com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentUser()));" + '\n');
            }
            this.out.append(this.tab + "return objectValue;" + '\n');
            this.tabSub();
            this.writeEnd();
        }
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    private ComponentCollection treeToCol(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(components.get(i), col);
        }
        return col;
    }

    private void addToCol(ComponentInfo info, ComponentCollection col) {
        int n = info.getComponents().size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(info.getComponents().get(i), col);
        }
        col.add(info);
    }
}

