/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.BorderPropertyUtil;
import java.util.Locale;

public class UIResourceWriter
extends CodeWriterBase {
    private Locale locale;
    private Locale defaultLocale;
    private UIObjectInfo model;
    private UIObjectInfo resultModel;
    private ComponentCollection components;
    private ComponentInfo toolBar;
    private ComponentInfo menuBar;
    private ComponentInfo rootPanel;
    private static final String MENUBAR = "mainMenuBar";
    private static final String TOOLBAR = "mainToolBar";
    private static final String TITLE_KEY = "this.title";

    public UIResourceWriter(UIObjectInfo model) {
        this(model, null, null);
    }

    public UIResourceWriter(UIObjectInfo model, Locale locale, Locale defaultLocale) {
        this.model = model;
        this.locale = locale;
        this.defaultLocale = defaultLocale;
        this.suffix = this.locale == null ? ".properties" : "_" + BOSLocaleUtil.getShortCode(locale) + ".properties";
        this.components = this.model.getComponents();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            if (this.components.get(i).getParent() != null) continue;
            if (this.components.get(i).getClassType().indexOf("Panel") >= 0) {
                this.rootPanel = this.components.get(i);
                continue;
            }
            if (this.components.get(i).getClassType().indexOf("MenuBar") >= 0) {
                this.menuBar = this.components.get(i);
                continue;
            }
            if (this.components.get(i).getClassType().indexOf("ToolBar") < 0) continue;
            this.toolBar = this.components.get(i);
        }
        this.components = this.treeToCol(this.model.getComponents());
    }

    @Override
    protected String getClassName() {
        return "Abstract" + this.model.getReleaseClass();
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    @Override
    public void write(StringBuffer in) {
        this.out = in;
        String pKey = TITLE_KEY;
        String pValue = this.locale == null || this.locale.equals(this.defaultLocale) ? this.model.getTitle() : this.model.getTitle(this.locale);
        this.out.append(this.saveConvert(pKey, true) + "=" + this.saveConvert(pValue, false) + '\n');
        int m = this.components.size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            if (cInfo.getParent() != null && cInfo.getParent().getClassType() != null && cInfo.getParent().getClassType().equals("com.kingdee.bos.ctrl.swing.KDTabbedPane")) {
                pKey = cInfo.getName() + ".constraints";
                pValue = (String)cInfo.getConstraint();
                this.out.append(this.saveConvert(pKey, true) + "=" + this.saveConvert(pValue, false) + '\n');
            }
            int n = cInfo.getProperties().size();
            for (int j = 0; j < n; ++j) {
                PropertyInfo pInfo = cInfo.getProperties().get(j);
                if (cInfo.isHerited() && !pInfo.isOverride()) continue;
                if ("border".equals(pInfo.getName())) {
                    pKey = cInfo.getName() + ".border.title";
                    pValue = BorderPropertyUtil.getTitleString(pInfo.getValue());
                    if (pValue == null) continue;
                    this.out.append(this.saveConvert(pKey, true) + "=" + this.saveConvert(pValue, false) + '\n');
                    continue;
                }
                if (!pInfo.isMultiLanguage()) continue;
                String componentName = cInfo == this.rootPanel ? "this" : (cInfo == this.menuBar ? MENUBAR : (cInfo == this.toolBar ? TOOLBAR : cInfo.getName()));
                pKey = componentName + "." + pInfo.getName();
                if (this.locale == null || this.locale.equals(this.defaultLocale)) {
                    pValue = pInfo.getValue();
                } else {
                    if (!pInfo.containsKey(UIResourceWriter.localedKeyName("value", this.locale))) continue;
                    pValue = pInfo.getValue(this.locale);
                }
                this.out.append(this.saveConvert(pKey, true) + "=" + this.saveConvert(pValue, false) + '\n');
            }
        }
        ActionCollection actions = this.model.getActions();
        int j = actions.size();
        for (int i = 0; i < j; ++i) {
            ActionInfo action = actions.get(i);
            if (action.isHerited() && !action.isOverride()) continue;
            pKey = action.getClassName() + ".SHORT_DESCRIPTION";
            pValue = this.locale == null || this.locale.equals(this.defaultLocale) ? action.getShortDesc() : action.getShortDesc(this.locale);
            this.out.append(this.saveConvert(pKey, true) + "=" + this.saveConvert(pValue, false) + '\n');
            pKey = action.getClassName() + ".LONG_DESCRIPTION";
            pValue = this.locale == null || this.locale.equals(this.defaultLocale) ? action.getLongDesc() : action.getLongDesc(this.locale);
            this.out.append(this.saveConvert(pKey, true) + "=" + this.saveConvert(pValue, false) + '\n');
            pKey = action.getClassName() + ".NAME";
            pValue = this.locale == null || this.locale.equals(this.defaultLocale) ? action.getControlName() : action.getControlName(this.locale);
            this.out.append(this.saveConvert(pKey, true) + "=" + this.saveConvert(pValue, false) + '\n');
        }
    }

    private static final String localedKeyName(String key, Locale locale) {
        return key.trim() + "_" + BOSLocaleUtil.getShortCode(locale);
    }

    private ComponentCollection treeToCol(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(components.get(i), col);
        }
        return col;
    }

    private void addToCol(ComponentInfo info, ComponentCollection col) {
        col.add(info);
        int n = info.getComponents().size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(info.getComponents().get(i), col);
        }
    }

    public static void main(String[] args) {
    }
}

