/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.templates.compiled;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectCollection;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.IEntityObjectCtrl;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.resource.IBizEnumCtrl;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public class AbstractInfoGenerator {
    protected static String nl;
    protected final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL;
    protected final String TEXT_3 = this.NL + "import java.io.Serializable;" + this.NL + "import com.kingdee.bos.dao.AbstractObjectValue;" + this.NL + "import java.util.Locale;" + this.NL + "import com.kingdee.util.TypeConversionUtils;" + this.NL + "import com.kingdee.bos.util.BOSObjectType;";
    protected final String TEXT_4 = this.NL + "import ";
    protected final String TEXT_5 = ".";
    protected final String TEXT_6 = ";";
    protected final String TEXT_7 = this.NL + this.NL;
    protected final String TEXT_8 = this.NL;
    protected final String TEXT_9 = " class Abstract";
    protected final String TEXT_10 = " extends ";
    protected final String TEXT_11 = " implements ";
    protected final String TEXT_12 = "Serializable " + this.NL + "{" + this.NL + "    public Abstract";
    protected final String TEXT_13 = "()" + this.NL + "    {" + this.NL + "        this(";
    protected final String TEXT_14 = ");" + this.NL + "    }" + this.NL + "    protected Abstract";
    protected final String TEXT_15 = "(String pkField)" + this.NL + "    {" + this.NL + "        super(pkField);";
    protected final String TEXT_16 = this.NL + "        put(";
    protected final String TEXT_17 = ", new ";
    protected final String TEXT_18 = "());";
    protected final String TEXT_19 = this.NL + "    }";
    protected final String TEXT_20 = this.NL + "    /**" + this.NL + "     * ";
    protected final String TEXT_21 = " " + this.NL + "     */" + this.NL + "    public ";
    protected final String TEXT_22 = " ";
    protected final String TEXT_23 = "()" + this.NL + "    {";
    protected final String TEXT_24 = this.NL + "        return ((Character)";
    protected final String TEXT_25 = "(";
    protected final String TEXT_26 = ")).charValue();";
    protected final String TEXT_27 = this.NL + "        return (byte[])";
    protected final String TEXT_28 = "(";
    protected final String TEXT_29 = ");";
    protected final String TEXT_30 = this.NL + "        return ";
    protected final String TEXT_31 = "(";
    protected final String TEXT_32 = ");";
    protected final String TEXT_33 = this.NL + "        return get";
    protected final String TEXT_34 = "((Locale)null);";
    protected final String TEXT_35 = this.NL + "        return ";
    protected final String TEXT_36 = ".getEnum(";
    protected final String TEXT_37 = "(";
    protected final String TEXT_38 = "));";
    protected final String TEXT_39 = this.NL + "    }" + this.NL + "    public void set";
    protected final String TEXT_40 = "(";
    protected final String TEXT_41 = " item)" + this.NL + "    {";
    protected final String TEXT_42 = this.NL + "        ";
    protected final String TEXT_43 = "(";
    protected final String TEXT_44 = ", new Character(item));";
    protected final String TEXT_45 = this.NL + "        ";
    protected final String TEXT_46 = "(";
    protected final String TEXT_47 = ", item);";
    protected final String TEXT_48 = this.NL + "\t\tset";
    protected final String TEXT_49 = "(item,(Locale)null);";
    protected final String TEXT_50 = this.NL + "\t\tif (item != null) {";
    protected final String TEXT_51 = this.NL + "        ";
    protected final String TEXT_52 = "(";
    protected final String TEXT_53 = ", item.getValue());" + this.NL + "\t\t}";
    protected final String TEXT_54 = this.NL + "    }";
    protected final String TEXT_55 = this.NL + "    public String get";
    protected final String TEXT_56 = "(Locale local)" + this.NL + "    {" + this.NL + "        return TypeConversionUtils.objToString(get(";
    protected final String TEXT_57 = ", local));" + this.NL + "    }" + this.NL + "    public void set";
    protected final String TEXT_58 = "(String item, Locale local)" + this.NL + "    {" + this.NL + "        put(";
    protected final String TEXT_59 = ", item, local);" + this.NL + "    }";
    protected final String TEXT_60 = this.NL + "    /**" + this.NL + "     * ";
    protected final String TEXT_61 = " " + this.NL + "     */" + this.NL + "    public ";
    protected final String TEXT_62 = " get";
    protected final String TEXT_63 = "()" + this.NL + "    {" + this.NL + "        return (";
    protected final String TEXT_64 = ")get(";
    protected final String TEXT_65 = ");" + this.NL + "    }";
    protected final String TEXT_66 = this.NL + "    public void set";
    protected final String TEXT_67 = "(";
    protected final String TEXT_68 = " item)" + this.NL + "    {" + this.NL + "        put(";
    protected final String TEXT_69 = ", item);" + this.NL + "    }";
    protected final String TEXT_70 = this.NL + "    public BOSObjectType getBOSType()" + this.NL + "    {" + this.NL + "        return new BOSObjectType(";
    protected final String TEXT_71 = ");" + this.NL + "    }" + this.NL + "}";
    private EntityObjectInfo entity;
    private HashMap setMap;
    private HashMap getMap;
    private HashMap mulLinkMap;
    private Context ctx = null;

    public static synchronized AbstractInfoGenerator create(String lineSeparator) {
        nl = lineSeparator;
        AbstractInfoGenerator result = new AbstractInfoGenerator();
        nl = null;
        return result;
    }

    public void init(EntityObjectInfo en) {
        this.entity = en;
        this.initSetMap();
        this.initGetMap();
        this.initMulLinkPropMap();
        this.ctx = ContextManager.getContext();
    }

    private void initSetMap() {
        this.setMap = new HashMap();
        this.setMap.put(DataType.BOSUUID, "setBOSUuid");
        this.setMap.put(DataType.UUID, "setUuid");
        this.setMap.put(DataType.STRING, "setString");
        this.setMap.put(DataType.DECIMAL, "setBigDecimal");
        this.setMap.put(DataType.BOOLEAN, "setBoolean");
        this.setMap.put(DataType.BYTE, "setByte");
        this.setMap.put(DataType.SHORT, "setShort");
        this.setMap.put(DataType.INTEGER, "setInt");
        this.setMap.put(DataType.LONG, "setLong");
        this.setMap.put(DataType.FLOAT, "setFloat");
        this.setMap.put(DataType.DOUBLE, "setDouble");
        this.setMap.put(DataType.DATE, "setDate");
        this.setMap.put(DataType.TIME, "setTime");
        this.setMap.put(DataType.TIMESTAMP, "setTimestamp");
    }

    private void initGetMap() {
        this.getMap = new HashMap();
        this.getMap.put(DataType.BOSUUID, "getBOSUuid");
        this.getMap.put(DataType.UUID, "getUuid");
        this.getMap.put(DataType.STRING, "getString");
        this.getMap.put(DataType.DECIMAL, "getBigDecimal");
        this.getMap.put(DataType.BOOLEAN, "getBoolean");
        this.getMap.put(DataType.BYTE, "getByte");
        this.getMap.put(DataType.SHORT, "getShort");
        this.getMap.put(DataType.INTEGER, "getInt");
        this.getMap.put(DataType.LONG, "getLong");
        this.getMap.put(DataType.FLOAT, "getFloat");
        this.getMap.put(DataType.DOUBLE, "getDouble");
        this.getMap.put(DataType.DATE, "getDate");
        this.getMap.put(DataType.TIME, "getTime");
        this.getMap.put(DataType.TIMESTAMP, "getTimestamp");
    }

    private void initMulLinkPropMap() {
        this.mulLinkMap = new HashMap();
        PropertyCollection props = this.entity.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            RelationshipInfo rel;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo) || (rel = ((LinkPropertyInfo)prop).getRelationship()) == null || rel.getSupplierCardinality() == null || !rel.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) && !rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) continue;
            this.mulLinkMap.put(prop.getName(), prop);
        }
    }

    private String getOwnerPropType(OwnPropertyInfo prop) {
        DataType dtype = prop.getDataType();
        String type = "";
        String temp = prop.getMetaDataRef();
        if (dtype.equals(DataType.ENUM)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    IBizEnumCtrl bizEnumCtrl = (IBizEnumCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.BIZENUM);
                    type = bizEnumCtrl.getValue(MetaDataPK.create(MetaDataUtils.getPackageName(temp), MetaDataUtils.getClassName(temp))).getClassName();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else if (dtype.equals(DataType.OBJECTVALUE)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    IEntityObjectCtrl enCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.ENTITY);
                    type = enCtrl.getValue(MetaDataPK.create(MetaDataUtils.getPackageName(temp), MetaDataUtils.getClassName(temp))).getObjectValueClass();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else if (dtype.equals(DataType.OBJECTCOLLECTION)) {
            if (!StringUtils.isEmpty((String)temp)) {
                try {
                    IEntityObjectCtrl enCtrl = (IEntityObjectCtrl)BOSObjectFactory.createBOSObject(this.ctx, MetaDataTypeList.ENTITY);
                    type = enCtrl.getValue(MetaDataPK.create(MetaDataUtils.getPackageName(temp), MetaDataUtils.getClassName(temp))).getObjectCollectionClass();
                }
                catch (BOSException e) {
                    type = "";
                }
            }
        } else {
            type = dtype.getJavaTypeName();
        }
        return type;
    }

    private String getGetMethod(DataType type) {
        if (!this.getMap.containsKey(type)) {
            return "get";
        }
        return (String)this.getMap.get(type);
    }

    private String getSetMethod(DataType type) {
        if (!this.setMap.containsKey(type)) {
            return "put";
        }
        return (String)this.setMap.get(type);
    }

    private String getEnumSetMethod(TypeReference et) {
        if (et == null) {
            return null;
        }
        String method = "put";
        if (et.getEnumValueType().equals((Object)BizEnumValueType.DOUBLE)) {
            method = this.getSetMethod(DataType.DOUBLE);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.FLOAT)) {
            method = this.getSetMethod(DataType.FLOAT);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.INTEGER)) {
            method = this.getSetMethod(DataType.INTEGER);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.LONG)) {
            method = this.getSetMethod(DataType.LONG);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.STRING)) {
            method = this.getSetMethod(DataType.STRING);
        }
        return method;
    }

    private String getEnumGetMethod(TypeReference et) {
        if (et == null) {
            return null;
        }
        String method = "get";
        if (et.getEnumValueType().equals((Object)BizEnumValueType.DOUBLE)) {
            method = this.getGetMethod(DataType.DOUBLE);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.FLOAT)) {
            method = this.getGetMethod(DataType.FLOAT);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.INTEGER)) {
            method = this.getGetMethod(DataType.INTEGER);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.LONG)) {
            method = this.getGetMethod(DataType.LONG);
        } else if (et.getEnumValueType().equals((Object)BizEnumValueType.STRING)) {
            method = this.getGetMethod(DataType.STRING);
        }
        return method;
    }

    private boolean isClient(LinkPropertyInfo prop) {
        RelationshipInfo rel = prop.getRelationship();
        if (rel.getSupplierObject() == null || rel.getClientObject() == null) {
            return false;
        }
        return rel.getClientObject().getFullName().equals(this.entity.getFullName()) || !rel.getSupplierObject().getFullName().equals(this.entity.getFullName());
    }

    private boolean isAvalibleLink(LinkPropertyInfo prop) {
        boolean isAvali = prop.getRelationship().getClientObject() != null && prop.getRelationship().getClientObject().getFullName().equals(this.entity.getFullName());
        return isAvali && this.isMulti(prop) || this.isCross(prop);
    }

    private boolean isMulti(LinkPropertyInfo prop) {
        return !(!prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ZERO_TO_ONE) && !prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ONE) || !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED));
    }

    private boolean isCross(LinkPropertyInfo prop) {
        return !(!prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getClientCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !prop.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED));
    }

    private String getKeyPropertyName() {
        int i;
        PropertyCollection props = this.entity.getInheritedNoDuplicatedProperties();
        if (this.entity.getLogicalKey() == null || this.entity.getLogicalKey().getKeyPropertys().size() != 1) {
            return "";
        }
        PropertyCollection ps = this.entity.getLogicalKey().getKeyPropertys();
        HashMap pcm = new HashMap(ps.size());
        for (i = 0; i < ps.size(); ++i) {
            pcm.put(ps.get(i).getName(), null);
        }
        for (i = 0; i < props.size(); ++i) {
            OwnPropertyInfo ow;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof OwnPropertyInfo) || (ow = (OwnPropertyInfo)prop).getDataType() == null || !pcm.containsKey(ow.getName())) continue;
            return ow.getName();
        }
        return "";
    }

    public String generate(Object argument) {
        String subMode;
        StringBuffer stringBuffer = new StringBuffer();
        Object arg = argument;
        EntityObjectInfo entity = (EntityObjectInfo)arg;
        this.init(entity);
        String fullName = entity.getObjectValueClass();
        String packageName = MetaDataUtils.getPackageName(fullName);
        String className = MetaDataUtils.getClassName(fullName);
        if (packageName.length() != 0) {
            stringBuffer.append("package ");
            stringBuffer.append(packageName);
            stringBuffer.append(this.TEXT_2);
        }
        stringBuffer.append(this.TEXT_3);
        BusinessObjectCollection boc = entity.getExtendStereoTypes();
        String strSteroExts = "";
        if (boc != null && boc.size() > 0) {
            for (int i = 0; i < boc.size(); ++i) {
                BusinessObjectInfo currBo = boc.get(i);
                if (!(currBo instanceof EntityObjectInfo)) continue;
                EntityObjectInfo currEntity = (EntityObjectInfo)currBo;
                String fullName2 = currEntity.getObjectValueClass();
                String packageName2 = MetaDataUtils.getPackageName(fullName2);
                String className2 = MetaDataUtils.getClassName(fullName2);
                strSteroExts = strSteroExts + className2 + ", ";
                stringBuffer.append(this.TEXT_4);
                stringBuffer.append(packageName2);
                stringBuffer.append(".");
                stringBuffer.append(className2);
                stringBuffer.append(";");
            }
        }
        stringBuffer.append(this.TEXT_7);
        String accLevel = entity.getAccessLevel() == null ? "public" : entity.getAccessLevel().getName();
        String string = subMode = entity.getSubClassingMode() == null ? "" : entity.getSubClassingMode().getName();
        if (subMode.equals("normal")) {
            subMode = "";
        }
        EntityObjectInfo base = entity.getBaseEntity();
        String extendsName = "AbstractObjectValue";
        if (base != null) {
            extendsName = base.getObjectValueClass();
        }
        stringBuffer.append(this.TEXT_8);
        stringBuffer.append(accLevel);
        stringBuffer.append(subMode.equals("") ? "" : " " + subMode);
        stringBuffer.append(" class Abstract");
        stringBuffer.append(className);
        stringBuffer.append(" extends ");
        stringBuffer.append(extendsName);
        stringBuffer.append(" implements ");
        stringBuffer.append(strSteroExts);
        stringBuffer.append(this.TEXT_12);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_13);
        stringBuffer.append("\"" + this.getKeyPropertyName() + "\"");
        stringBuffer.append(this.TEXT_14);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_15);
        if (this.mulLinkMap.size() != 0) {
            for (LinkPropertyInfo lnkProp : this.mulLinkMap.values()) {
                if (!this.isAvalibleLink(lnkProp)) continue;
                EntityObjectInfo sel = null;
                if (this.isMulti(lnkProp)) {
                    sel = lnkProp.getRelationship().getSupplierObject();
                } else if (this.isCross(lnkProp)) {
                    sel = this.isClient(lnkProp) ? lnkProp.getRelationship().getSupplierObject() : lnkProp.getRelationship().getClientObject();
                }
                if (sel == null) continue;
                stringBuffer.append(this.TEXT_16);
                stringBuffer.append("\"" + lnkProp.getName() + "\"");
                stringBuffer.append(", new ");
                stringBuffer.append(sel.getObjectCollectionClass());
                stringBuffer.append("());");
            }
        }
        stringBuffer.append(this.TEXT_19);
        PropertyCollection props = entity.getOwnerAndExtendedProperties();
        for (int i = 0; i < props.size(); ++i) {
            LinkPropertyInfo linkProp;
            RelationshipInfo rel;
            PropertyInfo prop = props.get(i);
            String name = prop.getName();
            String upcastName = "";
            if (name != null && name.length() > 0) {
                upcastName = name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
            }
            if (prop instanceof OwnPropertyInfo) {
                String method;
                TypeReference et;
                String method2;
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                DataType dtype = ownProp.getDataType();
                String type = this.getOwnerPropType(ownProp);
                boolean isBooleanProp = ownProp.getDataType().equals(DataType.BOOLEAN);
                boolean isEnum = dtype == DataType.ENUM;
                stringBuffer.append(this.TEXT_20);
                stringBuffer.append("Object:" + entity.getAlias() + "'s " + ownProp.getAlias() + "property");
                stringBuffer.append(this.TEXT_21);
                stringBuffer.append(type);
                stringBuffer.append(" ");
                stringBuffer.append(isBooleanProp ? "is" + upcastName : "get" + upcastName);
                stringBuffer.append(this.TEXT_23);
                if (!isEnum) {
                    method2 = this.getGetMethod(dtype);
                    if (!ownProp.isMultilingual()) {
                        if (dtype == DataType.CHAR) {
                            stringBuffer.append(this.TEXT_24);
                            stringBuffer.append(method2);
                            stringBuffer.append("(");
                            stringBuffer.append("\"" + name + "\"");
                            stringBuffer.append(")).charValue();");
                        } else if (dtype == DataType.BYTEARRAY) {
                            stringBuffer.append(this.TEXT_27);
                            stringBuffer.append(method2);
                            stringBuffer.append("(");
                            stringBuffer.append("\"" + name + "\"");
                            stringBuffer.append(");");
                        } else {
                            stringBuffer.append(this.TEXT_30);
                            stringBuffer.append(method2);
                            stringBuffer.append("(");
                            stringBuffer.append("\"" + name + "\"");
                            stringBuffer.append(");");
                        }
                    } else {
                        stringBuffer.append(this.TEXT_33);
                        stringBuffer.append(upcastName);
                        stringBuffer.append("((Locale)null);");
                    }
                } else {
                    et = new TypeReference(ownProp.getDataType().getName(), ownProp.getMetaDataRef());
                    if (et != null && et.getEnumValueType() != null) {
                        method = this.getEnumGetMethod(et);
                        stringBuffer.append(this.TEXT_35);
                        stringBuffer.append(et.toString());
                        stringBuffer.append(".getEnum(");
                        stringBuffer.append(method);
                        stringBuffer.append("(");
                        stringBuffer.append("\"" + ownProp.getName() + "\"");
                        stringBuffer.append("));");
                    }
                }
                stringBuffer.append(this.TEXT_39);
                stringBuffer.append(upcastName);
                stringBuffer.append("(");
                stringBuffer.append(type);
                stringBuffer.append(this.TEXT_41);
                if (!isEnum) {
                    if (!ownProp.isMultilingual()) {
                        method2 = this.getSetMethod(dtype);
                        if (dtype == DataType.CHAR) {
                            stringBuffer.append(this.TEXT_42);
                            stringBuffer.append(method2);
                            stringBuffer.append("(");
                            stringBuffer.append("\"" + name + "\"");
                            stringBuffer.append(", new Character(item));");
                        } else {
                            stringBuffer.append(this.TEXT_45);
                            stringBuffer.append(method2);
                            stringBuffer.append("(");
                            stringBuffer.append("\"" + name + "\"");
                            stringBuffer.append(", item);");
                        }
                    } else {
                        stringBuffer.append(this.TEXT_48);
                        stringBuffer.append(upcastName);
                        stringBuffer.append("(item,(Locale)null);");
                    }
                } else {
                    et = new TypeReference(ownProp.getDataType().getName(), ownProp.getMetaDataRef());
                    if (et != null || et.getEnumValueType() != null) {
                        method = this.getEnumSetMethod(et);
                        stringBuffer.append(this.TEXT_50);
                        stringBuffer.append(this.TEXT_51);
                        stringBuffer.append(method);
                        stringBuffer.append("(");
                        stringBuffer.append("\"" + ownProp.getName() + "\"");
                        stringBuffer.append(this.TEXT_53);
                    }
                }
                stringBuffer.append(this.TEXT_54);
                if (!ownProp.isMultilingual() || !ownProp.getDataType().equals(DataType.STRING)) continue;
                stringBuffer.append(this.TEXT_55);
                stringBuffer.append(upcastName);
                stringBuffer.append(this.TEXT_56);
                stringBuffer.append("\"" + ownProp.getName() + "\"");
                stringBuffer.append(this.TEXT_57);
                stringBuffer.append(upcastName);
                stringBuffer.append(this.TEXT_58);
                stringBuffer.append("\"" + ownProp.getName() + "\"");
                stringBuffer.append(this.TEXT_59);
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo) || (rel = (linkProp = (LinkPropertyInfo)prop).getRelationship()).getSupplierObject() == null || rel.getClientObject() == null) continue;
            boolean isMulti = false;
            EntityObjectInfo se = this.isClient(linkProp) ? rel.getSupplierObject() : rel.getClientObject();
            if (se == null) continue;
            String type = "";
            type = (rel.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || rel.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) && this.isClient(linkProp) ? se.getObjectCollectionClass() : se.getObjectValueClass();
            isMulti = this.isCross(linkProp);
            if (isMulti) {
                type = se.getObjectCollectionClass();
            }
            stringBuffer.append(this.TEXT_60);
            stringBuffer.append("Object: " + entity.getAlias() + " 's " + linkProp.getAlias() + " property");
            stringBuffer.append(this.TEXT_61);
            stringBuffer.append(type);
            stringBuffer.append(" get");
            stringBuffer.append(upcastName);
            stringBuffer.append(this.TEXT_63);
            stringBuffer.append(type);
            stringBuffer.append(")get(");
            stringBuffer.append("\"" + name + "\"");
            stringBuffer.append(this.TEXT_65);
            if (rel.getSupplierCardinality() != CardinalityType.ZERO_TO_ONE && rel.getSupplierCardinality() != CardinalityType.ONE && this.isClient(linkProp) || isMulti) continue;
            stringBuffer.append(this.TEXT_66);
            stringBuffer.append(upcastName);
            stringBuffer.append("(");
            stringBuffer.append(type);
            stringBuffer.append(this.TEXT_68);
            stringBuffer.append("\"" + name + "\"");
            stringBuffer.append(this.TEXT_69);
        }
        stringBuffer.append(this.TEXT_70);
        stringBuffer.append("\"" + entity.getType().toString() + "\"");
        stringBuffer.append(this.TEXT_71);
        return stringBuffer.toString();
    }
}

