/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.templates.compiled;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.util.RuleJCodeWriter;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.resource.IBizEnumCtrl;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.dtp.BorderPropertyUtil;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.kdtable.KDTablePanelDesignerHelper;
import com.kingdee.bos.ui.dtp.model.layout.BorderLayout;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class HMDUICodeGenerator {
    protected static String nl;
    protected final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL;
    protected final String TEXT_3 = this.NL + "import com.kingdee.eas.framework.client.multiDetail.Bill;" + this.NL + "import com.kingdee.eas.framework.BillBaseInfo;" + this.NL + "" + this.NL + "public class ";
    protected final String TEXT_4 = " extends Bill" + this.NL + "{" + this.NL + "    public ";
    protected final String TEXT_5 = "() throws Exception" + this.NL + "    {" + this.NL + "        super();" + this.NL + "    }";
    protected final String TEXT_6 = this.NL + this.NL + "    public BillBaseInfo getBillBase()" + this.NL + "    {" + this.NL + "        return new ";
    protected final String TEXT_7 = "Info();" + this.NL + "    }";
    protected final String TEXT_8 = this.NL + this.NL + "    public void addBillDetails()" + this.NL + "    {" + this.NL + "        try {";
    protected final String TEXT_9 = this.NL + "            this.addBillDetail(new ";
    protected final String TEXT_10 = ".";
    protected final String TEXT_11 = "());";
    protected final String TEXT_12 = this.NL + "            this.addBillDetail(new ";
    protected final String TEXT_13 = "());";
    protected final String TEXT_14 = this.NL + "        } catch (Exception ex) {" + this.NL + "        }" + this.NL + "    }" + this.NL + "}";
    private static final Logger logger;
    static final String CLF;
    boolean multiLanguage = true;
    ComponentCollection components = null;
    ComponentInfo toolBar = null;
    ComponentInfo menuBar = null;
    ComponentInfo rootPanel = null;
    UIObjectInfo model = null;
    private static final String MENUBAR = "menuBar";
    private static final String TOOLBAR = "toolBar";
    private static final String TBUTTONGROUP = "com.kingdee.bos.ctrl.swing.KDButtonGroup";
    private static final String TSCROLLPANE = "com.kingdee.bos.ctrl.swing.KDScrollPane";
    private static final String KDMENUBAR = "com.kingdee.bos.ctrl.swing.KDMenuBar";
    private static final String KDMENU = "com.kingdee.bos.ctrl.swing.KDMenu";
    private static final String KDTABLE = "com.kingdee.bos.ctrl.kdf.table.KDTable";
    private static final String KDTABBEDPANE = "com.kingdee.bos.ctrl.swing.KDTabbedPane";
    private static final String KDDATEPICKER = "com.kingdee.bos.ctrl.swing.KDDatePicker";
    private static final String KDTIMEPICKER = "com.kingdee.bos.ctrl.swing.KDTimePicker";
    private static final String KDFORMATTEDTEXTFIELD = "com.kingdee.bos.ctrl.swing.KDFormattedTextField";
    private static final String KDNUMBERTEXTFIELD = "com.kingdee.bos.ctrl.swing.KDNumberTextField";
    private static final String KDSPINNER = "com.kingdee.bos.ctrl.swing.KDSpinner";
    private static final String KDCONTAINER = "com.kingdee.bos.ctrl.swing.KDContainer";
    private static final String KDBIZPROMPTBOX = "com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox";
    private static final String KDPANEL = "com.kingdee.bos.ctrl.swing.KDPanel";
    private static final String baseClassName = "CoreUIObject";
    private boolean hasBindTable = false;
    private boolean hasBindQuery = false;
    private boolean hasBindWorkFlow = false;
    private String bindObjectType = "";
    private Hashtable headerList = new Hashtable();
    private ArrayList queryList = new ArrayList();
    private ArrayList cloneQueryList = new ArrayList();
    private boolean needGenerateQueryExecutor = false;
    private String firstFocusControlName = null;

    public static synchronized HMDUICodeGenerator create(String lineSeparator) {
        nl = lineSeparator;
        HMDUICodeGenerator result = new HMDUICodeGenerator();
        nl = null;
        return result;
    }

    private String getComponentName(ComponentInfo cInfo) {
        String componentName = cInfo == this.rootPanel ? "this" : (cInfo == this.toolBar ? "this.toolBar" : (cInfo == this.menuBar ? "this.menuBar" : "this." + cInfo.getName()));
        return componentName;
    }

    private ComponentCollection treeToCol(ComponentCollection components) {
        ComponentCollection col = new ComponentCollection();
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(components.get(i), col);
        }
        return col;
    }

    private void addToCol(ComponentInfo info, ComponentCollection col) {
        int n = info.getComponents().size();
        for (int i = 0; i < n; ++i) {
            this.addToCol(info.getComponents().get(i), col);
        }
        col.add(info);
    }

    private String getExpression(ComponentInfo cInfo, PropertyInfo pInfo) {
        String expr = "";
        String componentName = this.getComponentName(cInfo);
        if ("com.kingdee.bos.ctrl.swing.KDCurrencyTextField".equalsIgnoreCase(cInfo.getClassType())) {
            if ("value".equalsIgnoreCase(pInfo.getName())) {
                if (!StringUtils.isEmpty((String)pInfo.getValue())) {
                    expr = componentName + ".set" + StringUtils.headCharUpperCase((String)pInfo.getName()) + "(new java.math.BigDecimal(" + pInfo.getValue() + "));";
                }
                return expr;
            }
            if ("currency".equalsIgnoreCase(pInfo.getName())) {
                if (!StringUtils.isEmpty((String)pInfo.getValue())) {
                    expr = componentName + ".set" + StringUtils.headCharUpperCase((String)pInfo.getName()) + "(Currency.getInstance(\"" + pInfo.getValue() + "\"));";
                }
                return expr;
            }
        }
        if (pInfo.getName().equalsIgnoreCase("items") && ("com.kingdee.bos.ctrl.swing.KDList".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDComboBox".equalsIgnoreCase(cInfo.getClassType()))) {
            if (pInfo.getValue() != null && pInfo.getValue().startsWith("[Enum]")) {
                if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDList")) {
                    expr = componentName + ".setListData(EnumUtils.getEnumList(\"" + this.getEnumClass(pInfo.getValue().substring(6)) + "\").toArray());";
                } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDComboBox")) {
                    expr = componentName + ".addItems(EnumUtils.getEnumList(\"" + this.getEnumClass(pInfo.getValue().substring(6)) + "\").toArray());";
                }
            } else if (this.multiLanguage && pInfo.isMultiLanguage()) {
                if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDList")) {
                    expr = componentName + ".setListData(resHelper.getArray(\"" + StringUtils.replace((String)componentName, (String)"this.", (String)"") + "." + pInfo.getName() + "\"));";
                } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDComboBox")) {
                    expr = componentName + ".addItems(resHelper.getArray(\"" + StringUtils.replace((String)componentName, (String)"this.", (String)"") + "." + pInfo.getName() + "\"));";
                }
            } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDList")) {
                expr = componentName + ".setListData(" + this.getValueString(pInfo, cInfo.getName()) + ");";
            } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.swing.KDComboBox")) {
                expr = componentName + ".addItems(" + this.getValueString(pInfo, cInfo.getName()) + ");";
            }
        } else if (this.multiLanguage && pInfo.isMultiLanguage() && !pInfo.getType().equals("javax.swing.border.Border")) {
            expr = componentName + ".set" + StringUtils.headCharUpperCase((String)pInfo.getName()) + "(resHelper.get" + this.getMethodName(pInfo.getType()) + "(\"" + StringUtils.replace((String)componentName, (String)"this.", (String)"") + "." + pInfo.getName() + "\"));";
        } else if (cInfo.getClassType().equalsIgnoreCase("com.kingdee.bos.ctrl.kdf.tablepanel.KDTablePanel") && pInfo.getName().equalsIgnoreCase("tableInfo")) {
            String xml = pInfo.getValue();
            int[] cols = KDTablePanelDesignerHelper.getLayoutArray(xml, 0);
            int[] rows = KDTablePanelDesignerHelper.getLayoutArray(xml, 1);
            String colStr = KDTablePanelDesignerHelper.getIntArrayString(cols);
            String rowStr = KDTablePanelDesignerHelper.getIntArrayString(rows);
            int rowlength = rows.length;
            int collength = cols.length;
            expr = componentName + ".rebuild(" + rowlength + ", " + collength + ", " + rowStr + ", " + colStr + ");";
        } else {
            expr = componentName + ".set" + StringUtils.headCharUpperCase((String)pInfo.getName()) + "(" + this.getValueString(pInfo, cInfo.getName()) + ");";
        }
        return expr;
    }

    private String getBindTableString(ComponentInfo cInfo, boolean isLoad, boolean isQuery, boolean isPutContent, String tab) {
        int i;
        int m;
        String bindString = "";
        String bindObjectName = "";
        String bindFieldName = "";
        String[] columns = null;
        String[] bindItems = null;
        bindString = isLoad ? "this.bindDataToTable(" : "this.bindTableToData(";
        if (this.headerList.containsKey(cInfo.getName()) && this.headerList.get(cInfo.getName()) != null) {
            columns = (String[])this.headerList.get(cInfo.getName());
            bindItems = new String[columns.length];
            int n = bindItems.length;
            for (int j = 0; j < n; ++j) {
                bindItems[j] = null;
            }
        }
        boolean hasFoundBindingField = false;
        int n = cInfo.getPropertyBindings().size();
        block1: for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (columns == null || pbInfo.getPropertyName().indexOf(".text") < 0) continue;
            String columnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
            if (isQuery) {
                if (bindObjectName.equals("")) {
                    bindObjectName = pbInfo.getBindingObject();
                }
            } else {
                if (pbInfo.getBingdingField().indexOf(".") < 0) continue;
                if (bindObjectName.equals("")) {
                    bindObjectName = pbInfo.getBindingObject();
                }
                if (!hasFoundBindingField && !StringUtils.isEmpty((String)(bindFieldName = this.findTableBindingField(bindObjectName, pbInfo.getBingdingField())))) {
                    hasFoundBindingField = true;
                }
            }
            int m1 = columns.length;
            for (int i1 = 0; i1 < m1; ++i1) {
                if (!columnName.equalsIgnoreCase(columns[i1])) continue;
                bindItems[i1] = pbInfo.getBingdingField();
                continue block1;
            }
        }
        if (!isQuery && bindItems != null) {
            m = bindItems.length;
            for (i = 0; i < m; ++i) {
                if (bindItems[i] == null || bindItems[i].length() <= bindFieldName.length() + 1) continue;
                bindItems[i] = bindItems[i].substring(bindFieldName.length() + 1);
            }
        }
        m = this.model.getDataObjects().size();
        for (i = 0; i < m; ++i) {
            if (!this.model.getDataObjects().get(i).getName().equals(bindObjectName)) continue;
            IObjectValue objectValue = this.model.getDataObjects().get(i).getInstance();
            if (objectValue != null && objectValue instanceof EntityObjectInfo) {
                String[] s = StringUtils.split((String)bindFieldName, (String)".");
                int n2 = s.length;
                for (int j = 0; j < n2; ++j) {
                    com.kingdee.bos.metadata.entity.PropertyInfo pInfo = ((EntityObjectInfo)objectValue).getPropertyByName(s[j]);
                    if (!(pInfo instanceof LinkPropertyInfo)) continue;
                    objectValue = j == n2 - 1 ? ((LinkPropertyInfo)pInfo).getRelationship().getSupplierObject() : ((LinkPropertyInfo)pInfo).getRelationship().getClientObject();
                }
                this.bindObjectType = ((EntityObjectInfo)objectValue).getObjectValueClass();
                break;
            }
            this.bindObjectType = StringUtils.headCharUpperCase((String)bindObjectName) + "Info";
            break;
        }
        bindFieldName = this.getGetMethodString(bindObjectName, bindFieldName, "Object");
        String sArray = "new String[] {";
        if (bindItems != null) {
            int n3 = bindItems.length;
            for (int j = 0; j < n3; ++j) {
                sArray = j == 0 ? sArray + "\"" + (bindItems[j] == null ? "" : bindItems[j]) + "\"" : sArray + ",\"" + (bindItems[j] == null ? "" : bindItems[j]) + "\"";
            }
        }
        sArray = sArray + "}";
        bindString = isQuery || isPutContent ? (StringUtils.isEmpty((String)bindObjectName) ? "" : tab + this.getComponentName(cInfo) + ".putBindContents(\"" + bindObjectName + "\"," + sArray + ");" + CLF) : tab + bindString + this.getComponentName(cInfo) + "," + bindFieldName + ");" + CLF;
        return bindString;
    }

    private String getValueString(PropertyInfo pInfo, String controlName) {
        String args;
        String type = pInfo.getType();
        if (type == null) {
            args = "null";
        } else if (pInfo.getValue() == null && (type.equals("String") || type.equals("java.lang.String"))) {
            args = "\"\"";
        } else if (pInfo.getName().equalsIgnoreCase("action")) {
            args = "(IItemAction)ActionProxyFactory.getProxy(" + pInfo.getValue() + ", new Class[] { IItemAction.class }, getServiceContext())";
        } else if (pInfo.getName().equalsIgnoreCase("items")) {
            String[] s = StringUtils.split((String)pInfo.getValue(), (String)";");
            args = "new String[] {";
            int n = s.length;
            for (int i = 0; i < n; ++i) {
                args = i == 0 ? args + "\"" + s[i] + "\"" : args + ",\"" + s[i] + "\"";
            }
            args = args + "}";
        } else if (type.equals("java.lang.String")) {
            String s = pInfo.getValue();
            s = StringUtils.replace((String)s, (String)"\\", (String)"\\\\");
            s = StringUtils.replace((String)s, (String)"\"", (String)"\\\"");
            args = "\"" + s + "\"";
        } else if (type.equals("java.lang.Character")) {
            args = "'" + pInfo.getValue() + "'";
        } else if (type.equals("java.awt.Dimension")) {
            args = "new Dimension(" + pInfo.getValue() + ")";
        } else if (type.equals("float")) {
            args = pInfo.getValue() + "f";
        } else if (type.equals("int") || type.equals("long") || type.equals("boolean") || type.equals("double")) {
            args = pInfo.getValue();
        } else if (type.equals("java.math.BigDecimal")) {
            args = " new java.math.BigDecimal(" + pInfo.getValue() + ")";
        } else if (type.equals("java.awt.Color")) {
            String[] s = StringUtils.split((String)pInfo.getValue(), (String)",");
            args = "new java.awt.Color(" + s[0].substring(s[0].indexOf("=") + 1) + "," + s[1].substring(s[1].indexOf("=") + 1) + "," + s[2].substring(s[2].indexOf("=") + 1) + ")";
        } else if (type.equals("java.awt.Font")) {
            String[] s = StringUtils.split((String)pInfo.getValue(), (String)",");
            args = "new java.awt.Font(\"" + s[0].substring(s[0].indexOf("=") + 1) + "\"," + s[2].substring(s[2].indexOf("=") + 1) + "," + s[3].substring(s[3].indexOf("=") + 1) + ")";
        } else if (type.equals("javax.swing.border.Border")) {
            args = BorderPropertyUtil.toJavaCode(pInfo.getValue(), controlName);
        } else if (type.equals("javax.swing.Icon")) {
            args = "com.kingdee.eas.util.client.EASResource.getIcon(\"" + pInfo.getValue() + "\")";
        } else if (type.equals("java.awt.Insets")) {
            args = "new java.awt.Insets(" + pInfo.getValue() + ")";
        } else {
            String s = pInfo.getValue();
            s = StringUtils.replace((String)s, (String)"\"", (String)"\\\"");
            s = StringUtils.replace((String)s, (String)"\\", (String)"\\\\");
            args = "\"" + s + "\"";
        }
        return args;
    }

    private String getEnumClass(String metaPK) {
        try {
            IBizEnumCtrl enumCtrl = (IBizEnumCtrl)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.BIZENUM);
            return enumCtrl.getValue(MetaDataPK.create(metaPK)).getClassName();
        }
        catch (BOSException e) {
            logger.error((Object)"error", (Throwable)e);
            return "";
        }
    }

    private String findTableBindingField(String dataObjName, String bindingFieldName) {
        if (StringUtils.isEmpty((String)dataObjName) || StringUtils.isEmpty((String)bindingFieldName)) {
            return "";
        }
        DataObjectInfo dataObjInfo = this.model.getDataObjects().getDataObject(dataObjName);
        IObjectValue tempObjValue = dataObjInfo.getInstance();
        if (tempObjValue == null || !(tempObjValue instanceof EntityObjectInfo)) {
            return "";
        }
        EntityObjectInfo entity = (EntityObjectInfo)tempObjValue;
        String[] s = StringUtils.split((String)bindingFieldName, (String)".");
        for (int i = 0; i < s.length; ++i) {
            com.kingdee.bos.metadata.entity.PropertyInfo pInfo = entity.getPropertyByName(s[i]);
            if (!(pInfo instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relationship = ((LinkPropertyInfo)pInfo).getRelationship();
            if (relationship.getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || relationship.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
                String validBindingField = s[0];
                for (int j = 1; j < i; ++j) {
                    validBindingField = validBindingField + "." + s[j];
                }
                return validBindingField;
            }
            entity = relationship.getClientObject();
        }
        return "";
    }

    private String getGetMethodString(String objectName, String fieldName, String type) {
        String expr = "";
        String[] s = StringUtils.split((String)fieldName, (String)".");
        String getMethodString = objectName;
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                if (type.equals("boolean")) {
                    getMethodString = getMethodString + ".is" + StringUtils.headCharUpperCase((String)s[i]) + "()";
                    continue;
                }
                getMethodString = getMethodString + ".get" + StringUtils.headCharUpperCase((String)s[i]) + "()";
                continue;
            }
            getMethodString = getMethodString + ".get" + StringUtils.headCharUpperCase((String)s[i]) + "()";
        }
        return getMethodString;
    }

    private String bindCloneQuery(ComponentInfo cInfo) {
        int n = cInfo.getPropertyBindings().size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(i);
            if (!this.cloneQueryList.contains(pbInfo.getBindingObject())) continue;
            return pbInfo.getBindingObject();
        }
        return null;
    }

    private String getMethodName(String type) {
        String methodName = "";
        methodName = type.equals("java.lang.String") ? "String" : (type.equals("java.lang.Character") ? "Char" : (type.equals("java.awt.Dimension") ? "Dimension" : (type.equals("float") ? "Float" : (type.equals("double") ? "Double" : (type.equals("java.math.BigDecimal") ? "BigDecimal" : (type.equals("int") ? "Int" : (type.equals("long") ? "Long" : (type.equals("boolean") ? "Boolean" : (type.equals("java.util.Date") || type.equals("java.sql.Date") ? "Date" : (type.equals("java.awt.Color") ? "Color" : (type.equals("java.awt.Font") ? "Font" : (type.equals("javax.swing.border.Border") ? "Border" : (type.equals("javax.swing.Icon") ? "Icon" : (type.equals("java.awt.Insets") ? "Insets" : type.substring(type.lastIndexOf(".") + 1)))))))))))))));
        return methodName;
    }

    private String getColumnBindQueryPK(ComponentInfo cInfo, String columnName) {
        if (StringUtils.isEmpty((String)columnName) || !this.headerList.containsKey(cInfo.getName())) {
            return null;
        }
        String[] columns = (String[])this.headerList.get(cInfo.getName());
        String bindObjectName = "";
        String tableColumnName = "";
        String sQueryPK = null;
        boolean hasFoundBindingField = false;
        int n = cInfo.getPropertyBindings().size();
        for (int j = 0; j < n; ++j) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(j);
            if (pbInfo.getPropertyName().indexOf(".text") < 0 || !(tableColumnName = StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"")).equalsIgnoreCase(columnName)) continue;
            bindObjectName = pbInfo.getBindingObject();
            String sbindField = pbInfo.getBingdingField();
            int m = this.model.getDataObjects().size();
            for (int i = 0; i < m; ++i) {
                RelationshipInfo relationShip;
                EntityObjectInfo supplyEntityInfo;
                EntityObjectInfo entity;
                com.kingdee.bos.metadata.entity.PropertyInfo prop;
                IObjectValue objectValue;
                if (!this.model.getDataObjects().get(i).getName().equals(bindObjectName) || (objectValue = this.model.getDataObjects().get(i).getInstance()) == null || !(objectValue instanceof EntityObjectInfo) || (prop = this.getPropertyByName(entity = (EntityObjectInfo)objectValue, sbindField)) == null || !(prop instanceof LinkPropertyInfo) || (supplyEntityInfo = (relationShip = ((LinkPropertyInfo)prop).getRelationship()).getSupplierObject()) == null || StringUtils.isEmpty((String)(sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query")))) continue;
                return sQueryPK;
            }
        }
        return null;
    }

    private com.kingdee.bos.metadata.entity.PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n && (prop = subEntity.getPropertyByName(propertys[i], true)) != null && prop instanceof LinkPropertyInfo; ++i) {
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            prop = null;
            break;
        }
        return prop;
    }

    private static String getNumberFormat(int precision) {
        String format = "0.";
        for (int i = 0; i < precision; ++i) {
            format = format + "0";
        }
        return format;
    }

    private String generateLayoutCode(String tabStr, String parentName, String parentClassType, LayoutInfo layoutInfo, String layoutType, Object constraint) {
        if (TSCROLLPANE.equals(parentClassType) || KDTABBEDPANE.equals(parentClassType) || "com.kingdee.bos.ctrl.swing.KDTreeView".equals(parentClassType) || "com.kingdee.bos.ctrl.swing.KDSplitPane".equals(parentClassType) || "com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(parentClassType)) {
            return "";
        }
        if (KDCONTAINER.equals(parentClassType)) {
            return this.generateLayoutCode(tabStr, parentName, parentClassType, layoutInfo, layoutType, constraint, ".getContentPane()");
        }
        return this.generateLayoutCode(tabStr, parentName, parentClassType, layoutInfo, layoutType, constraint, "");
    }

    private String generateLayoutCode(String tabStr, String parentName, String parentClassType, LayoutInfo layoutInfo, String layoutType, Object constraint, String specialStr) {
        StringBuffer retStr = new StringBuffer();
        if (layoutType == null || "XYLayout".equals(layoutType)) {
            retStr.append(tabStr + parentName + specialStr + ".setLayout(null);");
        } else if ("KDLayout".equals(layoutType)) {
            Object tempCons = constraint;
            String strOriginalBounds = null;
            if (tempCons != null && (tempCons instanceof Rectangle || tempCons instanceof KDLayoutConstraint)) {
                if (tempCons instanceof Rectangle) {
                    strOriginalBounds = ".putClientProperty(\"OriginalBounds\", new Rectangle(" + ((Rectangle)tempCons).x + ", " + ((Rectangle)tempCons).y + ", " + ((Rectangle)tempCons).width + ", " + ((Rectangle)tempCons).height + "));";
                } else if (tempCons instanceof KDLayoutConstraint) {
                    strOriginalBounds = ".putClientProperty(\"OriginalBounds\", new Rectangle(" + ((KDLayoutConstraint)tempCons).x + ", " + ((KDLayoutConstraint)tempCons).y + ", " + ((KDLayoutConstraint)tempCons).width + ", " + ((KDLayoutConstraint)tempCons).height + "));";
                }
            }
            retStr.append(tabStr + parentName + specialStr + ".setLayout(new KDLayout());");
            if (strOriginalBounds != null) {
                retStr.append(CLF + tabStr + parentName + specialStr + strOriginalBounds);
            } else {
                retStr.append(CLF + tabStr + "//TODO \u7531\u4e8e\u8be5\u5bb9\u5668\u91c7\u7528KDLayout\u5e03\u5c40\uff0c\u8bf7\u5728\u4e0b\u9762\u4e00\u6761\u8bed\u53e5\u4e2d\u4fee\u6b63\u8be5\u5bb9\u5668\u7684\u521d\u59cb\u5927\u5c0f\uff1a");
                retStr.append(CLF + tabStr + parentName + specialStr + ".putClientProperty(\"OriginalBounds\", new Rectangle(0,0,1,1));");
            }
        } else if ("BorderLayout".equals(layoutType)) {
            Layout tempLayout = LayoutConverter.convertToLayoutObj(layoutInfo);
            int hgap = 0;
            int vgap = 0;
            if (tempLayout instanceof BorderLayout) {
                hgap = ((BorderLayout)tempLayout).getHgap();
                vgap = ((BorderLayout)tempLayout).getVgap();
            }
            retStr.append(parentName + specialStr + ".setLayout(new BorderLayout(" + hgap + ", " + vgap + "));");
        }
        return retStr.toString();
    }

    public String generateInitUIToolBarLayoutCode(String tabStr) {
        if (this.toolBar == null || !"com.kingdee.bos.ctrl.swing.KDToolBar".equals(this.toolBar.getClassType())) {
            return "";
        }
        return this.generateFlowLayoutCode(tabStr, "this.toolBar", this.toolBar.getComponents(), "") + this.recursiveGenInitUIBarLayoutCode(tabStr, this.toolBar.getComponents());
    }

    public String generateInitUIMenuBarLayoutCode(String tabStr) {
        if (this.menuBar == null || !KDMENUBAR.equals(this.menuBar.getClassType())) {
            return "";
        }
        return this.generateFlowLayoutCode(tabStr, "this.menuBar", this.menuBar.getComponents(), "") + this.recursiveGenInitUIBarLayoutCode(tabStr, this.menuBar.getComponents());
    }

    private String recursiveGenInitUIContentLayoutCode(String tabStr, ComponentCollection childCollection) {
        int i;
        StringBuffer retStr = new StringBuffer();
        if (childCollection == null || childCollection.size() == 0) {
            return "";
        }
        Vector<ComponentInfo> kdtablepanels = new Vector<ComponentInfo>();
        int j = childCollection.size();
        for (i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (!childComponent.isContainer()) continue;
            LayoutInfo layoutInfo = childComponent.getLayoutInfo();
            String layoutType = null;
            if (layoutInfo != null) {
                layoutType = layoutInfo.getType();
            }
            if (childComponent.isContainer() && childComponent.getComponents().size() > 0) {
                retStr.append(tabStr + "//" + childComponent.getName() + CLF);
            }
            if ("com.kingdee.bos.ctrl.kdf.tablepanel.KDTablePanel".equals(childComponent.getClassType())) {
                kdtablepanels.add(childComponent);
            } else {
                retStr.append(this.generateLayoutCode(tabStr, childComponent.getName(), childComponent.getClassType(), layoutInfo, layoutType, childComponent.getConstraint()));
            }
            retStr.append(this.generateChildControlCode(tabStr, childComponent.getName(), childComponent.getClassType(), childComponent.getComponents(), layoutType));
            retStr.append(this.recursiveGenInitUIContentLayoutCode(tabStr, childComponent.getComponents()));
        }
        j = kdtablepanels.size();
        for (i = 0; i < j; ++i) {
            ComponentInfo com = (ComponentInfo)kdtablepanels.get(i);
            retStr.append("        ");
            retStr.append(com.getName());
            retStr.append(".doAutoLayout();");
            retStr.append("\n");
        }
        return retStr.toString();
    }

    private String recursiveGenInitUIBarLayoutCode(String tabStr, ComponentCollection childCollection) {
        StringBuffer retStr = new StringBuffer();
        if (childCollection == null || childCollection.size() == 0) {
            return "";
        }
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (!childComponent.isContainer()) continue;
            LayoutInfo layoutInfo = childComponent.getLayoutInfo();
            String layoutType = null;
            if (layoutInfo != null) {
                layoutType = layoutInfo.getType();
            }
            if (childComponent.isContainer() && childComponent.getComponents().size() > 0) {
                retStr.append(tabStr + "//" + childComponent.getName() + CLF);
            }
            retStr.append(this.generateFlowLayoutCode(tabStr, childComponent.getName(), childComponent.getComponents(), ""));
            retStr.append(this.recursiveGenInitUIBarLayoutCode(tabStr, childComponent.getComponents()));
        }
        return retStr.toString();
    }

    private String generateChildControlCode(String tabStr, String parentName, String parentClassType, ComponentCollection childCollection, String layoutType) {
        if (childCollection == null || childCollection.size() == 0) {
            return "";
        }
        if (TSCROLLPANE.equals(parentClassType)) {
            return this.generateChildControlCodeForScrollPane(tabStr, parentName, childCollection);
        }
        if (KDTABBEDPANE.equals(parentClassType)) {
            return this.generateTabbedPaneLayoutCode(tabStr, parentName, childCollection);
        }
        if ("com.kingdee.bos.ctrl.swing.KDTreeView".equals(parentClassType)) {
            return this.generateTreeViewLayoutCode(tabStr, parentName, childCollection);
        }
        if ("com.kingdee.bos.ctrl.swing.KDSplitPane".equals(parentClassType)) {
            return this.generateSplitLayoutCode(tabStr, parentName, childCollection);
        }
        if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(parentClassType)) {
            return this.generateLabelContainerLayoutCode(tabStr, parentName, childCollection);
        }
        if (KDCONTAINER.equals(parentClassType)) {
            return this.generateChildControlLayout(tabStr, parentName, childCollection, layoutType, ".getContentPane()");
        }
        return this.generateChildControlLayout(tabStr, parentName, childCollection, layoutType, "");
    }

    private String generateChildControlLayout(String tabStr, String parentName, ComponentCollection childCollection, String layoutType, String specialStr) {
        if (layoutType == null || "XYLayout".equals(layoutType)) {
            return this.generateXYLayoutCode(tabStr, parentName, childCollection, specialStr);
        }
        if ("KDLayout".equals(layoutType)) {
            return this.generateKDLayoutCode(tabStr, parentName, childCollection, specialStr);
        }
        if ("SameGridLayout".equals(layoutType)) {
            return this.generateSameGridLayoutCode(tabStr, parentName, childCollection, specialStr);
        }
        if ("BorderLayout".equals(layoutType)) {
            return this.generateBorderLayoutCode(tabStr, parentName, childCollection, specialStr);
        }
        return "";
    }

    private String generateChildControlCodeForScrollPane(String tabStr, String parentName, ComponentCollection childCollection) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            retStr.append(tabStr + parentName + ".getViewport().add(" + componentName + ", null);" + CLF);
        }
        return retStr.toString();
    }

    private String generateXYLayoutCode(String tabStr, String parentName, ComponentCollection childCollection, String specialStr) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            if (constraint != null && constraint instanceof Rectangle) {
                Rectangle rect = (Rectangle)constraint;
                retStr.append(tabStr + componentName + ".setBounds(new Rectangle(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + "));" + CLF);
            }
            if (KDTABLE.equals(childComponent.getClassType()) && this.isBuildDetail(childComponent)) {
                String entryClassName = this.getBindedEntryClassName(childComponent);
                if (!StringUtils.isEmpty((String)entryClassName)) {
                    String definePanel = componentName + "_detailPanel = (com.kingdee.eas.framework.client.multiDetail.DetailPanel)com.kingdee.eas.framework.client.multiDetail.HMDUtils.buildDetail(this,dataBinder," + componentName + ",new " + entryClassName + "(),null," + this.isGenAgentCode() + ");";
                    componentName = componentName + "_detailPanel";
                    retStr.append(tabStr + definePanel + CLF);
                    retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", null);" + CLF);
                    String applyDefaultValueCode = RuleJCodeWriter.genApplyDefaultValue(this.model, childComponent, componentName);
                    if (StringUtils.isEmpty((String)applyDefaultValueCode)) continue;
                    retStr.append(applyDefaultValueCode);
                    continue;
                }
                retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", null);" + CLF);
                continue;
            }
            retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", null);" + CLF);
        }
        return retStr.toString();
    }

    private boolean isBuildDetail(ComponentInfo cInfo) {
        String value = cInfo.getExtendedProperty("buildDetail");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private String getBindedEntryClassName(ComponentInfo cInfo) {
        int n = cInfo.getPropertyBindings().size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo propbInfo = cInfo.getPropertyBindings().get(i);
            if (!"userObject".equalsIgnoreCase(propbInfo.getPropertyName())) continue;
            if (propbInfo.getFieldType().endsWith("Collection")) {
                return propbInfo.getFieldType().substring(0, propbInfo.getFieldType().length() - 10) + "Info";
            }
            return null;
        }
        return null;
    }

    private String generateSameGridLayoutCode(String tabStr, String parentName, ComponentCollection childCollection, String specialStr) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            String tempConsCode = "null";
            if (constraint != null && constraint instanceof Rectangle) {
                Rectangle rect = (Rectangle)constraint;
                tempConsCode = "new SameGridConstraints(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + ")";
            }
            if (KDTABLE.equals(childComponent.getClassType()) && this.isBuildDetail(childComponent)) {
                String entryClassName = this.getBindedEntryClassName(childComponent);
                if (!StringUtils.isEmpty((String)entryClassName)) {
                    String definePanel = componentName + "_detailPanel = (com.kingdee.eas.framework.client.multiDetail.DetailPanel)com.kingdee.eas.framework.client.multiDetail.HMDUtils.buildDetail(this,dataBinder," + componentName + ",new " + entryClassName + "(),null," + this.isGenAgentCode() + ");";
                    componentName = componentName + "_detailPanel";
                    retStr.append(tabStr + definePanel + CLF);
                    retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", " + tempConsCode + ");" + CLF);
                    String applyDefaultValueCode = RuleJCodeWriter.genApplyDefaultValue(this.model, childComponent, componentName);
                    if (StringUtils.isEmpty((String)applyDefaultValueCode)) continue;
                    retStr.append(applyDefaultValueCode);
                    continue;
                }
                retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", " + tempConsCode + ");" + CLF);
                continue;
            }
            retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", " + tempConsCode + ");" + CLF);
        }
        return retStr.toString();
    }

    private String generateKDLayoutCode(String tabStr, String parentName, ComponentCollection childCollection, String specialStr) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            String tempConsCode = "null";
            if (constraint != null && constraint instanceof KDLayoutConstraint) {
                tempConsCode = ((KDLayoutConstraint)constraint).toJavaCode();
                retStr.append(tabStr + componentName + ".setBounds(new Rectangle(" + ((KDLayoutConstraint)constraint).x + ", " + ((KDLayoutConstraint)constraint).y + ", " + ((KDLayoutConstraint)constraint).width + ", " + ((KDLayoutConstraint)constraint).height + "));" + CLF);
            }
            if (KDTABLE.equals(childComponent.getClassType()) && this.isBuildDetail(childComponent)) {
                String entryClassName = this.getBindedEntryClassName(childComponent);
                if (!StringUtils.isEmpty((String)entryClassName)) {
                    String definePanel = componentName + "_detailPanel = (com.kingdee.eas.framework.client.multiDetail.DetailPanel)com.kingdee.eas.framework.client.multiDetail.HMDUtils.buildDetail(this,dataBinder," + componentName + ",new " + entryClassName + "(),null," + this.isGenAgentCode() + ");";
                    componentName = componentName + "_detailPanel";
                    retStr.append(tabStr + definePanel + CLF);
                    retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", " + tempConsCode + ");" + CLF);
                    String applyDefaultValueCode = RuleJCodeWriter.genApplyDefaultValue(this.model, childComponent, componentName);
                    if (StringUtils.isEmpty((String)applyDefaultValueCode)) continue;
                    retStr.append(applyDefaultValueCode);
                    continue;
                }
                retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", " + tempConsCode + ");" + CLF);
                continue;
            }
            retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", " + tempConsCode + ");" + CLF);
        }
        return retStr.toString();
    }

    private String generateBorderLayoutCode(String tabStr, String parentName, ComponentCollection childCollection, String specialStr) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            if (KDTABLE.equals(childComponent.getClassType()) && this.isBuildDetail(childComponent)) {
                String entryClassName = this.getBindedEntryClassName(childComponent);
                if (!StringUtils.isEmpty((String)entryClassName)) {
                    String definePanel = componentName + "_detailPanel = (com.kingdee.eas.framework.client.multiDetail.DetailPanel)com.kingdee.eas.framework.client.multiDetail.HMDUtils.buildDetail(this,dataBinder," + componentName + ",new " + entryClassName + "(),null," + this.isGenAgentCode() + ");";
                    componentName = componentName + "_detailPanel";
                    retStr.append(tabStr + definePanel + CLF);
                    retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", BorderLayout." + constraint.toString().toUpperCase() + ");" + CLF);
                    String applyDefaultValueCode = RuleJCodeWriter.genApplyDefaultValue(this.model, childComponent, componentName);
                    if (StringUtils.isEmpty((String)applyDefaultValueCode)) continue;
                    retStr.append(applyDefaultValueCode);
                    continue;
                }
                retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", BorderLayout." + constraint.toString().toUpperCase() + ");" + CLF);
                continue;
            }
            retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ", BorderLayout." + constraint.toString().toUpperCase() + ");" + CLF);
        }
        return retStr.toString();
    }

    private String generateTabbedPaneLayoutCode(String tabStr, String parentName, ComponentCollection childCollection) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            if (constraint == null || !(constraint instanceof String)) continue;
            if (KDTABLE.equals(childComponent.getClassType()) && this.isBuildDetail(childComponent)) {
                String entryClassName = this.getBindedEntryClassName(childComponent);
                if (!StringUtils.isEmpty((String)entryClassName)) {
                    String definePanel = componentName + "_detailPanel = (com.kingdee.eas.framework.client.multiDetail.DetailPanel)com.kingdee.eas.framework.client.multiDetail.HMDUtils.buildDetail(this,dataBinder," + componentName + ",new " + entryClassName + "(),null," + this.isGenAgentCode() + ");";
                    componentName = componentName + "_detailPanel";
                    retStr.append(tabStr + definePanel + CLF);
                    retStr.append(tabStr + parentName + ".add(" + componentName + ", resHelper.getString(\"" + componentName + ".constraints\"));" + CLF);
                    String applyDefaultValueCode = RuleJCodeWriter.genApplyDefaultValue(this.model, childComponent, componentName);
                    if (StringUtils.isEmpty((String)applyDefaultValueCode)) continue;
                    retStr.append(applyDefaultValueCode);
                    continue;
                }
                retStr.append(tabStr + parentName + ".add(" + componentName + ", resHelper.getString(\"" + componentName + ".constraints\"));" + CLF);
                continue;
            }
            retStr.append(tabStr + parentName + ".add(" + componentName + ", resHelper.getString(\"" + componentName + ".constraints\"));" + CLF);
        }
        return retStr.toString();
    }

    private String generateTreeViewLayoutCode(String tabStr, String parentName, ComponentCollection childCollection) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (!"com.kingdee.bos.ctrl.swing.KDTree".equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            retStr.append(tabStr + parentName + ".setTree(" + componentName + ");" + CLF);
        }
        return retStr.toString();
    }

    private String generateSplitLayoutCode(String tabStr, String parentName, ComponentCollection childCollection) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            if (KDTABLE.equals(childComponent.getClassType()) && this.isBuildDetail(childComponent)) {
                String entryClassName = this.getBindedEntryClassName(childComponent);
                if (!StringUtils.isEmpty((String)entryClassName)) {
                    String definePanel = componentName + "_detailPanel = (com.kingdee.eas.framework.client.multiDetail.DetailPanel)com.kingdee.eas.framework.client.multiDetail.HMDUtils.buildDetail(this,dataBinder," + componentName + ",new " + entryClassName + "(),null," + this.isGenAgentCode() + ");";
                    componentName = componentName + "_detailPanel";
                    retStr.append(tabStr + definePanel + CLF);
                    retStr.append(tabStr + parentName + ".add(" + componentName + ", " + "\"" + constraint.toString() + "\"" + ");" + CLF);
                    String applyDefaultValueCode = RuleJCodeWriter.genApplyDefaultValue(this.model, childComponent, componentName);
                    if (StringUtils.isEmpty((String)applyDefaultValueCode)) continue;
                    retStr.append(applyDefaultValueCode);
                    continue;
                }
                retStr.append(tabStr + parentName + ".add(" + componentName + ", " + "\"" + constraint.toString() + "\"" + ");" + CLF);
                continue;
            }
            retStr.append(tabStr + parentName + ".add(" + componentName + ", " + "\"" + constraint.toString() + "\"" + ");" + CLF);
        }
        return retStr.toString();
    }

    private String generateLabelContainerLayoutCode(String tabStr, String parentName, ComponentCollection childCollection) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            Object constraint = childComponent.getConstraint();
            retStr.append(tabStr + parentName + ".setBoundEditor(" + componentName + ");" + CLF);
        }
        return retStr.toString();
    }

    private String generateFlowLayoutCode(String tabStr, String parentName, ComponentCollection childCollection, String specialStr) {
        StringBuffer retStr = new StringBuffer();
        int j = childCollection.size();
        for (int i = 0; i < j; ++i) {
            ComponentInfo childComponent = childCollection.get(i);
            if (TBUTTONGROUP.equals(childComponent.getClassType())) continue;
            String componentName = childComponent.getName();
            if (KDTABLE.equals(childComponent.getClassType()) && this.isBuildDetail(childComponent)) {
                String entryClassName = this.getBindedEntryClassName(childComponent);
                if (!StringUtils.isEmpty((String)entryClassName)) {
                    String definePanel = componentName + "_detailPanel = (com.kingdee.eas.framework.client.multiDetail.DetailPanel)com.kingdee.eas.framework.client.multiDetail.HMDUtils.buildDetail(this,dataBinder," + componentName + ",new " + entryClassName + "(),null," + this.isGenAgentCode() + ");";
                    componentName = componentName + "_detailPanel";
                    retStr.append(tabStr + definePanel + CLF);
                    retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ");" + CLF);
                    String applyDefaultValueCode = RuleJCodeWriter.genApplyDefaultValue(this.model, childComponent, componentName);
                    if (StringUtils.isEmpty((String)applyDefaultValueCode)) continue;
                    retStr.append(applyDefaultValueCode);
                    continue;
                }
                retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ");" + CLF);
                continue;
            }
            if (this.isCustomizedToolBarButton(childComponent) && "this.toolbar".equalsIgnoreCase(parentName)) {
                retStr.append(tabStr + "this.customToolBar.add(" + componentName + ");" + CLF);
                continue;
            }
            retStr.append(tabStr + parentName + specialStr + ".add(" + componentName + ");" + CLF);
        }
        return retStr.toString();
    }

    private String getLoadExpression(ComponentInfo cInfo, PropertyBindingInfo pbInfo) {
        return this.getLoadExpression(cInfo, pbInfo, null);
    }

    private String getLoadExpression(ComponentInfo cInfo, PropertyBindingInfo pbInfo, String value) {
        String expr = "";
        String componentName = this.getComponentName(cInfo);
        String[] s = StringUtils.split((String)pbInfo.getBingdingField(), (String)".");
        String getFieldString = pbInfo.getBindingObject();
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                if (pbInfo.getFieldType().equals("boolean")) {
                    getFieldString = getFieldString + ".is" + StringUtils.headCharUpperCase((String)s[i]) + "()";
                    continue;
                }
                getFieldString = getFieldString + ".get" + StringUtils.headCharUpperCase((String)s[i]) + "()";
                continue;
            }
            getFieldString = getFieldString + ".get" + StringUtils.headCharUpperCase((String)s[i]) + "()";
        }
        if ("com.kingdee.bos.ctrl.swing.KDCurrencyTextField".equalsIgnoreCase(cInfo.getClassType()) && "value".equalsIgnoreCase(pbInfo.getPropertyName())) {
            if (!StringUtils.isEmpty((String)getFieldString)) {
                expr = componentName + ".set" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "(new java.math.BigDecimal(" + getFieldString + "));";
            }
            return expr;
        }
        expr = value == null ? (pbInfo.getPropertyName().equals("selectedValue") ? componentName + ".set" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "(" + this.convertType(getFieldString, pbInfo.getFieldType(), pbInfo.getPropertyType()) + ",true);" : componentName + ".set" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "(" + this.convertType(getFieldString, pbInfo.getFieldType(), pbInfo.getPropertyType()) + ");") : componentName + ".set" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "(" + value + ");";
        return expr;
    }

    public String convertType(String srcValue, String srcType, String desType) {
        String desValue = "";
        desValue = srcType.equals(desType) || StringUtils.replace((String)srcType, (String)"java.lang.", (String)"").equals(desType) || StringUtils.replace((String)desType, (String)"java.lang.", (String)"").equals(srcType) ? srcValue : (desType.equals("String") || desType.equals("java.lang.String") ? "String.valueOf(" + srcValue + ")" : ((srcType.equals("java.util.Date") || srcType.equals("java.sql.Timestamp") || srcType.equals("java.sql.Time")) && (desType.equals("java.util.Date") || desType.equals("java.sql.Timestamp") || desType.equals("java.sql.Time")) ? (desType.equals("java.util.Date") ? srcValue : "new " + desType + "(" + srcValue + ".getTime())") : (srcType.equals("String") || srcType.equals("java.lang.String") ? (desType.equals("Object") || desType.equals("java.lang.Object") ? srcValue : (desType.equals("float") ? "Float.parseFloat(" + srcValue + ")" : (desType.equals("java.lang.Float") ? "new Float(" + srcValue + ")" : (desType.equals("double") ? "Double.parseDouble(" + srcValue + ")" : (desType.equals("java.lang.Double") ? "new Double(" + srcValue + ")" : (desType.equals("int") ? "Integer.parseInt(" + srcValue + ")" : (desType.equals("java.lang.Integer") ? "new Integer(" + srcValue + ")" : (desType.equals("long") ? "Long.parseLong(" + srcValue + ")" : (desType.equals("java.lang.Long") ? "new Long(" + srcValue + ")" : (desType.equals("boolean") ? "Boolean.valueOf(" + srcValue + ")" : (desType.equals("java.lang.Boolean") ? "new Boolean(" + srcValue + ")" : (desType.equals("java.util.Date") ? "new java.util.Date(" + srcValue + ")" : (desType.equals("java.sql.Date") ? "java.sql.Date.valueOf(" + srcValue + ")" : (desType.equals("BOSUuid") || desType.equals("com.kingdee.bos.util.BOSUuid") ? "BOSUuid.read(" + srcValue + ")" : (desType.equals("java.math.BigDecimal") ? "new java.math.BigDecimal(" + srcValue + ")" : (desType.equals("java.math.BigInteger") ? "new java.math.BigInteger(" + srcValue + ")" : "String.valueOf(" + srcValue + ")")))))))))))))))) : (srcType.equals("Object") || srcType.equals("java.lang.Object") ? (desType.equals("float") ? "Float.parseFloat(String.valueOf(" + srcValue + "))" : (desType.equals("double") ? "Double.parseDouble(String.valueOf(" + srcValue + "))" : (desType.equals("int") ? "Integer.parseInt(String.valueOf(" + srcValue + "))" : (desType.equals("long") ? "Long.parseLong(String.valueOf(" + srcValue + "))" : (desType.equals("boolean") ? "Boolean.valueOf(String.valueOf(" + srcValue + "))" : (desType.indexOf(".") >= 0 ? "(" + desType + ")" + srcValue : srcValue)))))) : (desType.equals("Object") || desType.equals("java.lang.Object") ? (srcType.equals("float") ? "new Float(" + srcValue + ")" : (srcType.equals("double") ? "new Double(" + srcValue + ")" : (srcType.equals("int") ? "new Integer(" + srcValue + ")" : (srcType.equals("long") ? "new Long(" + srcValue + ")" : (srcType.equals("boolean") ? "new Boolean(" + srcValue + ")" : srcValue))))) : srcValue)))));
        return desValue;
    }

    private String getStoreExpression(ComponentInfo cInfo, PropertyBindingInfo pbInfo) {
        String expr = "";
        String componentName = this.getComponentName(cInfo);
        String[] s = StringUtils.split((String)pbInfo.getBingdingField(), (String)".");
        String getFieldString = pbInfo.getBindingObject();
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            getFieldString = i == n - 1 ? getFieldString + ".set" + StringUtils.headCharUpperCase((String)s[i]) + "(" : getFieldString + ".get" + StringUtils.headCharUpperCase((String)s[i]) + "()";
        }
        if (pbInfo.getPropertyType().equals("boolean")) {
            expr = getFieldString + this.convertType(componentName + ".is" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "()", pbInfo.getPropertyType(), pbInfo.getFieldType()) + ");";
        } else if ((cInfo.getClassType().equalsIgnoreCase(KDDATEPICKER) || cInfo.getClassType().equalsIgnoreCase(KDTIMEPICKER)) && pbInfo.getPropertyName().equals("value")) {
            expr = Date.class.getName().equals(pbInfo.getFieldType()) ? getFieldString + "com.kingdee.util.DateTimeUtils.truncateDate((java.util.Date)" + componentName + ".get" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "(java.util.Date.class)));" : getFieldString + "(" + pbInfo.getFieldType() + ")" + componentName + ".get" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "(" + pbInfo.getFieldType() + ".class));";
        } else if ((cInfo.getClassType().equalsIgnoreCase(KDFORMATTEDTEXTFIELD) || cInfo.getClassType().equalsIgnoreCase(KDNUMBERTEXTFIELD) || cInfo.getClassType().equalsIgnoreCase(KDSPINNER)) && pbInfo.getPropertyName().equals("value")) {
            String fieldType = pbInfo.getFieldType();
            String primitiveTypeExpression = ")." + pbInfo.getFieldType() + "Value()";
            if (pbInfo.getFieldType().equalsIgnoreCase("boolean")) {
                fieldType = "Boolean";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("char")) {
                fieldType = "Char";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("byte")) {
                fieldType = "Byte";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("short")) {
                fieldType = "Short";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("int")) {
                fieldType = "Integer";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("long")) {
                fieldType = "Long";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("float")) {
                fieldType = "Float";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("double")) {
                fieldType = "Double";
            } else if (pbInfo.getFieldType().equalsIgnoreCase("BigDecimal")) {
                fieldType = "java.math.BigDecimal";
            } else {
                primitiveTypeExpression = "";
            }
            String fieldTypeExpression = primitiveTypeExpression.equals("") ? fieldType : "(" + fieldType;
            expr = getFieldString + "(" + fieldTypeExpression + ")" + componentName + ".get" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "(" + fieldType + ".class)" + primitiveTypeExpression + ");";
        } else {
            expr = getFieldString + this.convertType(componentName + ".get" + StringUtils.headCharUpperCase((String)pbInfo.getPropertyName()) + "()", pbInfo.getPropertyType(), pbInfo.getFieldType()) + ");";
        }
        return expr;
    }

    private String bindQuery(ComponentInfo cInfo) {
        int n = cInfo.getPropertyBindings().size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = cInfo.getPropertyBindings().get(i);
            if (!this.queryList.contains(pbInfo.getBindingObject())) continue;
            return pbInfo.getBindingObject();
        }
        return null;
    }

    private ComponentInfo getKDTableComponent(UIObjectInfo entryUI) {
        ComponentCollection cCol = this.treeToCol(entryUI.getComponents());
        int n = cCol.size();
        for (int i = 0; i < n; ++i) {
            if (!KDTABLE.equalsIgnoreCase(cCol.get(i).getClassType())) continue;
            return cCol.get(i);
        }
        return null;
    }

    private ComponentInfo getEntryTable(IMetaDataPK entryUIPK) {
        try {
            UIObjectInfo entryUI = new UIObjectCtrl(ContextManager.getContext()).getValue(entryUIPK);
            return this.getKDTableComponent(entryUI);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ComponentInfo getTableComonentInfo() {
        int m = this.components.size();
        for (int i = 0; i < m; ++i) {
            ComponentInfo cInfo = this.components.get(i);
            if (cInfo.getClassType() == null || !cInfo.getClassType().equalsIgnoreCase(KDTABLE)) continue;
            return cInfo;
        }
        return null;
    }

    protected JoinQueryInfo getBindedQueryForListUI() {
        DataObjectInfo dInfo;
        IObjectValue objectValue = null;
        int n = this.model.getDataObjects().size();
        for (int i = 0; i < n && !(dInfo = this.model.getDataObjects().get(i)).getObjectType().equals(MetaDataTypeList.ENTITY.toString()); ++i) {
            if (!dInfo.getObjectType().equals(MetaDataTypeList.UNIONQUERY.toString()) && !dInfo.getObjectType().equals(MetaDataTypeList.JOINQUERY.toString())) continue;
            objectValue = dInfo.getInstanceOfQueryForBim();
            if (objectValue == null || !(objectValue instanceof JoinQueryInfo)) break;
            return (JoinQueryInfo)objectValue;
        }
        return null;
    }

    private EntityObjectInfo getBindedEntityForTable(ComponentInfo cInfo) {
        com.kingdee.bos.metadata.entity.PropertyInfo prop;
        DataObjectInfo editData;
        IObjectValue objValue;
        String entryPropertyName = this.getBindedEntryPropertyNameForTable(cInfo);
        if (!StringUtils.isEmpty((String)entryPropertyName) && this.model.getDataObjects().size() > 0 && (objValue = (editData = this.model.getDataObjects().get(0)).getInstance()) != null && objValue instanceof EntityObjectInfo && (prop = ((EntityObjectInfo)objValue).getPropertyByName(entryPropertyName, true)) != null && prop instanceof LinkPropertyInfo) {
            RelationshipInfo rel = ((LinkPropertyInfo)prop).getRelationship();
            return rel.getSupplierObject();
        }
        return null;
    }

    private String getTableColumnName(ComponentInfo kdTable, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        PropertyBindingCollection pbCol = kdTable.getPropertyBindings();
        int n = pbCol.size();
        for (int i = 0; i < n; ++i) {
            PropertyBindingInfo pbInfo = pbCol.get(i);
            if (!pbInfo.getBingdingField().endsWith(fieldName) || StringUtils.isEmpty((String)pbInfo.getPropertyName())) continue;
            return StringUtils.replace((String)pbInfo.getPropertyName(), (String)".text", (String)"");
        }
        return null;
    }

    private String getBindedEntryPropertyNameForTable(ComponentInfo cInfo) {
        if (cInfo == null || !KDTABLE.equalsIgnoreCase(cInfo.getClassType())) {
            return null;
        }
        String bindedDataFieldName = null;
        PropertyBindingCollection pbCol = cInfo.getPropertyBindings();
        if (pbCol.size() > 0) {
            int n = pbCol.size();
            for (int i = 0; i < n; ++i) {
                PropertyBindingInfo pbInfo = pbCol.get(i);
                if (pbInfo.getPropertyName() == null || pbInfo.getPropertyName().indexOf(".text") <= 0) continue;
                bindedDataFieldName = pbInfo.getBingdingField().substring(0, pbInfo.getBingdingField().indexOf("."));
                break;
            }
        }
        return bindedDataFieldName;
    }

    private boolean isPrimaryType(String type) {
        return "int".equals(type) || "float".equals(type) || "long".equals(type) || "double".equals(type) || "boolean".equals(type) || "byte".equals(type) || "char".equals(type) || "short".equals(type);
    }

    private boolean isGenAgentCode() {
        if (!this.model.isGenAgent()) {
            return false;
        }
        String agentName = this.getAgentClazName();
        return !StringUtils.isEmpty((String)agentName);
    }

    private String getAgentClazName() {
        IObjectValue objVal;
        DataObjectInfo dInfo;
        String agentName = null;
        if (this.model.getDataObjects().size() > 0 && (dInfo = this.model.getDataObjects().get(0)).getObjectType().equals(MetaDataTypeList.ENTITY.toString()) && (objVal = dInfo.getInstance()) != null && objVal instanceof EntityObjectInfo) {
            agentName = ((EntityObjectInfo)objVal).getBusinessAgent();
        }
        return agentName;
    }

    private boolean isCustomizedToolBarButton(ComponentInfo cInfo) {
        PropertyInfo pInfo = cInfo.getPropertyByName("customizedToolBarButton");
        if (pInfo != null) {
            return "true".equalsIgnoreCase(pInfo.getValue());
        }
        return false;
    }

    public String toAppPackage(String packageName) {
        if (StringUtils.isEmpty((String)packageName)) {
            return "";
        }
        if (packageName.indexOf(".client") >= 0) {
            return StringUtils.replace((String)packageName, (String)".client", (String)".app");
        }
        return packageName;
    }

    public String generate(Object argument) {
        IObjectValue objValue;
        StringBuffer stringBuffer = new StringBuffer();
        Object arg = argument;
        UIObjectInfo model = (UIObjectInfo)arg;
        ComponentCollection components = this.treeToCol(model.getComponents());
        String packageName = model.getReleasePackage();
        String className = StringUtils.replace((String)model.getReleaseClass(), (String)"EditUI", (String)"") + "HMD";
        if (packageName != null && packageName.length() != 0) {
            stringBuffer.append("package ");
            stringBuffer.append(packageName);
            stringBuffer.append(this.TEXT_2);
        }
        stringBuffer.append(this.TEXT_3);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_4);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_5);
        if (model.getDataObjects().size() > 0 && (objValue = model.getDataObjects().get(0).getInstance()) != null && objValue instanceof EntityObjectInfo) {
            stringBuffer.append(this.TEXT_6);
            stringBuffer.append(((EntityObjectInfo)objValue).getBusinessImplName());
            stringBuffer.append(this.TEXT_7);
        }
        stringBuffer.append(this.TEXT_8);
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            String uiObjectPK;
            ComponentInfo cInfo = components.get(i);
            if (cInfo.getClassType() == null || !cInfo.getClassType().equalsIgnoreCase(KDPANEL) || StringUtils.isEmpty((String)cInfo.getBimUIObjectPK()) || StringUtils.isEmpty((String)(uiObjectPK = cInfo.getBimUIObjectPK()))) continue;
            Context ctx = ContextManager.getContext();
            UIObjectCtrl uiCtrl = new UIObjectCtrl(ctx);
            UIObjectInfo entryUI = null;
            try {
                entryUI = uiCtrl.getValueNotCache(MetaDataPK.create(uiObjectPK));
                if (entryUI == null) continue;
                if (!StringUtils.isEmpty((String)(entryUI = UIObjectAssembler.assembleUI(ctx, entryUI)).getReleasePackage())) {
                    stringBuffer.append(this.TEXT_9);
                    stringBuffer.append(entryUI.getReleasePackage());
                    stringBuffer.append(".");
                    stringBuffer.append(entryUI.getReleaseClass());
                    stringBuffer.append("());");
                    continue;
                }
                stringBuffer.append(this.TEXT_12);
                stringBuffer.append(entryUI.getReleaseClass());
                stringBuffer.append("());");
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
        stringBuffer.append(this.TEXT_14);
        return stringBuffer.toString();
    }

    static {
        logger = Logger.getLogger((String)"com.kingdee.bos.metadata.code.AbstractUICodeWriter");
        CLF = System.getProperties().getProperty("line.separator");
    }
}

