/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.templates.compiled;

import com.kingdee.bos.metadata.resource.ResourceInfo;
import com.kingdee.bos.metadata.resource.ResourceItemCollection;
import com.kingdee.bos.metadata.resource.ResourceItemInfo;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class MultiLanguageGenerator {
    protected static String nl;
    protected final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "";
    protected final String TEXT_2 = "=";
    protected final String TEXT_3 = this.NL;
    private static String specialSaveChars;
    private static final char[] hexDigit;

    public static synchronized MultiLanguageGenerator create(String lineSeparator) {
        nl = lineSeparator;
        MultiLanguageGenerator result = new MultiLanguageGenerator();
        nl = null;
        return result;
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        if (StringUtils.isEmpty((String)theString)) {
            return "";
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(MultiLanguageGenerator.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(MultiLanguageGenerator.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(MultiLanguageGenerator.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(MultiLanguageGenerator.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Object arg = argument;
        Object[] args = (Object[])arg;
        ResourceInfo multiLanguageInfo = (ResourceInfo)args[0];
        Locale locale = (Locale)args[1];
        Locale defaultLocale = (Locale)args[2];
        ResourceItemCollection itemCol = multiLanguageInfo.getItems();
        if (itemCol != null) {
            for (int i = 0; i < itemCol.size(); ++i) {
                ResourceItemInfo itemInfo = itemCol.get(i);
                String value = "";
                if (locale == null) {
                    value = MultiLanguageGenerator.saveConvert(itemInfo.getValue(), false);
                } else {
                    itemInfo.setDefaultLocale(defaultLocale);
                    value = MultiLanguageGenerator.saveConvert(itemInfo.getValue(locale), false);
                }
                stringBuffer.append("");
                stringBuffer.append(MultiLanguageGenerator.saveConvert(itemInfo.getLabel(), true));
                stringBuffer.append("=");
                stringBuffer.append(value);
                stringBuffer.append(this.TEXT_3);
            }
        }
        return stringBuffer.toString();
    }

    static {
        specialSaveChars = "=: \t\r\n\f#!";
        hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

