/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.translate;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.code.internal.ASTFlattener;
import com.kingdee.bos.metadata.code.translate.JdtBosTranslator;
import com.kingdee.bos.metadata.code.translate.TranslateException;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XMethod;
import xjavadoc.XTag;
import xjavadoc.filesystem.AbstractFile;

public class FacadeTranslator
extends JdtBosTranslator {
    private XClass xClass;

    @Override
    protected AbstractMetaDataValue getMetaData(CompilationUnit unit) {
        FacadeInfo facade = new FacadeInfo();
        facade = this.assignFacade(unit, facade);
        return facade;
    }

    @Override
    public String transBos2Jdt(AbstractMetaDataValue metaData) throws TranslateException {
        FacadeInfo facade = null;
        String result = "";
        if (!(metaData instanceof FacadeInfo)) {
            return result;
        }
        facade = (FacadeInfo)metaData;
        try {
            CompilationUnit unit = this.constructClass(facade);
            ASTFlattener flattener = new ASTFlattener();
            flattener.visit(unit);
            result = flattener.getFormattedResult(0, "\r\n");
        }
        catch (TranslateException se) {
            throw se;
        }
        catch (Exception e) {
            throw new TranslateException(e);
        }
        return result;
    }

    private FacadeInfo assignFacade(CompilationUnit unit, FacadeInfo facade) {
        String[] comments;
        String comment;
        List types = unit.types();
        if (types.isEmpty()) {
            return null;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        if (typeDeclaration == null) {
            return null;
        }
        this.packageName = this.getPackageName(unit);
        facade.setPackage(this.packageName);
        Javadoc javaDoc = typeDeclaration.getJavadoc();
        if (javaDoc != null && (comment = javaDoc.getComment()).indexOf("alias") > 0 && (comments = StringUtils.split((String)comment, (String)"\r\n")) != null && comments.length > 0) {
            for (int i = 0; i < comments.length; ++i) {
                String line = comments[i];
                int startPosition = line.indexOf("@");
                int endPosition = 0;
                if (startPosition <= 0) continue;
                endPosition = line.indexOf(" ", startPosition);
                String keyWord = "";
                String keyValue = "";
                if (endPosition > 0) {
                    keyWord = line.substring(startPosition + 1, endPosition);
                    keyValue = line.substring(endPosition + 1).trim();
                } else {
                    keyWord = line.substring(startPosition + 1).trim();
                }
                if (!keyWord.equalsIgnoreCase("alias")) continue;
                facade.setAlias(keyValue);
            }
        }
        this.imports = unit.imports();
        this.assignClass(typeDeclaration, facade);
        this.assignMethods(typeDeclaration, facade);
        return facade;
    }

    private void assignClass(TypeDeclaration typeDeclaration, FacadeInfo facade) {
        int typeModifier = typeDeclaration.getModifiers();
        facade.setAccessLevel(AccessLevel.getEnum(this.getAccessLevel(typeModifier)));
        facade.setSubClassingMode(SubClassingMode.getEnum(this.getSubClassingMode(typeModifier)));
        SimpleName typeName = typeDeclaration.getName();
        facade.setName(typeName.toString());
        String qName = this.packageName + "." + typeName.getIdentifier();
        super.getXJavaDoc().reset(false);
        super.getXJavaDoc().addAbstractFile(qName, (AbstractFile)this.xJavadocFile);
        this.xClass = super.getXJavaDoc().getXClass(qName);
        XDoc xDoc = this.xClass.getDoc();
        String comment = xDoc.getCommentText();
        if (comment != null) {
            facade.setDescription(comment);
        }
        for (XTag xTag : xDoc.getTags()) {
            String name = xTag.getName();
            String value = xTag.getValue();
            if (name.equalsIgnoreCase("alias")) {
                facade.setAlias(value);
                continue;
            }
            if (!name.equalsIgnoreCase("stereotype")) continue;
        }
        Name superName = typeDeclaration.getSuperclass();
        FacadeInfo base = new FacadeInfo();
        if (superName != null) {
            String sName = superName.toString();
            if (sName.indexOf(".") > 0) {
                base.setName(sName.substring(sName.lastIndexOf(".")));
                base.setPackage(sName.substring(0, sName.lastIndexOf(".")));
            } else {
                base.setName(sName);
                if (!this.imports.isEmpty()) {
                    for (ImportDeclaration importDeclaration : this.imports) {
                        String importName = importDeclaration.getName().toString();
                        if (importName.indexOf(sName) <= 0) continue;
                        base.setPackage(importName.substring(0, importName.length() - sName.length() - 1));
                    }
                }
            }
            facade.setBaseFacade(base);
        }
    }

    private void assignMethods(TypeDeclaration typeDeclaration, FacadeInfo facade) {
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        if (methods != null && methods.length > 0) {
            for (int i = 0; i < methods.length; ++i) {
                List exceptions;
                MethodInfo methodInfo = new MethodInfo();
                MethodDeclaration method = methods[i];
                int methodModifier = method.getModifiers();
                methodInfo.setAccessLevel(AccessLevel.getEnum(this.getAccessLevel(methodModifier)));
                methodInfo.setSubClassingMode(SubClassingMode.getEnum(this.getSubClassingMode(methodModifier)));
                Type methodType = method.getReturnType();
                int methodDimension = method.getExtraDimensions();
                String typeReference = this.constructDataTypeArray(methodType, methodDimension);
                methodInfo.setDataType(typeReference);
                SimpleName methodName = method.getName();
                methodInfo.setName(methodName.toString());
                boolean isConstructor = method.isConstructor();
                List parameters = method.parameters();
                if (!parameters.isEmpty()) {
                    for (SingleVariableDeclaration parameter : parameters) {
                        ParameterInfo parameterInfo = new ParameterInfo();
                        parameterInfo.setName(parameter.getName().toString());
                        int paramDimension = parameter.getExtraDimensions();
                        Type paramType = parameter.getType();
                        parameterInfo.setDataType(this.constructDataTypeArray(paramType, paramDimension));
                        methodInfo.getParameters().add(parameterInfo);
                    }
                }
                if (!(exceptions = method.thrownExceptions()).isEmpty()) {
                    for (Object o : exceptions) {
                        BizExceptionInfo exceptionInfo = new BizExceptionInfo();
                        exceptionInfo.setPackage(this.packageName);
                        exceptionInfo.setName(o.toString());
                        exceptionInfo.setClassName(this.packageName + "." + o.toString());
                        methodInfo.getBizExceptions().add(exceptionInfo);
                    }
                }
                facade.getMethods().add(methodInfo);
            }
            if (this.xClass != null && this.xClass.getMethods() != null) {
                for (XMethod xMethod : this.xClass.getMethods()) {
                    if (xMethod == null) continue;
                    XDoc xDoc = xMethod.getDoc();
                    MethodInfo methodInfo = this.getMethodInfoFrom(facade, xMethod);
                    if (methodInfo == null) continue;
                    String comment = xDoc.getCommentText();
                    for (XTag xTag : xDoc.getTags()) {
                        String name = xTag.getName();
                        String value = xTag.getValue();
                        if (!name.equalsIgnoreCase("alias")) continue;
                        methodInfo.setAlias(value);
                        break;
                    }
                    methodInfo.setDescription(comment);
                }
            }
        }
    }

    private MethodInfo getMethodInfoFrom(FacadeInfo facade, XMethod xMethod) {
        if (facade == null) {
            return null;
        }
        String mName = xMethod.getName();
        String signature = xMethod.getSignature(false);
        signature = signature.substring(1, signature.length() - 1) + ",";
        Iterator mInfos = facade.getMethods().iterator();
        while (mInfos.hasNext()) {
            MethodInfo mInfo = (MethodInfo)mInfos.next();
            if (!mInfo.getName().equals(mName)) continue;
            StringBuffer signature2 = new StringBuffer();
            Iterator it = mInfo.getParameters().iterator();
            while (it.hasNext()) {
                ParameterInfo p = (ParameterInfo)it.next();
                signature2.append(p.getDataType()).append(",");
            }
            if (signature.equals(signature2.toString())) {
                signature2 = null;
                return mInfo;
            }
            signature2 = null;
        }
        return null;
    }

    private CompilationUnit constructClass(FacadeInfo facade) throws TranslateException {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("org.eclipse.jdt.core.compiler.source", "1.4");
        AST ast = new AST(m);
        CompilationUnit unit = ast.newCompilationUnit();
        PackageDeclaration packageDeclaration = ast.newPackageDeclaration();
        String[] packageNames = StringUtils.split((String)facade.getPackage(), (String)".");
        Object packageName = null;
        packageName = packageNames != null && packageNames.length > 1 ? ast.newName(packageNames) : (!facade.getPackage().equals("") ? ast.newSimpleName(facade.getPackage()) : ast.newSimpleName("default"));
        packageDeclaration.setName(packageName);
        unit.setPackage(packageDeclaration);
        TypeDeclaration type = ast.newTypeDeclaration();
        type.setInterface(false);
        String accessLevel = facade.getAccessLevel().getName();
        String subClassingMode = facade.getSubClassingMode().getName();
        int modifier = this.getModifiers(accessLevel, subClassingMode);
        type.setModifiers(modifier);
        type.setName(ast.newSimpleName(facade.getName()));
        FacadeInfo base = facade.getBaseFacade();
        if (base != null) {
            if (base.getName().indexOf(".") > 0) {
                String[] baseNames = StringUtils.split((String)base.getName(), (String)".");
                type.setSuperclass(ast.newName(baseNames));
            } else {
                type.setSuperclass((Name)ast.newSimpleName(base.getName()));
            }
        }
        MethodCollection methods = facade.getMethods();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)it.next();
            this.addMethod(type, methodInfo);
        }
        Javadoc topComment = ast.newJavadoc();
        topComment.setComment(this.getTypeJavadoc(facade));
        type.setJavadoc(topComment);
        unit.types().add(type);
        return unit;
    }

    private void addMethod(TypeDeclaration type, MethodInfo methodInfo) {
        AST ast = type.getAST();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        String methodName = methodInfo.getName();
        String accessLevel = methodInfo.getAccessLevel().getName();
        String subClassingMode = methodInfo.getSubClassingMode().getName();
        String dataType = methodInfo.getDataType();
        if (methodName.equals(type.getName().toString())) {
            methodDeclaration.setConstructor(true);
        } else {
            methodDeclaration.setConstructor(false);
        }
        methodDeclaration.setModifiers(this.getModifiers(accessLevel, subClassingMode));
        methodDeclaration.setName(ast.newSimpleName(methodName));
        methodDeclaration.setReturnType(this.getType(dataType, ast));
        StringBuffer comment = this.getMethodJavadocHeader(methodInfo);
        ParameterCollection parameters = methodInfo.getParameters();
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            ParameterInfo parameterInfo = (ParameterInfo)it.next();
            SingleVariableDeclaration variableDeclaration = ast.newSingleVariableDeclaration();
            variableDeclaration.setModifiers(0);
            variableDeclaration.setType(this.getType(parameterInfo.getDataType(), ast));
            variableDeclaration.setName(ast.newSimpleName(parameterInfo.getName()));
            methodDeclaration.parameters().add(variableDeclaration);
            comment.append("\n* @param " + parameterInfo.getName());
        }
        Iterator itException = methodInfo.getBizExceptions().iterator();
        while (itException.hasNext()) {
            BizExceptionInfo bizExceptionInfo = (BizExceptionInfo)itException.next();
            if (bizExceptionInfo.getName().indexOf(".") > 0) {
                String[] eName = StringUtils.split((String)bizExceptionInfo.getName(), (String)".");
                methodDeclaration.thrownExceptions().add(ast.newName(eName));
            } else {
                methodDeclaration.thrownExceptions().add(ast.newSimpleName(bizExceptionInfo.getName()));
            }
            comment.append("\n* @throws " + bizExceptionInfo.getName());
        }
        comment.append("\n*\n*/");
        Javadoc javaDoc = ast.newJavadoc();
        javaDoc.setComment(comment.toString());
        methodDeclaration.setJavadoc(javaDoc);
        Block block = ast.newBlock();
        methodDeclaration.setBody(block);
        type.bodyDeclarations().add(methodDeclaration);
    }
}

