/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code.webui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.QueryCtrl;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumCtrl;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import org.apache.log4j.Logger;

public class PropertyHelper {
    private static Logger logger = Logger.getLogger(PropertyHelper.class);
    private PropertyInfo info;
    private String name;
    private DataType dataType;
    private boolean isLink = false;
    private BizEnumInfo enumInfo;
    private String f7QueryPK;
    private int length;
    private boolean nullable;
    private int orgType = -1;

    public PropertyHelper(Context ctx, PropertyInfo info) throws BOSException {
        this.info = info;
        this.name = info.getName();
        if (info instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownInfo = (OwnPropertyInfo)info;
            this.nullable = ownInfo.isNullable();
            this.length = ownInfo.getLength();
            this.dataType = ownInfo.getDataType();
            if (this.dataType.equals(DataType.ENUM)) {
                String enumName = ownInfo.getMetaDataRef();
                this.enumInfo = new BizEnumCtrl(ctx).getValue(MetaDataPK.create(enumName));
            }
        } else {
            this.isLink = true;
            LinkPropertyInfo linkInfo = (LinkPropertyInfo)info;
            this.f7QueryPK = linkInfo.getRelationship().getSupplierObject().getExtendedProperty("defaultF7Query");
            if (this.f7QueryPK == null) {
                this.f7QueryPK = "";
            }
            if (this.f7QueryPK != null && this.f7QueryPK.length() > 0) {
                try {
                    IMetaDataPK queryPK = MetaDataPKFactory.getMetaDataPK(this.f7QueryPK);
                    QueryCtrl queryCtrl = new QueryCtrl(ctx);
                    QueryInfo queryInfo = queryCtrl.getValue(queryPK);
                    this.orgType = this.getQueryInfoOrgType(queryInfo);
                }
                catch (Exception e) {
                    logger.error((Object)("F7 Query PK:" + this.f7QueryPK + " get org type error!"));
                }
            }
        }
    }

    public boolean isNumberField() {
        return this.dataType.equals(DataType.BYTE) || this.dataType.equals(DataType.DECIMAL) || this.dataType.equals(DataType.DOUBLE) || this.dataType.equals(DataType.FLOAT) || this.dataType.equals(DataType.LONG) || this.dataType.equals(DataType.INTEGER) || this.dataType.equals(DataType.SHORT);
    }

    public boolean isDateField() {
        return this.dataType.equals(DataType.DATE) || this.dataType.equals(DataType.TIMESTAMP) || this.dataType.equals(DataType.TIME);
    }

    public int getOrgType() {
        return this.orgType;
    }

    public int getQueryInfoOrgType(QueryInfo queryInfo) {
        int orgType = -1;
        try {
            EntityObjectInfo eo;
            String orgTypeStr;
            SubObjectInfo main = queryInfo.getMainObject();
            if (main instanceof SubQueryInfo) {
                main = ((SubQueryInfo)main).getQueryRef().getMainObject();
            }
            if ((orgTypeStr = (eo = ((SubEntityInfo)main).getEntityRef()).getExtendedProperty("OrgType")) != null) {
                if ("Admin".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 0;
                } else if ("Company".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 1;
                } else if ("Sale".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 2;
                } else if ("Purchase".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 3;
                } else if ("Storage".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 4;
                } else if ("CostCenter".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 5;
                } else if ("ProfitCenter".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 6;
                } else if ("UnionDebt".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 8;
                } else if ("ControlUnit".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 10;
                } else if ("HRO".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 16;
                } else if ("Transport".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 24;
                } else if ("Quality".equalsIgnoreCase(orgTypeStr)) {
                    orgType = 32;
                } else if ("NONE".equalsIgnoreCase(orgTypeStr)) {
                    orgType = -1;
                }
            } else {
                orgType = -1;
            }
        }
        catch (RuntimeException e) {
            orgType = -1;
        }
        catch (BOSException e) {
            orgType = -1;
        }
        return orgType;
    }

    public boolean isEnumField() {
        return this.dataType.equals(DataType.ENUM);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public int getLength() {
        return this.length;
    }

    public String getF7QueryPK() {
        return this.f7QueryPK;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public BizEnumInfo getEnumInfo() {
        return this.enumInfo;
    }

    public PropertyInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }
}

