/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.compare;

import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.compare.data.Report;
import com.kingdee.bos.metadata.compare.data.ReportItem;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class MetadataCompare {
    private static Map supportedTypes = new HashMap();
    private static Set supportedSuffix = new HashSet();

    public Report compare(String targetUrl, String masterUrl) {
        File targetFile = new File(targetUrl);
        File masterFile = new File(masterUrl);
        Hashtable targetMap = new Hashtable();
        Hashtable masterMap = new Hashtable();
        this.processDirectory(targetFile, targetMap, null);
        this.processDirectory(masterFile, masterMap, null);
        return this.compareMap(targetMap, masterMap);
    }

    private void processDirectory(File file, Hashtable fileList, String pgName) {
        String[] metas = file.list();
        File[] files = file.listFiles();
        if (metas == null || metas.length <= 0) {
            return;
        }
        String fileName = null;
        String suffix = null;
        int len = metas.length;
        for (int i = 0; i < len; ++i) {
            fileName = metas[i];
            if (fileName.indexOf(46) >= 0) {
                suffix = this.getEntrySuffix(fileName);
                if (suffix == null || !supportedSuffix.contains(suffix)) continue;
                fileList.put(this.getEntryName(fileName, pgName), files[i]);
                continue;
            }
            File child = new File(file, fileName);
            if (!child.isDirectory()) continue;
            String fullPkgName = null;
            fullPkgName = StringUtils.isEmpty((String)pgName) ? fileName : pgName + "." + fileName;
            this.processDirectory(files[i], fileList, fullPkgName);
        }
    }

    private String getEntrySuffix(String entryName) {
        return entryName.substring(entryName.lastIndexOf(46) + 1, entryName.length());
    }

    private static void registerType(BOSObjectType bosType, String suffix) {
        supportedTypes.put(bosType, suffix);
        supportedSuffix.add(suffix);
    }

    private String getEntryName(String entry, String pgName) {
        String fullName = "";
        fullName = pgName == null ? entry : pgName + "." + entry;
        return fullName;
    }

    private Report compareMap(Hashtable targetMap, Hashtable masterMap) {
        ReportItem item;
        String itemName;
        Hashtable<String, ReportItem> result = new Hashtable<String, ReportItem>();
        Enumeration e = targetMap.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            itemName = (String)e.nextElement();
            if (targetMap.get(itemName) != null) {
                File targetFile = (File)targetMap.get(itemName);
                item = new ReportItem();
                item.setItemName(itemName);
                item.setTargetFile(targetFile);
                if (masterMap.get(itemName) == null) {
                    item.setReportState(3);
                } else {
                    File masterFile = (File)masterMap.get(itemName);
                    item.setMasterFile(masterFile);
                    if (this.equals(targetFile, masterFile)) {
                        item.setReportState(1);
                    } else {
                        item.setReportState(2);
                    }
                }
                result.put(itemName, item);
            }
            ++i;
        }
        e = masterMap.keys();
        i = 0;
        while (e.hasMoreElements()) {
            itemName = (String)e.nextElement();
            if (masterMap.get(itemName) != null && !result.containsKey(itemName)) {
                File masterFile = (File)masterMap.get(itemName);
                item = new ReportItem();
                item.setItemName(itemName);
                item.setMasterFile(masterFile);
                if (targetMap.get(itemName) == null) {
                    item.setReportState(0);
                } else {
                    File targetFile = (File)targetMap.get(itemName);
                    item.setTargetFile(targetFile);
                    if (this.equals(targetFile, masterFile)) {
                        item.setReportState(1);
                    } else {
                        item.setReportState(2);
                    }
                }
                result.put(itemName, item);
            }
            ++i;
        }
        return this.convertToReport(result);
    }

    private boolean equals(File targetFile, File masterFile) {
        return targetFile != null && masterFile != null ? targetFile.getName().equalsIgnoreCase(masterFile.getName()) && targetFile.length() == masterFile.length() && targetFile.lastModified() == masterFile.lastModified() : targetFile == null && masterFile == null;
    }

    private Report convertToReport(Hashtable ht) {
        Report report = new Report();
        Enumeration e = ht.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String itemName = (String)e.nextElement();
            ReportItem item = (ReportItem)ht.get(itemName);
            report.getReportCollection().add(item);
            ++i;
        }
        return report;
    }

    static {
        MetadataCompare.registerType(MetaDataTypeList.APPVIEW, "appview");
        MetadataCompare.registerType(MetaDataTypeList.ENTITY, "entity");
        MetadataCompare.registerType(MetaDataTypeList.RELATIONSHIP, "relation");
        MetadataCompare.registerType(MetaDataTypeList.ABSTRACTTABLE, "table");
        MetadataCompare.registerType(MetaDataTypeList.BASEQUERY, "query");
        MetadataCompare.registerType(MetaDataTypeList.BIZENUM, "enum");
        MetadataCompare.registerType(MetaDataTypeList.BIZDATATYPE, "bizdatatype");
        MetadataCompare.registerType(MetaDataTypeList.BIZEXCEPTION, "exception");
        MetadataCompare.registerType(MetaDataTypeList.BOTMAPPING, "botmapping");
        MetadataCompare.registerType(MetaDataTypeList.FACADE, "facade");
        MetadataCompare.registerType(MetaDataTypeList.FUNCTION, "function");
        MetadataCompare.registerType(MetaDataTypeList.LOG, "log");
        MetadataCompare.registerType(MetaDataTypeList.MULTILANGUAGE, "resource");
        MetadataCompare.registerType(MetaDataTypeList.IMAGE_RESOURCE_TYPE, "imageresource");
        MetadataCompare.registerType(MetaDataTypeList.MUTEX, "mutex");
        MetadataCompare.registerType(MetaDataTypeList.PACKAGE, "package");
        MetadataCompare.registerType(MetaDataTypeList.PERMISSION, "permission");
        MetadataCompare.registerType(MetaDataTypeList.MDQUERY, "mdquery");
        MetadataCompare.registerType(MetaDataTypeList.RULE, "rule");
        MetadataCompare.registerType(MetaDataTypeList.SOLUTION, "solution");
        MetadataCompare.registerType(MetaDataTypeList.UIOBJECT, "ui");
        MetadataCompare.registerType(MetaDataTypeList.WEBUIOBJECT, "webui");
        MetadataCompare.registerType(MetaDataTypeList.WFROLE, "wfrole");
        MetadataCompare.registerType(MetaDataTypeList.WORKFLOW, "kdwf");
        MetadataCompare.registerType(MetaDataTypeList.METADATABRIEFVIEW, "mdbview");
        MetadataCompare.registerType(MetaDataTypeList.WEBPAGEOBJECT, "wbpage");
        MetadataCompare.registerType(MetaDataTypeList.WEBCOMPONENTOBJECT, "wbcom");
        MetadataCompare.registerType(MetaDataTypeList.WEBCONTROLOBJECT, "wbctl");
    }
}

