/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.xml.impl.DocumentProxyStateManager;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.configure.ProjectProviderManager;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ConfigMDUtil {
    private static Logger logger = Logger.getLogger(ConfigMDUtil.class);
    public static final String STANDARD_MD = "standard_MD";
    public static final String DYNAMIC_CONFIG_PATH = "DynamicConfig.path";
    public static final String DYNAMIC_CONFIG_FILE = "DynamicConfig.xml";
    private static Map<String, Throwable> exMap = new ConcurrentHashMap<String, Throwable>();
    private static volatile Context ctx = null;
    private static final ThreadLocal<Context> threadCx = new ThreadLocal();
    private static final Map<String, ProjectInfo> aisToProjects = new HashMap<String, ProjectInfo>(8);
    private static Boolean client;
    private static volatile boolean noAIS;
    private static ConcurrentHashSet<String> notNeedLoadConfigPKs;

    public static String getAIS() {
        return ConfigMDUtil.getAIS(null);
    }

    public static String getAIS(Context ctx) {
        String ais = null;
        if (ctx != null) {
            ais = ctx.getAIS();
        } else {
            ctx = ConfigMDUtil.getContext();
            if (ctx != null) {
                ais = ctx.getAIS();
            }
        }
        if (!StringUtils.isEmpty((String)ais)) {
            return ais;
        }
        return STANDARD_MD;
    }

    public static Context getContext() {
        Context ctx = ContextUtils.getContextFromSessionNoException();
        if (ctx == null && (ctx = ConfigMDUtil.getContextFromEnv()) == null && (ctx = threadCx.get()) == null) {
            ctx = ContextManager.getContext();
        }
        return ctx;
    }

    public static void setContextToEnv(Context context) {
        if (ConfigMDUtil.isClient()) {
            ctx = context;
        }
    }

    public static Context getContextFromEnv() {
        return ctx;
    }

    public static void setContextToThread(Context context) {
        threadCx.set(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProjects(String ais, Project[] ps) {
        ProjectInfo p = new ProjectInfo(ps);
        Map<String, ProjectInfo> map = aisToProjects;
        synchronized (map) {
            aisToProjects.put(ais, p);
            Project.Projects.reAssart(ais);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearProjects() {
        String ais = ConfigMDUtil.getAIS();
        Map<String, ProjectInfo> map = aisToProjects;
        synchronized (map) {
            aisToProjects.remove(ais);
            Project.Projects.reAssart(ais);
        }
    }

    public static Project[] getProjects(String ais) {
        if (!ConfigMDUtil.checkAIS(ais)) {
            return null;
        }
        ProjectInfo pInfo = aisToProjects.get(ais);
        if (pInfo != null) {
            return pInfo.projects;
        }
        if (ProjectProviderManager.getProvider() != null) {
            Project[] ps = ProjectProviderManager.getProvider().getProjects(ais);
            ConfigMDUtil.setProjects(ais, ps);
            return ps;
        }
        return null;
    }

    public static Project[] getProjects() {
        return ConfigMDUtil.getProjects(ConfigMDUtil.getAIS());
    }

    public static List<Project> getOrderedProjects(String ais) {
        ProjectInfo pInfo = aisToProjects.get(ais);
        if (pInfo != null) {
            return pInfo.orderedProjects;
        }
        ConfigMDUtil.getProjects();
        pInfo = aisToProjects.get(ais);
        if (pInfo != null) {
            return pInfo.orderedProjects;
        }
        return null;
    }

    public static List<Project> getOrderedProjects() {
        return ConfigMDUtil.getOrderedProjects(ConfigMDUtil.getAIS());
    }

    public static boolean isClient() {
        if (client == null) {
            client = System.getProperty("easclient.root") != null;
        }
        return client;
    }

    public static void setNoAIS(boolean b) {
        noAIS = b;
    }

    public static boolean checkAIS(String ais) {
        if (noAIS) {
            return false;
        }
        if (ais == null) {
            return false;
        }
        return !STANDARD_MD.equals(ais) && !"datacenter".equalsIgnoreCase(ais);
    }

    public static boolean checkAIS() {
        return ConfigMDUtil.checkAIS(ConfigMDUtil.getAIS());
    }

    public static void addNotNeedLoadConfigPK(String fullName) {
        notNeedLoadConfigPKs.add(fullName);
    }

    public static boolean isNeedLoadConfig(String metaType, String fullName) {
        return ConfigMDUtil.checkAIS() && DocumentProxyStateManager.isRepeatLog() && !MetaDataTypeList.SOLUTION.toString().equals(metaType) && ConfigMDUtil.isNeedLoadConfigPK(fullName);
    }

    public static boolean isNeedLoadConfigPK(String fullName) {
        if (fullName == null) {
            return false;
        }
        return !fullName.startsWith("com.kingdee.bos.config.app.") && !fullName.equals("com.kingdee.eas.framework.app.CoreBase") && !fullName.startsWith("com.kingdee.eas.bs.ml.app.") && !notNeedLoadConfigPKs.contains(fullName);
    }

    public static ArrayList<String> getDataCenterIDs() throws Exception {
        String dcc = System.getProperty("datacenter.config");
        if (dcc == null) {
            logger.warn((Object)"not set system property: datacenter.config)");
            return new ArrayList<String>(1);
        }
        File dccFile = new File(dcc);
        return ConfigMDUtil.getDataCenterIDs(dccFile);
    }

    public static ArrayList<String> getDataCenterIDs(File dccFile) throws Exception {
        ArrayList<String> dcList = new ArrayList<String>();
        if (!dccFile.exists()) {
            logger.error((Object)("Can't find " + dccFile));
            return dcList;
        }
        Document dcmDoc = XMLParser.parseXML((InputStream)new FileInputStream(dccFile));
        List eles = dcmDoc.getRootElement().getChildren("datacenter");
        if (eles != null) {
            for (int i = 0; i < eles.size(); ++i) {
                Element ele = (Element)eles.get(i);
                String id = ele.getAttributeValue("id");
                if (StringUtils.isEmpty((String)id)) continue;
                dcList.add(id);
            }
        }
        return dcList;
    }

    public static boolean isExMapContains(String pk) {
        return exMap.containsKey(ConfigMDUtil.getAIS() + pk);
    }

    public static Map getExMap() {
        return exMap;
    }

    public static void add2ExMap(String pk, Throwable value) {
        exMap.put(ConfigMDUtil.getAIS() + pk, value);
    }

    public static void removeExMap(String pk) {
        exMap.remove(ConfigMDUtil.getAIS() + pk);
    }

    static {
        noAIS = false;
        notNeedLoadConfigPKs = new ConcurrentHashSet();
    }

    static class ProjectInfo {
        final Project[] projects;
        final List<Project> orderedProjects;

        ProjectInfo(Project[] projects) {
            this.projects = projects;
            this.orderedProjects = Project.getOrderedProjects(projects);
        }
    }

    static class ConcurrentHashSet<T> {
        private static final Integer VALUE = 0;
        private final Map<T, Integer> p = new ConcurrentHashMap<T, Integer>();

        ConcurrentHashSet() {
        }

        void add(T v) {
            this.p.put(v, VALUE);
        }

        boolean contains(T v) {
            return this.p.containsKey(v);
        }
    }
}

