/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.configure.ChangeType;
import com.kingdee.bos.metadata.configure.MetadataChangeEvent;
import com.kingdee.bos.metadata.configure.MetadataChangeListener;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetadataChangeListenerManager {
    private static Logger logger = Logger.getLogger(MetadataChangeListenerManager.class);
    private static Map listeners = new HashMap();

    private static void init() {
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("mdChangeListeners");
        if (ci == null) {
            logger.info((Object)"Can't find mdChangeListeners configItem");
            return;
        }
        Map map = ci.getProperties();
        for (String className : map.values()) {
            try {
                Class<?> c = Class.forName(className);
                MetadataChangeListener lis = (MetadataChangeListener)c.newInstance();
                listeners.put(className, lis);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static synchronized void register(MetadataChangeListener listener) {
        listeners.put(listener.getClass().getName(), listener);
    }

    public static synchronized void register(Class listenerClass) {
        try {
            MetadataChangeListener lis = (MetadataChangeListener)listenerClass.newInstance();
            listeners.put(listenerClass.getName(), lis);
            logger.info((Object)(listenerClass.getName() + " is registered to MetadataChangeListenerManager."));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static synchronized void register(String className) {
        try {
            Class<?> c = Class.forName(className);
            MetadataChangeListener lis = (MetadataChangeListener)c.newInstance();
            listeners.put(className, lis);
            logger.info((Object)(className + " is registered to MetadataChangeListenerManager."));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static synchronized void unregister(MetadataChangeListener listener) {
        listeners.remove(listener.getClass().getName());
        logger.info((Object)(listener.getClass().getName() + " is unregistered from MetadataChangeListenerManager."));
    }

    public static synchronized void unregister(String listenerClassName) {
        listeners.remove(listenerClassName);
        logger.info((Object)(listenerClassName + " is unregistered from MetadataChangeListenerManager."));
    }

    public static synchronized void notify(AbstractMetaDataValue metadata, AbstractMDElement[] eles, ChangeType type) {
        MetadataChangeEvent event = new MetadataChangeEvent(metadata, eles, type);
        for (MetadataChangeListener listener : listeners.values()) {
            listener.metadataChanged(event);
        }
    }

    public static synchronized void notify(AbstractMetaDataValue[] metadata) {
        for (int i = 0; i < metadata.length; ++i) {
            MetadataChangeEvent event = new MetadataChangeEvent(metadata[i], ChangeType.UPDATE);
            for (MetadataChangeListener listener : listeners.values()) {
                listener.metadataChanged(event);
            }
        }
    }

    public static synchronized void notifyClearAll() {
        MetadataChangeEvent event = new MetadataChangeEvent(null, ChangeType.CLEARALL);
        for (MetadataChangeListener listener : listeners.values()) {
            listener.metadataChanged(event);
        }
    }

    static {
        try {
            MetadataChangeListenerManager.init();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

