/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.ProjectProvider;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ProjectProviderManager {
    private static Logger logger = Logger.getLogger(ProjectProviderManager.class);
    private static ProjectProvider provider;

    private static void init() {
        block14: {
            String configPath = System.getProperty("DynamicConfig.path");
            if (StringUtils.isEmpty((String)configPath)) {
                String home = System.getProperty("EAS_HOME");
                configPath = ConfigMDUtil.isClient() ? home + "/client/deploy/client/" + "DynamicConfig.xml" : home + "/server/properties/" + "DynamicConfig.xml";
            }
            if (new File(configPath).exists()) {
                try {
                    Document doc = XMLParser.parseXML((InputStream)new FileInputStream(configPath));
                    Element root = doc.getRootElement();
                    List cis = root.getChildren("configitem", root.getNamespace());
                    if (cis == null || cis.size() <= 0) break block14;
                    for (int i = 0; i < cis.size(); ++i) {
                        Element ci = (Element)cis.get(i);
                        String name = ci.getAttributeValue("name");
                        if (!"projectProvider".equals(name)) continue;
                        Element att = ci.getChild("attribute", root.getNamespace());
                        if (att == null) break;
                        String className = att.getAttributeValue("value");
                        try {
                            Class<?> c = Class.forName(className);
                            ProjectProvider lis = (ProjectProvider)c.newInstance();
                            if (provider == null) {
                                provider = lis;
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e, (Throwable)e);
                }
            }
        }
        if (provider != null) {
            return;
        }
        String fileName = System.getProperty("bos.config", "bosconfig.xml");
        if (!new File(fileName).exists()) {
            logger.warn((Object)(fileName + " not exist!"));
            return;
        }
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("projectProvider");
        if (ci == null) {
            logger.info((Object)"Can't find projectProvider configItem");
            return;
        }
        Map map = ci.getProperties();
        for (String className : map.values()) {
            try {
                Class<?> c = Class.forName(className);
                ProjectProvider lis = (ProjectProvider)c.newInstance();
                if (provider != null) continue;
                provider = lis;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static void setProvider(ProjectProvider pp) {
        provider = pp;
    }

    public static ProjectProvider getProvider() {
        return provider;
    }

    static {
        try {
            ProjectProviderManager.init();
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
    }
}

