/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.DynamicMetadataInfo;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MDReferenceFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.RuleSetCtrl;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.ChangeType;
import com.kingdee.bos.metadata.configure.ConfigMDDownloader;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.DBConfigMDDownloader;
import com.kingdee.bos.metadata.configure.DynamicMD;
import com.kingdee.bos.metadata.configure.DynamicMDContainer;
import com.kingdee.bos.metadata.configure.DynamicMetadataProviderManager;
import com.kingdee.bos.metadata.configure.IDynamicMetadataProvider;
import com.kingdee.bos.metadata.configure.IMetadataStoreAgent;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MdsDoc;
import com.kingdee.bos.metadata.configure.MetadataChangeListenerManager;
import com.kingdee.bos.metadata.configure.MetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreAgentFactory;
import com.kingdee.bos.metadata.configure.MetadataStoreUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.configure.Saver4;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.upgrade.FileUtil;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.metadata.util.ZipFileUtils;
import com.kingdee.bos.metadata.webcomponent.WebComponentObjectAssembler;
import com.kingdee.bos.metadata.webcomponent.WebComponentObjectCtrl;
import com.kingdee.bos.metadata.webcomponent.WebComponentObjectInfo;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectAssembler;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectCtrl;
import com.kingdee.bos.metadata.webcontrol.WebControlObjectInfo;
import com.kingdee.bos.metadata.webpage.WebPageObjectAssembler;
import com.kingdee.bos.metadata.webpage.WebPageObjectCtrl;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectCtrl;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.rpc.io.loadbalance.JobManager;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ServerMetadataStore
extends ORMObject
implements IServerMetadataStore,
IMarshalObject {
    private static Logger logger = Logger.getLogger(ServerMetadataStore.class);
    private Context ctx;
    private IMetadataStoreAgent agent;
    private static String configureDir;
    private String configureJar;
    private String tempDir;
    private Saver4 saver;
    private static int updateCount;
    private static int update2OtherServerCount;

    public ServerMetadataStore() {
        this(null);
    }

    public ServerMetadataStore(Context ctx) {
        this.ctx = ctx != null ? ctx : ConfigMDUtil.getContext();
        this.saver = new Saver4(MetaDataLoaderFactory.getMetaDataLoader(this.ctx));
        this.initConfigureDir();
    }

    private synchronized void init() {
        if (this.agent != null) {
            return;
        }
        ORMServiceLocation loc = new ORMServiceLocation("license");
        if (!loc.isLocal()) {
            String url = loc.getServiceURL();
            logger.info((Object)("master url: " + url));
            this.agent = (IMetadataStoreAgent)BOSObjectFactory.getRemoteBOSObjectFactory(url).getSession().createObject("com.kingdee.bos.metadata.configure.RemoteMetadataStoreAgent", IMetadataStoreAgent.class, new Class[]{Context.class}, (Object[])new Context[]{this.ctx});
        } else {
            this.agent = MetadataStoreAgentFactory.getMetadataStoreAgent(this.ctx);
        }
    }

    @Override
    public boolean lock(BOSObjectType bosType, IMetaDataPK pk) {
        this.init();
        return this.agent.lock(bosType, pk);
    }

    @Override
    public boolean unlock(BOSObjectType bosType, IMetaDataPK pk) {
        this.init();
        return this.agent.unlock(bosType, pk);
    }

    @Override
    public void save(final BOSObjectType bosType, final IMetaDataPK pk, final String[] eles, final MdsDoc[] docs) throws Exception {
        try {
            this.innerSave(docs);
            StoreTaskConf task = new StoreTaskConf(){

                public JobManager.Task<IServerMetadataStore> getTask() {
                    return new JobManager.Task<IServerMetadataStore>(){

                        public void run(IServerMetadataStore model) throws BOSException {
                            try {
                                model.save2OtherServer(bosType, pk, eles, docs);
                            }
                            catch (Exception e) {
                                throw new BOSException("delete2OtherServer error.", (Throwable)e);
                            }
                        }
                    };
                }
            };
            JobManager.dispatch2Others((JobManager.TaskConf)task);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.rollback(docs);
            throw e;
        }
        finally {
            for (int i = 0; i < docs.length; ++i) {
                this.load(docs[i].getBosType(), docs[i].getPk());
            }
            this.notify(pk, eles);
        }
    }

    private void innerSave(MdsDoc[] docs) throws Exception {
        String mdPath = Utils.getMetadataSrc(this.ctx);
        mdPath = MetadataStore.getFirstPath(mdPath);
        for (int i = 0; i < docs.length; ++i) {
            MdsDoc doc = docs[i];
            StringBuffer bf = new StringBuffer(mdPath);
            bf.append(doc.getPk()).append(Utils.getMetaDataSuffix(doc.getBosType()));
            File file = new File(bf.toString());
            if (file.exists() && file.isFile()) {
                file.renameTo(new File(bf.toString() + ".cfgbak"));
            }
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(bf.toString()));
            logger.info((Object)("save " + doc.getPk().getFullName() + "." + Utils.getMetaDataSuffix(doc.getBosType()) + "  to  " + bf));
            XmlUtils.output(doc.getDocument(), os);
            ((OutputStream)os).close();
        }
    }

    @Override
    public void save2OtherServer(BOSObjectType bosType, IMetaDataPK pk, String[] eles, MdsDoc[] docs) throws Exception {
        try {
            this.innerSave(docs);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.rollback(docs);
            throw e;
        }
        finally {
            for (int i = 0; i < docs.length; ++i) {
                this.load(docs[i].getBosType(), docs[i].getPk());
            }
            this.notify(pk, eles);
        }
    }

    private void notify(IMetaDataPK pk, String[] eles) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(this.ctx);
        EntityObjectInfo entity = loader.getEntity(pk);
        AbstractMDElement[] props = new PropertyInfo[eles.length];
        for (int i = 0; i < eles.length; ++i) {
            props[i] = entity.getPropertyByName(eles[i]);
        }
        MetadataChangeListenerManager.notify(entity, props, ChangeType.ADDNEW);
    }

    private void rollback(MdsDoc[] docs) throws Exception {
        if (docs == null) {
            logger.warn((Object)"MdsDos is null");
            return;
        }
        String mdPath = Utils.getMetadataSrc(this.ctx);
        mdPath = MetadataStore.getFirstPath(mdPath);
        for (int i = 0; i < docs.length; ++i) {
            MdsDoc doc = docs[i];
            if (doc == null) continue;
            StringBuffer bf = new StringBuffer(mdPath);
            bf.append(doc.getPk()).append(Utils.getMetaDataSuffix(doc.getBosType()));
            File file = new File(bf.toString());
            logger.info((Object)("delete: " + file.getAbsolutePath()));
            file.delete();
            File bak = new File(bf.toString() + ".cfgbak");
            if (!bak.exists() || !bak.isFile()) continue;
            bak.renameTo(file);
        }
    }

    private void load(BOSObjectType bosType, IMetaDataPK pk) {
        if (bosType != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(this.ctx);
            if (MetaDataTypeList.ENTITY.equals((Object)bosType)) {
                EntityObjectInfo entity = loader.getEntity(pk);
                PropertyCollection pc = entity.getPropertiesRuntime();
                for (int i = 0; i < pc.size(); ++i) {
                    PropertyInfo pi = pc.get(i);
                    if (!(pi instanceof LinkPropertyInfo)) continue;
                    LinkPropertyInfo lpi = (LinkPropertyInfo)pi;
                    RelationshipInfo rsi = lpi.getRelationship();
                    loader.clear(rsi.getBOSType(), MetaDataPK.create(rsi.getRealFullName()));
                    if (rsi.getClientObject() != null && !pk.getFullName().equals(rsi.getClientObject().getFullName())) {
                        loader.clear(MetaDataTypeList.ENTITY, MetaDataPK.create(rsi.getClientObject().getFullName()));
                    }
                    if (rsi.getSupplierObject() == null || pk.getFullName().equals(rsi.getSupplierObject().getFullName())) continue;
                    loader.clear(MetaDataTypeList.ENTITY, MetaDataPK.create(rsi.getSupplierObject().getFullName()));
                }
            }
            loader.clear(bosType, pk);
            if (MetaDataTypeList.PERMISSION.equals((Object)bosType)) {
                try {
                    ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
                }
                catch (CannotCreateServiceManagerException e) {
                    logger.warn((Object)e, (Throwable)((Object)e));
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        }
    }

    private void load(BOSObjectType bosType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(this.ctx);
        loader.clear(bosType);
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.ctx);
        marshaller.writeObject((Object)this.agent);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.ctx = (Context)unmarshaller.readObject();
        this.agent = (IMetadataStoreAgent)unmarshaller.readObject();
    }

    @Override
    public void delete(final BOSObjectType bosType, final IMetaDataPK pk, final String[] eles, final MdsDoc[] docs) throws Exception {
        try {
            this.innerDelete(docs);
            StoreTaskConf task = new StoreTaskConf(){

                public JobManager.Task<IServerMetadataStore> getTask() {
                    return new JobManager.Task<IServerMetadataStore>(){

                        public void run(IServerMetadataStore model) throws BOSException {
                            try {
                                model.delete2OtherServer(bosType, pk, eles, docs);
                            }
                            catch (Exception e) {
                                throw new BOSException("delete2OtherServer error.", (Throwable)e);
                            }
                        }
                    };
                }
            };
            JobManager.dispatch2Others((JobManager.TaskConf)task);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.rollback(docs);
            throw e;
        }
        finally {
            for (int i = 0; i < docs.length; ++i) {
                this.load(docs[i].getBosType(), docs[i].getPk());
            }
            this.notify(pk, eles);
        }
    }

    private void innerDelete(MdsDoc[] docs) throws Exception {
        String mdPath = Utils.getMetadataSrc(this.ctx);
        mdPath = MetadataStore.getFirstPath(mdPath);
        for (int i = 0; i < docs.length; ++i) {
            MdsDoc doc = docs[i];
            if (doc == null) continue;
            StringBuffer bf = new StringBuffer(mdPath);
            bf.append(doc.getPk()).append(Utils.getMetaDataSuffix(doc.getBosType()));
            File file = new File(bf.toString());
            if (file.exists() && file.isFile()) {
                file.renameTo(new File(bf.toString() + ".cfgbak"));
            }
            if (MetaDataTypeList.ENTITY.equals((Object)doc.getBosType())) {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(bf.toString()));
                logger.info((Object)("save " + doc.getPk().getFullName() + "." + Utils.getMetaDataSuffix(doc.getBosType()) + "  to  " + bf));
                XmlUtils.output(doc.getDocument(), os);
                ((OutputStream)os).close();
                continue;
            }
            if (!MetaDataTypeList.RELATIONSHIP.equals((Object)doc.getBosType())) continue;
            File relation = new File(bf.toString());
            if (relation.exists()) {
                logger.info((Object)("delete: " + relation.getAbsolutePath()));
                relation.delete();
                continue;
            }
            logger.warn((Object)("file " + bf + " not exists"));
        }
    }

    @Override
    public void delete2OtherServer(BOSObjectType bosType, IMetaDataPK pk, String[] eles, MdsDoc[] docs) throws Exception {
        try {
            this.innerDelete(docs);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.rollback(docs);
            throw e;
        }
        finally {
            for (int i = 0; i < docs.length; ++i) {
                this.load(docs[i].getBosType(), docs[i].getPk());
            }
            this.notify(pk, eles);
        }
    }

    private void initConfigureDir() {
        configureDir = System.getProperty("configure.path");
        String eas_home = System.getProperty("EAS_HOME");
        if (configureDir == null && eas_home == null) {
            throw new RuntimeException("not set EAS_HOME and not set configure Dir. please set -DEAS_HOME or -Dconfigure.path");
        }
        if (configureDir == null) {
            configureDir = eas_home + "/server/metas/configure";
        }
        this.configureJar = configureDir + "/" + this.ctx.getAIS() + "/" + "dynamic-configure-metas.jar";
    }

    @Override
    public void update(MdsDoc[] docs) throws Exception {
        this.update(docs, null);
    }

    @Override
    public void update(MdsDoc[] docs, List<IMetaDataPK> relationPKList) throws Exception {
        this.update(docs, relationPKList, false);
    }

    @Override
    public void update(MdsDoc[] docs, boolean aliasChanged) throws Exception {
        this.update(docs, null, aliasChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(final MdsDoc[] docs, List<IMetaDataPK> relationPKList, final boolean aliasChanged) throws Exception {
        String tempDir = configureDir + "/" + this.ctx.getAIS() + "_temp";
        try {
            Class<ServerMetadataStore> clazz = ServerMetadataStore.class;
            synchronized (ServerMetadataStore.class) {
                Object temp;
                ++updateCount;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                if (new File(this.configureJar).exists()) {
                    ZipFileUtils.unJarFile(this.configureJar, tempDir);
                }
                if (!((File)(temp = new File(tempDir))).exists()) {
                    ((File)temp).mkdirs();
                }
                this.innerUpdate((File)temp, docs);
                MetadataStoreUtil.zip(this.configureJar, this.ctx, true);
                File cj = new File(this.configureJar);
                final String sizeTime = cj.length() + "_" + cj.lastModified();
                StoreTaskConf task = new StoreTaskConf(){

                    public JobManager.Task<IServerMetadataStore> getTask() {
                        return new JobManager.Task<IServerMetadataStore>(){

                            public void run(IServerMetadataStore model) throws BOSException {
                                try {
                                    model.update2OtherServer(docs, sizeTime, aliasChanged);
                                }
                                catch (Exception e) {
                                    throw new BOSException("delete2OtherServer error.", (Throwable)e);
                                }
                            }
                        };
                    }
                };
                JobManager.dispatch2Others((JobManager.TaskConf)task);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.updateRollback(docs);
            throw e;
        }
        finally {
            Class<ServerMetadataStore> clazz = ServerMetadataStore.class;
            synchronized (ServerMetadataStore.class) {
                if (--updateCount == 0) {
                    FileUtil.deleteDir(new File(tempDir));
                }
                // ** MonitorExit[var11_15] (shouldn't be in output)
                for (int i = 0; i < docs.length; ++i) {
                    this.load(docs[i].getBosType(), docs[i].getPk());
                }
                if (aliasChanged) {
                    this.load(MetaDataTypeList.METADATABRIEFVIEW);
                }
                if (relationPKList != null) {
                    for (IMetaDataPK tmp : relationPKList) {
                        this.load(MetaDataTypeList.RELATIONSHIP, tmp);
                    }
                }
                this.notify(docs);
            }
        }
        {
            return;
        }
    }

    private void innerUpdate(File temp, MdsDoc[] docs) throws FileNotFoundException, IOException {
        for (int i = 0; i < docs.length; ++i) {
            MdsDoc md = docs[i];
            Document doc = md.getDocument();
            String relative = this.getRelativePath(md);
            File file = new File(temp, relative);
            if (file.exists()) {
                file.renameTo(new File(temp, relative + ".cfgbak"));
            }
            if (file.exists() && doc == null) {
                logger.info((Object)(temp.getAbsolutePath() + File.separatorChar + relative + " is deleted"));
                continue;
            }
            if (doc == null) continue;
            file = new File(temp, relative);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            XmlUtils.output(doc, os);
            ((OutputStream)os).close();
            logger.info((Object)(temp.getAbsolutePath() + File.separatorChar + relative + " is added or updated"));
        }
    }

    private String getRelativePath(MdsDoc md) {
        String relative = md.getBosType() != null ? md.getPk().toString() + Utils.getMetaDataSuffix(md.getBosType()) : md.getPk().toString();
        return relative;
    }

    @Override
    public void update2OtherServer(MdsDoc[] docs, String sizeTime) throws Exception {
        this.update2OtherServer(docs, sizeTime, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update2OtherServer(MdsDoc[] docs, String sizeTime, boolean aliasChanged) throws Exception {
        try {
            Class<ServerMetadataStore> clazz;
            File cj = new File(this.configureJar);
            String sizeTimeLocal = cj.length() + "_" + cj.lastModified();
            if (!sizeTime.equals(sizeTimeLocal)) {
                String tempDir = configureDir + "/" + this.ctx.getAIS() + "_temp";
                try {
                    clazz = ServerMetadataStore.class;
                    synchronized (ServerMetadataStore.class) {
                        File temp;
                        ++update2OtherServerCount;
                        // ** MonitorExit[var7_9] (shouldn't be in output)
                        if (new File(this.configureJar).exists()) {
                            ZipFileUtils.unJarFile(this.configureJar, tempDir);
                        }
                        if (!(temp = new File(tempDir)).exists()) {
                            temp.mkdirs();
                        }
                        this.innerUpdate(temp, docs);
                        MetadataStoreUtil.zip(this.configureJar, this.ctx, true);
                        return;
                    }
                }
                finally {
                    clazz = ServerMetadataStore.class;
                    synchronized (ServerMetadataStore.class) {
                        if (--update2OtherServerCount == 0) {
                            FileUtil.deleteDir(new File(tempDir));
                        }
                        // ** MonitorExit[var7_9] (shouldn't be in output)
                    }
                }
            }
            ConfigureResourceLoader loader = ConfigureResourceLoader.getInstance(this.ctx);
            clazz = loader;
            synchronized (clazz) {
                loader.clear();
                loader.init();
            }
            ConfigMDDownloader.init();
            return;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.updateRollback(docs);
            throw e;
        }
        finally {
            for (int i = 0; i < docs.length; ++i) {
                this.load(docs[i].getBosType(), docs[i].getPk());
            }
            if (aliasChanged) {
                this.load(MetaDataTypeList.METADATABRIEFVIEW);
            }
            this.notify(docs);
        }
    }

    private void updateRollback(MdsDoc[] docs) {
        logger.info((Object)"ServerMetadataStore updateRollback.");
        if (docs == null) {
            logger.warn((Object)"MdsDos is null");
            return;
        }
        if (this.tempDir == null) {
            logger.warn((Object)"tempDir is null");
            return;
        }
        File temp = new File(this.tempDir);
        for (int i = 0; i < docs.length; ++i) {
            MdsDoc md = docs[i];
            if (md == null) continue;
            String relative = this.getRelativePath(md);
            File file = new File(temp, relative);
            File bak = new File(temp, relative + ".cfgbak");
            if (!bak.exists()) {
                file.delete();
                continue;
            }
            bak.renameTo(file);
        }
    }

    private void notify(MdsDoc[] docs) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(this.ctx);
        ArrayList<EntityObjectInfo> list = new ArrayList<EntityObjectInfo>();
        for (int i = 0; i < docs.length; ++i) {
            MdsDoc md = docs[i];
            BOSObjectType type = md.getBosType();
            if (!MetaDataTypeList.ENTITY.equals((Object)type)) continue;
            EntityObjectInfo entity = loader.getEntity(md.getPk());
            list.add(entity);
        }
        MetadataChangeListenerManager.notify(list.toArray(new AbstractMetaDataValue[0]));
    }

    @Override
    public void unlockAll() {
        this.init();
        this.agent.unlockAll();
    }

    @Override
    public MetaDataPK2 lock(MetaDataPK2[] pks) {
        this.init();
        return this.agent.lock(pks);
    }

    @Override
    public void unlock(MetaDataPK2[] pks) {
        this.init();
        this.agent.unlock(pks);
    }

    @Override
    public void saveMetadata(AbstractMetaDataValue metadata, String projectID) throws Exception {
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[]{metadata};
        this.saveMetadata(mds, projectID);
    }

    @Override
    public boolean saveMetadata(AbstractMetaDataValue[] mds, String projectID) throws Exception {
        return this.saveMetadata(mds, projectID, null);
    }

    private void setIsAffectMdbview(DynamicMetadataInfo dmi, AbstractMetaDataValue amd, AbstractMetaDataValue base) {
        if (amd == null || base == null) {
            return;
        }
        String s1 = amd.getAlias();
        String s2 = base.getAlias();
        if (!StringUtils.isEmpty((String)s1) && !s1.equals(s2)) {
            dmi.setIsAffectMdbview(true);
            return;
        }
        s1 = amd.getExtendedProperty("nobotp");
        s2 = base.getExtendedProperty("nobotp");
        if (s1 == null && s2 != null || s1 != null && s2 == null) {
            dmi.setIsAffectMdbview(true);
            return;
        }
        s1 = amd.getExtendedProperty("isConfigCache");
        s2 = base.getExtendedProperty("isConfigCache");
        if (!StringUtils.isEmpty((String)s1) && !s1.equals(s2)) {
            dmi.setIsAffectMdbview(true);
            return;
        }
        s1 = amd.getExtendedProperty("codingRuleEnabled");
        s2 = base.getExtendedProperty("codingRuleEnabled");
        if (!StringUtils.isEmpty((String)s1) && !s1.equals(s2)) {
            dmi.setIsAffectMdbview(true);
            return;
        }
        s1 = amd.getExtendedProperty("enableFieldPermission");
        s2 = base.getExtendedProperty("enableFieldPermission");
        if (!StringUtils.isEmpty((String)s1) && !s1.equals(s2)) {
            dmi.setIsAffectMdbview(true);
            return;
        }
        s1 = amd.getExtendedProperty("isParamObject");
        s2 = base.getExtendedProperty("isParamObject");
        if (!StringUtils.isEmpty((String)s1) && !s1.equals(s2)) {
            dmi.setIsAffectMdbview(true);
            return;
        }
    }

    private boolean afterSave(AbstractMetaDataValue amd, String projectID, IMetaDataPK[] pks) throws BOSException {
        List<Project> orderedProjects;
        BOSObjectType bosType = amd.getBOSType();
        MetaDataPK pk = MetaDataPK.create(amd.getRealFullName());
        Project.Projects prjs = Project.Projects.getProjects(new Project[]{new Project(projectID)});
        MDContext mdContext = MDContextFactory.getSystemMDContext();
        boolean find = false;
        for (int j = 0; j < pks.length; ++j) {
            if (!pks[j].getFullName().equals(amd.getRealFullName())) continue;
            find = true;
            break;
        }
        if (!find) {
            mdContext.pkIndexs.addPK(bosType, pk, prjs);
            if (MetaDataTypeList.ENTITY.equals((Object)bosType)) {
                mdContext.entityMapping.addPKMapping(((EntityObjectInfo)amd).getType(), pk);
            } else if (MetaDataTypeList.FACADE.equals((Object)bosType)) {
                mdContext.facadeMapping.addPKMapping(((FacadeInfo)amd).getType(), pk);
            }
            if (ConfigMDUtil.getOrderedProjects() != null && ConfigMDUtil.getOrderedProjects().contains(new Project(projectID)) || "always_on".equals(projectID)) {
                if (MetaDataTypeList.PERMISSION.equals((Object)bosType)) {
                    MDReferenceFactory.clearPermission();
                    ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
                } else if (MetaDataTypeList.LOG.equals((Object)bosType)) {
                    MDReferenceFactory.clearLog();
                    ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
                }
            }
        }
        DBConfigMDDownloader.clear();
        if (find) {
            this.load(amd.getBOSType(), pk);
        }
        if ((orderedProjects = ConfigMDUtil.getOrderedProjects()) != null && orderedProjects.contains(new Project(projectID)) || "always_on".equals(projectID)) {
            MetadataChangeListenerManager.notify(new AbstractMetaDataValue[]{amd});
        }
        DynamicMDContainer.clearDynamicMDs(this.ctx);
        return find;
    }

    @Override
    public void saveMetadata2OtherServer(AbstractMetaDataValue[] mds, String projectID, boolean isAffectMdbview) throws Exception {
        MetaDataLoaderFactory.getMetaDataLoader(this.ctx);
        for (int i = 0; i < mds.length; ++i) {
            this.afterSave2OtherServer(mds[i], projectID, isAffectMdbview);
        }
        Project.Projects prjs = Project.Projects.getProjects(new Project[]{new Project(projectID)});
        MDContextFactory.getSystemMDContext().clear(prjs);
    }

    private void afterSave2OtherServer(AbstractMetaDataValue amd, String projectID, boolean isAffectMdbview) throws BOSException {
        List<Project> orderedProjects;
        BOSObjectType bosType = amd.getBOSType();
        MetaDataPK pk = MetaDataPK.create(amd.getRealFullName());
        MDContext mdContext = MDContextFactory.getSystemMDContext();
        Project prj = new Project(projectID);
        Project.Projects prjs = Project.Projects.getProjects(new Project[]{prj});
        mdContext.pkIndexs.addPK(bosType, pk, prjs);
        if (MetaDataTypeList.ENTITY.equals((Object)bosType)) {
            mdContext.entityMapping.addPKMapping(((EntityObjectInfo)amd).getType(), pk, false);
        } else if (MetaDataTypeList.FACADE.equals((Object)bosType)) {
            mdContext.facadeMapping.addPKMapping(((FacadeInfo)amd).getType(), pk, false);
        }
        if (ConfigMDUtil.getOrderedProjects() != null && ConfigMDUtil.getOrderedProjects().contains(prj) || "always_on".equals(projectID)) {
            if (MetaDataTypeList.PERMISSION.equals((Object)bosType)) {
                MDReferenceFactory.clearPermission();
                ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
            } else if (MetaDataTypeList.LOG.equals((Object)bosType)) {
                MDReferenceFactory.clearLog();
                ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
            }
        }
        if ((orderedProjects = ConfigMDUtil.getOrderedProjects()) != null && orderedProjects.contains(prj) || "always_on".equals(projectID)) {
            this.load(amd.getBOSType(), pk);
            MetadataChangeListenerManager.notify(new AbstractMetaDataValue[]{amd});
        }
        if (isAffectMdbview) {
            this.load(MetaDataTypeList.METADATABRIEFVIEW);
        }
        DynamicMDContainer.clearDynamicMDs(this.ctx);
    }

    @Override
    public void setProjects(final Project[] ps) throws BOSException {
        this.setProject0(ps);
        StoreTaskConf task = new StoreTaskConf(){

            public JobManager.Task<IServerMetadataStore> getTask() {
                return new JobManager.Task<IServerMetadataStore>(){

                    public void run(IServerMetadataStore model) throws BOSException {
                        model.setProjects2OtherServer(ps);
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    @Override
    public void setProjects2OtherServer(Project[] ps) throws BOSException {
        this.setProject0(ps);
    }

    private void setProject0(Project[] ps) throws CannotCreateServiceManagerException {
        HashSet<Project> changedProjects = new HashSet<Project>();
        Set<Project> oldSet = this.asSet(ConfigMDUtil.getProjects());
        Set<Project> newSet = this.asSet(ps);
        for (Project p : oldSet) {
            if (newSet.contains(p)) continue;
            changedProjects.add(p);
        }
        for (Project p : newSet) {
            if (oldSet.contains(p)) continue;
            changedProjects.add(p);
        }
        boolean hasPermissionItem = this.hasPermissionItem(changedProjects.toArray(new Project[0]));
        ConfigMDUtil.clearProjects();
        DBConfigMDDownloader.clear();
        MetaDataLoaderFactory.getMetaDataLoader(this.ctx).clearAll();
        XMLAccessEngine.clearEngines(this.ctx);
        MetadataChangeListenerManager.notifyClearAll();
        if (hasPermissionItem) {
            ServiceManagerFactory.getServiceManager().clearServiceBinder(this.ctx);
            MDReferenceFactory.clearPermission();
        }
    }

    private Set<Project> asSet(Project[] ps) {
        HashSet<Project> set = new HashSet<Project>();
        if (ps != null) {
            for (int i = 0; i < ps.length; ++i) {
                set.add(ps[i]);
            }
        }
        return set;
    }

    private boolean hasPermissionItem(Project[] ps) {
        Project.Projects depends = Project.Projects.getProjects(ps);
        Set<IMetaDataPK> pks = MDContextFactory.getSystemMDContext().pkIndexs.getFromDB4Self(MetaDataTypeList.PERMISSION, depends);
        if (pks == null || pks.isEmpty()) {
            return false;
        }
        for (IMetaDataPK pk : pks) {
            PermissionInfo pi = (PermissionInfo)MetaDataLoaderFactory.getMetaDataLoader(this.ctx).get(MetaDataTypeList.PERMISSION, pk, depends);
            if (pi == null) {
                return false;
            }
            PermissionItemCollection items = pi.getPermissionItems();
            if (items == null || items.size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteMetadata(final MetaDataPK2[] pks, final String projectID) throws Exception {
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp == null) {
            logger.warn((Object)"DynamicMetadataProvider is null");
            return;
        }
        for (int i = 0; i < pks.length; ++i) {
            MetaDataPK2 pk2 = pks[i];
            MetaDataPK pk = MetaDataPK.create(pk2.getFullName());
            BOSObjectType type = BOSObjectType.create((String)pk2.getType());
            DBConfigureResourceLoader.deleteMetadata(new Project(projectID), pk, type);
        }
        this.afterDelete(pks, projectID);
        StoreTaskConf task = new StoreTaskConf(){

            public JobManager.Task<IServerMetadataStore> getTask() {
                return new JobManager.Task<IServerMetadataStore>(){

                    public void run(IServerMetadataStore model) throws BOSException {
                        try {
                            model.deleteMetadata2OtherServer(pks, projectID);
                        }
                        catch (Exception e) {
                            throw new BOSException("delete metadata error.", (Throwable)e);
                        }
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    private void afterDelete(MetaDataPK2[] pks, String projectID) throws Exception {
        Project prj = new Project(projectID);
        List<Project> orderedProjects = ConfigMDUtil.getOrderedProjects();
        if (orderedProjects != null && orderedProjects.contains(prj) || "always_on".equals(projectID)) {
            for (int i = 0; i < pks.length; ++i) {
                this.load(BOSObjectType.create((String)pks[i].getType()), MetaDataPK.create(pks[i].getFullName()));
            }
            DBConfigMDDownloader.clear();
        }
        MDContextFactory.getSystemMDContext().clear(Project.Projects.getProjects(prj));
        DynamicMDContainer.clearDynamicMDs(this.ctx);
    }

    @Override
    public void deleteMetadata2OtherServer(MetaDataPK2[] pks, String projectID) throws Exception {
        this.afterDelete(pks, projectID);
    }

    @Override
    public boolean saveMetadata(AbstractMetaDataValue metadata, String projectID, Project[] depends) throws Exception {
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[]{metadata};
        return this.saveMetadata(mds, projectID, depends);
    }

    @Override
    public boolean saveMetadata(final AbstractMetaDataValue[] mds, final String projectID, Project[] depends) throws Exception {
        for (int i = 0; i < mds.length; ++i) {
            AbstractMetaDataValue amd = mds[i];
            if (!(amd instanceof RelationshipInfo) || ((RelationshipInfo)amd).getSupplierObject() != null) continue;
            throw new BOSException("METADATA_INCOMPLETE" + amd.getFullName());
        }
        boolean isAffectMdbview = false;
        for (int i = 0; i < mds.length; ++i) {
            AbstractMetaDataValue amd = mds[i];
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(this.ctx);
            BOSObjectType bosType = amd.getBOSType();
            MetaDataPK pk = MetaDataPK.create(amd.getRealFullName());
            AbstractMetaDataValue base = (AbstractMetaDataValue)loader.get(bosType, pk, Project.Projects.getProjects(depends, projectID));
            if (amd instanceof UIObjectInfo) {
                MetaDataLoaderFactory.getMetaDataLoader(this.ctx).clear(MetaDataTypeList.UIOBJECT);
                XMLAccessEngine.getXMLLoader(this.ctx).clearCacheByType(MetaDataTypeList.UIOBJECT);
                UIObjectCtrl.beforeSave((UIObjectInfo)amd);
                amd = UIObjectAssembler.parseUI(ConfigMDUtil.getContext(), (UIObjectInfo)amd);
            } else if (amd instanceof WebUIObjectInfo) {
                MetaDataLoaderFactory.getMetaDataLoader(this.ctx).clear(MetaDataTypeList.WEBUIOBJECT);
                XMLAccessEngine.getXMLLoader(this.ctx).clearCacheByType(MetaDataTypeList.WEBUIOBJECT);
                WebUIObjectCtrl.beforeSave((WebUIObjectInfo)amd);
                amd = UIObjectAssembler.parseUI(ConfigMDUtil.getContext(), (WebUIObjectInfo)amd);
            } else if (amd instanceof RuleSetInfo) {
                RuleSetCtrl.beforeSave((RuleSetInfo)amd);
            } else if (amd instanceof BizUnitInfo) {
                BizUnitCtrl.beforeSave((BizUnitInfo)amd);
            } else if (amd instanceof WebPageObjectInfo) {
                MetaDataLoaderFactory.getMetaDataLoader(this.ctx).clear(MetaDataTypeList.WEBPAGEOBJECT);
                XMLAccessEngine.getXMLLoader(this.ctx).clearCacheByType(MetaDataTypeList.WEBPAGEOBJECT);
                WebPageObjectCtrl.beforeSave((WebPageObjectInfo)amd);
                amd = WebPageObjectAssembler.parseWebPage(ConfigMDUtil.getContext(), (WebPageObjectInfo)amd);
            } else if (amd instanceof WebComponentObjectInfo) {
                MetaDataLoaderFactory.getMetaDataLoader(this.ctx).clear(MetaDataTypeList.WEBCOMPONENTOBJECT);
                XMLAccessEngine.getXMLLoader(this.ctx).clearCacheByType(MetaDataTypeList.WEBCOMPONENTOBJECT);
                WebComponentObjectCtrl.beforeSave((WebComponentObjectInfo)amd);
                amd = WebComponentObjectAssembler.parseWebComponent(ConfigMDUtil.getContext(), (WebComponentObjectInfo)amd);
            } else if (amd instanceof WebControlObjectInfo) {
                MetaDataLoaderFactory.getMetaDataLoader(this.ctx).clear(MetaDataTypeList.WEBCONTROLOBJECT);
                XMLAccessEngine.getXMLLoader(this.ctx).clearCacheByType(MetaDataTypeList.WEBCONTROLOBJECT);
                WebControlObjectCtrl.beforeSave((WebControlObjectInfo)amd);
                amd = WebControlObjectAssembler.parseWebControl(ConfigMDUtil.getContext(), (WebControlObjectInfo)amd);
            }
            Document saveDom = this.saver.diffStore(amd, base);
            if (saveDom == null) {
                MetaDataPK2 pk2 = new MetaDataPK2(amd.getRealFullName(), bosType.toString());
                this.deleteMetadata(new MetaDataPK2[]{pk2}, projectID);
                continue;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XmlUtils.output(saveDom, baos);
            byte[] segment = baos.toByteArray();
            DynamicMetadataInfo dmi = new DynamicMetadataInfo();
            dmi.setMetaDataPK(amd.getRealFullName());
            dmi.setBosType(bosType.toString());
            dmi.setSegment(segment);
            dmi.setProjectID(projectID);
            this.setIsAffectMdbview(dmi, amd, base);
            if (dmi.isIsAffectMdbview()) {
                isAffectMdbview = true;
            }
            StringBuffer oql = new StringBuffer();
            oql.append("where metaDataPK='");
            oql.append(dmi.getMetaDataPK());
            oql.append("' and bosType ");
            oql.append(DBConfigureResourceLoader.getCondition(bosType));
            oql.append(" and projectID='");
            oql.append(projectID);
            oql.append("'");
            IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
            if (dmp == null) break;
            boolean exist = dmp.exists(oql.toString());
            Project.Projects prjs = Project.Projects.getProjects(new Project[]{new Project(projectID)});
            MDContext mdContext = MDContextFactory.getSystemMDContext();
            IMetaDataPK[] pks = mdContext.pkIndexs.getMetaDataPKs(bosType, prjs);
            if (exist) {
                DynamicMetadataInfo existDmi = dmp.getValue(oql.toString());
                dmi.setId(existDmi.getId());
                dmp.update(new ObjectUuidPK(existDmi.getId()), dmi);
            } else {
                dmp.addnew(dmi);
            }
            boolean find = this.afterSave(amd, projectID, pks);
            if (find) continue;
            isAffectMdbview = true;
        }
        if (isAffectMdbview) {
            this.load(MetaDataTypeList.METADATABRIEFVIEW);
        }
        MDContextFactory.getSystemMDContext().clear(Project.Projects.getProjects(new Project[]{new Project(projectID)}));
        final boolean effectMDBView = isAffectMdbview;
        StoreTaskConf task = new StoreTaskConf(){

            public JobManager.Task<IServerMetadataStore> getTask() {
                return new JobManager.Task<IServerMetadataStore>(){

                    public void run(IServerMetadataStore model) throws BOSException {
                        try {
                            model.saveMetadata2OtherServer(mds, projectID, effectMDBView);
                        }
                        catch (Exception e) {
                            throw new BOSException("delete2OtherServer error.", (Throwable)e);
                        }
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
        return isAffectMdbview;
    }

    public void deleteMetadata(Project p, IMetaDataPK pk, BOSObjectType type) throws Exception {
        MetaDataPK2 pk2 = new MetaDataPK2(pk.getFullName(), type.toString());
        this.deleteMetadata(new MetaDataPK2[]{pk2}, p.getId());
    }

    @Override
    public void saveXml(final Project p, final IMetaDataPK pk, final BOSObjectType type, String xml) throws Exception {
        this.beforeSaveXml(p, pk, type, xml);
        DBConfigureResourceLoader.saveResource(p, pk, type, xml);
        this.afterSaveXml(p, pk, type);
        StoreTaskConf task = new StoreTaskConf(){

            public JobManager.Task<IServerMetadataStore> getTask() {
                return new JobManager.Task<IServerMetadataStore>(){

                    public void run(IServerMetadataStore model) throws BOSException {
                        try {
                            model.saveXml2OtherServer(p, pk, type);
                        }
                        catch (Exception e) {
                            throw new BOSException("delete2OtherServer error.", (Throwable)e);
                        }
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    private void beforeSaveXml(Project p, IMetaDataPK pk, BOSObjectType type, String xml) throws BOSException {
        Project.Projects prjs = Project.Projects.getProjects(new Project[]{p});
        MDContext mdContext = MDContextFactory.getSystemMDContext();
        boolean exist = mdContext.pkIndexs.isExist(type, pk, prjs);
        if (!exist) {
            mdContext.pkIndexs.addPK(type, pk, prjs);
            if (xml != null) {
                String bt;
                if (MetaDataTypeList.ENTITY.equals((Object)type)) {
                    String bt2 = this.getBosType(xml);
                    if (!StringUtils.isEmpty((String)bt2)) {
                        mdContext.entityMapping.addPKMapping(BOSObjectType.create((String)bt2), pk);
                    }
                } else if (MetaDataTypeList.FACADE.equals((Object)type) && !StringUtils.isEmpty((String)(bt = this.getBosType(xml)))) {
                    mdContext.facadeMapping.addPKMapping(BOSObjectType.create((String)bt), pk);
                }
            }
        }
    }

    private String getBosType(String xml) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Document doc = XMLParser.parseXML((InputStream)is);
            Element root = doc.getRootElement();
            String bosType = root.getChildText("bosType", root.getNamespace());
            return bosType;
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
            return null;
        }
    }

    private void afterSaveXml(Project p, IMetaDataPK pk, BOSObjectType type) throws BOSException {
        DBConfigMDDownloader.clear();
        this.load(type, pk);
        List<Project> orderedProjects = ConfigMDUtil.getOrderedProjects();
        if (orderedProjects != null && orderedProjects.contains(p) || "always_on".equals(p.getId())) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(ConfigMDUtil.getContext());
            AbstractMetaDataValue amd = (AbstractMetaDataValue)loader.get(type, pk);
            MetadataChangeListenerManager.notify(new AbstractMetaDataValue[]{amd});
        }
        DynamicMDContainer.clearDynamicMDs(this.ctx);
    }

    @Override
    public void saveXml2OtherServer(Project p, IMetaDataPK pk, BOSObjectType type) throws Exception {
        this.afterSaveXml(p, pk, type);
    }

    @Override
    public void upgrade(Project p) throws Exception {
        if (!new File(this.configureJar).exists()) {
            logger.info((Object)("upgrade: " + this.configureJar + " not exist."));
            return;
        }
        logger.info((Object)("Begin upgrade " + this.configureJar));
        JarFile jf = new JarFile(this.configureJar);
        Enumeration<JarEntry> enume = jf.entries();
        while (enume.hasMoreElements()) {
            String name;
            int i;
            JarEntry entry = enume.nextElement();
            if (entry.isDirectory() || (i = (name = entry.getName()).lastIndexOf(46)) <= 0 || !Utils.acceptSuffix(name)) continue;
            String suffix = name.substring(i + 1);
            name = name.substring(0, i);
            name = name.replace('/', '.');
            InputStream is = jf.getInputStream(entry);
            Document doc = XMLParser.parseXML((InputStream)is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XmlUtils.output(doc, baos);
            String xml = baos.toString("UTF-8");
            String type = Utils.getBOSTypeBySuffix(suffix);
            this.saveXml(p, MetaDataPK.create(name), BOSObjectType.create((String)type), xml);
        }
        jf.close();
        this.afterUpgrade();
        logger.info((Object)("End upgrade " + this.configureJar));
        StoreTaskConf task = new StoreTaskConf(){

            public JobManager.Task<IServerMetadataStore> getTask() {
                return new JobManager.Task<IServerMetadataStore>(){

                    public void run(IServerMetadataStore model) throws BOSException {
                        try {
                            model.upgrade2OtherServer();
                        }
                        catch (Exception e) {
                            throw new BOSException("delete2OtherServer error.", (Throwable)e);
                        }
                    }
                };
            }
        };
        JobManager.dispatch2Others((JobManager.TaskConf)task);
    }

    private void afterUpgrade() throws Exception {
        boolean b;
        ConfigureResourceLoader loader = ConfigureResourceLoader.getInstance(this.ctx);
        loader.clear();
        File bak = new File(this.configureJar + ".bak");
        if (bak.exists()) {
            bak.delete();
        }
        if (b = new File(this.configureJar).renameTo(bak)) {
            logger.info((Object)(this.configureJar + " renameTo " + bak.getName()));
        }
        MetaDataLoaderFactory.getMetaDataLoader(this.ctx).clearAll();
        ConfigureResourceLoader.removeLoader(ConfigMDUtil.getAIS());
        ConfigMDDownloader.init();
    }

    @Override
    public void upgrade2OtherServer() throws Exception {
        this.afterUpgrade();
    }

    @Override
    public List<DynamicMD> getDynamicMDs() {
        return this.getDynamicMDs(null);
    }

    @Override
    public List<DynamicMD> getDynamicMDs(Project[] depends) {
        return DynamicMDContainer.getDynamicMDs(this.ctx, Project.Projects.getProjects(depends));
    }

    @Override
    public List<MetaDataPK2> getAssociatedMDPKs(MetaDataPK2 pk2) throws BOSException {
        return DynamicMDContainer.getAssociatedMDPKs(this.ctx, pk2);
    }

    @Override
    public List<MetaDataPK2> getAssociatedMDPKs(MetaDataPK2[] pks) throws BOSException {
        return DynamicMDContainer.getAssociatedMDPKs(this.ctx, pks);
    }

    @Override
    public List<MetaDataPK2> getAssociatedMDPKs(MetaDataPK2[] pks, Project[] depends) throws BOSException {
        return DynamicMDContainer.getAssociatedMDPKs(this.ctx, pks, Project.Projects.getProjects(depends));
    }

    static {
        updateCount = 0;
        update2OtherServerCount = 0;
    }

    abstract class StoreTaskConf
    implements JobManager.TaskConf<IServerMetadataStore> {
        StoreTaskConf() {
        }

        public Class<IServerMetadataStore> getInterface() {
            return IServerMetadataStore.class;
        }

        public String getImplName() {
            return "com.kingdee.bos.metadata.configure.RemoteMetadataStore";
        }

        public Class[] getArgumentTypes() {
            return new Class[]{Context.class};
        }

        public Object[] getArguments() {
            return new Context[]{ServerMetadataStore.this.ctx};
        }

        public IServerMetadataStore getLocalInstance() {
            return null;
        }
    }
}

