/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.configure;

import com.kingdee.bos.Context;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.PropertyNotFoundException;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;

public class VOUtil {
    public static Object getProperty(IObjectValue ov, String propertyName, IMetaDataPK pk, Context ctx) throws PropertyNotFoundException, ReflectException {
        EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader(ctx).getEntity(pk);
        return VOUtil.getProperty(ov, propertyName, entity);
    }

    public static Object getProperty(IObjectValue ov, String propertyName, BOSObjectType type, Context ctx) throws PropertyNotFoundException, ReflectException {
        EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader(ctx).getEntity(type);
        return VOUtil.getProperty(ov, propertyName, entity);
    }

    public static Object setProperty(IObjectValue ov, String propertyName, Object value, IMetaDataPK pk, Context ctx) throws PropertyNotFoundException, ReflectException {
        EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader(ctx).getEntity(pk);
        return VOUtil.setProperty(ov, propertyName, value, entity);
    }

    public static Object setProperty(IObjectValue ov, String propertyName, Object value, BOSObjectType bostype, Context ctx) throws PropertyNotFoundException, ReflectException {
        EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader(ctx).getEntity(bostype);
        return VOUtil.setProperty(ov, propertyName, value, entity);
    }

    public static Object setPropertyClient(IObjectValue ov, String propertyName, Object value, IMetaDataPK pk) throws PropertyNotFoundException, ReflectException {
        return VOUtil.setProperty(ov, propertyName, value, pk, null);
    }

    public static Object setPropertyClient(IObjectValue ov, String propertyName, Object value, BOSObjectType bostype) throws PropertyNotFoundException, ReflectException {
        return VOUtil.setProperty(ov, propertyName, value, bostype, null);
    }

    public static Object getPropertyClient(IObjectValue ov, String propertyName, IMetaDataPK pk) throws PropertyNotFoundException, ReflectException {
        return VOUtil.getProperty(ov, propertyName, pk, null);
    }

    public static Object getPropertyClient(IObjectValue ov, String propertyName, BOSObjectType type) throws PropertyNotFoundException, ReflectException {
        return VOUtil.getProperty(ov, propertyName, type, null);
    }

    public static Object setProperty(IObjectValue ov, String propertyName, Object value, EntityObjectInfo entity) throws PropertyNotFoundException, ReflectException {
        PropertyInfo prop = entity.getPropertyByName(propertyName);
        if (prop == null) {
            throw new PropertyNotFoundException(entity.getFullName(), propertyName);
        }
        if (entity.isDynamic() || prop.isConfigured()) {
            if (VOUtil.isEnumType(prop)) {
                return VOUtil.setEnumProperty(ov, (OwnPropertyInfo)prop, value);
            }
            return VOUtil.setConfiguredPropertyByReflect(ov, prop.getName(), value);
        }
        return VOUtil.setPropertyByReflect(ov, prop, value);
    }

    public static Object getProperty(IObjectValue ov, String propertyName, EntityObjectInfo entity) throws PropertyNotFoundException, ReflectException {
        PropertyInfo prop = entity.getPropertyByNameRuntime(propertyName);
        if (prop == null) {
            throw new PropertyNotFoundException(entity.getFullName(), propertyName);
        }
        if (entity.isDynamic() || prop.isConfigured()) {
            if (VOUtil.isEnumType(prop)) {
                return VOUtil.getEnumProperty(ov, (OwnPropertyInfo)prop);
            }
            return VOUtil.getConfiguredProperty(ov, prop, propertyName);
        }
        return VOUtil.getPropertyByReflect(ov, prop, propertyName);
    }

    private static boolean isEnumType(PropertyInfo prop) {
        OwnPropertyInfo ownProp;
        return prop instanceof OwnPropertyInfo && (ownProp = (OwnPropertyInfo)prop).getDataType().equals(DataType.ENUM);
    }

    public static Object getEnumProperty(IObjectValue ov, String propName, BizEnumInfo enumInfo, String refTypeInfo) throws ReflectException {
        if (enumInfo.isDynamic()) {
            return VOUtil.getDynamicEnumProperty(ov, propName, enumInfo, refTypeInfo);
        }
        return VOUtil.getStaticEnumProperty(ov, propName, enumInfo, refTypeInfo);
    }

    private static Object getStaticEnumProperty(IObjectValue ov, String propName, BizEnumInfo enumInfo, String refTypeInfo) throws ReflectException {
        Class<?> refEnum;
        BizEnumValueType type = enumInfo.getDataType();
        try {
            refEnum = Class.forName(refTypeInfo);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectException(e);
        }
        Class[] paraTypes = null;
        Object[] args = null;
        if (type == BizEnumValueType.INTEGER) {
            paraTypes = new Class[]{Integer.TYPE};
            args = new Object[]{ov.getInt(propName)};
        } else if (type == BizEnumValueType.STRING) {
            paraTypes = new Class[]{String.class};
            args = new Object[]{ov.getString(propName)};
        } else if (type == BizEnumValueType.FLOAT) {
            paraTypes = new Class[]{Float.TYPE};
            args = new Object[]{new Float(ov.getFloat(propName))};
        } else if (type == BizEnumValueType.LONG) {
            paraTypes = new Class[]{Long.TYPE};
            args = new Object[]{ov.getLong(propName)};
        } else if (type == BizEnumValueType.DOUBLE) {
            paraTypes = new Class[]{Double.TYPE};
            args = new Object[]{new Double(ov.getDouble(propName))};
        }
        try {
            Method method = refEnum.getMethod("getEnum", paraTypes);
            return method.invoke(null, args);
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    private static Object getDynamicEnumProperty(IObjectValue ov, String propName, BizEnumInfo enumInfo, String refTypeInfo) throws ReflectException {
        String value = ov.getString(propName);
        return DynamicEnum.getEnum((String)refTypeInfo, (Object)value);
    }

    private static Object getEnumProperty(IObjectValue ov, OwnPropertyInfo prop) throws ReflectException {
        BizEnumInfo enumType = prop.getEnumType(MDHostType.RUNTIME);
        String ref = prop.getMetaDataRef();
        if (enumType == null) {
            IMetaDataLoader loader;
            if (ConfigMDUtil.isClient()) {
                loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            } else {
                Context ctx = ConfigMDUtil.getContext();
                loader = MetaDataLoaderFactory.getLocalMetaDataLoader(ctx);
            }
            enumType = loader.getEnum(MetaDataPK.create(ref));
        }
        return VOUtil.getEnumProperty(ov, prop.getName(), enumType, ref);
    }

    private static Object getPropertyByReflect(IObjectValue ov, PropertyInfo prop, String propertyName) throws ReflectException {
        String prefix = prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).getDataType().equals(DataType.BOOLEAN) ? "is" : "get";
        String methodName = prefix + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = ov.getClass().getMethod(methodName, new Class[0]);
            return method.invoke((Object)ov, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    public static Object setEnumProperty(IObjectValue ov, String propName, BizEnumInfo enumInfo, String refTypeInfo, Object value) throws ReflectException {
        BizEnumValueType type = enumInfo.getDataType();
        Object v = null;
        if (enumInfo.isDynamic()) {
            v = ((DynamicEnum)value).getValue();
        } else if (type == BizEnumValueType.INTEGER) {
            v = ((IntEnum)value).getValue();
        } else if (type == BizEnumValueType.STRING) {
            v = ((StringEnum)value).getValue();
        } else if (type == BizEnumValueType.FLOAT) {
            v = new Float(((FloatEnum)value).getValue());
        } else if (type == BizEnumValueType.LONG) {
            v = ((LongEnum)value).getValue();
        } else if (type == BizEnumValueType.DOUBLE) {
            v = new Double(((DoubleEnum)value).getValue());
        }
        try {
            Method method = ov.getClass().getMethod("put", String.class, Object.class);
            return method.invoke((Object)ov, propName, v);
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    private static Object setEnumProperty(IObjectValue ov, OwnPropertyInfo prop, Object value) throws ReflectException {
        return VOUtil.setEnumProperty(ov, prop.getName(), prop.getEnumType(MDHostType.RUNTIME), null, value);
    }

    public static Object setConfiguredPropertyByReflect(IObjectValue ov, String propName, Object value) throws ReflectException {
        try {
            Class[] paraTypes = new Class[]{String.class, Object.class};
            Method method = ov.getClass().getMethod("put", paraTypes);
            return method.invoke((Object)ov, propName, value);
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    public static Object getConfiguredProperty(IObjectValue ov, DataType dtype, String propertyName) {
        if (dtype != null) {
            if (dtype.equals(DataType.BOSUUID)) {
                return ov.getBOSUuid(propertyName);
            }
            if (dtype.equals(DataType.STRING)) {
                return ov.getString(propertyName);
            }
            if (dtype.equals(DataType.DECIMAL)) {
                return ov.getBigDecimal(propertyName);
            }
            if (dtype.equals(DataType.BOOLEAN)) {
                return ov.getBoolean(propertyName);
            }
            if (dtype.equals(DataType.BYTE)) {
                return new Byte(ov.getByte(propertyName));
            }
            if (dtype.equals(DataType.SHORT)) {
                return new Short(ov.getShort(propertyName));
            }
            if (dtype.equals(DataType.INTEGER)) {
                return ov.getInt(propertyName);
            }
            if (dtype.equals(DataType.LONG)) {
                return ov.getLong(propertyName);
            }
            if (dtype.equals(DataType.FLOAT)) {
                return new Float(ov.getFloat(propertyName));
            }
            if (dtype.equals(DataType.DOUBLE)) {
                return new Double(ov.getDouble(propertyName));
            }
            if (dtype.equals(DataType.DATE)) {
                return ov.getDate(propertyName);
            }
            if (dtype.equals(DataType.TIME)) {
                return ov.getTime(propertyName);
            }
            if (dtype.equals(DataType.TIMESTAMP)) {
                return ov.getTimestamp(propertyName);
            }
        }
        return ov.get(propertyName);
    }

    private static Object getConfiguredProperty(IObjectValue ov, PropertyInfo prop, String propertyName) {
        if (prop instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProperty = (OwnPropertyInfo)prop;
            DataType dtype = ownProperty.getDataType();
            return VOUtil.getConfiguredProperty(ov, dtype, propertyName);
        }
        return ov.get(propertyName);
    }

    private static Object setPropertyByReflect(IObjectValue ov, PropertyInfo prop, Object value) throws ReflectException {
        String prefix = "set";
        String methodName = prefix + prop.getName().substring(0, 1).toUpperCase() + prop.getName().substring(1);
        try {
            Class clazz = null;
            String javaType = null;
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo own = (OwnPropertyInfo)prop;
                DataType dt = own.getDataType();
                if (DataType.STRING.equals(dt)) {
                    clazz = String.class;
                } else if (DataType.INTEGER.equals(dt)) {
                    clazz = Integer.TYPE;
                } else if (DataType.BOOLEAN.equals(dt)) {
                    clazz = Boolean.TYPE;
                } else if (DataType.BYTE.equals(dt)) {
                    clazz = Byte.TYPE;
                } else if (DataType.CHAR.equals(dt)) {
                    clazz = Character.TYPE;
                } else if (DataType.DOUBLE.equals(dt)) {
                    clazz = Double.TYPE;
                } else if (DataType.FLOAT.equals(dt)) {
                    clazz = Float.TYPE;
                } else if (DataType.LONG.equals(dt)) {
                    clazz = Long.TYPE;
                } else if (DataType.SHORT.equals(dt)) {
                    clazz = Short.TYPE;
                } else {
                    javaType = dt.getJavaTypeName();
                    if (Enum.class.getName().equals(javaType)) {
                        javaType = own.getMetaDataRef();
                    }
                }
            } else {
                LinkPropertyInfo link = (LinkPropertyInfo)prop;
                RelationshipInfo relation = link.getRelationship();
                CardinalityType ctype = relation.getSupplierCardinality();
                javaType = CardinalityType.ONE_TO_UNBOUNDED.equals((Object)ctype) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)ctype) ? relation.getSupplierObject().getObjectCollectionClassRuntime() : relation.getSupplierObject().getObjectValueClassRuntime();
            }
            if (clazz == null) {
                clazz = Class.forName(javaType);
            }
            Class[] paraTypes = new Class[]{clazz};
            Method method = ov.getClass().getMethod(methodName, paraTypes);
            return method.invoke((Object)ov, value);
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }
}

